<?php

declare(strict_types=1);

namespace Drupal\multiple_email\Form;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Form for setting an email address as the primary email.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class ConfirmSetPrimaryForm extends AjaxConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'multiple_email_confirm_set_primary';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDescription(): TranslatableMarkup {
    return $this->t('Are you sure you want to set %email as the primary email?', [
      '%email' => $this->email->getEmail(),
    ]);
  }

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   *   An error occurred while saving the user entity.
   */
  protected function doAction(): void {
    $email_address = $this->email->getEmail();

    $user = $this->email->getOwner();
    $user->setEmail($email_address);
    $user->save();
  }

}
