<?php

declare(strict_types=1);

namespace Drupal\multiple_email\Util;

use Drupal\Component\Serialization\Json;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;
use Drupal\multiple_email\EmailInterface;

/**
 * Utility class to set operation links for an email entity.
 *
 * @deprecated in multiple_email:3.0.0 and is removed from multiple_email:4.0.0.
 *   There is no replacement.
 *
 * @see https://www.drupal.org/node/3564861
 */
class EmailOperations {

  use StringTranslationTrait;

  /**
   * An array of operation links.
   *
   * @var array
   */
  protected array $operations = [];

  /**
   * Constructs a new \Drupal\multiple_email\Util\EmailOperations instance.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email entity to perform the operation on.
   */
  public function __construct(
    protected readonly EmailInterface $email,
  ) {
    @trigger_error('The ' . __CLASS__ . ' class is deprecated in multiple_email:3.0.0 and is removed from multiple_email:4.0.0. There is no replacement. See https://www.drupal.org/node/3564861', E_USER_DEPRECATED);
  }

  /**
   * Gets all operation links.
   *
   * @return array
   *   An array of operation links.
   */
  public function getAll(): array {
    return $this->operations;
  }

  /**
   * Adds the "Confirm" link to the array of operations.
   */
  public function addConfirm(): void {
    $this->operations['confirm'] = [
      'title' => $this->t('Confirm'),
      'weight' => 5,
      'url' => Url::fromRoute(
        'multiple_email.confirm',
        ['multiple_email' => $this->email->id()],
      ),
      'attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 'auto',
        ]),
      ],
    ];
  }

  /**
   * Adds the "Set primary" link to the array of operations.
   */
  public function addSetPrimary(): void {
    $this->operations['set-primary'] = [
      'title' => $this->t('Set Primary'),
      'weight' => 10,
      'url' => Url::fromRoute(
        'multiple_email.set_primary',
        ['multiple_email' => $this->email->id()],
      ),
      'attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 'auto',
        ]),
      ],
    ];
  }

  /**
   * Adds the "Resend confirmation" link to the array of operations.
   */
  public function addResend(): void {
    $this->operations['resend'] = [
      'title' => $this->t('Resend confirmation'),
      'weight' => 15,
      'url' => Url::fromRoute(
        'multiple_email.resend',
        ['multiple_email' => $this->email->id()],
      ),
      'attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 'auto',
        ]),
      ],
    ];
  }

  /**
   * Adds the "Cancel confirmation" link to the array of operations.
   */
  public function addCancel(): void {
    $this->operations['cancel'] = [
      'title' => $this->t('Cancel Confirmation'),
      'weight' => 20,
      'url' => Url::fromRoute(
        'multiple_email.cancel_confirmation',
        ['multiple_email' => $this->email->id()],
      ),
      'attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 'auto',
        ]),
      ],
    ];
  }

  /**
   * Adds the "Remove" link to the array of operations.
   */
  public function addRemove(): void {
    $this->operations['remove'] = [
      'title' => $this->t('Remove'),
      'weight' => 25,
      'url' => Url::fromRoute(
        'multiple_email.remove',
        ['multiple_email' => $this->email->id()],
      ),
      'attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 'auto',
        ]),
      ],
    ];
  }

}
