MyREST SEO
==========

MyREST SEO is a helper module for Drupal 10.3–11.x that adds a simple SEO dashboard and utilities for robots.txt and basic redirect rules.

Overview
- SEO admin page (/admin/seo) with quick links:
  - Redirects extras (built‑in simple redirect rules UI).
  - Robots.txt settings (via Robotstxt module).
  - XML sitemap (if Simple Sitemap is installed).
  - Optional links to your custom Metatag tools (myrest_route_metatag, myrest_metatag) when those modules are enabled.
- Robots.txt extras for a “front” domain (second textarea), preserved in configuration.

Requirements
- Drupal: ^10.3 || ^11
- PHP: >= 8.2

Dependencies
- Hard (required):
  - robotstxt (drupal/robotstxt) — to ensure the Robots.txt link always opens a working settings page.
- Optional (soft):
  - redirect (drupal/redirect) — MyREST SEO provides its own simple rules; if Redirect is installed you may prefer to manage redirects there.
  - simple_sitemap (drupal/simple_sitemap) — the XML sitemap link is shown only if this module is enabled.
  - myrest_route_metatag (custom) — when enabled, MyREST SEO adds a menu link to its collection page.
  - myrest_metatag (custom) — when enabled, MyREST SEO adds a menu link to its collection page.

Installation
1) Place the module into web/modules/custom/myrest_seo (or require via your site composer in a custom path).
2) Enable the module: /admin/modules (MyREST SEO).
3) Grant the permission “administer myrest_seo” to the role that should access the SEO section.

Permissions
- administer myrest_seo — access to the SEO dashboard and module’s admin pages.

Admin paths
- SEO dashboard: /admin/seo
- Redirect rules (built‑in UI): /admin/seo/redirects
- MyREST SEO settings (front domain, etc.): /admin/seo/settings
- Robots.txt: /admin/seo/robotstxt → safely redirects to the Robotstxt settings page
- XML sitemap: visible under /admin/seo only if Simple Sitemap is installed
- Metatag links (custom modules): visible under /admin/seo only if myrest_route_metatag / myrest_metatag are installed

Robots.txt extras
- On the Robotstxt settings page, MyREST SEO adds a second textarea to manage robots.txt for the “front” domain.
- Storage:
  - The extra content is saved in robotstxt.settings: robotstxt_content_for_domain_app (schema provided).
  - The front domain base URL is stored in myrest_seo.settings: robots_front_domain (empty by default). If empty, a legacy fallback may read myother.settings: domain_app; otherwise the current host is used in labels.
- The field labels show absolute robots.txt URLs for both the admin site and the configured front domain.

Redirect rules (MVP)
- Toggle: enable/disable at /admin/seo/redirects.
- Rules format (one per line):
  - source|target|status|enabled
  - Example: /old|/new|301|1
  - Status: 301 or 302. Target can be absolute or a site‑relative path starting with “/”.
- Cacheability: the subscriber attaches proper cache metadata (contexts like languages:language_interface, url.path; tags config:myrest_seo.redirects) and uses no‑cache redirects (max‑age 0).
- Compatibility: if the Redirect module is enabled, MyREST SEO shows a warning in the UI to avoid duplicate/conflicting rules (you can keep rules in one place).

Help page
- Core “Help” module can display this README at /admin/help/myrest_seo via hook_help(). Markdown is rendered when Parsedown is available; otherwise README is shown as preformatted text. HTML is sanitized.

Development notes
- Coding standards: Drupal (PHPCS) and phpstan‑drupal (level 8) are supported in CI.
- Tests: baseline functional/kernel tests can be added (separate task) to cover admin routes and redirects.
- License: GPL‑2.0‑or‑later (LICENSE.txt included).

Optional integrations (soft deps)
- Simple Sitemap: MyREST SEO shows a link to its settings only when the module is enabled.
- Custom Metatag modules:
  - myrest_route_metatag — Template meta tags list at /admin/seo/myrest_route_metatag/list.
  - myrest_metatag — Meta tags by URL at /admin/seo/myrest_metatag.
  Links appear automatically when the modules are enabled; no hard dependency is declared by MyREST SEO.

Planned improvements (future work)
- Redirects UI refinements: table UI instead of textarea; import/export; regex and prefix matching; option to preserve query parameters; loop detection; more cache contexts when needed.
- Robots extras: dedicated ConfigFormBase (alternative to form_alter) with migration path; clearer ownership of configuration.
- Metatag summary/hub: optional built‑in summary pages (when contrib/custom tools are absent), with safe route detection across versions.
- Tests: Functional/Kernel tests for routes, robots extras, and redirects; GitLab CI job for PHPUnit.
- Documentation: convert in‑code comments to English; expand README with screenshots and examples.

Issue queue
- Please report issues and feature requests on the project page at drupal.org.
