<?php

declare(strict_types=1);

namespace Drupal\myrest_seo\Controller;

use Drupal\Core\Form\FormBuilderInterface;
use Drupal\myrest_seo\Form\RedirectsForm;

/**
 * Helper controller to render MyREST SEO forms.
 *
 * This exists to be backward-compatible with routes that may still reference
 * a controller callback due to cached routes, while the canonical definition
 * uses the _form route default.
 */
final class FormController {

  /**
   * The form builder service.
   */
  private FormBuilderInterface $formBuilder;

  public function __construct(FormBuilderInterface $formBuilder) {
    $this->formBuilder = $formBuilder;
  }

  /**
   * Renders the redirects admin form.
   *
   * @return array
   *   A render array for the redirects form.
   */
  public function redirects(): array {
    return $this->formBuilder->getForm(RedirectsForm::class);
  }

}
