<?php

declare(strict_types=1);

namespace Drupal\myrest_seo\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Ensures MyREST SEO routes have proper admin options.
 */
final class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    $route_names = [
      'myrest_seo',
      'myrest_seo.robots',
      'myrest_seo.redirect',
      'myrest_seo.simplesitemap',
      'myrest_seo.robotstxt',
      'myrest_seo.redirects_admin',
    ];
    foreach ($route_names as $name) {
      if ($route = $collection->get($name)) {
        $route->setOption('_admin_route', TRUE);
      }
    }
  }

}
