<pre>
  ┌───────┐
  │       │
  │  a:o  │  acolono.com
  │       │
  └───────┘
</pre>

# NanoBanana Editor

AI-powered image editor for Drupal Media entities using Google Gemini's image generation models.

## Overview

NanoBanana Editor integrates AI-powered image generation and editing directly into Drupal's Media management workflow. Built on top of the [ai_provider_nanobanana](https://www.drupal.org/project/ai_provider_nanobanana) module, it provides intuitive interfaces for editors to generate new images or transform existing ones using natural language prompts.

## Features

- **Edit Existing Images**: Transform media images with AI-powered editing
- **Generate New Images**: Create images from text descriptions or image references
- **Multi-Image Composition**: Combine up to 14 images (model-dependent)
- **Model Selection**: Choose between Gemini 2.5 Flash (fast) and Gemini 3 Pro (high quality)
- **Aspect Ratio Control**: 1:1, 3:4, 4:3, 9:16, 16:9, etc.
- **High-Resolution Output**: Up to 4K resolution with Gemini 3 Pro
- **Style Presets**: Create reusable style prompts for consistent image generation
- **System Instructions**: Set global prompt behavior for all generations
- **Media Integration**: Edit/Generate buttons directly in Media forms
- **Thumbnail Previews**: Visual previews of uploaded images
- **Intuitive UI**: Sidebar layout with configuration options and live preview

## Requirements

- Drupal 10.3+ or Drupal 11+
- [AI module](https://www.drupal.org/project/ai)
- [ai_provider_nanobanana module](https://www.drupal.org/project/ai_provider_nanobanana)
- Media module (core)
- Google Gemini API key configured in ai_provider_nanobanana

## Installation

1. Ensure ai_provider_nanobanana is installed and configured:
   ```bash
   drush en ai_provider_nanobanana
   ```

2. Enable the NanoBanana Editor module:
   ```bash
   drush en nanobanana_editor
   ```

3. Clear cache:
   ```bash
   drush cr
   ```

## Configuration

Navigate to **Configuration → Media → NanoBanana Settings** (`/admin/config/media/nanobanana`)

### System Instructions

Global instructions prepended to all prompts. Use this to set consistent behavior, tone, or quality standards.

**Example:**
```
Generate high-quality, professional images suitable for editorial use.
Maintain photorealistic style unless otherwise specified.
```

### Image Styles

Create reusable style presets that users can select when generating images.

**To add a style:**
1. Go to **Configuration → Media → NanoBanana Settings**
2. Click **Add style** button
3. Enter a **Style Name** (e.g., "Watercolor", "Photorealistic", "Comic Book")
4. Enter **Style Prompt** (e.g., "in watercolor painting style", "photorealistic with dramatic lighting")
5. Click **Add style**

**Usage:** When generating or editing images, users can select a style from the dropdown to automatically apply that style prompt.

## Usage

### Editing Existing Images

1. Navigate to any media entity edit form (e.g., `/media/1/edit`)
2. Click **Edit with NanoBanana** button
3. The edit interface opens with:
   - **Current Image**: Preview of the existing image
   - **Prompt**: Describe the changes you want to make
   - **Model**: Select Gemini 2.5 Flash or Gemini 3 Pro
   - **Additional Images** (optional): Upload up to 13 additional images to compose with the original
   - **Image Size** (Gemini 3 Pro only): Choose resolution (Default, 1K, 2K, 4K)
   - **Aspect Ratio**: Select output dimensions
   - **Style**: Apply a preset style (optional)
4. Click **Generate** to preview the result
5. Click **Save** to replace the media entity's image, or **Cancel** to discard

**Example Prompts:**
- "Convert this to a watercolor painting"
- "Remove the background and make it transparent"
- "Change the sky to sunset"
- "Add dramatic lighting from the left"

### Generating New Images

#### From Media Add Form

1. Navigate to **Content → Media → Add Media → Image** (`/media/add/image`)
2. Click **Generate with NanoBanana** button
3. The generator interface opens with:
   - **Prompt**: Describe the image you want to create
   - **Model**: Select Gemini 2.5 Flash or Gemini 3 Pro
   - **Images** (optional): Upload reference images (up to 3 for Flash, 14 for Pro)
   - **Image Size** (Gemini 3 Pro only): Choose resolution
   - **Aspect Ratio**: Select output dimensions
   - **Style**: Apply a preset style (optional)
4. Click **Generate** to preview the result
5. Click **Save** to create a new media entity with the generated image

#### Direct URL

Navigate directly to `/media/generate/image` to access the image generator.

**Example Prompts:**
- "A serene mountain landscape at sunset, photorealistic"
- "Modern minimalist office interior, bright natural lighting"
- "Portrait of a golden retriever puppy, shallow depth of field"
- "Abstract geometric pattern in blue and orange tones"

### Multi-Image Generation

Combine multiple images to create composite scenes, style transfers, or complex compositions.

**To use:**
1. In either Edit or Generate form
2. Select model (Flash: up to 3 total images, Pro: up to 14 total images)
3. Upload additional images in the **Additional Images** field
4. Enter a prompt describing how to combine them

**Example Use Cases:**
- Style transfer: Upload a content image and a style reference
- Object composition: Combine objects from different images
- Scene blending: Merge multiple scenes into one cohesive image
- Character combinations: Compose characters from different sources

**Example Prompt:**
```
Combine these images into a single scene with the character from image 1
in the environment from image 2, maintaining consistent lighting
```

## Model Comparison

### Gemini 2.5 Flash Image
- **Speed**: Fast, low-latency generation
- **Multi-Image**: Up to 3 total images (1 main + 2 additional in Edit mode)
- **Resolution**: Standard
- **Best For**: Quick iterations, real-time editing, prototyping

### Gemini 3 Pro Image (Preview)
- **Speed**: Slower, higher quality
- **Multi-Image**: Up to 14 total images (1 main + 13 additional in Edit mode)
- **Resolution**: Default, 1K, 2K, 4K
- **Best For**: Final production, high-quality output, complex compositions

## Configuration Options

### Aspect Ratio Options
- `Default` - Maintains original or model default
- `1:1` - Square
- `2:3`, `3:2` - Photo formats
- `3:4`, `4:3` - Standard formats
- `4:5`, `5:4` - Portrait/landscape
- `9:16`, `16:9` - Vertical/widescreen
- `21:9` - Ultra-wide

### Image Size (Gemini 3 Pro Only)
- `Default` - Standard resolution
- `1K` - ~1000px
- `2K` - ~2000px
- `4K` - ~4000px

**Note:** Higher resolutions take longer to generate.

The interface is responsive and adapts to mobile devices.

## Permissions

**To edit images:**
- `update media` permission for the media entity

**To generate new images:**
- `create media` permission

**To configure settings:**
- `administer site configuration` permission

## Media Integration

The module integrates seamlessly with Drupal's Media module by adding buttons to standard forms:

### Media Image Edit Form (`media_image_edit_form`)
Adds "**Edit with NanoBanana**" button in the form actions

### Media Image Add Form (`media_image_add_form`)
Adds "**Generate with NanoBanana**" button in the form actions

These buttons are only visible when:
- The media bundle is `image`
- The media entity has an image field with a value (edit form only)

## Troubleshooting

### "NO_IMAGE" Error
The AI model didn't generate an image. This can happen when:
- The prompt is too vague or unclear
- The request conflicts with content policies
- The images uploaded are incompatible
- **Solution**: Be more specific in your prompt with clear, descriptive language

### Validation Errors
**"Too many images for this model"**
- Gemini 2.5 Flash supports up to 3 total images (or 2 additional in Edit mode)
- Gemini 3 Pro supports up to 14 total images (or 13 additional in Edit mode)
- **Solution**: Remove excess images or switch to Gemini 3 Pro

### API Key Issues
If you receive API errors:
- Verify the API key is configured in ai_provider_nanobanana settings
- See [ai_provider_nanobanana](https://www.drupal.org/project/ai_provider_nanobanana) for details

### Image Upload Errors
- **File size issues**: Ensure images are reasonable size (<10MB recommended)
- **Format issues**: Use standard formats (JPEG, PNG)
- **Permission errors**: Check file system permissions

### Generated Image Not Saving
- Verify you have `update media` permission
- Check that the media entity's image field is writable
- Review Drupal logs at `/admin/reports/dblog`

## Workflow Tips

### For Quick Edits
1. Use **Gemini 2.5 Flash** for speed
2. Use **Default** aspect ratio to maintain dimensions
3. Keep prompts concise and specific

### For High-Quality Output
1. Use **Gemini 3 Pro Image**
2. Select **2K or 4K** resolution
3. Write detailed, descriptive prompts
4. Use style presets for consistency

### For Complex Compositions
1. Use **Gemini 3 Pro** (supports up to 14 images)
2. Upload high-quality reference images
3. Write specific instructions on how to combine images

### Creating Consistent Style
1. Configure system instructions with brand guidelines
2. Create style presets for common use cases
3. Train editors on effective prompt writing
4. Use the same model for consistency (Flash for speed, Pro for quality)

## Best Practices

### Writing Effective Prompts
- **Be specific**: Instead of "make it better", try "enhance contrast and add dramatic lighting"
- **Describe the end result**: Focus on what you want, not how to achieve it
- **Use references**: When using multi-image mode, refer to specific images
- **Style keywords**: Include terms like "photorealistic", "watercolor", "dramatic", "minimalist"

### Image Selection for Multi-Image
- **Quality matters**: Use clear, well-lit source images
- **Resolution**: Higher resolution inputs generally produce better outputs
- **Relevance**: Ensure all images contribute to the desired result
- **Limit wisely**: More images isn't always better; use only what's needed

### System Instructions Examples
```
Generate images optimized for web use with fast loading times.
Maintain brand colors: blue (#0066CC), orange (#FF6600).
Avoid text in images unless explicitly requested.
```

```
All images should be suitable for professional business presentations.
Use natural lighting and neutral backgrounds when appropriate.
Maintain high contrast for readability.
```

## Resources

- [ai_provider_nanobanana Module](https://www.drupal.org/project/ai_provider_nanobanana)
- [Google Gemini API Documentation](https://ai.google.dev/gemini-api/docs/image-generation)
- [Drupal AI Module Documentation](https://www.drupal.org/project/ai)

by acolono GmbH
---------------

~~we build your websites~~
we build your business

hello@acolono.com

www.acolono.com
www.twitter.com/acolono
www.drupal.org/acolono-gmbh
