<?php

namespace Drupal\navigation_extra\Plugin\Navigation\Extra;

use Drupal\Core\Form\FormStateInterface;
use Drupal\navigation_extra\NavigationExtraPluginBase;

/**
 * An NavigationExtraPlugin.
 *
 * Used for moving local tasks into the navigation section.
 *
 * @NavigationExtraPlugin(
 *   id = "local_tasks",
 *   name = @Translation("Local tasks"),
 *   description = @Translation("Allows you to put the local tasks of the current route into the navigation bar. When enabled, goto navigation layout settings and add the Local Tasks block."),
 *   weight = 0
 * )
 */
class LocalTasksPlugin extends NavigationExtraPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigForm(array &$form, FormStateInterface $form_state): array {
    $elements = parent::buildConfigForm($form, $form_state);
    return $elements;
  }

}
