/**
 *
 * Extra JS for manipulating the navigation menu.
 *
 * @type {Drupal~behavior}
 *
 * @prop {Drupal~behaviorAttach} attach
 */
(
  (Drupal, once, drupalSettings) => {
    Drupal.behaviors.navigationExtraEnvironment = {
      /**
       * Attaches the behavior to the context element.
       *
       * @param {HTMLElement} context The context element to attach the behavior to.
       */
      attach: (context) => {
        if (context === document) {
          const environmentBgColor =
            drupalSettings.navigation_extra.environment.background;

          const environmentColor =
            drupalSettings.navigation_extra.environment.color;

          const doc = document.documentElement;

          // Set a custom background property, the css uses.
          doc.style.setProperty('--env-background', environmentBgColor);

          // Set a custom text color property, the css uses.
          doc.style.setProperty('--env-color', environmentColor);

          once(
            'navigation-extra--environment',
            '.admin-toolbar__header',
            context,
          ).forEach((header) => {
            // Make sure we activate the css on our header.
            header.classList.add('navigation-extra--env');
          });
        }
      },
    };
  }
)(Drupal, once, drupalSettings);
