<?php

declare(strict_types=1);

namespace Drupal\navigation_extra\Plugin\Block;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\system\Plugin\Block\SystemMenuBlock;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a navigation block class to show the version information.
 *
 * This basically does what NavigationMenuBlock is doing, but since that is
 * a final class we can't extend from it.
 */
#[Block(
  id: 'navigation_extra_version',
  admin_label: new TranslatableMarkup('Version'),
)]
class NavigationExtraVersionBlock extends SystemMenuBlock implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('navigation.menu_tree'),
      $container->get('menu.active_trail'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeId() {
    return "navigation_extra_version";
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'level' => 1,
      'depth' => 3,
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function blockdAccess(AccountInterface $account): AccessResultInterface {
    return AccessResult::allowedIf($this->navigationExtra->isEnabled('version'));
  }

}
