<?php

namespace Drupal\navigation_extra\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Defines a navigation extra plugin.
 *
 * Plugin Namespace: Plugin\Navigation\Extra.
 *
 * @Annotation
 */
class NavigationExtraPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation|string
   *
   * @ingroup plugin_translatable
   */
  public Translation|string $name;

  /**
   * The description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation|string
   *
   * @ingroup plugin_translatable
   */
  public Translation|string $description;

  /**
   * The dependencies of the plugin.
   *
   * @var array
   *
   * @ingroup plugin_translatable
   */
  public array $dependencies;

  /**
   * The weight of the plugin.
   *
   * @var int
   */
  public int $weight;
}
