<?php

declare(strict_types=1);

namespace Drupal\navigation_extra;

use Drupal\Component\Plugin\Discovery\CachedDiscoveryInterface;
use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Manages navigation extra plugins.
 */
interface NavigationExtraPluginManagerInterface extends PluginManagerInterface, CachedDiscoveryInterface, CacheableDependencyInterface {

  /**
   * Given an entity, let plugins decide if a menu rebuild is required.
   *
   * @param string $plugin_id
   *   The plugin id to check if it is enabled or not.
   *
   * @return bool
   *   Return TRUE if the plugin is enabled, FALSE if not.
   */
  public function isEnabled(string $plugin_id): bool;

  /**
   * Given an entity, let plugins decide if a menu rebuild is required.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   */
  public function menuLinkRebuild(EntityInterface $entity): void;

  /**
   * Dispatches the hook_menu_links_discovered_alter to the plugins.
   *
   * @param array $links
   *   The links array.
   */
  public function menuLinksDiscoveredAlter(array &$links): void;

  /**
   * Dispatches the hook_preprocess_menu to the plugins.
   *
   * @param array $variables
   *   The variables array.
   */
  public function preprocessMenu(array &$variables): void;

  /**
   * Dispatches the hook_page_attachments to the plugins.
   *
   * @param array $page
   *   The page array.
   */
  public function pageAttachments(array &$page): void;

}
