<?php

namespace Drupal\navigation_extra\Plugin\Navigation\Extra;

use Drupal\Core\Form\FormStateInterface;
use Drupal\navigation_extra\NavigationExtraPluginBase;

/**
 * An NavigationExtraPlugin for file navigation links.
 *
 * @NavigationExtraPlugin(
 *   id = "files",
 *   name = @Translation("Files"),
 *   description = @Translation("Provides navigation links for files."),
 *   weight = 3,
 *   entity_type = "file",
 *   dependencies = {
 *     "file"
 *   }
 * )
 */
class FilesPlugin extends NavigationExtraPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigForm(array &$form, FormStateInterface $form_state): array {
    $elements = parent::buildConfigForm($form, $form_state);

    $elements['hide_core_link'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Hide core link'),
      '#description' => $this->t('Hide link provided by core.'),
      '#default_value' => $this->config->get("plugins.files.hide_core_link") ?? FALSE,
    ];

    $elements['show_in_media'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show in media'),
      '#description' => $this->t('Show files in media. The media plugin needs to be enabled.'),
      '#default_value' => $this->config->get("plugins.files.show_in_media") ?? FALSE,
      '#access' => $this->moduleHandler->moduleExists('media'),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function alterDiscoveredMenuLinks(array &$links): void {
    $hide_core_link = $this->config->get("plugins.files.hide_core_link") ?? FALSE;

    if ($hide_core_link) {
      $this->removeLink('navigation.files', $links);
    }
    else {
      // Create the root element if it does not exist.
      $this->addLink('navigation.files', [
        'route_name' => 'view.files.page_1',
        'title' => $this->t('Files'),
        'weight' => $this->config->get("plugins.files.weight") ?? 0,
        'options' => [
          'attributes' => [
            'class' => [
              'navigation-extra--files',
            ],
          ],
        ],
      ] + ($links['navigation.files'] ?? []), $links);
    }

  }

  /**
   * {@inheritdoc}
   */
  public function postAlterDiscoveredMenuLinks(array &$links): void {
    $show_in_media = $this->config->get('plugins.files.show_in_media') ?? FALSE;

    if ($show_in_media && isset($links['navigation.media'])) {
      // Create the root element if it does not exist.
      $this->addLink('navigation.media.files', [
        'route_name' => 'view.files.page_1',
        'title' => $this->t('Files'),
        'weight' => $this->config->get("plugins.files.weight") ?? 0,
        'parent' => 'navigation.media',
        'options' => [
          'attributes' => [
            'class' => [
              'navigation-extra--files',
            ],
          ],
        ],
      ], $links);
    }
  }

}
