<?php

namespace Drupal\navigation_extra\Plugin\Navigation\Extra;

use Drupal\Core\Form\FormStateInterface;
use Drupal\navigation_extra\NavigationExtraPluginBase;

/**
 * Alter the system taxonomies menu and adding a new main categories menu item.
 *
 * @NavigationExtraPlugin(
 *   id = "taxonomies",
 *   name = @Translation("Taxonomies"),
 *   description = @Translation("Adds a 'taxonomies' item to the admin menu."),
 *   weight = 2,
 *   entity_type = "taxonomy_vocabulary",
 *   dependencies = {
 *     "taxonomy"
 *   }
 * )
 */
class TaxonomiesPlugin extends NavigationExtraPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigForm(array &$form, FormStateInterface $form_state): array {
    $elements = parent::buildConfigForm($form, $form_state);

    $elements += $this->buildConfigFormCreateItems($form, $form_state);

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function alterDiscoveredMenuLinks(array &$links): void {
    // Create the root element if it does not exist.
    $this->addLink('navigation.taxonomies', [
      'route_name' => 'entity.taxonomy_vocabulary.collection',
      'title' => $this->t('Taxonomies'),
      'weight' => $this->config->get("plugins.taxonomies.weight") ?? 0,
      'options' => [
        'icon' => [
          'pack_id' => 'navigation_extra',
          'icon_id' => 'taxonomies',
          'settings' => [
            'class' => 'toolbar-button__icon',
            'size' => 25,
          ],
        ],
        'attributes' => [
          'class' => [
            'navigation-extra--taxonomy',
          ],
        ],
      ],
    ] + ($links['navigation.taxonomies'] ?? []), $links);

    // Create the collections.
    $this->addCollectionLinks(
      'navigation.taxonomies',
      fn($collection) => ([
        'route_name' => 'entity.taxonomy_vocabulary.collection',
        'route_parameters' => [
          'collection' => $collection['id'],
        ],
      ]),
      $links
    );

    $this->addItemLinks(
      'navigation.taxonomies',
      'taxonomy_vocabulary',
      fn($item) => ([
        'route_name' => 'entity.taxonomy_vocabulary.overview_form',
        'route_parameters' => [
          'taxonomy_vocabulary' => $item->id(),
        ],
      ]),
      $links
    );

    $this->addCreateEntityLinks(
      'navigation.taxonomies',
      'entity.taxonomy_vocabulary.overview_form',
      'entity.taxonomy_term.add_form',
      'taxonomy_vocabulary',
      $links
    );
  }

}
