<?php

declare(strict_types=1);

namespace Drupal\navigation_menu_role\Hook;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for Navigation Menu Roles.
 */
class NavigationMenuRoleHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.navigation_menu_role':
        $output = '';
        $output .= '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('The Navigation Menu Role module provides a set of menu blocks for Navigation visible per role.') . '</p>';
        $output .= '<p>' . $this->t('For more information, see the <a href=":docs">online documentation for the Navigation Menu Role module</a>.', [':docs' => 'https://www.drupal.org/project/navigation_menu_role']) . '</p>';
        return $output;
    }
    return NULL;
  }

  /**
   * Implements hook_block_alter().
   */
  #[Hook('block_alter')]
  public function blockAlter(&$definitions) : void {
    array_walk($definitions, function (&$definition, $block_id) {
      [$base_plugin_id] = explode(PluginBase::DERIVATIVE_SEPARATOR, $block_id);

      // Add the allow_in_navigation attribute to those blocks valid for
      // Navigation.
      // @todo Refactor to use actual block Attribute once
      //   https://www.drupal.org/project/drupal/issues/3443882 is merged.
      if ($base_plugin_id === 'navigation_menu_role') {
        $definition['allow_in_navigation'] = TRUE;
        // Hide Navigation specific blocks from the generic UI.
        $definition['_block_ui_hidden'] = TRUE;
      }
    });
  }

}
