(($, Drupal, once) => {
  Drupal.behaviors.NavigationPlusSettingsSidebar = {
    attach(context, settings) {
      once('settings-sidebar', '#navigation-plus-settings', context).forEach(button => {

        button.addEventListener('click', () => {
          const settingsSidebar = document.querySelector('#edit-mode-settings');
          if (settingsSidebar.classList.contains('navigation-plus-hidden')) {
            // Close any open right sidebars.
            document.querySelectorAll('.navigation-plus-sidebar.right-sidebar').forEach(sidebar => {
              if (!sidebar.classList.contains('navigation-plus-hidden')) {
                sidebar.classList.add('navigation-plus-hidden');
                sidebar.removeAttribute('data-offset-right');
              }
            });
            // Open settings sidebar.
            settingsSidebar.setAttribute('data-offset-right', '');
            settingsSidebar.classList.remove('navigation-plus-hidden');
            button.classList.add('active');
            Drupal.displace();
          } else {
            // Close settings sidebar.
            settingsSidebar.removeAttribute('data-offset-right');
            settingsSidebar.classList.add('navigation-plus-hidden');
            button.classList.remove('active');
            Drupal.displace();
          }
        });

      });
    }
  };
})(jQuery, Drupal, once);
