<?php

declare(strict_types=1);

namespace Drupal\navigation_plus\Controller;

use Drupal\user\Entity\User;
use Drupal\Component\Utility\Html;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;

/**
 * Settings sidebar end points.
 */
final class Settings extends ControllerBase {

  /**
   * Save hotkey.
   */
  public function saveHotkey(string $tool_id, string $hotkey)  {
    $account = $this->currentUser();
    if ($account->isAuthenticated()) {
      $user = User::load($account->id());
      $settings = $user->navigation_plus_settings->getValue();
      $settings[0]['hotkeys'][$tool_id] = Html::escape($hotkey);
      $user->set('navigation_plus_settings', $settings[0]);

      navigation_plus_save_outside_workspace($user);
    }

    // @todo Return "saved" message.
    return new AjaxResponse(NULL, Response::HTTP_OK);
  }

  /**
   * Remove media file association.
   */
  public function removeMediaFileAssociation(string $file_extension)  {
    $account = $this->currentUser();
    if ($account->isAuthenticated()) {
      $user = User::load($account->id());
      $settings = $user->navigation_plus_settings->getValue();
      if (!empty($settings[0]['file_associations'][$file_extension])) {
        unset($settings[0]['file_associations'][$file_extension]);
        $user->set('navigation_plus_settings', $settings[0]);
        navigation_plus_save_outside_workspace($user);
      }
    }

    // @todo Return "saved" message.
    return new AjaxResponse(NULL, Response::HTTP_OK);
  }

}
