<?php

namespace Drupal\navigation_plus\Hooks;

use Drupal\Core\Render\Element;
use Drupal\Core\Entity\EntityInterface;
use Drupal\navigation_plus\NavigationPlusUi;
use Drupal\navigation_plus\Event\EditableUiBuilder;
use Drupal\navigation_plus\LoadEditablePageResponseTrait;
use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

class EntityViewAlter {

  use LoadEditablePageResponseTrait;

  /**
   * @var \Drupal\edit_plus\ParamConverter\EntityConverter
   */
  protected $entityConverter;

  public function __construct(
    private readonly NavigationPlusUi $navigationPlusUi,
    protected readonly EventDispatcherInterface $eventDispatcher,
  ) {}

  public function alter(array &$build, EntityInterface $entity, EntityViewDisplayInterface $display) {
    if (!\Drupal::currentUser()->hasPermission('use toolbar plus edit mode')) {
      return;
    }

    $violation = $this->ensureWorkspace($entity);
    if ($violation) {
      $wrapper = sprintf('data-navigation-plus-entity-wrapper="%s::%s::%s"', $entity->getEntityTypeId(), navigation_plus_entity_identifier($entity), $entity->bundle());
      $build['#markup'] = "<div $wrapper>$violation</div>";
      $build['#workspace_warning'] = TRUE;
      unset($build['#theme'], $build['#pre_render'], $build['_layout_builder']);
      foreach (Element::children($build) as $key) {
        unset($build[$key]);
      }
      return $build;
    }

    if (empty($build['#workspace_warning'])) {
      $this->buildEditModeUi($entity, $build, $display);
    }

  }

  public function buildEditModeUi(EntityInterface $entity, array &$build, EntityViewDisplayInterface $display) {
    $mode = $this->navigationPlusUi->getMode();
    if ($mode !== 'edit') {
      return;
    }
    $route_entity = $this->navigationPlusUi->deriveEntityFromRoute();
    if (empty($route_entity)) {
      return;
    }
    $entity_type_id = $route_entity->getEntityTypeId();
    if (empty($build["#$entity_type_id"])) {
      return;
    }

    $build_entity = $build["#$entity_type_id"];
    // Is this the entity we are editing?
    if ($build_entity->id() !== $route_entity->id() || $build_entity->getRevisionId() !== $route_entity->getRevisionId()) {
      return;
    }

    $entity = $this->entityConverter()->loadEntityFromTempstore($entity);

    // The editable elements need attributes and wrappers to let the JS know
    // what is editable. When this entity is rendered via a page request or
    // LoadEditablePage, dispatch a builder event and let Layout Builder +
    // replace the page with its UI. We don't need to worry about Edit+ because
    // it adds its field attributes based on whether we are in Edit mode.
    $event = $this->eventDispatcher->dispatch(new EditableUiBuilder($build, $mode, $entity, $build['#view_mode']), EditableUiBuilder::class);
    $build = $event->getBuild();
  }

  // @todo Remove implicit dependency on edit_plus. This will require a generic
  // @todo tempstore instead of sharing layout builders tempstore.
  public function entityConverter() {
    return \Drupal::service('edit_plus.param_converter.entity');
  }

}
