<?php

namespace Drupal\navigation_plus\Event;

use Drupal\media\Entity\Media;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Component\EventDispatcher\Event;

/**
 * Layout Builder replace media.
 *
 * A user has dragged a Media Type compatible file from their browser to a
 * dropzone on an existing Media Block on the page. We then replace the media.
 */
class LayoutBuilderReplaceMedia extends Event {

  protected AjaxResponse $response;

  public function __construct(
    protected Media $media,
    protected EntityInterface $entity,
    protected string $view_mode,
    protected string $media_reference
  ) {}

  /**
   * @return \Drupal\Core\Entity\EntityInterface
   */
  public function getEntity(): EntityInterface {
    return $this->entity;
  }

  public function getViewMode(): string {
    return $this->view_mode;
  }

  public function getMediaReference(): string {
    return $this->media_reference;
  }

  /**
   * @return \Drupal\Core\Ajax\AjaxResponse
   */
  public function getResponse(): AjaxResponse {
    return $this->response;
  }

  /**
   * @param \Drupal\Core\Ajax\AjaxResponse $response
   */
  public function setResponse(AjaxResponse $response): void {
    $this->response = $response;
  }

  /**
   * @return \Drupal\media\Entity\Media
   */
  public function getMedia(): Media {
    return $this->media;
  }

}
