<?php

namespace Drupal\navigation_plus\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * AJAX command for displaying messages through Edit Mode's message system.
 */
class EditModeMessageCommand implements CommandInterface {

  /**
   * The message to display.
   *
   * @var string
   */
  protected $message;

  /**
   * The message type.
   *
   * @var string
   */
  protected $type;

  /**
   * Constructs an EditModeMessageCommand object.
   *
   * @param string $message
   *   The message to display.
   * @param string $type
   *   The message type ('status', 'warning', 'error', etc.).
   */
  public function __construct(string $message, string $type = 'status') {
    $this->message = $message;
    $this->type = $type;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'editModeMessage',
      'message' => $this->message,
      'type' => $this->type,
    ];
  }

}