<?php

declare(strict_types=1);

namespace Drupal\navigation_plus\EventSubscriber;

use Drupal\navigation_plus\FlagNewPage;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * New Entity flag setter.
 */
final class NewEntitySubscriber implements EventSubscriberInterface {

  /**
   * Constructs a NewEntitySubscriber object.
   */
  public function __construct(
    private readonly FlagNewPage $navigationPlusFlagNewPage,
  ) {}

  /**
   * Kernel response event handler.
   */
  public function onKernelResponse(ResponseEvent $event): void {
    \Drupal::service('navigation_plus.flag_new_page')->informFrontEndOfNewEntity($event);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::RESPONSE => ['onKernelResponse'],
    ];
  }

}
