<?php

declare(strict_types=1);

namespace Drupal\navigation_plus\Controller;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\navigation_plus\Ajax\EditModeMessageCommand;
use Drupal\user\Entity\User;
use Drupal\Component\Utility\Html;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;
use Drupal\navigation_plus\NavigationPlusFormTrait;

/**
 * Settings sidebar end points.
 */
final class Settings extends ControllerBase {

  use StringTranslationTrait;
  use NavigationPlusFormTrait;

  /**
   * Save hotkey.
   */
  public function saveHotkey(string $tool_id, string $hotkey)  {
    $account = $this->currentUser();
    if ($account->isAuthenticated()) {
      $user = User::load($account->id());
      $settings = $user->navigation_plus_settings->getValue();
      $settings[0]['hotkeys'][$tool_id] = Html::escape($hotkey);
      $user->set('navigation_plus_settings', $settings[0]);

      navigation_plus_save_outside_workspace($user);
    }

    // @todo Return "saved" message.
    return new AjaxResponse(NULL, Response::HTTP_OK);
  }

  /**
   * Remove media file association.
   */
  public function removeMediaFileAssociation(string $file_extension)  {
    $account = $this->currentUser();
    if ($account->isAuthenticated()) {
      $user = User::load($account->id());
      $settings = $user->navigation_plus_settings->getValue();

      $save = FALSE;
      if (!empty($settings[0]['file_associations'][strtolower($file_extension)])) {
        unset($settings[0]['file_associations'][strtolower($file_extension)]);
        $save = TRUE;
      }
      if (!empty($settings[0]['file_associations'][strtoupper($file_extension)])) {
        unset($settings[0]['file_associations'][strtoupper($file_extension)]);
        $save = TRUE;
      }

      if ($save) {
        $user->set('navigation_plus_settings', $settings[0]);
        navigation_plus_save_outside_workspace($user);
      }
    }

    // @todo Return "saved" message.
    return new AjaxResponse(NULL, Response::HTTP_OK);
  }

}
