(($, Drupal, once) => {

  /**
   * Right sidebar buttons.
   *
   * @type {{attach(*, *): void}}
   */
  Drupal.behaviors.NpRightSideBarButtons = {
    attach(context, settings) {
      once('np-right-sidebar-buttons', '[data-right-sidebar-button-for]', context).forEach(button => {

        button.addEventListener('click', (e) => {
          const sidebar = document.querySelector(e.currentTarget.dataset.rightSidebarButtonFor);
          if (sidebar && sidebar.classList.contains('navigation-plus-hidden')) {
            Drupal.NavigationPlus.ModeManager.getPlugin('edit').openRightSidebar(sidebar);
          } else {
            Drupal.NavigationPlus.ModeManager.getPlugin('edit').closeRightSidebars();
          }
        });

      });
    }
  };

})(jQuery, Drupal, once);
