<?php

declare(strict_types=1);

namespace Drupal\netforum\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * PHP requirements for this module.
 */
class PhpRequirementsHook {

  use StringTranslationTrait;

  #[Hook('runtime_requirements')]
  public function runtime(): array {
    $requirements = [];

    // PHP SOAP extension is needed for this module to function!
    if (!extension_loaded('soap')) {
      $requirements['soap-extension'] = [
        'title' => $this->t('PHP SOAP extension'),
        'value' => $this->t('Not installed'),
        'description' => $this->t('The <a rel="noreferrer" href="https://www.php.net/manual/en/intro.soap.php">PHP SOAP extension</a> is required for the NetForum module.'),
        'severity' => REQUIREMENT_ERROR,
      ];
    }

    return $requirements;
  }

}
