<?php

declare(strict_types=1);

namespace Drupal\netforum;

use Drupal\netforum\xWeb\NetForumXml;

/**
 * Drupal Service to interact with the generated NetForum xWeb SDK.
 *
 * @phpcs:disable Drupal.NamingConventions.ValidFunctionName.ScopeNotCamelCaps
 */
interface NetForumXmlServiceInterface {

  public function newClient(NetForumXmlServiceOptions $options): NetForumXml;

  public function getClient(): NetForumXml;

  public function getClientOptions(): NetForumXmlServiceOptions;

  public function getGeneratedDate(): string;

  public function getGeneratedNFVersion(): string;

  public function getGeneratedRelease(): string;

}
