<?php

declare(strict_types=1);

namespace Drupal\netforum;

/**
 * SoapClient HTTP authentication types.
 */
enum SoapHttpAuthenticationType: int {

  case Basic = 0;

  case Digest = 1;

  public static function fromSoapOptionValue(int $value): SoapHttpAuthenticationType {
    return match ($value) {
      SOAP_AUTHENTICATION_BASIC => SoapHttpAuthenticationType::Basic,
      SOAP_AUTHENTICATION_DIGEST => SoapHttpAuthenticationType::Digest,
      default => throw new \ValueError("Unsupported SOAP authentication type: $value"),
    };
  }

  public function toSoapOptionValue(): int {
    return match ($this) {
      self::Basic => SOAP_AUTHENTICATION_BASIC,
      self::Digest => SOAP_AUTHENTICATION_DIGEST,
    };
  }

}
