<?php

declare(strict_types=1);

namespace Drupal\netforum;

/**
 * SoapClient WSDL Cache configuration options.
 */
enum SoapWsdlCacheType: int {

  case None = 0;

  case Disk = 1;

  case Memory = 2;

  case DiskAndMemory = 3;

  public static function fromSoapOptionValue(int $value): SoapWsdlCacheType {
    return match ($value) {
      WSDL_CACHE_NONE => SoapWsdlCacheType::None,
      WSDL_CACHE_DISK => SoapWsdlCacheType::Disk,
      WSDL_CACHE_MEMORY => SoapWsdlCacheType::Memory,
      WSDL_CACHE_BOTH => SoapWsdlCacheType::DiskAndMemory,
      default => throw new \ValueError("Unsupported SOAP authentication type: $value"),
    };
  }

  public function toSoapOptionValue(): int {
    return match ($this) {
      self::None => WSDL_CACHE_NONE,
      self::Disk => WSDL_CACHE_DISK,
      self::Memory => WSDL_CACHE_MEMORY,
      self::DiskAndMemory => WSDL_CACHE_BOTH,
    };
  }

}
