<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb;

/**
 * Interface that all authentication token handlers must implement.
 */
interface AuthTokenHandlerInterface {

  public function preSoapCall(string $name, SoapClient $soapClient, array|null $requestHeaders): void;

  public function postSoapCall(string $name, SoapClient $soapClient, array|null $responseHeaders): void;

  public function authenticate(): void;

  public function handlesTokenExpiry(): bool;

}
