<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAVFormControl ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfAVFormControl extends AbstractStructArrayBase
{
    /**
     * The AVFormControl
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\AVFormControl[]|null
     */
    protected ?array $AVFormControl = null;
    /**
     * Constructor method for ArrayOfAVFormControl
     * @uses ArrayOfAVFormControl::setAVFormControl()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AVFormControl[] $aVFormControl
     */
    public function __construct(?array $aVFormControl = null)
    {
        $this
            ->setAVFormControl($aVFormControl);
    }
    /**
     * Get AVFormControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl[]|null
     */
    public function getAVFormControl(): ?array
    {
        return $this->AVFormControl ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setAVFormControl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAVFormControl method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAVFormControlForArrayConstraintFromSetAVFormControl(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAVFormControlAVFormControlItem) {
            // validation for constraint: itemType
            if (!$arrayOfAVFormControlAVFormControlItem instanceof \Drupal\netforum\xWeb\Generated\StructType\AVFormControl) {
                $invalidValues[] = is_object($arrayOfAVFormControlAVFormControlItem) ? get_class($arrayOfAVFormControlAVFormControlItem) : sprintf('%s(%s)', gettype($arrayOfAVFormControlAVFormControlItem), var_export($arrayOfAVFormControlAVFormControlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AVFormControl property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\AVFormControl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set AVFormControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\AVFormControl[] $aVFormControl
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVFormControl
     */
    public function setAVFormControl(?array $aVFormControl = null): self
    {
        // validation for constraint: array
        if ('' !== ($aVFormControlArrayErrorMessage = self::validateAVFormControlForArrayConstraintFromSetAVFormControl($aVFormControl))) {
            throw new InvalidArgumentException($aVFormControlArrayErrorMessage, __LINE__);
        }
        if (is_null($aVFormControl) || (is_array($aVFormControl) && empty($aVFormControl))) {
            unset($this->AVFormControl);
        } else {
            $this->AVFormControl = $aVFormControl;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\AVFormControl
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\AVFormControl
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\AVFormControl
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\AVFormControl
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\AVFormControl
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\AVFormControl $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVFormControl
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\AVFormControl) {
            throw new InvalidArgumentException(sprintf('The AVFormControl property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\AVFormControl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AVFormControl
     */
    public function getAttributeName(): string
    {
        return 'AVFormControl';
    }
}
