<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAvailableValue ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAvailableValue
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfAvailableValue extends AbstractStructArrayBase
{
    /**
     * The AvailableValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\AvailableValue[]|null
     */
    protected ?array $AvailableValue = null;
    /**
     * Constructor method for ArrayOfAvailableValue
     * @uses ArrayOfAvailableValue::setAvailableValue()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AvailableValue[] $availableValue
     */
    public function __construct(?array $availableValue = null)
    {
        $this
            ->setAvailableValue($availableValue);
    }
    /**
     * Get AvailableValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue[]|null
     */
    public function getAvailableValue(): ?array
    {
        return $this->AvailableValue ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setAvailableValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailableValue method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailableValueForArrayConstraintFromSetAvailableValue(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAvailableValueAvailableValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfAvailableValueAvailableValueItem instanceof \Drupal\netforum\xWeb\Generated\StructType\AvailableValue) {
                $invalidValues[] = is_object($arrayOfAvailableValueAvailableValueItem) ? get_class($arrayOfAvailableValueAvailableValueItem) : sprintf('%s(%s)', gettype($arrayOfAvailableValueAvailableValueItem), var_export($arrayOfAvailableValueAvailableValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AvailableValue property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\AvailableValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set AvailableValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\AvailableValue[] $availableValue
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue
     */
    public function setAvailableValue(?array $availableValue = null): self
    {
        // validation for constraint: array
        if ('' !== ($availableValueArrayErrorMessage = self::validateAvailableValueForArrayConstraintFromSetAvailableValue($availableValue))) {
            throw new InvalidArgumentException($availableValueArrayErrorMessage, __LINE__);
        }
        if (is_null($availableValue) || (is_array($availableValue) && empty($availableValue))) {
            unset($this->AvailableValue);
        } else {
            $this->AvailableValue = $availableValue;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\AvailableValue
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\AvailableValue
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\AvailableValue
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\AvailableValue
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\AvailableValue|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\AvailableValue
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\AvailableValue $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\AvailableValue) {
            throw new InvalidArgumentException(sprintf('The AvailableValue property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\AvailableValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AvailableValue
     */
    public function getAttributeName(): string
    {
        return 'AvailableValue';
    }
}
