<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfColumn ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfColumn extends AbstractStructArrayBase
{
    /**
     * The Column
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\Column[]|null
     */
    protected ?array $Column = null;
    /**
     * Constructor method for ArrayOfColumn
     * @uses ArrayOfColumn::setColumn()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Column[] $column
     */
    public function __construct(?array $column = null)
    {
        $this
            ->setColumn($column);
    }
    /**
     * Get Column value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column[]|null
     */
    public function getColumn(): ?array
    {
        return $this->Column ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setColumn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColumn method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColumnForArrayConstraintFromSetColumn(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfColumnColumnItem) {
            // validation for constraint: itemType
            if (!$arrayOfColumnColumnItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Column) {
                $invalidValues[] = is_object($arrayOfColumnColumnItem) ? get_class($arrayOfColumnColumnItem) : sprintf('%s(%s)', gettype($arrayOfColumnColumnItem), var_export($arrayOfColumnColumnItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Column property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Column, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Column value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Column[] $column
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfColumn
     */
    public function setColumn(?array $column = null): self
    {
        // validation for constraint: array
        if ('' !== ($columnArrayErrorMessage = self::validateColumnForArrayConstraintFromSetColumn($column))) {
            throw new InvalidArgumentException($columnArrayErrorMessage, __LINE__);
        }
        if (is_null($column) || (is_array($column) && empty($column))) {
            unset($this->Column);
        } else {
            $this->Column = $column;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\Column
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\Column
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\Column
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\Column
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\Column
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Column $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfColumn
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Column) {
            throw new InvalidArgumentException(sprintf('The Column property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Column, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Column
     */
    public function getAttributeName(): string
    {
        return 'Column';
    }
}
