<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfListOption ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfListOption extends AbstractStructArrayBase
{
    /**
     * The ListOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\ListOption[]|null
     */
    protected ?array $ListOption = null;
    /**
     * Constructor method for ArrayOfListOption
     * @uses ArrayOfListOption::setListOption()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ListOption[] $listOption
     */
    public function __construct(?array $listOption = null)
    {
        $this
            ->setListOption($listOption);
    }
    /**
     * Get ListOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption[]|null
     */
    public function getListOption(): ?array
    {
        return $this->ListOption ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setListOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOption method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOptionForArrayConstraintFromSetListOption(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfListOptionListOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfListOptionListOptionItem instanceof \Drupal\netforum\xWeb\Generated\StructType\ListOption) {
                $invalidValues[] = is_object($arrayOfListOptionListOptionItem) ? get_class($arrayOfListOptionListOptionItem) : sprintf('%s(%s)', gettype($arrayOfListOptionListOptionItem), var_export($arrayOfListOptionListOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOption property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\ListOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set ListOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\ListOption[] $listOption
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption
     */
    public function setListOption(?array $listOption = null): self
    {
        // validation for constraint: array
        if ('' !== ($listOptionArrayErrorMessage = self::validateListOptionForArrayConstraintFromSetListOption($listOption))) {
            throw new InvalidArgumentException($listOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($listOption) || (is_array($listOption) && empty($listOption))) {
            unset($this->ListOption);
        } else {
            $this->ListOption = $listOption;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\ListOption
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\ListOption
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\ListOption
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\ListOption
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListOption|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\ListOption
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\ListOption $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfListOption
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\ListOption) {
            throw new InvalidArgumentException(sprintf('The ListOption property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\ListOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ListOption
     */
    public function getAttributeName(): string
    {
        return 'ListOption';
    }
}
