<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMailingListSetting ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfMailingListSetting extends AbstractStructArrayBase
{
    /**
     * The MailingListSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting[]|null
     */
    protected ?array $MailingListSetting = null;
    /**
     * Constructor method for ArrayOfMailingListSetting
     * @uses ArrayOfMailingListSetting::setMailingListSetting()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting[] $mailingListSetting
     */
    public function __construct(?array $mailingListSetting = null)
    {
        $this
            ->setMailingListSetting($mailingListSetting);
    }
    /**
     * Get MailingListSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting[]|null
     */
    public function getMailingListSetting(): ?array
    {
        return $this->MailingListSetting ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setMailingListSetting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailingListSetting method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailingListSettingForArrayConstraintFromSetMailingListSetting(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMailingListSettingMailingListSettingItem) {
            // validation for constraint: itemType
            if (!$arrayOfMailingListSettingMailingListSettingItem instanceof \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting) {
                $invalidValues[] = is_object($arrayOfMailingListSettingMailingListSettingItem) ? get_class($arrayOfMailingListSettingMailingListSettingItem) : sprintf('%s(%s)', gettype($arrayOfMailingListSettingMailingListSettingItem), var_export($arrayOfMailingListSettingMailingListSettingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MailingListSetting property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set MailingListSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting[] $mailingListSetting
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting
     */
    public function setMailingListSetting(?array $mailingListSetting = null): self
    {
        // validation for constraint: array
        if ('' !== ($mailingListSettingArrayErrorMessage = self::validateMailingListSettingForArrayConstraintFromSetMailingListSetting($mailingListSetting))) {
            throw new InvalidArgumentException($mailingListSettingArrayErrorMessage, __LINE__);
        }
        if (is_null($mailingListSetting) || (is_array($mailingListSetting) && empty($mailingListSetting))) {
            unset($this->MailingListSetting);
        } else {
            $this->MailingListSetting = $mailingListSetting;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\MailingListSetting
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfMailingListSetting
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting) {
            throw new InvalidArgumentException(sprintf('The MailingListSetting property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\MailingListSetting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MailingListSetting
     */
    public function getAttributeName(): string
    {
        return 'MailingListSetting';
    }
}
