<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AVFormControl StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AVFormControl extends DesignedFormControl
{
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $IsRequired;
    /**
     * The IsReadOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $IsReadOnly;
    /**
     * The IsInvisible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $IsInvisible;
    /**
     * The CausesAutoPostBack
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $CausesAutoPostBack;
    /**
     * The Left
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $Left;
    /**
     * The Top
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $Top;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $Height;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $Width;
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Caption = null;
    /**
     * The DataObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $DataObject = null;
    /**
     * The AvailableValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue $AvailableValues = null;
    /**
     * The DependantControls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString $DependantControls = null;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Name = null;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Type = null;
    /**
     * The DefaultValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $DefaultValue = null;
    /**
     * The InputMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $InputMask = null;
    /**
     * The GroupingTag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $GroupingTag = null;
    /**
     * Constructor method for AVFormControl
     * @uses AVFormControl::setIsRequired()
     * @uses AVFormControl::setIsReadOnly()
     * @uses AVFormControl::setIsInvisible()
     * @uses AVFormControl::setCausesAutoPostBack()
     * @uses AVFormControl::setLeft()
     * @uses AVFormControl::setTop()
     * @uses AVFormControl::setHeight()
     * @uses AVFormControl::setWidth()
     * @uses AVFormControl::setCaption()
     * @uses AVFormControl::setDataObject()
     * @uses AVFormControl::setAvailableValues()
     * @uses AVFormControl::setDependantControls()
     * @uses AVFormControl::setName()
     * @uses AVFormControl::setType()
     * @uses AVFormControl::setDefaultValue()
     * @uses AVFormControl::setInputMask()
     * @uses AVFormControl::setGroupingTag()
     * @param bool $isRequired
     * @param bool $isReadOnly
     * @param bool $isInvisible
     * @param bool $causesAutoPostBack
     * @param int $left
     * @param int $top
     * @param int $height
     * @param int $width
     * @param string $caption
     * @param string $dataObject
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue $availableValues
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString $dependantControls
     * @param string $name
     * @param string $type
     * @param string $defaultValue
     * @param string $inputMask
     * @param string $groupingTag
     */
    public function __construct(bool $isRequired, bool $isReadOnly, bool $isInvisible, bool $causesAutoPostBack, int $left, int $top, int $height, int $width, ?string $caption = null, ?string $dataObject = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue $availableValues = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString $dependantControls = null, ?string $name = null, ?string $type = null, ?string $defaultValue = null, ?string $inputMask = null, ?string $groupingTag = null)
    {
        $this
            ->setIsRequired($isRequired)
            ->setIsReadOnly($isReadOnly)
            ->setIsInvisible($isInvisible)
            ->setCausesAutoPostBack($causesAutoPostBack)
            ->setLeft($left)
            ->setTop($top)
            ->setHeight($height)
            ->setWidth($width)
            ->setCaption($caption)
            ->setDataObject($dataObject)
            ->setAvailableValues($availableValues)
            ->setDependantControls($dependantControls)
            ->setName($name)
            ->setType($type)
            ->setDefaultValue($defaultValue)
            ->setInputMask($inputMask)
            ->setGroupingTag($groupingTag);
    }
    /**
     * Get IsRequired value
     * @return bool
     */
    public function getIsRequired(): bool
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setIsRequired(bool $isRequired): self
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        
        return $this;
    }
    /**
     * Get IsReadOnly value
     * @return bool
     */
    public function getIsReadOnly(): bool
    {
        return $this->IsReadOnly;
    }
    /**
     * Set IsReadOnly value
     * @param bool $isReadOnly
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setIsReadOnly(bool $isReadOnly): self
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadOnly, true), gettype($isReadOnly)), __LINE__);
        }
        $this->IsReadOnly = $isReadOnly;
        
        return $this;
    }
    /**
     * Get IsInvisible value
     * @return bool
     */
    public function getIsInvisible(): bool
    {
        return $this->IsInvisible;
    }
    /**
     * Set IsInvisible value
     * @param bool $isInvisible
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setIsInvisible(bool $isInvisible): self
    {
        // validation for constraint: boolean
        if (!is_null($isInvisible) && !is_bool($isInvisible)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInvisible, true), gettype($isInvisible)), __LINE__);
        }
        $this->IsInvisible = $isInvisible;
        
        return $this;
    }
    /**
     * Get CausesAutoPostBack value
     * @return bool
     */
    public function getCausesAutoPostBack(): bool
    {
        return $this->CausesAutoPostBack;
    }
    /**
     * Set CausesAutoPostBack value
     * @param bool $causesAutoPostBack
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setCausesAutoPostBack(bool $causesAutoPostBack): self
    {
        // validation for constraint: boolean
        if (!is_null($causesAutoPostBack) && !is_bool($causesAutoPostBack)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($causesAutoPostBack, true), gettype($causesAutoPostBack)), __LINE__);
        }
        $this->CausesAutoPostBack = $causesAutoPostBack;
        
        return $this;
    }
    /**
     * Get Left value
     * @return int
     */
    public function getLeft(): int
    {
        return $this->Left;
    }
    /**
     * Set Left value
     * @param int $left
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setLeft(int $left): self
    {
        // validation for constraint: int
        if (!is_null($left) && !(is_int($left) || ctype_digit($left))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($left, true), gettype($left)), __LINE__);
        }
        $this->Left = $left;
        
        return $this;
    }
    /**
     * Get Top value
     * @return int
     */
    public function getTop(): int
    {
        return $this->Top;
    }
    /**
     * Set Top value
     * @param int $top
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setTop(int $top): self
    {
        // validation for constraint: int
        if (!is_null($top) && !(is_int($top) || ctype_digit($top))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($top, true), gettype($top)), __LINE__);
        }
        $this->Top = $top;
        
        return $this;
    }
    /**
     * Get Height value
     * @return int
     */
    public function getHeight(): int
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setHeight(int $height): self
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        
        return $this;
    }
    /**
     * Get Width value
     * @return int
     */
    public function getWidth(): int
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setWidth(int $width): self
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption(): ?string
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setCaption(?string $caption = null): self
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        
        return $this;
    }
    /**
     * Get DataObject value
     * @return string|null
     */
    public function getDataObject(): ?string
    {
        return $this->DataObject;
    }
    /**
     * Set DataObject value
     * @param string $dataObject
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setDataObject(?string $dataObject = null): self
    {
        // validation for constraint: string
        if (!is_null($dataObject) && !is_string($dataObject)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataObject, true), gettype($dataObject)), __LINE__);
        }
        $this->DataObject = $dataObject;
        
        return $this;
    }
    /**
     * Get AvailableValues value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue|null
     */
    public function getAvailableValues(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue
    {
        return $this->AvailableValues;
    }
    /**
     * Set AvailableValues value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue $availableValues
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setAvailableValues(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAvailableValue $availableValues = null): self
    {
        $this->AvailableValues = $availableValues;
        
        return $this;
    }
    /**
     * Get DependantControls value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString|null
     */
    public function getDependantControls(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString
    {
        return $this->DependantControls;
    }
    /**
     * Set DependantControls value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString $dependantControls
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setDependantControls(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString $dependantControls = null): self
    {
        $this->DependantControls = $dependantControls;
        
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setName(?string $name = null): self
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setType(?string $type = null): self
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue(): ?string
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setDefaultValue(?string $defaultValue = null): self
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        
        return $this;
    }
    /**
     * Get InputMask value
     * @return string|null
     */
    public function getInputMask(): ?string
    {
        return $this->InputMask;
    }
    /**
     * Set InputMask value
     * @param string $inputMask
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setInputMask(?string $inputMask = null): self
    {
        // validation for constraint: string
        if (!is_null($inputMask) && !is_string($inputMask)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputMask, true), gettype($inputMask)), __LINE__);
        }
        $this->InputMask = $inputMask;
        
        return $this;
    }
    /**
     * Get GroupingTag value
     * @return string|null
     */
    public function getGroupingTag(): ?string
    {
        return $this->GroupingTag;
    }
    /**
     * Set GroupingTag value
     * @param string $groupingTag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormControl
     */
    public function setGroupingTag(?string $groupingTag = null): self
    {
        // validation for constraint: string
        if (!is_null($groupingTag) && !is_string($groupingTag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupingTag, true), gettype($groupingTag)), __LINE__);
        }
        $this->GroupingTag = $groupingTag;
        
        return $this;
    }
}
