<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AVFormDataInterface StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AVFormDataInterface extends AbstractStructBase
{
    /**
     * The InsertMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $InsertMethod = null;
    /**
     * The UpdateMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $UpdateMethod = null;
    /**
     * The SelectMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $SelectMethod = null;
    /**
     * The RefreshMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $RefreshMethod = null;
    /**
     * The DeleteMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $DeleteMethod = null;
    /**
     * The ServiceUrl
     * @var string|null
     */
    protected ?string $ServiceUrl = null;
    /**
     * Constructor method for AVFormDataInterface
     * @uses AVFormDataInterface::setInsertMethod()
     * @uses AVFormDataInterface::setUpdateMethod()
     * @uses AVFormDataInterface::setSelectMethod()
     * @uses AVFormDataInterface::setRefreshMethod()
     * @uses AVFormDataInterface::setDeleteMethod()
     * @uses AVFormDataInterface::setServiceUrl()
     * @param string $insertMethod
     * @param string $updateMethod
     * @param string $selectMethod
     * @param string $refreshMethod
     * @param string $deleteMethod
     * @param string $serviceUrl
     */
    public function __construct(?string $insertMethod = null, ?string $updateMethod = null, ?string $selectMethod = null, ?string $refreshMethod = null, ?string $deleteMethod = null, ?string $serviceUrl = null)
    {
        $this
            ->setInsertMethod($insertMethod)
            ->setUpdateMethod($updateMethod)
            ->setSelectMethod($selectMethod)
            ->setRefreshMethod($refreshMethod)
            ->setDeleteMethod($deleteMethod)
            ->setServiceUrl($serviceUrl);
    }
    /**
     * Get InsertMethod value
     * @return string|null
     */
    public function getInsertMethod(): ?string
    {
        return $this->InsertMethod;
    }
    /**
     * Set InsertMethod value
     * @param string $insertMethod
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setInsertMethod(?string $insertMethod = null): self
    {
        // validation for constraint: string
        if (!is_null($insertMethod) && !is_string($insertMethod)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertMethod, true), gettype($insertMethod)), __LINE__);
        }
        $this->InsertMethod = $insertMethod;
        
        return $this;
    }
    /**
     * Get UpdateMethod value
     * @return string|null
     */
    public function getUpdateMethod(): ?string
    {
        return $this->UpdateMethod;
    }
    /**
     * Set UpdateMethod value
     * @param string $updateMethod
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setUpdateMethod(?string $updateMethod = null): self
    {
        // validation for constraint: string
        if (!is_null($updateMethod) && !is_string($updateMethod)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateMethod, true), gettype($updateMethod)), __LINE__);
        }
        $this->UpdateMethod = $updateMethod;
        
        return $this;
    }
    /**
     * Get SelectMethod value
     * @return string|null
     */
    public function getSelectMethod(): ?string
    {
        return $this->SelectMethod;
    }
    /**
     * Set SelectMethod value
     * @param string $selectMethod
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setSelectMethod(?string $selectMethod = null): self
    {
        // validation for constraint: string
        if (!is_null($selectMethod) && !is_string($selectMethod)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectMethod, true), gettype($selectMethod)), __LINE__);
        }
        $this->SelectMethod = $selectMethod;
        
        return $this;
    }
    /**
     * Get RefreshMethod value
     * @return string|null
     */
    public function getRefreshMethod(): ?string
    {
        return $this->RefreshMethod;
    }
    /**
     * Set RefreshMethod value
     * @param string $refreshMethod
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setRefreshMethod(?string $refreshMethod = null): self
    {
        // validation for constraint: string
        if (!is_null($refreshMethod) && !is_string($refreshMethod)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refreshMethod, true), gettype($refreshMethod)), __LINE__);
        }
        $this->RefreshMethod = $refreshMethod;
        
        return $this;
    }
    /**
     * Get DeleteMethod value
     * @return string|null
     */
    public function getDeleteMethod(): ?string
    {
        return $this->DeleteMethod;
    }
    /**
     * Set DeleteMethod value
     * @param string $deleteMethod
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setDeleteMethod(?string $deleteMethod = null): self
    {
        // validation for constraint: string
        if (!is_null($deleteMethod) && !is_string($deleteMethod)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deleteMethod, true), gettype($deleteMethod)), __LINE__);
        }
        $this->DeleteMethod = $deleteMethod;
        
        return $this;
    }
    /**
     * Get ServiceUrl value
     * @return string|null
     */
    public function getServiceUrl(): ?string
    {
        return $this->ServiceUrl;
    }
    /**
     * Set ServiceUrl value
     * @param string $serviceUrl
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormDataInterface
     */
    public function setServiceUrl(?string $serviceUrl = null): self
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceUrl, true), gettype($serviceUrl)), __LINE__);
        }
        $this->ServiceUrl = $serviceUrl;
        
        return $this;
    }
}
