<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AVWizard StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AVWizard extends AbstractStructBase
{
    /**
     * The ObjectKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ObjectKey;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Description = null;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Title = null;
    /**
     * The ObjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectName = null;
    /**
     * The ObjectPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectPrefix = null;
    /**
     * The ObjectType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectType = null;
    /**
     * The Forms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm $Forms = null;
    /**
     * Constructor method for AVWizard
     * @uses AVWizard::setObjectKey()
     * @uses AVWizard::setDescription()
     * @uses AVWizard::setTitle()
     * @uses AVWizard::setObjectName()
     * @uses AVWizard::setObjectPrefix()
     * @uses AVWizard::setObjectType()
     * @uses AVWizard::setForms()
     * @param string $objectKey
     * @param string $description
     * @param string $title
     * @param string $objectName
     * @param string $objectPrefix
     * @param string $objectType
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm $forms
     */
    public function __construct(string $objectKey, ?string $description = null, ?string $title = null, ?string $objectName = null, ?string $objectPrefix = null, ?string $objectType = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm $forms = null)
    {
        $this
            ->setObjectKey($objectKey)
            ->setDescription($description)
            ->setTitle($title)
            ->setObjectName($objectName)
            ->setObjectPrefix($objectPrefix)
            ->setObjectType($objectType)
            ->setForms($forms);
    }
    /**
     * Get ObjectKey value
     * @return string
     */
    public function getObjectKey(): string
    {
        return $this->ObjectKey;
    }
    /**
     * Set ObjectKey value
     * @param string $objectKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setObjectKey(string $objectKey): self
    {
        // validation for constraint: string
        if (!is_null($objectKey) && !is_string($objectKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectKey, true), gettype($objectKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($objectKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $objectKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($objectKey, true)), __LINE__);
        }
        $this->ObjectKey = $objectKey;
        
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setDescription(?string $description = null): self
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setTitle(?string $title = null): self
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        
        return $this;
    }
    /**
     * Get ObjectName value
     * @return string|null
     */
    public function getObjectName(): ?string
    {
        return $this->ObjectName;
    }
    /**
     * Set ObjectName value
     * @param string $objectName
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setObjectName(?string $objectName = null): self
    {
        // validation for constraint: string
        if (!is_null($objectName) && !is_string($objectName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectName, true), gettype($objectName)), __LINE__);
        }
        $this->ObjectName = $objectName;
        
        return $this;
    }
    /**
     * Get ObjectPrefix value
     * @return string|null
     */
    public function getObjectPrefix(): ?string
    {
        return $this->ObjectPrefix;
    }
    /**
     * Set ObjectPrefix value
     * @param string $objectPrefix
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setObjectPrefix(?string $objectPrefix = null): self
    {
        // validation for constraint: string
        if (!is_null($objectPrefix) && !is_string($objectPrefix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectPrefix, true), gettype($objectPrefix)), __LINE__);
        }
        $this->ObjectPrefix = $objectPrefix;
        
        return $this;
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType(): ?string
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setObjectType(?string $objectType = null): self
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectType, true), gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        
        return $this;
    }
    /**
     * Get Forms value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm|null
     */
    public function getForms(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm
    {
        return $this->Forms;
    }
    /**
     * Set Forms value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm $forms
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizard
     */
    public function setForms(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfAVWizardForm $forms = null): self
    {
        $this->Forms = $forms;
        
        return $this;
    }
}
