<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AVWizardForm StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AVWizardForm extends AbstractStructBase
{
    /**
     * The ObjectKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ObjectKey;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $Order;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Key = null;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Title = null;
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Header = null;
    /**
     * The ObjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectName = null;
    /**
     * The ObjectPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectPrefix = null;
    /**
     * The ObjectType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ObjectType = null;
    /**
     * The ProgressBarTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $ProgressBarTitle = null;
    /**
     * The StepTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $StepTitle = null;
    /**
     * Constructor method for AVWizardForm
     * @uses AVWizardForm::setObjectKey()
     * @uses AVWizardForm::setOrder()
     * @uses AVWizardForm::setKey()
     * @uses AVWizardForm::setTitle()
     * @uses AVWizardForm::setHeader()
     * @uses AVWizardForm::setObjectName()
     * @uses AVWizardForm::setObjectPrefix()
     * @uses AVWizardForm::setObjectType()
     * @uses AVWizardForm::setProgressBarTitle()
     * @uses AVWizardForm::setStepTitle()
     * @param string $objectKey
     * @param int $order
     * @param string $key
     * @param string $title
     * @param string $header
     * @param string $objectName
     * @param string $objectPrefix
     * @param string $objectType
     * @param string $progressBarTitle
     * @param string $stepTitle
     */
    public function __construct(string $objectKey, int $order, ?string $key = null, ?string $title = null, ?string $header = null, ?string $objectName = null, ?string $objectPrefix = null, ?string $objectType = null, ?string $progressBarTitle = null, ?string $stepTitle = null)
    {
        $this
            ->setObjectKey($objectKey)
            ->setOrder($order)
            ->setKey($key)
            ->setTitle($title)
            ->setHeader($header)
            ->setObjectName($objectName)
            ->setObjectPrefix($objectPrefix)
            ->setObjectType($objectType)
            ->setProgressBarTitle($progressBarTitle)
            ->setStepTitle($stepTitle);
    }
    /**
     * Get ObjectKey value
     * @return string
     */
    public function getObjectKey(): string
    {
        return $this->ObjectKey;
    }
    /**
     * Set ObjectKey value
     * @param string $objectKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setObjectKey(string $objectKey): self
    {
        // validation for constraint: string
        if (!is_null($objectKey) && !is_string($objectKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectKey, true), gettype($objectKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($objectKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $objectKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($objectKey, true)), __LINE__);
        }
        $this->ObjectKey = $objectKey;
        
        return $this;
    }
    /**
     * Get Order value
     * @return int
     */
    public function getOrder(): int
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setOrder(int $order): self
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        
        return $this;
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey(): ?string
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setKey(?string $key = null): self
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setTitle(?string $title = null): self
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        
        return $this;
    }
    /**
     * Get Header value
     * @return string|null
     */
    public function getHeader(): ?string
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param string $header
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setHeader(?string $header = null): self
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->Header = $header;
        
        return $this;
    }
    /**
     * Get ObjectName value
     * @return string|null
     */
    public function getObjectName(): ?string
    {
        return $this->ObjectName;
    }
    /**
     * Set ObjectName value
     * @param string $objectName
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setObjectName(?string $objectName = null): self
    {
        // validation for constraint: string
        if (!is_null($objectName) && !is_string($objectName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectName, true), gettype($objectName)), __LINE__);
        }
        $this->ObjectName = $objectName;
        
        return $this;
    }
    /**
     * Get ObjectPrefix value
     * @return string|null
     */
    public function getObjectPrefix(): ?string
    {
        return $this->ObjectPrefix;
    }
    /**
     * Set ObjectPrefix value
     * @param string $objectPrefix
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setObjectPrefix(?string $objectPrefix = null): self
    {
        // validation for constraint: string
        if (!is_null($objectPrefix) && !is_string($objectPrefix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectPrefix, true), gettype($objectPrefix)), __LINE__);
        }
        $this->ObjectPrefix = $objectPrefix;
        
        return $this;
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType(): ?string
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setObjectType(?string $objectType = null): self
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectType, true), gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        
        return $this;
    }
    /**
     * Get ProgressBarTitle value
     * @return string|null
     */
    public function getProgressBarTitle(): ?string
    {
        return $this->ProgressBarTitle;
    }
    /**
     * Set ProgressBarTitle value
     * @param string $progressBarTitle
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setProgressBarTitle(?string $progressBarTitle = null): self
    {
        // validation for constraint: string
        if (!is_null($progressBarTitle) && !is_string($progressBarTitle)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($progressBarTitle, true), gettype($progressBarTitle)), __LINE__);
        }
        $this->ProgressBarTitle = $progressBarTitle;
        
        return $this;
    }
    /**
     * Get StepTitle value
     * @return string|null
     */
    public function getStepTitle(): ?string
    {
        return $this->StepTitle;
    }
    /**
     * Set StepTitle value
     * @param string $stepTitle
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVWizardForm
     */
    public function setStepTitle(?string $stepTitle = null): self
    {
        // validation for constraint: string
        if (!is_null($stepTitle) && !is_string($stepTitle)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stepTitle, true), gettype($stepTitle)), __LINE__);
        }
        $this->StepTitle = $stepTitle;
        
        return $this;
    }
}
