<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Accreditation_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Accreditation_DataObjectType extends AbstractStructBase
{
    /**
     * The ama_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ama_key = null;
    /**
     * The ama_code
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_code = null;
    /**
     * The ama_desc
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_desc = null;
    /**
     * The ama_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_add_user = null;
    /**
     * The ama_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_add_date = null;
    /**
     * The ama_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_change_user = null;
    /**
     * The ama_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_change_date = null;
    /**
     * The ama_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ama_delete_flag = null;
    /**
     * The ama_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ama_key_ext = null;
    /**
     * The ama_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ama_entity_key = null;
    /**
     * Constructor method for AccreditationArea_Accreditation_DataObjectType
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_key()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_code()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_desc()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_add_user()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_add_date()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_change_user()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_change_date()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_delete_flag()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_key_ext()
     * @uses AccreditationArea_Accreditation_DataObjectType::setAma_entity_key()
     * @param string $ama_key
     * @param string $ama_code
     * @param string $ama_desc
     * @param string $ama_add_user
     * @param string $ama_add_date
     * @param string $ama_change_user
     * @param string $ama_change_date
     * @param string $ama_delete_flag
     * @param string $ama_key_ext
     * @param string $ama_entity_key
     */
    public function __construct(?string $ama_key = null, ?string $ama_code = null, ?string $ama_desc = null, ?string $ama_add_user = null, ?string $ama_add_date = null, ?string $ama_change_user = null, ?string $ama_change_date = null, ?string $ama_delete_flag = null, ?string $ama_key_ext = null, ?string $ama_entity_key = null)
    {
        $this
            ->setAma_key($ama_key)
            ->setAma_code($ama_code)
            ->setAma_desc($ama_desc)
            ->setAma_add_user($ama_add_user)
            ->setAma_add_date($ama_add_date)
            ->setAma_change_user($ama_change_user)
            ->setAma_change_date($ama_change_date)
            ->setAma_delete_flag($ama_delete_flag)
            ->setAma_key_ext($ama_key_ext)
            ->setAma_entity_key($ama_entity_key);
    }
    /**
     * Get ama_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_key(): ?string
    {
        return $this->ama_key ?? null;
    }
    /**
     * Set ama_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_key(?string $ama_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_key) && !is_string($ama_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_key, true), gettype($ama_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ama_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ama_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ama_key, true)), __LINE__);
        }
        if (is_null($ama_key) || (is_array($ama_key) && empty($ama_key))) {
            unset($this->ama_key);
        } else {
            $this->ama_key = $ama_key;
        }
        
        return $this;
    }
    /**
     * Get ama_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_code(): ?string
    {
        return $this->ama_code ?? null;
    }
    /**
     * Set ama_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_code(?string $ama_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_code) && !is_string($ama_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_code, true), gettype($ama_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ama_code) && mb_strlen((string) $ama_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ama_code)), __LINE__);
        }
        if (is_null($ama_code) || (is_array($ama_code) && empty($ama_code))) {
            unset($this->ama_code);
        } else {
            $this->ama_code = $ama_code;
        }
        
        return $this;
    }
    /**
     * Get ama_desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_desc(): ?string
    {
        return $this->ama_desc ?? null;
    }
    /**
     * Set ama_desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_desc
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_desc(?string $ama_desc = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_desc) && !is_string($ama_desc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_desc, true), gettype($ama_desc)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ama_desc) && mb_strlen((string) $ama_desc) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $ama_desc)), __LINE__);
        }
        if (is_null($ama_desc) || (is_array($ama_desc) && empty($ama_desc))) {
            unset($this->ama_desc);
        } else {
            $this->ama_desc = $ama_desc;
        }
        
        return $this;
    }
    /**
     * Get ama_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_add_user(): ?string
    {
        return $this->ama_add_user ?? null;
    }
    /**
     * Set ama_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_add_user(?string $ama_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_add_user) && !is_string($ama_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_add_user, true), gettype($ama_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ama_add_user) && mb_strlen((string) $ama_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ama_add_user)), __LINE__);
        }
        if (is_null($ama_add_user) || (is_array($ama_add_user) && empty($ama_add_user))) {
            unset($this->ama_add_user);
        } else {
            $this->ama_add_user = $ama_add_user;
        }
        
        return $this;
    }
    /**
     * Get ama_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_add_date(): ?string
    {
        return $this->ama_add_date ?? null;
    }
    /**
     * Set ama_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_add_date(?string $ama_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_add_date) && !is_string($ama_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_add_date, true), gettype($ama_add_date)), __LINE__);
        }
        if (is_null($ama_add_date) || (is_array($ama_add_date) && empty($ama_add_date))) {
            unset($this->ama_add_date);
        } else {
            $this->ama_add_date = $ama_add_date;
        }
        
        return $this;
    }
    /**
     * Get ama_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_change_user(): ?string
    {
        return $this->ama_change_user ?? null;
    }
    /**
     * Set ama_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_change_user(?string $ama_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_change_user) && !is_string($ama_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_change_user, true), gettype($ama_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ama_change_user) && mb_strlen((string) $ama_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ama_change_user)), __LINE__);
        }
        if (is_null($ama_change_user) || (is_array($ama_change_user) && empty($ama_change_user))) {
            unset($this->ama_change_user);
        } else {
            $this->ama_change_user = $ama_change_user;
        }
        
        return $this;
    }
    /**
     * Get ama_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_change_date(): ?string
    {
        return $this->ama_change_date ?? null;
    }
    /**
     * Set ama_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_change_date(?string $ama_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_change_date) && !is_string($ama_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_change_date, true), gettype($ama_change_date)), __LINE__);
        }
        if (is_null($ama_change_date) || (is_array($ama_change_date) && empty($ama_change_date))) {
            unset($this->ama_change_date);
        } else {
            $this->ama_change_date = $ama_change_date;
        }
        
        return $this;
    }
    /**
     * Get ama_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_delete_flag(): ?string
    {
        return $this->ama_delete_flag ?? null;
    }
    /**
     * Set ama_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_delete_flag(?string $ama_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_delete_flag) && !is_string($ama_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_delete_flag, true), gettype($ama_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ama_delete_flag) && $ama_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ama_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ama_delete_flag) && $ama_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ama_delete_flag, true)), __LINE__);
        }
        if (is_null($ama_delete_flag) || (is_array($ama_delete_flag) && empty($ama_delete_flag))) {
            unset($this->ama_delete_flag);
        } else {
            $this->ama_delete_flag = $ama_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ama_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_key_ext(): ?string
    {
        return $this->ama_key_ext ?? null;
    }
    /**
     * Set ama_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_key_ext(?string $ama_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_key_ext) && !is_string($ama_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_key_ext, true), gettype($ama_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ama_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ama_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ama_key_ext, true)), __LINE__);
        }
        if (is_null($ama_key_ext) || (is_array($ama_key_ext) && empty($ama_key_ext))) {
            unset($this->ama_key_ext);
        } else {
            $this->ama_key_ext = $ama_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ama_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAma_entity_key(): ?string
    {
        return $this->ama_entity_key ?? null;
    }
    /**
     * Set ama_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ama_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
     */
    public function setAma_entity_key(?string $ama_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ama_entity_key) && !is_string($ama_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ama_entity_key, true), gettype($ama_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ama_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ama_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ama_entity_key, true)), __LINE__);
        }
        if (is_null($ama_entity_key) || (is_array($ama_entity_key) && empty($ama_entity_key))) {
            unset($this->ama_entity_key);
        } else {
            $this->ama_entity_key = $ama_entity_key;
        }
        
        return $this;
    }
}
