<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Accreditation_Type_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Accreditation_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The amt_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amt_key = null;
    /**
     * The amt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_add_user = null;
    /**
     * The amt_add_date
     * Meta information extracted from the WSDL
     * - documentation: amt_add_date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_add_date = null;
    /**
     * The amt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_change_user = null;
    /**
     * The amt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_change_date = null;
    /**
     * The amt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_delete_flag = null;
    /**
     * The amt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amt_entity_key = null;
    /**
     * The amt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amt_key_ext = null;
    /**
     * The amt_desc
     * Meta information extracted from the WSDL
     * - documentation: Type Desc. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amt_desc = null;
    /**
     * Constructor method for AccreditationArea_Accreditation_Type_DataObjectType
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_key()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_add_user()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_add_date()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_change_user()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_change_date()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_delete_flag()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_entity_key()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_key_ext()
     * @uses AccreditationArea_Accreditation_Type_DataObjectType::setAmt_desc()
     * @param string $amt_key
     * @param string $amt_add_user
     * @param string $amt_add_date
     * @param string $amt_change_user
     * @param string $amt_change_date
     * @param string $amt_delete_flag
     * @param string $amt_entity_key
     * @param string $amt_key_ext
     * @param string $amt_desc
     */
    public function __construct(?string $amt_key = null, ?string $amt_add_user = null, ?string $amt_add_date = null, ?string $amt_change_user = null, ?string $amt_change_date = null, ?string $amt_delete_flag = null, ?string $amt_entity_key = null, ?string $amt_key_ext = null, ?string $amt_desc = null)
    {
        $this
            ->setAmt_key($amt_key)
            ->setAmt_add_user($amt_add_user)
            ->setAmt_add_date($amt_add_date)
            ->setAmt_change_user($amt_change_user)
            ->setAmt_change_date($amt_change_date)
            ->setAmt_delete_flag($amt_delete_flag)
            ->setAmt_entity_key($amt_entity_key)
            ->setAmt_key_ext($amt_key_ext)
            ->setAmt_desc($amt_desc);
    }
    /**
     * Get amt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_key(): ?string
    {
        return $this->amt_key ?? null;
    }
    /**
     * Set amt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_key(?string $amt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_key) && !is_string($amt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_key, true), gettype($amt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amt_key, true)), __LINE__);
        }
        if (is_null($amt_key) || (is_array($amt_key) && empty($amt_key))) {
            unset($this->amt_key);
        } else {
            $this->amt_key = $amt_key;
        }
        
        return $this;
    }
    /**
     * Get amt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_add_user(): ?string
    {
        return $this->amt_add_user ?? null;
    }
    /**
     * Set amt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_add_user(?string $amt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_add_user) && !is_string($amt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_add_user, true), gettype($amt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($amt_add_user) && mb_strlen((string) $amt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $amt_add_user)), __LINE__);
        }
        if (is_null($amt_add_user) || (is_array($amt_add_user) && empty($amt_add_user))) {
            unset($this->amt_add_user);
        } else {
            $this->amt_add_user = $amt_add_user;
        }
        
        return $this;
    }
    /**
     * Get amt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_add_date(): ?string
    {
        return $this->amt_add_date ?? null;
    }
    /**
     * Set amt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_add_date(?string $amt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_add_date) && !is_string($amt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_add_date, true), gettype($amt_add_date)), __LINE__);
        }
        if (is_null($amt_add_date) || (is_array($amt_add_date) && empty($amt_add_date))) {
            unset($this->amt_add_date);
        } else {
            $this->amt_add_date = $amt_add_date;
        }
        
        return $this;
    }
    /**
     * Get amt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_change_user(): ?string
    {
        return $this->amt_change_user ?? null;
    }
    /**
     * Set amt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_change_user(?string $amt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_change_user) && !is_string($amt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_change_user, true), gettype($amt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($amt_change_user) && mb_strlen((string) $amt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $amt_change_user)), __LINE__);
        }
        if (is_null($amt_change_user) || (is_array($amt_change_user) && empty($amt_change_user))) {
            unset($this->amt_change_user);
        } else {
            $this->amt_change_user = $amt_change_user;
        }
        
        return $this;
    }
    /**
     * Get amt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_change_date(): ?string
    {
        return $this->amt_change_date ?? null;
    }
    /**
     * Set amt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_change_date(?string $amt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_change_date) && !is_string($amt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_change_date, true), gettype($amt_change_date)), __LINE__);
        }
        if (is_null($amt_change_date) || (is_array($amt_change_date) && empty($amt_change_date))) {
            unset($this->amt_change_date);
        } else {
            $this->amt_change_date = $amt_change_date;
        }
        
        return $this;
    }
    /**
     * Get amt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_delete_flag(): ?string
    {
        return $this->amt_delete_flag ?? null;
    }
    /**
     * Set amt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_delete_flag(?string $amt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_delete_flag) && !is_string($amt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_delete_flag, true), gettype($amt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($amt_delete_flag) && $amt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($amt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amt_delete_flag) && $amt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amt_delete_flag, true)), __LINE__);
        }
        if (is_null($amt_delete_flag) || (is_array($amt_delete_flag) && empty($amt_delete_flag))) {
            unset($this->amt_delete_flag);
        } else {
            $this->amt_delete_flag = $amt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get amt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_entity_key(): ?string
    {
        return $this->amt_entity_key ?? null;
    }
    /**
     * Set amt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_entity_key(?string $amt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_entity_key) && !is_string($amt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_entity_key, true), gettype($amt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amt_entity_key, true)), __LINE__);
        }
        if (is_null($amt_entity_key) || (is_array($amt_entity_key) && empty($amt_entity_key))) {
            unset($this->amt_entity_key);
        } else {
            $this->amt_entity_key = $amt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get amt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_key_ext(): ?string
    {
        return $this->amt_key_ext ?? null;
    }
    /**
     * Set amt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_key_ext(?string $amt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_key_ext) && !is_string($amt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_key_ext, true), gettype($amt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amt_key_ext, true)), __LINE__);
        }
        if (is_null($amt_key_ext) || (is_array($amt_key_ext) && empty($amt_key_ext))) {
            unset($this->amt_key_ext);
        } else {
            $this->amt_key_ext = $amt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get amt_desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmt_desc(): ?string
    {
        return $this->amt_desc ?? null;
    }
    /**
     * Set amt_desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amt_desc
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
     */
    public function setAmt_desc(?string $amt_desc = null): self
    {
        // validation for constraint: string
        if (!is_null($amt_desc) && !is_string($amt_desc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amt_desc, true), gettype($amt_desc)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($amt_desc) && mb_strlen((string) $amt_desc) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $amt_desc)), __LINE__);
        }
        if (is_null($amt_desc) || (is_array($amt_desc) && empty($amt_desc))) {
            unset($this->amt_desc);
        } else {
            $this->amt_desc = $amt_desc;
        }
        
        return $this;
    }
}
