<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Affiliated_CAO_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Affiliated_CAO_DataObjectType extends AbstractStructBase
{
    /**
     * The cao__cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_key = null;
    /**
     * The cao__cst_type
     * Meta information extracted from the WSDL
     * - documentation: Customer Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_type = null;
    /**
     * The cao__cst_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Name . This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_name_cp = null;
    /**
     * The cao__cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Customer Sort Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_sort_name_dn = null;
    /**
     * The cao__cst_ind_full_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_ind_full_name_dn = null;
    /**
     * The cao__cst_org_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_org_name_dn = null;
    /**
     * The cao__cst_ixo_title_dn
     * Meta information extracted from the WSDL
     * - documentation: Title. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_ixo_title_dn = null;
    /**
     * The cao__cst_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Comm Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_pref_comm_meth = null;
    /**
     * The cao__cst_bio
     * Meta information extracted from the WSDL
     * - documentation: Biographical Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_bio = null;
    /**
     * The cao__cst_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_add_date = null;
    /**
     * The cao__cst_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_add_user = null;
    /**
     * The cao__cst_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_change_date = null;
    /**
     * The cao__cst_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_change_user = null;
    /**
     * The cao__cst_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_delete_flag = null;
    /**
     * The cao__cst_recno
     * Meta information extracted from the WSDL
     * - documentation: Record Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_recno = null;
    /**
     * The cao__cst_id
     * Meta information extracted from the WSDL
     * - documentation: Customer ID. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_id = null;
    /**
     * The cao__cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_key_ext = null;
    /**
     * The cao__cst_email_text_only
     * Meta information extracted from the WSDL
     * - documentation: Send Only Plain Text E-mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_email_text_only = null;
    /**
     * The cao__cst_credit_limit
     * Meta information extracted from the WSDL
     * - documentation: credit limit. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cao__cst_credit_limit = null;
    /**
     * The cao__cst_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_src_key = null;
    /**
     * The cao__cst_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_src_code = null;
    /**
     * The cao__cst_tax_exempt_flag
     * Meta information extracted from the WSDL
     * - documentation: Tax Exempt. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_tax_exempt_flag = null;
    /**
     * The cao__cst_tax_id
     * Meta information extracted from the WSDL
     * - documentation: Tax Id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_tax_id = null;
    /**
     * The cao__cst_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Mailing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cxa_key = null;
    /**
     * The cao__cst_no_email_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact by Email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_email_flag = null;
    /**
     * The cao__cst_cxa_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Billing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cxa_billing_key = null;
    /**
     * The cao__cst_eml_address_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_eml_address_dn = null;
    /**
     * The cao__cst_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_eml_key = null;
    /**
     * The cao__cst_no_phone_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Phone. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_phone_flag = null;
    /**
     * The cao__cst_phn_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_phn_number_complete_dn = null;
    /**
     * The cao__cst_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cph_key = null;
    /**
     * The cao__cst_no_fax_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_fax_flag = null;
    /**
     * The cao__cst_fax_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_fax_number_complete_dn = null;
    /**
     * The cao__cst_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cfx_key = null;
    /**
     * The cao__cst_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_ixo_key = null;
    /**
     * The cao__cst_no_web_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Make Available Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_web_flag = null;
    /**
     * The cao__cst_oldid
     * Meta information extracted from the WSDL
     * - documentation: oldid. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_oldid = null;
    /**
     * The cao__cst_member_flag
     * Meta information extracted from the WSDL
     * - documentation: Member Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_member_flag = null;
    /**
     * The cao__cst_url_code_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Website. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_url_code_dn = null;
    /**
     * The cao__cst_parent_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_parent_cst_key = null;
    /**
     * The cao__cst_url_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Website Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_url_key = null;
    /**
     * The cao__cst_no_msg_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Instant Mess. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_msg_flag = null;
    /**
     * The cao__cst_msg_handle_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Hand. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_msg_handle_dn = null;
    /**
     * The cao__cst_web_login
     * Meta information extracted from the WSDL
     * - documentation: Web Login. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_login = null;
    /**
     * The cao__cst_web_password
     * Meta information extracted from the WSDL
     * - documentation: Web Password. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_password = null;
    /**
     * The cao__cst_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_entity_key = null;
    /**
     * The cao__cst_msg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_msg_key = null;
    /**
     * The cao__cst_no_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_mail_flag = null;
    /**
     * The cao__cst_web_start_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_start_date = null;
    /**
     * The cao__cst_web_end_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_end_date = null;
    /**
     * The cao__cst_web_force_password_change
     * Meta information extracted from the WSDL
     * - documentation: Force User to Change Password. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_force_password_change = null;
    /**
     * The cao__cst_web_login_disabled_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Disabled. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_login_disabled_flag = null;
    /**
     * The cao__cst_comment
     * Meta information extracted from the WSDL
     * - documentation: Comments. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_comment = null;
    /**
     * The cao__cst_credit_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_credit_hold_flag = null;
    /**
     * The cao__cst_credit_hold_reason
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_credit_hold_reason = null;
    /**
     * The cao__cst_web_forgot_password_status
     * Meta information extracted from the WSDL
     * - documentation: Forgot Password Status. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_forgot_password_status = null;
    /**
     * The cao__cst_old_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Old Primary Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_old_cxa_key = null;
    /**
     * The cao__cst_last_email_date
     * Meta information extracted from the WSDL
     * - documentation: last email date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_last_email_date = null;
    /**
     * The cao__cst_no_publish_flag
     * Meta information extracted from the WSDL
     * - documentation: Do not publish to other systems?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_no_publish_flag = null;
    /**
     * The cao__cst_sin_key
     * Meta information extracted from the WSDL
     * - documentation: industry. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_sin_key = null;
    /**
     * The cao__cst_ttl_key
     * Meta information extracted from the WSDL
     * - documentation: title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_ttl_key = null;
    /**
     * The cao__cst_jfn_key
     * Meta information extracted from the WSDL
     * - documentation: job function. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_jfn_key = null;
    /**
     * The cao__cst_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cur_key = null;
    /**
     * The cao__cst_attribute_1
     * Meta information extracted from the WSDL
     * - documentation: price attribute 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_attribute_1 = null;
    /**
     * The cao__cst_attribute_2
     * Meta information extracted from the WSDL
     * - documentation: price attribute 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_attribute_2 = null;
    /**
     * The cao__cst_salutation_1
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_salutation_1 = null;
    /**
     * The cao__cst_salutation_2
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_salutation_2 = null;
    /**
     * The cao__cst_merge_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Merged Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_merge_cst_key = null;
    /**
     * The cao__cst_salutation_3
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_salutation_3 = null;
    /**
     * The cao__cst_salutation_4
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 4. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_salutation_4 = null;
    /**
     * The cao__cst_default_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: default recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_default_recognize_as = null;
    /**
     * The cao__cst_score
     * Meta information extracted from the WSDL
     * - documentation: Score. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $cao__cst_score = null;
    /**
     * The cao__cst_score_normalized
     * Meta information extracted from the WSDL
     * - documentation: Normalized Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_score_normalized = null;
    /**
     * The cao__cst_score_trend
     * Meta information extracted from the WSDL
     * - documentation: Scoring Trend. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_score_trend = null;
    /**
     * The cao__cst_vault_account
     * Meta information extracted from the WSDL
     * - documentation: Vault Customer Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_vault_account = null;
    /**
     * The cao__cst_exclude_from_social_flag
     * Meta information extracted from the WSDL
     * - documentation: Exclude from Social. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_exclude_from_social_flag = null;
    /**
     * The cao__cst_social_score
     * Meta information extracted from the WSDL
     * - documentation: Social Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_social_score = null;
    /**
     * The cao__cst_ptin
     * Meta information extracted from the WSDL
     * - documentation: PTIN. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_ptin = null;
    /**
     * The cao__cst_aicpa_member_id
     * Meta information extracted from the WSDL
     * - documentation: AICPA Member ID. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_aicpa_member_id = null;
    /**
     * The cao__cst_vendor_code
     * Meta information extracted from the WSDL
     * - documentation: Vendor Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_vendor_code = null;
    /**
     * The cao__cst_salt
     * Meta information extracted from the WSDL
     * - documentation: Salt. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_salt = null;
    /**
     * The cao__cst_sca_key
     * Meta information extracted from the WSDL
     * - documentation: Primary A-Score Scale. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_sca_key = null;
    /**
     * The cao__cst_iterations
     * Meta information extracted from the WSDL
     * - documentation: Iterations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cao__cst_iterations = null;
    /**
     * The cao__cst_web_password_change_date
     * Meta information extracted from the WSDL
     * - documentation: Web Password Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_password_change_date = null;
    /**
     * The cao__cst_web_failed_login_count
     * Meta information extracted from the WSDL
     * - documentation: Web Failed Login Count. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_failed_login_count = null;
    /**
     * The cao__cst_web_last_failed_login_date
     * Meta information extracted from the WSDL
     * - documentation: Web Last Failed Login Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_last_failed_login_date = null;
    /**
     * The cao__cst_web_login_locked_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Locked. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_web_login_locked_flag = null;
    /**
     * The cao__cst_cph_sms_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Phone SMS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cao__cst_cph_sms_key = null;
    /**
     * The cao__cst_sms_opt
     * Meta information extracted from the WSDL
     * - documentation: SMS OptIn OptOut. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_sms_opt = null;
    /**
     * The cao__cst_sms_consent_type
     * Meta information extracted from the WSDL
     * - documentation: Consent Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_sms_consent_type = null;
    /**
     * The cao__cst_failed_payment_attempts
     * Meta information extracted from the WSDL
     * - documentation: cao__cst_failed_payment_attempts. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cao__cst_failed_payment_attempts = null;
    /**
     * Constructor method for AccreditationArea_Affiliated_CAO_DataObjectType
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_type()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_name_cp()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_sort_name_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_ind_full_name_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_org_name_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_ixo_title_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_pref_comm_meth()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_bio()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_add_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_add_user()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_change_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_change_user()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_delete_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_recno()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_id()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_key_ext()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_email_text_only()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_credit_limit()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_src_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_src_code()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_tax_exempt_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_tax_id()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cxa_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_email_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cxa_billing_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_eml_address_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_eml_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_phone_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_phn_number_complete_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cph_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_fax_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_fax_number_complete_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cfx_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_ixo_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_web_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_oldid()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_member_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_url_code_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_parent_cst_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_url_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_msg_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_msg_handle_dn()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_login()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_password()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_entity_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_msg_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_mail_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_start_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_end_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_force_password_change()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_login_disabled_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_comment()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_credit_hold_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_credit_hold_reason()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_forgot_password_status()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_old_cxa_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_last_email_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_no_publish_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_sin_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_ttl_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_jfn_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cur_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_attribute_1()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_attribute_2()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_salutation_1()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_salutation_2()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_merge_cst_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_salutation_3()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_salutation_4()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_default_recognize_as()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_score()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_score_normalized()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_score_trend()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_vault_account()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_exclude_from_social_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_social_score()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_ptin()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_aicpa_member_id()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_vendor_code()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_salt()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_sca_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_iterations()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_password_change_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_failed_login_count()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_last_failed_login_date()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_web_login_locked_flag()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_cph_sms_key()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_sms_opt()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_sms_consent_type()
     * @uses AccreditationArea_Affiliated_CAO_DataObjectType::setCao__cst_failed_payment_attempts()
     * @param string $cao__cst_key
     * @param string $cao__cst_type
     * @param string $cao__cst_name_cp
     * @param string $cao__cst_sort_name_dn
     * @param string $cao__cst_ind_full_name_dn
     * @param string $cao__cst_org_name_dn
     * @param string $cao__cst_ixo_title_dn
     * @param string $cao__cst_pref_comm_meth
     * @param string $cao__cst_bio
     * @param string $cao__cst_add_date
     * @param string $cao__cst_add_user
     * @param string $cao__cst_change_date
     * @param string $cao__cst_change_user
     * @param string $cao__cst_delete_flag
     * @param int $cao__cst_recno
     * @param string $cao__cst_id
     * @param string $cao__cst_key_ext
     * @param string $cao__cst_email_text_only
     * @param float $cao__cst_credit_limit
     * @param string $cao__cst_src_key
     * @param string $cao__cst_src_code
     * @param string $cao__cst_tax_exempt_flag
     * @param string $cao__cst_tax_id
     * @param string $cao__cst_cxa_key
     * @param string $cao__cst_no_email_flag
     * @param string $cao__cst_cxa_billing_key
     * @param string $cao__cst_eml_address_dn
     * @param string $cao__cst_eml_key
     * @param string $cao__cst_no_phone_flag
     * @param string $cao__cst_phn_number_complete_dn
     * @param string $cao__cst_cph_key
     * @param string $cao__cst_no_fax_flag
     * @param string $cao__cst_fax_number_complete_dn
     * @param string $cao__cst_cfx_key
     * @param string $cao__cst_ixo_key
     * @param string $cao__cst_no_web_flag
     * @param string $cao__cst_oldid
     * @param string $cao__cst_member_flag
     * @param string $cao__cst_url_code_dn
     * @param string $cao__cst_parent_cst_key
     * @param string $cao__cst_url_key
     * @param string $cao__cst_no_msg_flag
     * @param string $cao__cst_msg_handle_dn
     * @param string $cao__cst_web_login
     * @param string $cao__cst_web_password
     * @param string $cao__cst_entity_key
     * @param string $cao__cst_msg_key
     * @param string $cao__cst_no_mail_flag
     * @param string $cao__cst_web_start_date
     * @param string $cao__cst_web_end_date
     * @param string $cao__cst_web_force_password_change
     * @param string $cao__cst_web_login_disabled_flag
     * @param string $cao__cst_comment
     * @param string $cao__cst_credit_hold_flag
     * @param string $cao__cst_credit_hold_reason
     * @param string $cao__cst_web_forgot_password_status
     * @param string $cao__cst_old_cxa_key
     * @param string $cao__cst_last_email_date
     * @param string $cao__cst_no_publish_flag
     * @param string $cao__cst_sin_key
     * @param string $cao__cst_ttl_key
     * @param string $cao__cst_jfn_key
     * @param string $cao__cst_cur_key
     * @param string $cao__cst_attribute_1
     * @param string $cao__cst_attribute_2
     * @param string $cao__cst_salutation_1
     * @param string $cao__cst_salutation_2
     * @param string $cao__cst_merge_cst_key
     * @param string $cao__cst_salutation_3
     * @param string $cao__cst_salutation_4
     * @param string $cao__cst_default_recognize_as
     * @param float $cao__cst_score
     * @param int $cao__cst_score_normalized
     * @param int $cao__cst_score_trend
     * @param string $cao__cst_vault_account
     * @param string $cao__cst_exclude_from_social_flag
     * @param int $cao__cst_social_score
     * @param string $cao__cst_ptin
     * @param int $cao__cst_aicpa_member_id
     * @param string $cao__cst_vendor_code
     * @param string $cao__cst_salt
     * @param string $cao__cst_sca_key
     * @param int $cao__cst_iterations
     * @param string $cao__cst_web_password_change_date
     * @param string $cao__cst_web_failed_login_count
     * @param string $cao__cst_web_last_failed_login_date
     * @param string $cao__cst_web_login_locked_flag
     * @param string $cao__cst_cph_sms_key
     * @param string $cao__cst_sms_opt
     * @param string $cao__cst_sms_consent_type
     * @param string $cao__cst_failed_payment_attempts
     */
    public function __construct(?string $cao__cst_key = null, ?string $cao__cst_type = null, ?string $cao__cst_name_cp = null, ?string $cao__cst_sort_name_dn = null, ?string $cao__cst_ind_full_name_dn = null, ?string $cao__cst_org_name_dn = null, ?string $cao__cst_ixo_title_dn = null, ?string $cao__cst_pref_comm_meth = null, ?string $cao__cst_bio = null, ?string $cao__cst_add_date = null, ?string $cao__cst_add_user = null, ?string $cao__cst_change_date = null, ?string $cao__cst_change_user = null, ?string $cao__cst_delete_flag = null, ?int $cao__cst_recno = null, ?string $cao__cst_id = null, ?string $cao__cst_key_ext = null, ?string $cao__cst_email_text_only = null, ?float $cao__cst_credit_limit = null, ?string $cao__cst_src_key = null, ?string $cao__cst_src_code = null, ?string $cao__cst_tax_exempt_flag = null, ?string $cao__cst_tax_id = null, ?string $cao__cst_cxa_key = null, ?string $cao__cst_no_email_flag = null, ?string $cao__cst_cxa_billing_key = null, ?string $cao__cst_eml_address_dn = null, ?string $cao__cst_eml_key = null, ?string $cao__cst_no_phone_flag = null, ?string $cao__cst_phn_number_complete_dn = null, ?string $cao__cst_cph_key = null, ?string $cao__cst_no_fax_flag = null, ?string $cao__cst_fax_number_complete_dn = null, ?string $cao__cst_cfx_key = null, ?string $cao__cst_ixo_key = null, ?string $cao__cst_no_web_flag = null, ?string $cao__cst_oldid = null, ?string $cao__cst_member_flag = null, ?string $cao__cst_url_code_dn = null, ?string $cao__cst_parent_cst_key = null, ?string $cao__cst_url_key = null, ?string $cao__cst_no_msg_flag = null, ?string $cao__cst_msg_handle_dn = null, ?string $cao__cst_web_login = null, ?string $cao__cst_web_password = null, ?string $cao__cst_entity_key = null, ?string $cao__cst_msg_key = null, ?string $cao__cst_no_mail_flag = null, ?string $cao__cst_web_start_date = null, ?string $cao__cst_web_end_date = null, ?string $cao__cst_web_force_password_change = null, ?string $cao__cst_web_login_disabled_flag = null, ?string $cao__cst_comment = null, ?string $cao__cst_credit_hold_flag = null, ?string $cao__cst_credit_hold_reason = null, ?string $cao__cst_web_forgot_password_status = null, ?string $cao__cst_old_cxa_key = null, ?string $cao__cst_last_email_date = null, ?string $cao__cst_no_publish_flag = null, ?string $cao__cst_sin_key = null, ?string $cao__cst_ttl_key = null, ?string $cao__cst_jfn_key = null, ?string $cao__cst_cur_key = null, ?string $cao__cst_attribute_1 = null, ?string $cao__cst_attribute_2 = null, ?string $cao__cst_salutation_1 = null, ?string $cao__cst_salutation_2 = null, ?string $cao__cst_merge_cst_key = null, ?string $cao__cst_salutation_3 = null, ?string $cao__cst_salutation_4 = null, ?string $cao__cst_default_recognize_as = null, ?float $cao__cst_score = null, ?int $cao__cst_score_normalized = null, ?int $cao__cst_score_trend = null, ?string $cao__cst_vault_account = null, ?string $cao__cst_exclude_from_social_flag = null, ?int $cao__cst_social_score = null, ?string $cao__cst_ptin = null, ?int $cao__cst_aicpa_member_id = null, ?string $cao__cst_vendor_code = null, ?string $cao__cst_salt = null, ?string $cao__cst_sca_key = null, ?int $cao__cst_iterations = null, ?string $cao__cst_web_password_change_date = null, ?string $cao__cst_web_failed_login_count = null, ?string $cao__cst_web_last_failed_login_date = null, ?string $cao__cst_web_login_locked_flag = null, ?string $cao__cst_cph_sms_key = null, ?string $cao__cst_sms_opt = null, ?string $cao__cst_sms_consent_type = null, ?string $cao__cst_failed_payment_attempts = null)
    {
        $this
            ->setCao__cst_key($cao__cst_key)
            ->setCao__cst_type($cao__cst_type)
            ->setCao__cst_name_cp($cao__cst_name_cp)
            ->setCao__cst_sort_name_dn($cao__cst_sort_name_dn)
            ->setCao__cst_ind_full_name_dn($cao__cst_ind_full_name_dn)
            ->setCao__cst_org_name_dn($cao__cst_org_name_dn)
            ->setCao__cst_ixo_title_dn($cao__cst_ixo_title_dn)
            ->setCao__cst_pref_comm_meth($cao__cst_pref_comm_meth)
            ->setCao__cst_bio($cao__cst_bio)
            ->setCao__cst_add_date($cao__cst_add_date)
            ->setCao__cst_add_user($cao__cst_add_user)
            ->setCao__cst_change_date($cao__cst_change_date)
            ->setCao__cst_change_user($cao__cst_change_user)
            ->setCao__cst_delete_flag($cao__cst_delete_flag)
            ->setCao__cst_recno($cao__cst_recno)
            ->setCao__cst_id($cao__cst_id)
            ->setCao__cst_key_ext($cao__cst_key_ext)
            ->setCao__cst_email_text_only($cao__cst_email_text_only)
            ->setCao__cst_credit_limit($cao__cst_credit_limit)
            ->setCao__cst_src_key($cao__cst_src_key)
            ->setCao__cst_src_code($cao__cst_src_code)
            ->setCao__cst_tax_exempt_flag($cao__cst_tax_exempt_flag)
            ->setCao__cst_tax_id($cao__cst_tax_id)
            ->setCao__cst_cxa_key($cao__cst_cxa_key)
            ->setCao__cst_no_email_flag($cao__cst_no_email_flag)
            ->setCao__cst_cxa_billing_key($cao__cst_cxa_billing_key)
            ->setCao__cst_eml_address_dn($cao__cst_eml_address_dn)
            ->setCao__cst_eml_key($cao__cst_eml_key)
            ->setCao__cst_no_phone_flag($cao__cst_no_phone_flag)
            ->setCao__cst_phn_number_complete_dn($cao__cst_phn_number_complete_dn)
            ->setCao__cst_cph_key($cao__cst_cph_key)
            ->setCao__cst_no_fax_flag($cao__cst_no_fax_flag)
            ->setCao__cst_fax_number_complete_dn($cao__cst_fax_number_complete_dn)
            ->setCao__cst_cfx_key($cao__cst_cfx_key)
            ->setCao__cst_ixo_key($cao__cst_ixo_key)
            ->setCao__cst_no_web_flag($cao__cst_no_web_flag)
            ->setCao__cst_oldid($cao__cst_oldid)
            ->setCao__cst_member_flag($cao__cst_member_flag)
            ->setCao__cst_url_code_dn($cao__cst_url_code_dn)
            ->setCao__cst_parent_cst_key($cao__cst_parent_cst_key)
            ->setCao__cst_url_key($cao__cst_url_key)
            ->setCao__cst_no_msg_flag($cao__cst_no_msg_flag)
            ->setCao__cst_msg_handle_dn($cao__cst_msg_handle_dn)
            ->setCao__cst_web_login($cao__cst_web_login)
            ->setCao__cst_web_password($cao__cst_web_password)
            ->setCao__cst_entity_key($cao__cst_entity_key)
            ->setCao__cst_msg_key($cao__cst_msg_key)
            ->setCao__cst_no_mail_flag($cao__cst_no_mail_flag)
            ->setCao__cst_web_start_date($cao__cst_web_start_date)
            ->setCao__cst_web_end_date($cao__cst_web_end_date)
            ->setCao__cst_web_force_password_change($cao__cst_web_force_password_change)
            ->setCao__cst_web_login_disabled_flag($cao__cst_web_login_disabled_flag)
            ->setCao__cst_comment($cao__cst_comment)
            ->setCao__cst_credit_hold_flag($cao__cst_credit_hold_flag)
            ->setCao__cst_credit_hold_reason($cao__cst_credit_hold_reason)
            ->setCao__cst_web_forgot_password_status($cao__cst_web_forgot_password_status)
            ->setCao__cst_old_cxa_key($cao__cst_old_cxa_key)
            ->setCao__cst_last_email_date($cao__cst_last_email_date)
            ->setCao__cst_no_publish_flag($cao__cst_no_publish_flag)
            ->setCao__cst_sin_key($cao__cst_sin_key)
            ->setCao__cst_ttl_key($cao__cst_ttl_key)
            ->setCao__cst_jfn_key($cao__cst_jfn_key)
            ->setCao__cst_cur_key($cao__cst_cur_key)
            ->setCao__cst_attribute_1($cao__cst_attribute_1)
            ->setCao__cst_attribute_2($cao__cst_attribute_2)
            ->setCao__cst_salutation_1($cao__cst_salutation_1)
            ->setCao__cst_salutation_2($cao__cst_salutation_2)
            ->setCao__cst_merge_cst_key($cao__cst_merge_cst_key)
            ->setCao__cst_salutation_3($cao__cst_salutation_3)
            ->setCao__cst_salutation_4($cao__cst_salutation_4)
            ->setCao__cst_default_recognize_as($cao__cst_default_recognize_as)
            ->setCao__cst_score($cao__cst_score)
            ->setCao__cst_score_normalized($cao__cst_score_normalized)
            ->setCao__cst_score_trend($cao__cst_score_trend)
            ->setCao__cst_vault_account($cao__cst_vault_account)
            ->setCao__cst_exclude_from_social_flag($cao__cst_exclude_from_social_flag)
            ->setCao__cst_social_score($cao__cst_social_score)
            ->setCao__cst_ptin($cao__cst_ptin)
            ->setCao__cst_aicpa_member_id($cao__cst_aicpa_member_id)
            ->setCao__cst_vendor_code($cao__cst_vendor_code)
            ->setCao__cst_salt($cao__cst_salt)
            ->setCao__cst_sca_key($cao__cst_sca_key)
            ->setCao__cst_iterations($cao__cst_iterations)
            ->setCao__cst_web_password_change_date($cao__cst_web_password_change_date)
            ->setCao__cst_web_failed_login_count($cao__cst_web_failed_login_count)
            ->setCao__cst_web_last_failed_login_date($cao__cst_web_last_failed_login_date)
            ->setCao__cst_web_login_locked_flag($cao__cst_web_login_locked_flag)
            ->setCao__cst_cph_sms_key($cao__cst_cph_sms_key)
            ->setCao__cst_sms_opt($cao__cst_sms_opt)
            ->setCao__cst_sms_consent_type($cao__cst_sms_consent_type)
            ->setCao__cst_failed_payment_attempts($cao__cst_failed_payment_attempts);
    }
    /**
     * Get cao__cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_key(): ?string
    {
        return $this->cao__cst_key ?? null;
    }
    /**
     * Set cao__cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_key(?string $cao__cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_key) && !is_string($cao__cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_key, true), gettype($cao__cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_key, true)), __LINE__);
        }
        if (is_null($cao__cst_key) || (is_array($cao__cst_key) && empty($cao__cst_key))) {
            unset($this->cao__cst_key);
        } else {
            $this->cao__cst_key = $cao__cst_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_type(): ?string
    {
        return $this->cao__cst_type ?? null;
    }
    /**
     * Set cao__cst_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_type(?string $cao__cst_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_type) && !is_string($cao__cst_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_type, true), gettype($cao__cst_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cao__cst_type) && mb_strlen((string) $cao__cst_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cao__cst_type)), __LINE__);
        }
        if (is_null($cao__cst_type) || (is_array($cao__cst_type) && empty($cao__cst_type))) {
            unset($this->cao__cst_type);
        } else {
            $this->cao__cst_type = $cao__cst_type;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_name_cp(): ?string
    {
        return $this->cao__cst_name_cp ?? null;
    }
    /**
     * Set cao__cst_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_name_cp(?string $cao__cst_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_name_cp) && !is_string($cao__cst_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_name_cp, true), gettype($cao__cst_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cao__cst_name_cp) && mb_strlen((string) $cao__cst_name_cp) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cao__cst_name_cp)), __LINE__);
        }
        if (is_null($cao__cst_name_cp) || (is_array($cao__cst_name_cp) && empty($cao__cst_name_cp))) {
            unset($this->cao__cst_name_cp);
        } else {
            $this->cao__cst_name_cp = $cao__cst_name_cp;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_sort_name_dn(): ?string
    {
        return $this->cao__cst_sort_name_dn ?? null;
    }
    /**
     * Set cao__cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_sort_name_dn(?string $cao__cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_sort_name_dn) && !is_string($cao__cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_sort_name_dn, true), gettype($cao__cst_sort_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cao__cst_sort_name_dn) && mb_strlen((string) $cao__cst_sort_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cao__cst_sort_name_dn)), __LINE__);
        }
        if (is_null($cao__cst_sort_name_dn) || (is_array($cao__cst_sort_name_dn) && empty($cao__cst_sort_name_dn))) {
            unset($this->cao__cst_sort_name_dn);
        } else {
            $this->cao__cst_sort_name_dn = $cao__cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_ind_full_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_ind_full_name_dn(): ?string
    {
        return $this->cao__cst_ind_full_name_dn ?? null;
    }
    /**
     * Set cao__cst_ind_full_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_ind_full_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_ind_full_name_dn(?string $cao__cst_ind_full_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_ind_full_name_dn) && !is_string($cao__cst_ind_full_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_ind_full_name_dn, true), gettype($cao__cst_ind_full_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cao__cst_ind_full_name_dn) && mb_strlen((string) $cao__cst_ind_full_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cao__cst_ind_full_name_dn)), __LINE__);
        }
        if (is_null($cao__cst_ind_full_name_dn) || (is_array($cao__cst_ind_full_name_dn) && empty($cao__cst_ind_full_name_dn))) {
            unset($this->cao__cst_ind_full_name_dn);
        } else {
            $this->cao__cst_ind_full_name_dn = $cao__cst_ind_full_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_org_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_org_name_dn(): ?string
    {
        return $this->cao__cst_org_name_dn ?? null;
    }
    /**
     * Set cao__cst_org_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_org_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_org_name_dn(?string $cao__cst_org_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_org_name_dn) && !is_string($cao__cst_org_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_org_name_dn, true), gettype($cao__cst_org_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cao__cst_org_name_dn) && mb_strlen((string) $cao__cst_org_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cao__cst_org_name_dn)), __LINE__);
        }
        if (is_null($cao__cst_org_name_dn) || (is_array($cao__cst_org_name_dn) && empty($cao__cst_org_name_dn))) {
            unset($this->cao__cst_org_name_dn);
        } else {
            $this->cao__cst_org_name_dn = $cao__cst_org_name_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_ixo_title_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_ixo_title_dn(): ?string
    {
        return $this->cao__cst_ixo_title_dn ?? null;
    }
    /**
     * Set cao__cst_ixo_title_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_ixo_title_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_ixo_title_dn(?string $cao__cst_ixo_title_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_ixo_title_dn) && !is_string($cao__cst_ixo_title_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_ixo_title_dn, true), gettype($cao__cst_ixo_title_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cao__cst_ixo_title_dn) && mb_strlen((string) $cao__cst_ixo_title_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cao__cst_ixo_title_dn)), __LINE__);
        }
        if (is_null($cao__cst_ixo_title_dn) || (is_array($cao__cst_ixo_title_dn) && empty($cao__cst_ixo_title_dn))) {
            unset($this->cao__cst_ixo_title_dn);
        } else {
            $this->cao__cst_ixo_title_dn = $cao__cst_ixo_title_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_pref_comm_meth(): ?string
    {
        return $this->cao__cst_pref_comm_meth ?? null;
    }
    /**
     * Set cao__cst_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_pref_comm_meth(?string $cao__cst_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_pref_comm_meth) && !is_string($cao__cst_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_pref_comm_meth, true), gettype($cao__cst_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cao__cst_pref_comm_meth) && mb_strlen((string) $cao__cst_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cao__cst_pref_comm_meth)), __LINE__);
        }
        if (is_null($cao__cst_pref_comm_meth) || (is_array($cao__cst_pref_comm_meth) && empty($cao__cst_pref_comm_meth))) {
            unset($this->cao__cst_pref_comm_meth);
        } else {
            $this->cao__cst_pref_comm_meth = $cao__cst_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_bio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_bio(): ?string
    {
        return $this->cao__cst_bio ?? null;
    }
    /**
     * Set cao__cst_bio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_bio
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_bio(?string $cao__cst_bio = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_bio) && !is_string($cao__cst_bio)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_bio, true), gettype($cao__cst_bio)), __LINE__);
        }
        if (is_null($cao__cst_bio) || (is_array($cao__cst_bio) && empty($cao__cst_bio))) {
            unset($this->cao__cst_bio);
        } else {
            $this->cao__cst_bio = $cao__cst_bio;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_add_date(): ?string
    {
        return $this->cao__cst_add_date ?? null;
    }
    /**
     * Set cao__cst_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_add_date(?string $cao__cst_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_add_date) && !is_string($cao__cst_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_add_date, true), gettype($cao__cst_add_date)), __LINE__);
        }
        if (is_null($cao__cst_add_date) || (is_array($cao__cst_add_date) && empty($cao__cst_add_date))) {
            unset($this->cao__cst_add_date);
        } else {
            $this->cao__cst_add_date = $cao__cst_add_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_add_user(): ?string
    {
        return $this->cao__cst_add_user ?? null;
    }
    /**
     * Set cao__cst_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_add_user(?string $cao__cst_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_add_user) && !is_string($cao__cst_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_add_user, true), gettype($cao__cst_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cao__cst_add_user) && mb_strlen((string) $cao__cst_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cao__cst_add_user)), __LINE__);
        }
        if (is_null($cao__cst_add_user) || (is_array($cao__cst_add_user) && empty($cao__cst_add_user))) {
            unset($this->cao__cst_add_user);
        } else {
            $this->cao__cst_add_user = $cao__cst_add_user;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_change_date(): ?string
    {
        return $this->cao__cst_change_date ?? null;
    }
    /**
     * Set cao__cst_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_change_date(?string $cao__cst_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_change_date) && !is_string($cao__cst_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_change_date, true), gettype($cao__cst_change_date)), __LINE__);
        }
        if (is_null($cao__cst_change_date) || (is_array($cao__cst_change_date) && empty($cao__cst_change_date))) {
            unset($this->cao__cst_change_date);
        } else {
            $this->cao__cst_change_date = $cao__cst_change_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_change_user(): ?string
    {
        return $this->cao__cst_change_user ?? null;
    }
    /**
     * Set cao__cst_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_change_user(?string $cao__cst_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_change_user) && !is_string($cao__cst_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_change_user, true), gettype($cao__cst_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cao__cst_change_user) && mb_strlen((string) $cao__cst_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cao__cst_change_user)), __LINE__);
        }
        if (is_null($cao__cst_change_user) || (is_array($cao__cst_change_user) && empty($cao__cst_change_user))) {
            unset($this->cao__cst_change_user);
        } else {
            $this->cao__cst_change_user = $cao__cst_change_user;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_delete_flag(): ?string
    {
        return $this->cao__cst_delete_flag ?? null;
    }
    /**
     * Set cao__cst_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_delete_flag(?string $cao__cst_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_delete_flag) && !is_string($cao__cst_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_delete_flag, true), gettype($cao__cst_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_delete_flag) && $cao__cst_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_delete_flag) && $cao__cst_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_delete_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_delete_flag) || (is_array($cao__cst_delete_flag) && empty($cao__cst_delete_flag))) {
            unset($this->cao__cst_delete_flag);
        } else {
            $this->cao__cst_delete_flag = $cao__cst_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_recno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_recno(): ?int
    {
        return $this->cao__cst_recno ?? null;
    }
    /**
     * Set cao__cst_recno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_recno
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_recno(?int $cao__cst_recno = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_recno) && !(is_int($cao__cst_recno) || ctype_digit($cao__cst_recno))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_recno, true), gettype($cao__cst_recno)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cao__cst_recno) && $cao__cst_recno > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cao__cst_recno, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cao__cst_recno) && $cao__cst_recno < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cao__cst_recno, true)), __LINE__);
        }
        if (is_null($cao__cst_recno) || (is_array($cao__cst_recno) && empty($cao__cst_recno))) {
            unset($this->cao__cst_recno);
        } else {
            $this->cao__cst_recno = $cao__cst_recno;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_id(): ?string
    {
        return $this->cao__cst_id ?? null;
    }
    /**
     * Set cao__cst_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_id(?string $cao__cst_id = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_id) && !is_string($cao__cst_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_id, true), gettype($cao__cst_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cao__cst_id) && mb_strlen((string) $cao__cst_id) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cao__cst_id)), __LINE__);
        }
        if (is_null($cao__cst_id) || (is_array($cao__cst_id) && empty($cao__cst_id))) {
            unset($this->cao__cst_id);
        } else {
            $this->cao__cst_id = $cao__cst_id;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_key_ext(): ?string
    {
        return $this->cao__cst_key_ext ?? null;
    }
    /**
     * Set cao__cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_key_ext(?string $cao__cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_key_ext) && !is_string($cao__cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_key_ext, true), gettype($cao__cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_key_ext, true)), __LINE__);
        }
        if (is_null($cao__cst_key_ext) || (is_array($cao__cst_key_ext) && empty($cao__cst_key_ext))) {
            unset($this->cao__cst_key_ext);
        } else {
            $this->cao__cst_key_ext = $cao__cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_email_text_only value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_email_text_only(): ?string
    {
        return $this->cao__cst_email_text_only ?? null;
    }
    /**
     * Set cao__cst_email_text_only value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_email_text_only
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_email_text_only(?string $cao__cst_email_text_only = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_email_text_only) && !is_string($cao__cst_email_text_only)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_email_text_only, true), gettype($cao__cst_email_text_only)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_email_text_only) && $cao__cst_email_text_only > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_email_text_only, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_email_text_only) && $cao__cst_email_text_only < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_email_text_only, true)), __LINE__);
        }
        if (is_null($cao__cst_email_text_only) || (is_array($cao__cst_email_text_only) && empty($cao__cst_email_text_only))) {
            unset($this->cao__cst_email_text_only);
        } else {
            $this->cao__cst_email_text_only = $cao__cst_email_text_only;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCao__cst_credit_limit(): ?float
    {
        return $this->cao__cst_credit_limit ?? null;
    }
    /**
     * Set cao__cst_credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cao__cst_credit_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_credit_limit(?float $cao__cst_credit_limit = null): self
    {
        // validation for constraint: float
        if (!is_null($cao__cst_credit_limit) && !(is_float($cao__cst_credit_limit) || is_numeric($cao__cst_credit_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cao__cst_credit_limit, true), gettype($cao__cst_credit_limit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cao__cst_credit_limit) && mb_strlen(mb_substr((string) $cao__cst_credit_limit, false !== mb_strpos((string) $cao__cst_credit_limit, '.') ? mb_strpos((string) $cao__cst_credit_limit, '.') + 1 : mb_strlen((string) $cao__cst_credit_limit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cao__cst_credit_limit, true), mb_strlen(mb_substr((string) $cao__cst_credit_limit, mb_strpos((string) $cao__cst_credit_limit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cao__cst_credit_limit) && mb_strlen(preg_replace('/(\D)/', '', (string) $cao__cst_credit_limit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cao__cst_credit_limit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cao__cst_credit_limit))), __LINE__);
        }
        if (is_null($cao__cst_credit_limit) || (is_array($cao__cst_credit_limit) && empty($cao__cst_credit_limit))) {
            unset($this->cao__cst_credit_limit);
        } else {
            $this->cao__cst_credit_limit = $cao__cst_credit_limit;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_src_key(): ?string
    {
        return $this->cao__cst_src_key ?? null;
    }
    /**
     * Set cao__cst_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_src_key(?string $cao__cst_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_src_key) && !is_string($cao__cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_src_key, true), gettype($cao__cst_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_src_key, true)), __LINE__);
        }
        if (is_null($cao__cst_src_key) || (is_array($cao__cst_src_key) && empty($cao__cst_src_key))) {
            unset($this->cao__cst_src_key);
        } else {
            $this->cao__cst_src_key = $cao__cst_src_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_src_code(): ?string
    {
        return $this->cao__cst_src_code ?? null;
    }
    /**
     * Set cao__cst_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_src_code(?string $cao__cst_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_src_code) && !is_string($cao__cst_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_src_code, true), gettype($cao__cst_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_src_code) && mb_strlen((string) $cao__cst_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_src_code)), __LINE__);
        }
        if (is_null($cao__cst_src_code) || (is_array($cao__cst_src_code) && empty($cao__cst_src_code))) {
            unset($this->cao__cst_src_code);
        } else {
            $this->cao__cst_src_code = $cao__cst_src_code;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_tax_exempt_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_tax_exempt_flag(): ?string
    {
        return $this->cao__cst_tax_exempt_flag ?? null;
    }
    /**
     * Set cao__cst_tax_exempt_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_tax_exempt_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_tax_exempt_flag(?string $cao__cst_tax_exempt_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_tax_exempt_flag) && !is_string($cao__cst_tax_exempt_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_tax_exempt_flag, true), gettype($cao__cst_tax_exempt_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_tax_exempt_flag) && $cao__cst_tax_exempt_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_tax_exempt_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_tax_exempt_flag) && $cao__cst_tax_exempt_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_tax_exempt_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_tax_exempt_flag) || (is_array($cao__cst_tax_exempt_flag) && empty($cao__cst_tax_exempt_flag))) {
            unset($this->cao__cst_tax_exempt_flag);
        } else {
            $this->cao__cst_tax_exempt_flag = $cao__cst_tax_exempt_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_tax_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_tax_id(): ?string
    {
        return $this->cao__cst_tax_id ?? null;
    }
    /**
     * Set cao__cst_tax_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_tax_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_tax_id(?string $cao__cst_tax_id = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_tax_id) && !is_string($cao__cst_tax_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_tax_id, true), gettype($cao__cst_tax_id)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cao__cst_tax_id) && mb_strlen((string) $cao__cst_tax_id) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cao__cst_tax_id)), __LINE__);
        }
        if (is_null($cao__cst_tax_id) || (is_array($cao__cst_tax_id) && empty($cao__cst_tax_id))) {
            unset($this->cao__cst_tax_id);
        } else {
            $this->cao__cst_tax_id = $cao__cst_tax_id;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cxa_key(): ?string
    {
        return $this->cao__cst_cxa_key ?? null;
    }
    /**
     * Set cao__cst_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cxa_key(?string $cao__cst_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cxa_key) && !is_string($cao__cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cxa_key, true), gettype($cao__cst_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cxa_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cxa_key) || (is_array($cao__cst_cxa_key) && empty($cao__cst_cxa_key))) {
            unset($this->cao__cst_cxa_key);
        } else {
            $this->cao__cst_cxa_key = $cao__cst_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_email_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_email_flag(): ?string
    {
        return $this->cao__cst_no_email_flag ?? null;
    }
    /**
     * Set cao__cst_no_email_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_email_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_email_flag(?string $cao__cst_no_email_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_email_flag) && !is_string($cao__cst_no_email_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_email_flag, true), gettype($cao__cst_no_email_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_email_flag) && $cao__cst_no_email_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_email_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_email_flag) && $cao__cst_no_email_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_email_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_email_flag) || (is_array($cao__cst_no_email_flag) && empty($cao__cst_no_email_flag))) {
            unset($this->cao__cst_no_email_flag);
        } else {
            $this->cao__cst_no_email_flag = $cao__cst_no_email_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cxa_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cxa_billing_key(): ?string
    {
        return $this->cao__cst_cxa_billing_key ?? null;
    }
    /**
     * Set cao__cst_cxa_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cxa_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cxa_billing_key(?string $cao__cst_cxa_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cxa_billing_key) && !is_string($cao__cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cxa_billing_key, true), gettype($cao__cst_cxa_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cxa_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cxa_billing_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cxa_billing_key) || (is_array($cao__cst_cxa_billing_key) && empty($cao__cst_cxa_billing_key))) {
            unset($this->cao__cst_cxa_billing_key);
        } else {
            $this->cao__cst_cxa_billing_key = $cao__cst_cxa_billing_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_eml_address_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_eml_address_dn(): ?string
    {
        return $this->cao__cst_eml_address_dn ?? null;
    }
    /**
     * Set cao__cst_eml_address_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_eml_address_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_eml_address_dn(?string $cao__cst_eml_address_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_eml_address_dn) && !is_string($cao__cst_eml_address_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_eml_address_dn, true), gettype($cao__cst_eml_address_dn)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cao__cst_eml_address_dn) && mb_strlen((string) $cao__cst_eml_address_dn) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cao__cst_eml_address_dn)), __LINE__);
        }
        if (is_null($cao__cst_eml_address_dn) || (is_array($cao__cst_eml_address_dn) && empty($cao__cst_eml_address_dn))) {
            unset($this->cao__cst_eml_address_dn);
        } else {
            $this->cao__cst_eml_address_dn = $cao__cst_eml_address_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_eml_key(): ?string
    {
        return $this->cao__cst_eml_key ?? null;
    }
    /**
     * Set cao__cst_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_eml_key(?string $cao__cst_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_eml_key) && !is_string($cao__cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_eml_key, true), gettype($cao__cst_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_eml_key, true)), __LINE__);
        }
        if (is_null($cao__cst_eml_key) || (is_array($cao__cst_eml_key) && empty($cao__cst_eml_key))) {
            unset($this->cao__cst_eml_key);
        } else {
            $this->cao__cst_eml_key = $cao__cst_eml_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_phone_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_phone_flag(): ?string
    {
        return $this->cao__cst_no_phone_flag ?? null;
    }
    /**
     * Set cao__cst_no_phone_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_phone_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_phone_flag(?string $cao__cst_no_phone_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_phone_flag) && !is_string($cao__cst_no_phone_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_phone_flag, true), gettype($cao__cst_no_phone_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_phone_flag) && $cao__cst_no_phone_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_phone_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_phone_flag) && $cao__cst_no_phone_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_phone_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_phone_flag) || (is_array($cao__cst_no_phone_flag) && empty($cao__cst_no_phone_flag))) {
            unset($this->cao__cst_no_phone_flag);
        } else {
            $this->cao__cst_no_phone_flag = $cao__cst_no_phone_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_phn_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_phn_number_complete_dn(): ?string
    {
        return $this->cao__cst_phn_number_complete_dn ?? null;
    }
    /**
     * Set cao__cst_phn_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_phn_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_phn_number_complete_dn(?string $cao__cst_phn_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_phn_number_complete_dn) && !is_string($cao__cst_phn_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_phn_number_complete_dn, true), gettype($cao__cst_phn_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cao__cst_phn_number_complete_dn) && mb_strlen((string) $cao__cst_phn_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cao__cst_phn_number_complete_dn)), __LINE__);
        }
        if (is_null($cao__cst_phn_number_complete_dn) || (is_array($cao__cst_phn_number_complete_dn) && empty($cao__cst_phn_number_complete_dn))) {
            unset($this->cao__cst_phn_number_complete_dn);
        } else {
            $this->cao__cst_phn_number_complete_dn = $cao__cst_phn_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cph_key(): ?string
    {
        return $this->cao__cst_cph_key ?? null;
    }
    /**
     * Set cao__cst_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cph_key(?string $cao__cst_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cph_key) && !is_string($cao__cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cph_key, true), gettype($cao__cst_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cph_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cph_key) || (is_array($cao__cst_cph_key) && empty($cao__cst_cph_key))) {
            unset($this->cao__cst_cph_key);
        } else {
            $this->cao__cst_cph_key = $cao__cst_cph_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_fax_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_fax_flag(): ?string
    {
        return $this->cao__cst_no_fax_flag ?? null;
    }
    /**
     * Set cao__cst_no_fax_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_fax_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_fax_flag(?string $cao__cst_no_fax_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_fax_flag) && !is_string($cao__cst_no_fax_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_fax_flag, true), gettype($cao__cst_no_fax_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_fax_flag) && $cao__cst_no_fax_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_fax_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_fax_flag) && $cao__cst_no_fax_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_fax_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_fax_flag) || (is_array($cao__cst_no_fax_flag) && empty($cao__cst_no_fax_flag))) {
            unset($this->cao__cst_no_fax_flag);
        } else {
            $this->cao__cst_no_fax_flag = $cao__cst_no_fax_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_fax_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_fax_number_complete_dn(): ?string
    {
        return $this->cao__cst_fax_number_complete_dn ?? null;
    }
    /**
     * Set cao__cst_fax_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_fax_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_fax_number_complete_dn(?string $cao__cst_fax_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_fax_number_complete_dn) && !is_string($cao__cst_fax_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_fax_number_complete_dn, true), gettype($cao__cst_fax_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cao__cst_fax_number_complete_dn) && mb_strlen((string) $cao__cst_fax_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cao__cst_fax_number_complete_dn)), __LINE__);
        }
        if (is_null($cao__cst_fax_number_complete_dn) || (is_array($cao__cst_fax_number_complete_dn) && empty($cao__cst_fax_number_complete_dn))) {
            unset($this->cao__cst_fax_number_complete_dn);
        } else {
            $this->cao__cst_fax_number_complete_dn = $cao__cst_fax_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cfx_key(): ?string
    {
        return $this->cao__cst_cfx_key ?? null;
    }
    /**
     * Set cao__cst_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cfx_key(?string $cao__cst_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cfx_key) && !is_string($cao__cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cfx_key, true), gettype($cao__cst_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cfx_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cfx_key) || (is_array($cao__cst_cfx_key) && empty($cao__cst_cfx_key))) {
            unset($this->cao__cst_cfx_key);
        } else {
            $this->cao__cst_cfx_key = $cao__cst_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_ixo_key(): ?string
    {
        return $this->cao__cst_ixo_key ?? null;
    }
    /**
     * Set cao__cst_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_ixo_key(?string $cao__cst_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_ixo_key) && !is_string($cao__cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_ixo_key, true), gettype($cao__cst_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_ixo_key, true)), __LINE__);
        }
        if (is_null($cao__cst_ixo_key) || (is_array($cao__cst_ixo_key) && empty($cao__cst_ixo_key))) {
            unset($this->cao__cst_ixo_key);
        } else {
            $this->cao__cst_ixo_key = $cao__cst_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_web_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_web_flag(): ?string
    {
        return $this->cao__cst_no_web_flag ?? null;
    }
    /**
     * Set cao__cst_no_web_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_web_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_web_flag(?string $cao__cst_no_web_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_web_flag) && !is_string($cao__cst_no_web_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_web_flag, true), gettype($cao__cst_no_web_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_web_flag) && $cao__cst_no_web_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_web_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_web_flag) && $cao__cst_no_web_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_web_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_web_flag) || (is_array($cao__cst_no_web_flag) && empty($cao__cst_no_web_flag))) {
            unset($this->cao__cst_no_web_flag);
        } else {
            $this->cao__cst_no_web_flag = $cao__cst_no_web_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_oldid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_oldid(): ?string
    {
        return $this->cao__cst_oldid ?? null;
    }
    /**
     * Set cao__cst_oldid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_oldid
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_oldid(?string $cao__cst_oldid = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_oldid) && !is_string($cao__cst_oldid)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_oldid, true), gettype($cao__cst_oldid)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($cao__cst_oldid) && mb_strlen((string) $cao__cst_oldid) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $cao__cst_oldid)), __LINE__);
        }
        if (is_null($cao__cst_oldid) || (is_array($cao__cst_oldid) && empty($cao__cst_oldid))) {
            unset($this->cao__cst_oldid);
        } else {
            $this->cao__cst_oldid = $cao__cst_oldid;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_member_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_member_flag(): ?string
    {
        return $this->cao__cst_member_flag ?? null;
    }
    /**
     * Set cao__cst_member_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_member_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_member_flag(?string $cao__cst_member_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_member_flag) && !is_string($cao__cst_member_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_member_flag, true), gettype($cao__cst_member_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_member_flag) && $cao__cst_member_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_member_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_member_flag) && $cao__cst_member_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_member_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_member_flag) || (is_array($cao__cst_member_flag) && empty($cao__cst_member_flag))) {
            unset($this->cao__cst_member_flag);
        } else {
            $this->cao__cst_member_flag = $cao__cst_member_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_url_code_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_url_code_dn(): ?string
    {
        return $this->cao__cst_url_code_dn ?? null;
    }
    /**
     * Set cao__cst_url_code_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_url_code_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_url_code_dn(?string $cao__cst_url_code_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_url_code_dn) && !is_string($cao__cst_url_code_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_url_code_dn, true), gettype($cao__cst_url_code_dn)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($cao__cst_url_code_dn) && mb_strlen((string) $cao__cst_url_code_dn) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $cao__cst_url_code_dn)), __LINE__);
        }
        if (is_null($cao__cst_url_code_dn) || (is_array($cao__cst_url_code_dn) && empty($cao__cst_url_code_dn))) {
            unset($this->cao__cst_url_code_dn);
        } else {
            $this->cao__cst_url_code_dn = $cao__cst_url_code_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_parent_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_parent_cst_key(): ?string
    {
        return $this->cao__cst_parent_cst_key ?? null;
    }
    /**
     * Set cao__cst_parent_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_parent_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_parent_cst_key(?string $cao__cst_parent_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_parent_cst_key) && !is_string($cao__cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_parent_cst_key, true), gettype($cao__cst_parent_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_parent_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_parent_cst_key, true)), __LINE__);
        }
        if (is_null($cao__cst_parent_cst_key) || (is_array($cao__cst_parent_cst_key) && empty($cao__cst_parent_cst_key))) {
            unset($this->cao__cst_parent_cst_key);
        } else {
            $this->cao__cst_parent_cst_key = $cao__cst_parent_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_url_key(): ?string
    {
        return $this->cao__cst_url_key ?? null;
    }
    /**
     * Set cao__cst_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_url_key(?string $cao__cst_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_url_key) && !is_string($cao__cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_url_key, true), gettype($cao__cst_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_url_key, true)), __LINE__);
        }
        if (is_null($cao__cst_url_key) || (is_array($cao__cst_url_key) && empty($cao__cst_url_key))) {
            unset($this->cao__cst_url_key);
        } else {
            $this->cao__cst_url_key = $cao__cst_url_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_msg_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_msg_flag(): ?string
    {
        return $this->cao__cst_no_msg_flag ?? null;
    }
    /**
     * Set cao__cst_no_msg_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_msg_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_msg_flag(?string $cao__cst_no_msg_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_msg_flag) && !is_string($cao__cst_no_msg_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_msg_flag, true), gettype($cao__cst_no_msg_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_msg_flag) && $cao__cst_no_msg_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_msg_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_msg_flag) && $cao__cst_no_msg_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_msg_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_msg_flag) || (is_array($cao__cst_no_msg_flag) && empty($cao__cst_no_msg_flag))) {
            unset($this->cao__cst_no_msg_flag);
        } else {
            $this->cao__cst_no_msg_flag = $cao__cst_no_msg_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_msg_handle_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_msg_handle_dn(): ?string
    {
        return $this->cao__cst_msg_handle_dn ?? null;
    }
    /**
     * Set cao__cst_msg_handle_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_msg_handle_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_msg_handle_dn(?string $cao__cst_msg_handle_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_msg_handle_dn) && !is_string($cao__cst_msg_handle_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_msg_handle_dn, true), gettype($cao__cst_msg_handle_dn)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cao__cst_msg_handle_dn) && mb_strlen((string) $cao__cst_msg_handle_dn) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cao__cst_msg_handle_dn)), __LINE__);
        }
        if (is_null($cao__cst_msg_handle_dn) || (is_array($cao__cst_msg_handle_dn) && empty($cao__cst_msg_handle_dn))) {
            unset($this->cao__cst_msg_handle_dn);
        } else {
            $this->cao__cst_msg_handle_dn = $cao__cst_msg_handle_dn;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_login(): ?string
    {
        return $this->cao__cst_web_login ?? null;
    }
    /**
     * Set cao__cst_web_login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_login
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_login(?string $cao__cst_web_login = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_login) && !is_string($cao__cst_web_login)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_login, true), gettype($cao__cst_web_login)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cao__cst_web_login) && mb_strlen((string) $cao__cst_web_login) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cao__cst_web_login)), __LINE__);
        }
        if (is_null($cao__cst_web_login) || (is_array($cao__cst_web_login) && empty($cao__cst_web_login))) {
            unset($this->cao__cst_web_login);
        } else {
            $this->cao__cst_web_login = $cao__cst_web_login;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_password(): ?string
    {
        return $this->cao__cst_web_password ?? null;
    }
    /**
     * Set cao__cst_web_password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_password
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_password(?string $cao__cst_web_password = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_password) && !is_string($cao__cst_web_password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_password, true), gettype($cao__cst_web_password)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_web_password) && mb_strlen((string) $cao__cst_web_password) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_web_password)), __LINE__);
        }
        if (is_null($cao__cst_web_password) || (is_array($cao__cst_web_password) && empty($cao__cst_web_password))) {
            unset($this->cao__cst_web_password);
        } else {
            $this->cao__cst_web_password = $cao__cst_web_password;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_entity_key(): ?string
    {
        return $this->cao__cst_entity_key ?? null;
    }
    /**
     * Set cao__cst_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_entity_key(?string $cao__cst_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_entity_key) && !is_string($cao__cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_entity_key, true), gettype($cao__cst_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_entity_key, true)), __LINE__);
        }
        if (is_null($cao__cst_entity_key) || (is_array($cao__cst_entity_key) && empty($cao__cst_entity_key))) {
            unset($this->cao__cst_entity_key);
        } else {
            $this->cao__cst_entity_key = $cao__cst_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_msg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_msg_key(): ?string
    {
        return $this->cao__cst_msg_key ?? null;
    }
    /**
     * Set cao__cst_msg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_msg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_msg_key(?string $cao__cst_msg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_msg_key) && !is_string($cao__cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_msg_key, true), gettype($cao__cst_msg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_msg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_msg_key, true)), __LINE__);
        }
        if (is_null($cao__cst_msg_key) || (is_array($cao__cst_msg_key) && empty($cao__cst_msg_key))) {
            unset($this->cao__cst_msg_key);
        } else {
            $this->cao__cst_msg_key = $cao__cst_msg_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_mail_flag(): ?string
    {
        return $this->cao__cst_no_mail_flag ?? null;
    }
    /**
     * Set cao__cst_no_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_mail_flag(?string $cao__cst_no_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_mail_flag) && !is_string($cao__cst_no_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_mail_flag, true), gettype($cao__cst_no_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_mail_flag) && $cao__cst_no_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_mail_flag) && $cao__cst_no_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_mail_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_mail_flag) || (is_array($cao__cst_no_mail_flag) && empty($cao__cst_no_mail_flag))) {
            unset($this->cao__cst_no_mail_flag);
        } else {
            $this->cao__cst_no_mail_flag = $cao__cst_no_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_start_date(): ?string
    {
        return $this->cao__cst_web_start_date ?? null;
    }
    /**
     * Set cao__cst_web_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_start_date(?string $cao__cst_web_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_start_date) && !is_string($cao__cst_web_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_start_date, true), gettype($cao__cst_web_start_date)), __LINE__);
        }
        if (is_null($cao__cst_web_start_date) || (is_array($cao__cst_web_start_date) && empty($cao__cst_web_start_date))) {
            unset($this->cao__cst_web_start_date);
        } else {
            $this->cao__cst_web_start_date = $cao__cst_web_start_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_end_date(): ?string
    {
        return $this->cao__cst_web_end_date ?? null;
    }
    /**
     * Set cao__cst_web_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_end_date(?string $cao__cst_web_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_end_date) && !is_string($cao__cst_web_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_end_date, true), gettype($cao__cst_web_end_date)), __LINE__);
        }
        if (is_null($cao__cst_web_end_date) || (is_array($cao__cst_web_end_date) && empty($cao__cst_web_end_date))) {
            unset($this->cao__cst_web_end_date);
        } else {
            $this->cao__cst_web_end_date = $cao__cst_web_end_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_force_password_change value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_force_password_change(): ?string
    {
        return $this->cao__cst_web_force_password_change ?? null;
    }
    /**
     * Set cao__cst_web_force_password_change value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_force_password_change
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_force_password_change(?string $cao__cst_web_force_password_change = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_force_password_change) && !is_string($cao__cst_web_force_password_change)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_force_password_change, true), gettype($cao__cst_web_force_password_change)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_web_force_password_change) && $cao__cst_web_force_password_change > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_web_force_password_change, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_web_force_password_change) && $cao__cst_web_force_password_change < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_web_force_password_change, true)), __LINE__);
        }
        if (is_null($cao__cst_web_force_password_change) || (is_array($cao__cst_web_force_password_change) && empty($cao__cst_web_force_password_change))) {
            unset($this->cao__cst_web_force_password_change);
        } else {
            $this->cao__cst_web_force_password_change = $cao__cst_web_force_password_change;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_login_disabled_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_login_disabled_flag(): ?string
    {
        return $this->cao__cst_web_login_disabled_flag ?? null;
    }
    /**
     * Set cao__cst_web_login_disabled_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_login_disabled_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_login_disabled_flag(?string $cao__cst_web_login_disabled_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_login_disabled_flag) && !is_string($cao__cst_web_login_disabled_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_login_disabled_flag, true), gettype($cao__cst_web_login_disabled_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_web_login_disabled_flag) && $cao__cst_web_login_disabled_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_web_login_disabled_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_web_login_disabled_flag) && $cao__cst_web_login_disabled_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_web_login_disabled_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_web_login_disabled_flag) || (is_array($cao__cst_web_login_disabled_flag) && empty($cao__cst_web_login_disabled_flag))) {
            unset($this->cao__cst_web_login_disabled_flag);
        } else {
            $this->cao__cst_web_login_disabled_flag = $cao__cst_web_login_disabled_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_comment(): ?string
    {
        return $this->cao__cst_comment ?? null;
    }
    /**
     * Set cao__cst_comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_comment
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_comment(?string $cao__cst_comment = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_comment) && !is_string($cao__cst_comment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_comment, true), gettype($cao__cst_comment)), __LINE__);
        }
        if (is_null($cao__cst_comment) || (is_array($cao__cst_comment) && empty($cao__cst_comment))) {
            unset($this->cao__cst_comment);
        } else {
            $this->cao__cst_comment = $cao__cst_comment;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_credit_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_credit_hold_flag(): ?string
    {
        return $this->cao__cst_credit_hold_flag ?? null;
    }
    /**
     * Set cao__cst_credit_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_credit_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_credit_hold_flag(?string $cao__cst_credit_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_credit_hold_flag) && !is_string($cao__cst_credit_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_credit_hold_flag, true), gettype($cao__cst_credit_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_credit_hold_flag) && $cao__cst_credit_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_credit_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_credit_hold_flag) && $cao__cst_credit_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_credit_hold_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_credit_hold_flag) || (is_array($cao__cst_credit_hold_flag) && empty($cao__cst_credit_hold_flag))) {
            unset($this->cao__cst_credit_hold_flag);
        } else {
            $this->cao__cst_credit_hold_flag = $cao__cst_credit_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_credit_hold_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_credit_hold_reason(): ?string
    {
        return $this->cao__cst_credit_hold_reason ?? null;
    }
    /**
     * Set cao__cst_credit_hold_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_credit_hold_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_credit_hold_reason(?string $cao__cst_credit_hold_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_credit_hold_reason) && !is_string($cao__cst_credit_hold_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_credit_hold_reason, true), gettype($cao__cst_credit_hold_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_credit_hold_reason) && mb_strlen((string) $cao__cst_credit_hold_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_credit_hold_reason)), __LINE__);
        }
        if (is_null($cao__cst_credit_hold_reason) || (is_array($cao__cst_credit_hold_reason) && empty($cao__cst_credit_hold_reason))) {
            unset($this->cao__cst_credit_hold_reason);
        } else {
            $this->cao__cst_credit_hold_reason = $cao__cst_credit_hold_reason;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_forgot_password_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_forgot_password_status(): ?string
    {
        return $this->cao__cst_web_forgot_password_status ?? null;
    }
    /**
     * Set cao__cst_web_forgot_password_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_forgot_password_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_forgot_password_status(?string $cao__cst_web_forgot_password_status = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_forgot_password_status) && !is_string($cao__cst_web_forgot_password_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_forgot_password_status, true), gettype($cao__cst_web_forgot_password_status)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_web_forgot_password_status) && $cao__cst_web_forgot_password_status > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_web_forgot_password_status, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_web_forgot_password_status) && $cao__cst_web_forgot_password_status < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_web_forgot_password_status, true)), __LINE__);
        }
        if (is_null($cao__cst_web_forgot_password_status) || (is_array($cao__cst_web_forgot_password_status) && empty($cao__cst_web_forgot_password_status))) {
            unset($this->cao__cst_web_forgot_password_status);
        } else {
            $this->cao__cst_web_forgot_password_status = $cao__cst_web_forgot_password_status;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_old_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_old_cxa_key(): ?string
    {
        return $this->cao__cst_old_cxa_key ?? null;
    }
    /**
     * Set cao__cst_old_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_old_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_old_cxa_key(?string $cao__cst_old_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_old_cxa_key) && !is_string($cao__cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_old_cxa_key, true), gettype($cao__cst_old_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_old_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_old_cxa_key, true)), __LINE__);
        }
        if (is_null($cao__cst_old_cxa_key) || (is_array($cao__cst_old_cxa_key) && empty($cao__cst_old_cxa_key))) {
            unset($this->cao__cst_old_cxa_key);
        } else {
            $this->cao__cst_old_cxa_key = $cao__cst_old_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_last_email_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_last_email_date(): ?string
    {
        return $this->cao__cst_last_email_date ?? null;
    }
    /**
     * Set cao__cst_last_email_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_last_email_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_last_email_date(?string $cao__cst_last_email_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_last_email_date) && !is_string($cao__cst_last_email_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_last_email_date, true), gettype($cao__cst_last_email_date)), __LINE__);
        }
        if (is_null($cao__cst_last_email_date) || (is_array($cao__cst_last_email_date) && empty($cao__cst_last_email_date))) {
            unset($this->cao__cst_last_email_date);
        } else {
            $this->cao__cst_last_email_date = $cao__cst_last_email_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_no_publish_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_no_publish_flag(): ?string
    {
        return $this->cao__cst_no_publish_flag ?? null;
    }
    /**
     * Set cao__cst_no_publish_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_no_publish_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_no_publish_flag(?string $cao__cst_no_publish_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_no_publish_flag) && !is_string($cao__cst_no_publish_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_no_publish_flag, true), gettype($cao__cst_no_publish_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_no_publish_flag) && $cao__cst_no_publish_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_no_publish_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_no_publish_flag) && $cao__cst_no_publish_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_no_publish_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_no_publish_flag) || (is_array($cao__cst_no_publish_flag) && empty($cao__cst_no_publish_flag))) {
            unset($this->cao__cst_no_publish_flag);
        } else {
            $this->cao__cst_no_publish_flag = $cao__cst_no_publish_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_sin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_sin_key(): ?string
    {
        return $this->cao__cst_sin_key ?? null;
    }
    /**
     * Set cao__cst_sin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_sin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_sin_key(?string $cao__cst_sin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_sin_key) && !is_string($cao__cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_sin_key, true), gettype($cao__cst_sin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_sin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_sin_key, true)), __LINE__);
        }
        if (is_null($cao__cst_sin_key) || (is_array($cao__cst_sin_key) && empty($cao__cst_sin_key))) {
            unset($this->cao__cst_sin_key);
        } else {
            $this->cao__cst_sin_key = $cao__cst_sin_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_ttl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_ttl_key(): ?string
    {
        return $this->cao__cst_ttl_key ?? null;
    }
    /**
     * Set cao__cst_ttl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_ttl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_ttl_key(?string $cao__cst_ttl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_ttl_key) && !is_string($cao__cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_ttl_key, true), gettype($cao__cst_ttl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_ttl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_ttl_key, true)), __LINE__);
        }
        if (is_null($cao__cst_ttl_key) || (is_array($cao__cst_ttl_key) && empty($cao__cst_ttl_key))) {
            unset($this->cao__cst_ttl_key);
        } else {
            $this->cao__cst_ttl_key = $cao__cst_ttl_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_jfn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_jfn_key(): ?string
    {
        return $this->cao__cst_jfn_key ?? null;
    }
    /**
     * Set cao__cst_jfn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_jfn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_jfn_key(?string $cao__cst_jfn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_jfn_key) && !is_string($cao__cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_jfn_key, true), gettype($cao__cst_jfn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_jfn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_jfn_key, true)), __LINE__);
        }
        if (is_null($cao__cst_jfn_key) || (is_array($cao__cst_jfn_key) && empty($cao__cst_jfn_key))) {
            unset($this->cao__cst_jfn_key);
        } else {
            $this->cao__cst_jfn_key = $cao__cst_jfn_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cur_key(): ?string
    {
        return $this->cao__cst_cur_key ?? null;
    }
    /**
     * Set cao__cst_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cur_key(?string $cao__cst_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cur_key) && !is_string($cao__cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cur_key, true), gettype($cao__cst_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cur_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cur_key) || (is_array($cao__cst_cur_key) && empty($cao__cst_cur_key))) {
            unset($this->cao__cst_cur_key);
        } else {
            $this->cao__cst_cur_key = $cao__cst_cur_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_attribute value
     * @return cao__cst_attribute
     */
    public function getCao__cst_attribute_1(): ?string
    {
        return $this->cao__cst_attribute_1 ?? null;
    }
    /**
     * Set cao__cst_attribute value
     * @param cao__cst_attribute $cao__cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_attribute_1(?string $cao__cst_attribute_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_attribute_1) && !is_string($cao__cst_attribute_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_attribute_1, true), gettype($cao__cst_attribute_1)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($cao__cst_attribute_1) && mb_strlen((string) $cao__cst_attribute_1) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $cao__cst_attribute_1)), __LINE__);
        }
        if (is_null($cao__cst_attribute_1) || (is_array($cao__cst_attribute_1) && empty($cao__cst_attribute_1))) {
            unset($this->cao__cst_attribute_1);
        } else {
            $this->cao__cst_attribute_1 = $cao__cst_attribute_1;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_attribute value
     * @return cao__cst_attribute
     */
    public function getCao__cst_attribute_2(): ?string
    {
        return $this->cao__cst_attribute_2 ?? null;
    }
    /**
     * Set cao__cst_attribute value
     * @param cao__cst_attribute $cao__cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_attribute_2(?string $cao__cst_attribute_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_attribute_2) && !is_string($cao__cst_attribute_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_attribute_2, true), gettype($cao__cst_attribute_2)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($cao__cst_attribute_2) && mb_strlen((string) $cao__cst_attribute_2) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $cao__cst_attribute_2)), __LINE__);
        }
        if (is_null($cao__cst_attribute_2) || (is_array($cao__cst_attribute_2) && empty($cao__cst_attribute_2))) {
            unset($this->cao__cst_attribute_2);
        } else {
            $this->cao__cst_attribute_2 = $cao__cst_attribute_2;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_salutation value
     * @return cao__cst_salutation
     */
    public function getCao__cst_salutation_1(): ?string
    {
        return $this->cao__cst_salutation_1 ?? null;
    }
    /**
     * Set cao__cst_salutation value
     * @param cao__cst_salutation $cao__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_salutation_1(?string $cao__cst_salutation_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_salutation_1) && !is_string($cao__cst_salutation_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_salutation_1, true), gettype($cao__cst_salutation_1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cao__cst_salutation_1) && mb_strlen((string) $cao__cst_salutation_1) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cao__cst_salutation_1)), __LINE__);
        }
        if (is_null($cao__cst_salutation_1) || (is_array($cao__cst_salutation_1) && empty($cao__cst_salutation_1))) {
            unset($this->cao__cst_salutation_1);
        } else {
            $this->cao__cst_salutation_1 = $cao__cst_salutation_1;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_salutation value
     * @return cao__cst_salutation
     */
    public function getCao__cst_salutation_2(): ?string
    {
        return $this->cao__cst_salutation_2 ?? null;
    }
    /**
     * Set cao__cst_salutation value
     * @param cao__cst_salutation $cao__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_salutation_2(?string $cao__cst_salutation_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_salutation_2) && !is_string($cao__cst_salutation_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_salutation_2, true), gettype($cao__cst_salutation_2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cao__cst_salutation_2) && mb_strlen((string) $cao__cst_salutation_2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cao__cst_salutation_2)), __LINE__);
        }
        if (is_null($cao__cst_salutation_2) || (is_array($cao__cst_salutation_2) && empty($cao__cst_salutation_2))) {
            unset($this->cao__cst_salutation_2);
        } else {
            $this->cao__cst_salutation_2 = $cao__cst_salutation_2;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_merge_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_merge_cst_key(): ?string
    {
        return $this->cao__cst_merge_cst_key ?? null;
    }
    /**
     * Set cao__cst_merge_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_merge_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_merge_cst_key(?string $cao__cst_merge_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_merge_cst_key) && !is_string($cao__cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_merge_cst_key, true), gettype($cao__cst_merge_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_merge_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_merge_cst_key, true)), __LINE__);
        }
        if (is_null($cao__cst_merge_cst_key) || (is_array($cao__cst_merge_cst_key) && empty($cao__cst_merge_cst_key))) {
            unset($this->cao__cst_merge_cst_key);
        } else {
            $this->cao__cst_merge_cst_key = $cao__cst_merge_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_salutation value
     * @return cao__cst_salutation
     */
    public function getCao__cst_salutation_3(): ?string
    {
        return $this->cao__cst_salutation_3 ?? null;
    }
    /**
     * Set cao__cst_salutation value
     * @param cao__cst_salutation $cao__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_salutation_3(?string $cao__cst_salutation_3 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_salutation_3) && !is_string($cao__cst_salutation_3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_salutation_3, true), gettype($cao__cst_salutation_3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cao__cst_salutation_3) && mb_strlen((string) $cao__cst_salutation_3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cao__cst_salutation_3)), __LINE__);
        }
        if (is_null($cao__cst_salutation_3) || (is_array($cao__cst_salutation_3) && empty($cao__cst_salutation_3))) {
            unset($this->cao__cst_salutation_3);
        } else {
            $this->cao__cst_salutation_3 = $cao__cst_salutation_3;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_salutation value
     * @return cao__cst_salutation
     */
    public function getCao__cst_salutation_4(): ?string
    {
        return $this->cao__cst_salutation_4 ?? null;
    }
    /**
     * Set cao__cst_salutation value
     * @param cao__cst_salutation $cao__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_salutation_4(?string $cao__cst_salutation_4 = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_salutation_4) && !is_string($cao__cst_salutation_4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_salutation_4, true), gettype($cao__cst_salutation_4)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cao__cst_salutation_4) && mb_strlen((string) $cao__cst_salutation_4) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cao__cst_salutation_4)), __LINE__);
        }
        if (is_null($cao__cst_salutation_4) || (is_array($cao__cst_salutation_4) && empty($cao__cst_salutation_4))) {
            unset($this->cao__cst_salutation_4);
        } else {
            $this->cao__cst_salutation_4 = $cao__cst_salutation_4;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_default_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_default_recognize_as(): ?string
    {
        return $this->cao__cst_default_recognize_as ?? null;
    }
    /**
     * Set cao__cst_default_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_default_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_default_recognize_as(?string $cao__cst_default_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_default_recognize_as) && !is_string($cao__cst_default_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_default_recognize_as, true), gettype($cao__cst_default_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($cao__cst_default_recognize_as) && mb_strlen((string) $cao__cst_default_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $cao__cst_default_recognize_as)), __LINE__);
        }
        if (is_null($cao__cst_default_recognize_as) || (is_array($cao__cst_default_recognize_as) && empty($cao__cst_default_recognize_as))) {
            unset($this->cao__cst_default_recognize_as);
        } else {
            $this->cao__cst_default_recognize_as = $cao__cst_default_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCao__cst_score(): ?float
    {
        return $this->cao__cst_score ?? null;
    }
    /**
     * Set cao__cst_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cao__cst_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_score(?float $cao__cst_score = null): self
    {
        // validation for constraint: float
        if (!is_null($cao__cst_score) && !(is_float($cao__cst_score) || is_numeric($cao__cst_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cao__cst_score, true), gettype($cao__cst_score)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cao__cst_score) && mb_strlen(mb_substr((string) $cao__cst_score, false !== mb_strpos((string) $cao__cst_score, '.') ? mb_strpos((string) $cao__cst_score, '.') + 1 : mb_strlen((string) $cao__cst_score))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cao__cst_score, true), mb_strlen(mb_substr((string) $cao__cst_score, mb_strpos((string) $cao__cst_score, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($cao__cst_score) && mb_strlen(preg_replace('/(\D)/', '', (string) $cao__cst_score)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($cao__cst_score, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cao__cst_score))), __LINE__);
        }
        if (is_null($cao__cst_score) || (is_array($cao__cst_score) && empty($cao__cst_score))) {
            unset($this->cao__cst_score);
        } else {
            $this->cao__cst_score = $cao__cst_score;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_score_normalized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_score_normalized(): ?int
    {
        return $this->cao__cst_score_normalized ?? null;
    }
    /**
     * Set cao__cst_score_normalized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_score_normalized
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_score_normalized(?int $cao__cst_score_normalized = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_score_normalized) && !(is_int($cao__cst_score_normalized) || ctype_digit($cao__cst_score_normalized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_score_normalized, true), gettype($cao__cst_score_normalized)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cao__cst_score_normalized) && $cao__cst_score_normalized > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cao__cst_score_normalized, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cao__cst_score_normalized) && $cao__cst_score_normalized < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cao__cst_score_normalized, true)), __LINE__);
        }
        if (is_null($cao__cst_score_normalized) || (is_array($cao__cst_score_normalized) && empty($cao__cst_score_normalized))) {
            unset($this->cao__cst_score_normalized);
        } else {
            $this->cao__cst_score_normalized = $cao__cst_score_normalized;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_score_trend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_score_trend(): ?int
    {
        return $this->cao__cst_score_trend ?? null;
    }
    /**
     * Set cao__cst_score_trend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_score_trend
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_score_trend(?int $cao__cst_score_trend = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_score_trend) && !(is_int($cao__cst_score_trend) || ctype_digit($cao__cst_score_trend))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_score_trend, true), gettype($cao__cst_score_trend)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cao__cst_score_trend) && $cao__cst_score_trend > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cao__cst_score_trend, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cao__cst_score_trend) && $cao__cst_score_trend < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cao__cst_score_trend, true)), __LINE__);
        }
        if (is_null($cao__cst_score_trend) || (is_array($cao__cst_score_trend) && empty($cao__cst_score_trend))) {
            unset($this->cao__cst_score_trend);
        } else {
            $this->cao__cst_score_trend = $cao__cst_score_trend;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_vault_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_vault_account(): ?string
    {
        return $this->cao__cst_vault_account ?? null;
    }
    /**
     * Set cao__cst_vault_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_vault_account
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_vault_account(?string $cao__cst_vault_account = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_vault_account) && !is_string($cao__cst_vault_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_vault_account, true), gettype($cao__cst_vault_account)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($cao__cst_vault_account) && mb_strlen((string) $cao__cst_vault_account) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $cao__cst_vault_account)), __LINE__);
        }
        if (is_null($cao__cst_vault_account) || (is_array($cao__cst_vault_account) && empty($cao__cst_vault_account))) {
            unset($this->cao__cst_vault_account);
        } else {
            $this->cao__cst_vault_account = $cao__cst_vault_account;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_exclude_from_social_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_exclude_from_social_flag(): ?string
    {
        return $this->cao__cst_exclude_from_social_flag ?? null;
    }
    /**
     * Set cao__cst_exclude_from_social_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_exclude_from_social_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_exclude_from_social_flag(?string $cao__cst_exclude_from_social_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_exclude_from_social_flag) && !is_string($cao__cst_exclude_from_social_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_exclude_from_social_flag, true), gettype($cao__cst_exclude_from_social_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_exclude_from_social_flag) && $cao__cst_exclude_from_social_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_exclude_from_social_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_exclude_from_social_flag) && $cao__cst_exclude_from_social_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_exclude_from_social_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_exclude_from_social_flag) || (is_array($cao__cst_exclude_from_social_flag) && empty($cao__cst_exclude_from_social_flag))) {
            unset($this->cao__cst_exclude_from_social_flag);
        } else {
            $this->cao__cst_exclude_from_social_flag = $cao__cst_exclude_from_social_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_social_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_social_score(): ?int
    {
        return $this->cao__cst_social_score ?? null;
    }
    /**
     * Set cao__cst_social_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_social_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_social_score(?int $cao__cst_social_score = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_social_score) && !(is_int($cao__cst_social_score) || ctype_digit($cao__cst_social_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_social_score, true), gettype($cao__cst_social_score)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cao__cst_social_score) && $cao__cst_social_score > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cao__cst_social_score, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cao__cst_social_score) && $cao__cst_social_score < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cao__cst_social_score, true)), __LINE__);
        }
        if (is_null($cao__cst_social_score) || (is_array($cao__cst_social_score) && empty($cao__cst_social_score))) {
            unset($this->cao__cst_social_score);
        } else {
            $this->cao__cst_social_score = $cao__cst_social_score;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_ptin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_ptin(): ?string
    {
        return $this->cao__cst_ptin ?? null;
    }
    /**
     * Set cao__cst_ptin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_ptin
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_ptin(?string $cao__cst_ptin = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_ptin) && !is_string($cao__cst_ptin)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_ptin, true), gettype($cao__cst_ptin)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($cao__cst_ptin) && mb_strlen((string) $cao__cst_ptin) > 9) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen((string) $cao__cst_ptin)), __LINE__);
        }
        if (is_null($cao__cst_ptin) || (is_array($cao__cst_ptin) && empty($cao__cst_ptin))) {
            unset($this->cao__cst_ptin);
        } else {
            $this->cao__cst_ptin = $cao__cst_ptin;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_aicpa_member_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_aicpa_member_id(): ?int
    {
        return $this->cao__cst_aicpa_member_id ?? null;
    }
    /**
     * Set cao__cst_aicpa_member_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_aicpa_member_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_aicpa_member_id(?int $cao__cst_aicpa_member_id = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_aicpa_member_id) && !(is_int($cao__cst_aicpa_member_id) || ctype_digit($cao__cst_aicpa_member_id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_aicpa_member_id, true), gettype($cao__cst_aicpa_member_id)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($cao__cst_aicpa_member_id) && $cao__cst_aicpa_member_id > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($cao__cst_aicpa_member_id, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($cao__cst_aicpa_member_id) && $cao__cst_aicpa_member_id < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($cao__cst_aicpa_member_id, true)), __LINE__);
        }
        if (is_null($cao__cst_aicpa_member_id) || (is_array($cao__cst_aicpa_member_id) && empty($cao__cst_aicpa_member_id))) {
            unset($this->cao__cst_aicpa_member_id);
        } else {
            $this->cao__cst_aicpa_member_id = $cao__cst_aicpa_member_id;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_vendor_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_vendor_code(): ?string
    {
        return $this->cao__cst_vendor_code ?? null;
    }
    /**
     * Set cao__cst_vendor_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_vendor_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_vendor_code(?string $cao__cst_vendor_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_vendor_code) && !is_string($cao__cst_vendor_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_vendor_code, true), gettype($cao__cst_vendor_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_vendor_code) && mb_strlen((string) $cao__cst_vendor_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_vendor_code)), __LINE__);
        }
        if (is_null($cao__cst_vendor_code) || (is_array($cao__cst_vendor_code) && empty($cao__cst_vendor_code))) {
            unset($this->cao__cst_vendor_code);
        } else {
            $this->cao__cst_vendor_code = $cao__cst_vendor_code;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_salt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_salt(): ?string
    {
        return $this->cao__cst_salt ?? null;
    }
    /**
     * Set cao__cst_salt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_salt
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_salt(?string $cao__cst_salt = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_salt) && !is_string($cao__cst_salt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_salt, true), gettype($cao__cst_salt)), __LINE__);
        }
        if (is_null($cao__cst_salt) || (is_array($cao__cst_salt) && empty($cao__cst_salt))) {
            unset($this->cao__cst_salt);
        } else {
            $this->cao__cst_salt = $cao__cst_salt;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_sca_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_sca_key(): ?string
    {
        return $this->cao__cst_sca_key ?? null;
    }
    /**
     * Set cao__cst_sca_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_sca_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_sca_key(?string $cao__cst_sca_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_sca_key) && !is_string($cao__cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_sca_key, true), gettype($cao__cst_sca_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_sca_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_sca_key, true)), __LINE__);
        }
        if (is_null($cao__cst_sca_key) || (is_array($cao__cst_sca_key) && empty($cao__cst_sca_key))) {
            unset($this->cao__cst_sca_key);
        } else {
            $this->cao__cst_sca_key = $cao__cst_sca_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_iterations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCao__cst_iterations(): ?int
    {
        return $this->cao__cst_iterations ?? null;
    }
    /**
     * Set cao__cst_iterations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cao__cst_iterations
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_iterations(?int $cao__cst_iterations = null): self
    {
        // validation for constraint: int
        if (!is_null($cao__cst_iterations) && !(is_int($cao__cst_iterations) || ctype_digit($cao__cst_iterations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cao__cst_iterations, true), gettype($cao__cst_iterations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cao__cst_iterations) && $cao__cst_iterations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cao__cst_iterations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cao__cst_iterations) && $cao__cst_iterations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cao__cst_iterations, true)), __LINE__);
        }
        if (is_null($cao__cst_iterations) || (is_array($cao__cst_iterations) && empty($cao__cst_iterations))) {
            unset($this->cao__cst_iterations);
        } else {
            $this->cao__cst_iterations = $cao__cst_iterations;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_password_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_password_change_date(): ?string
    {
        return $this->cao__cst_web_password_change_date ?? null;
    }
    /**
     * Set cao__cst_web_password_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_password_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_password_change_date(?string $cao__cst_web_password_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_password_change_date) && !is_string($cao__cst_web_password_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_password_change_date, true), gettype($cao__cst_web_password_change_date)), __LINE__);
        }
        if (is_null($cao__cst_web_password_change_date) || (is_array($cao__cst_web_password_change_date) && empty($cao__cst_web_password_change_date))) {
            unset($this->cao__cst_web_password_change_date);
        } else {
            $this->cao__cst_web_password_change_date = $cao__cst_web_password_change_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_failed_login_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_failed_login_count(): ?string
    {
        return $this->cao__cst_web_failed_login_count ?? null;
    }
    /**
     * Set cao__cst_web_failed_login_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_failed_login_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_failed_login_count(?string $cao__cst_web_failed_login_count = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_failed_login_count) && !is_string($cao__cst_web_failed_login_count)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_failed_login_count, true), gettype($cao__cst_web_failed_login_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_web_failed_login_count) && $cao__cst_web_failed_login_count > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_web_failed_login_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_web_failed_login_count) && $cao__cst_web_failed_login_count < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_web_failed_login_count, true)), __LINE__);
        }
        if (is_null($cao__cst_web_failed_login_count) || (is_array($cao__cst_web_failed_login_count) && empty($cao__cst_web_failed_login_count))) {
            unset($this->cao__cst_web_failed_login_count);
        } else {
            $this->cao__cst_web_failed_login_count = $cao__cst_web_failed_login_count;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_last_failed_login_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_last_failed_login_date(): ?string
    {
        return $this->cao__cst_web_last_failed_login_date ?? null;
    }
    /**
     * Set cao__cst_web_last_failed_login_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_last_failed_login_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_last_failed_login_date(?string $cao__cst_web_last_failed_login_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_last_failed_login_date) && !is_string($cao__cst_web_last_failed_login_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_last_failed_login_date, true), gettype($cao__cst_web_last_failed_login_date)), __LINE__);
        }
        if (is_null($cao__cst_web_last_failed_login_date) || (is_array($cao__cst_web_last_failed_login_date) && empty($cao__cst_web_last_failed_login_date))) {
            unset($this->cao__cst_web_last_failed_login_date);
        } else {
            $this->cao__cst_web_last_failed_login_date = $cao__cst_web_last_failed_login_date;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_web_login_locked_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_web_login_locked_flag(): ?string
    {
        return $this->cao__cst_web_login_locked_flag ?? null;
    }
    /**
     * Set cao__cst_web_login_locked_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_web_login_locked_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_web_login_locked_flag(?string $cao__cst_web_login_locked_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_web_login_locked_flag) && !is_string($cao__cst_web_login_locked_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_web_login_locked_flag, true), gettype($cao__cst_web_login_locked_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cao__cst_web_login_locked_flag) && $cao__cst_web_login_locked_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cao__cst_web_login_locked_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cao__cst_web_login_locked_flag) && $cao__cst_web_login_locked_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cao__cst_web_login_locked_flag, true)), __LINE__);
        }
        if (is_null($cao__cst_web_login_locked_flag) || (is_array($cao__cst_web_login_locked_flag) && empty($cao__cst_web_login_locked_flag))) {
            unset($this->cao__cst_web_login_locked_flag);
        } else {
            $this->cao__cst_web_login_locked_flag = $cao__cst_web_login_locked_flag;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_cph_sms_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_cph_sms_key(): ?string
    {
        return $this->cao__cst_cph_sms_key ?? null;
    }
    /**
     * Set cao__cst_cph_sms_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_cph_sms_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_cph_sms_key(?string $cao__cst_cph_sms_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_cph_sms_key) && !is_string($cao__cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_cph_sms_key, true), gettype($cao__cst_cph_sms_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cao__cst_cph_sms_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cao__cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cao__cst_cph_sms_key, true)), __LINE__);
        }
        if (is_null($cao__cst_cph_sms_key) || (is_array($cao__cst_cph_sms_key) && empty($cao__cst_cph_sms_key))) {
            unset($this->cao__cst_cph_sms_key);
        } else {
            $this->cao__cst_cph_sms_key = $cao__cst_cph_sms_key;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_sms_opt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_sms_opt(): ?string
    {
        return $this->cao__cst_sms_opt ?? null;
    }
    /**
     * Set cao__cst_sms_opt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_sms_opt
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_sms_opt(?string $cao__cst_sms_opt = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_sms_opt) && !is_string($cao__cst_sms_opt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_sms_opt, true), gettype($cao__cst_sms_opt)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_sms_opt) && mb_strlen((string) $cao__cst_sms_opt) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_sms_opt)), __LINE__);
        }
        if (is_null($cao__cst_sms_opt) || (is_array($cao__cst_sms_opt) && empty($cao__cst_sms_opt))) {
            unset($this->cao__cst_sms_opt);
        } else {
            $this->cao__cst_sms_opt = $cao__cst_sms_opt;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_sms_consent_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_sms_consent_type(): ?string
    {
        return $this->cao__cst_sms_consent_type ?? null;
    }
    /**
     * Set cao__cst_sms_consent_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_sms_consent_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_sms_consent_type(?string $cao__cst_sms_consent_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_sms_consent_type) && !is_string($cao__cst_sms_consent_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_sms_consent_type, true), gettype($cao__cst_sms_consent_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cao__cst_sms_consent_type) && mb_strlen((string) $cao__cst_sms_consent_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cao__cst_sms_consent_type)), __LINE__);
        }
        if (is_null($cao__cst_sms_consent_type) || (is_array($cao__cst_sms_consent_type) && empty($cao__cst_sms_consent_type))) {
            unset($this->cao__cst_sms_consent_type);
        } else {
            $this->cao__cst_sms_consent_type = $cao__cst_sms_consent_type;
        }
        
        return $this;
    }
    /**
     * Get cao__cst_failed_payment_attempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCao__cst_failed_payment_attempts(): ?string
    {
        return $this->cao__cst_failed_payment_attempts ?? null;
    }
    /**
     * Set cao__cst_failed_payment_attempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cao__cst_failed_payment_attempts
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
     */
    public function setCao__cst_failed_payment_attempts(?string $cao__cst_failed_payment_attempts = null): self
    {
        // validation for constraint: string
        if (!is_null($cao__cst_failed_payment_attempts) && !is_string($cao__cst_failed_payment_attempts)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cao__cst_failed_payment_attempts, true), gettype($cao__cst_failed_payment_attempts)), __LINE__);
        }
        if (is_null($cao__cst_failed_payment_attempts) || (is_array($cao__cst_failed_payment_attempts) && empty($cao__cst_failed_payment_attempts))) {
            unset($this->cao__cst_failed_payment_attempts);
        } else {
            $this->cao__cst_failed_payment_attempts = $cao__cst_failed_payment_attempts;
        }
        
        return $this;
    }
}
