<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Customer_Address_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Customer_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The cxa_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_cst_key = null;
    /**
     * The cxa_adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_adr_key = null;
    /**
     * The cxa_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_add_date = null;
    /**
     * The cxa_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_add_user = null;
    /**
     * The cxa_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_change_date = null;
    /**
     * The cxa_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_change_user = null;
    /**
     * The cxa_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_delete_flag = null;
    /**
     * The cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_key = null;
    /**
     * The cxa_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_key_ext = null;
    /**
     * The cxa_on_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Address On Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_on_hold_flag = null;
    /**
     * The cxa_adh_key
     * Meta information extracted from the WSDL
     * - documentation: On Hold Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_adh_key = null;
    /**
     * The cxa_adt_key
     * Meta information extracted from the WSDL
     * - documentation: Address Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_adt_key = null;
    /**
     * The cxa_seasonal_from_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal From Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_seasonal_from_date = null;
    /**
     * The cxa_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_mailing_label = null;
    /**
     * The cxa_seasonal_through_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal Through Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_seasonal_through_date = null;
    /**
     * The cxa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxa_entity_key = null;
    /**
     * The cxa_mail_stop
     * Meta information extracted from the WSDL
     * - documentation: Mailstop. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_mail_stop = null;
    /**
     * The cxa_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_mailing_label_html = null;
    /**
     * The cxa_on_hold_from
     * Meta information extracted from the WSDL
     * - documentation: Hold From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_on_hold_from = null;
    /**
     * The cxa_on_hold_through
     * Meta information extracted from the WSDL
     * - documentation: On Hold Until Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxa_on_hold_through = null;
    /**
     * Constructor method for AccreditationArea_Customer_Address_DataObjectType
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_cst_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_adr_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_add_date()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_add_user()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_change_date()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_change_user()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_delete_flag()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_key_ext()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_on_hold_flag()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_adh_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_adt_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_seasonal_from_date()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_mailing_label()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_seasonal_through_date()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_entity_key()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_mail_stop()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_mailing_label_html()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_on_hold_from()
     * @uses AccreditationArea_Customer_Address_DataObjectType::setCxa_on_hold_through()
     * @param string $cxa_cst_key
     * @param string $cxa_adr_key
     * @param string $cxa_add_date
     * @param string $cxa_add_user
     * @param string $cxa_change_date
     * @param string $cxa_change_user
     * @param string $cxa_delete_flag
     * @param string $cxa_key
     * @param string $cxa_key_ext
     * @param string $cxa_on_hold_flag
     * @param string $cxa_adh_key
     * @param string $cxa_adt_key
     * @param string $cxa_seasonal_from_date
     * @param string $cxa_mailing_label
     * @param string $cxa_seasonal_through_date
     * @param string $cxa_entity_key
     * @param string $cxa_mail_stop
     * @param string $cxa_mailing_label_html
     * @param string $cxa_on_hold_from
     * @param string $cxa_on_hold_through
     */
    public function __construct(?string $cxa_cst_key = null, ?string $cxa_adr_key = null, ?string $cxa_add_date = null, ?string $cxa_add_user = null, ?string $cxa_change_date = null, ?string $cxa_change_user = null, ?string $cxa_delete_flag = null, ?string $cxa_key = null, ?string $cxa_key_ext = null, ?string $cxa_on_hold_flag = null, ?string $cxa_adh_key = null, ?string $cxa_adt_key = null, ?string $cxa_seasonal_from_date = null, ?string $cxa_mailing_label = null, ?string $cxa_seasonal_through_date = null, ?string $cxa_entity_key = null, ?string $cxa_mail_stop = null, ?string $cxa_mailing_label_html = null, ?string $cxa_on_hold_from = null, ?string $cxa_on_hold_through = null)
    {
        $this
            ->setCxa_cst_key($cxa_cst_key)
            ->setCxa_adr_key($cxa_adr_key)
            ->setCxa_add_date($cxa_add_date)
            ->setCxa_add_user($cxa_add_user)
            ->setCxa_change_date($cxa_change_date)
            ->setCxa_change_user($cxa_change_user)
            ->setCxa_delete_flag($cxa_delete_flag)
            ->setCxa_key($cxa_key)
            ->setCxa_key_ext($cxa_key_ext)
            ->setCxa_on_hold_flag($cxa_on_hold_flag)
            ->setCxa_adh_key($cxa_adh_key)
            ->setCxa_adt_key($cxa_adt_key)
            ->setCxa_seasonal_from_date($cxa_seasonal_from_date)
            ->setCxa_mailing_label($cxa_mailing_label)
            ->setCxa_seasonal_through_date($cxa_seasonal_through_date)
            ->setCxa_entity_key($cxa_entity_key)
            ->setCxa_mail_stop($cxa_mail_stop)
            ->setCxa_mailing_label_html($cxa_mailing_label_html)
            ->setCxa_on_hold_from($cxa_on_hold_from)
            ->setCxa_on_hold_through($cxa_on_hold_through);
    }
    /**
     * Get cxa_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_cst_key(): ?string
    {
        return $this->cxa_cst_key ?? null;
    }
    /**
     * Set cxa_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_cst_key(?string $cxa_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_cst_key) && !is_string($cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_cst_key, true), gettype($cxa_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_cst_key, true)), __LINE__);
        }
        if (is_null($cxa_cst_key) || (is_array($cxa_cst_key) && empty($cxa_cst_key))) {
            unset($this->cxa_cst_key);
        } else {
            $this->cxa_cst_key = $cxa_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_adr_key(): ?string
    {
        return $this->cxa_adr_key ?? null;
    }
    /**
     * Set cxa_adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_adr_key(?string $cxa_adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_adr_key) && !is_string($cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_adr_key, true), gettype($cxa_adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_adr_key, true)), __LINE__);
        }
        if (is_null($cxa_adr_key) || (is_array($cxa_adr_key) && empty($cxa_adr_key))) {
            unset($this->cxa_adr_key);
        } else {
            $this->cxa_adr_key = $cxa_adr_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_add_date(): ?string
    {
        return $this->cxa_add_date ?? null;
    }
    /**
     * Set cxa_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_add_date(?string $cxa_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_add_date) && !is_string($cxa_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_add_date, true), gettype($cxa_add_date)), __LINE__);
        }
        if (is_null($cxa_add_date) || (is_array($cxa_add_date) && empty($cxa_add_date))) {
            unset($this->cxa_add_date);
        } else {
            $this->cxa_add_date = $cxa_add_date;
        }
        
        return $this;
    }
    /**
     * Get cxa_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_add_user(): ?string
    {
        return $this->cxa_add_user ?? null;
    }
    /**
     * Set cxa_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_add_user(?string $cxa_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_add_user) && !is_string($cxa_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_add_user, true), gettype($cxa_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxa_add_user) && mb_strlen((string) $cxa_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxa_add_user)), __LINE__);
        }
        if (is_null($cxa_add_user) || (is_array($cxa_add_user) && empty($cxa_add_user))) {
            unset($this->cxa_add_user);
        } else {
            $this->cxa_add_user = $cxa_add_user;
        }
        
        return $this;
    }
    /**
     * Get cxa_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_change_date(): ?string
    {
        return $this->cxa_change_date ?? null;
    }
    /**
     * Set cxa_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_change_date(?string $cxa_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_change_date) && !is_string($cxa_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_change_date, true), gettype($cxa_change_date)), __LINE__);
        }
        if (is_null($cxa_change_date) || (is_array($cxa_change_date) && empty($cxa_change_date))) {
            unset($this->cxa_change_date);
        } else {
            $this->cxa_change_date = $cxa_change_date;
        }
        
        return $this;
    }
    /**
     * Get cxa_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_change_user(): ?string
    {
        return $this->cxa_change_user ?? null;
    }
    /**
     * Set cxa_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_change_user(?string $cxa_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_change_user) && !is_string($cxa_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_change_user, true), gettype($cxa_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxa_change_user) && mb_strlen((string) $cxa_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxa_change_user)), __LINE__);
        }
        if (is_null($cxa_change_user) || (is_array($cxa_change_user) && empty($cxa_change_user))) {
            unset($this->cxa_change_user);
        } else {
            $this->cxa_change_user = $cxa_change_user;
        }
        
        return $this;
    }
    /**
     * Get cxa_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_delete_flag(): ?string
    {
        return $this->cxa_delete_flag ?? null;
    }
    /**
     * Set cxa_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_delete_flag(?string $cxa_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_delete_flag) && !is_string($cxa_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_delete_flag, true), gettype($cxa_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cxa_delete_flag) && $cxa_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cxa_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cxa_delete_flag) && $cxa_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cxa_delete_flag, true)), __LINE__);
        }
        if (is_null($cxa_delete_flag) || (is_array($cxa_delete_flag) && empty($cxa_delete_flag))) {
            unset($this->cxa_delete_flag);
        } else {
            $this->cxa_delete_flag = $cxa_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_key(): ?string
    {
        return $this->cxa_key ?? null;
    }
    /**
     * Set cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_key(?string $cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_key) && !is_string($cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_key, true), gettype($cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_key, true)), __LINE__);
        }
        if (is_null($cxa_key) || (is_array($cxa_key) && empty($cxa_key))) {
            unset($this->cxa_key);
        } else {
            $this->cxa_key = $cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_key_ext(): ?string
    {
        return $this->cxa_key_ext ?? null;
    }
    /**
     * Set cxa_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_key_ext(?string $cxa_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_key_ext) && !is_string($cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_key_ext, true), gettype($cxa_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_key_ext, true)), __LINE__);
        }
        if (is_null($cxa_key_ext) || (is_array($cxa_key_ext) && empty($cxa_key_ext))) {
            unset($this->cxa_key_ext);
        } else {
            $this->cxa_key_ext = $cxa_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cxa_on_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_on_hold_flag(): ?string
    {
        return $this->cxa_on_hold_flag ?? null;
    }
    /**
     * Set cxa_on_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_on_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_on_hold_flag(?string $cxa_on_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_on_hold_flag) && !is_string($cxa_on_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_on_hold_flag, true), gettype($cxa_on_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cxa_on_hold_flag) && $cxa_on_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cxa_on_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cxa_on_hold_flag) && $cxa_on_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cxa_on_hold_flag, true)), __LINE__);
        }
        if (is_null($cxa_on_hold_flag) || (is_array($cxa_on_hold_flag) && empty($cxa_on_hold_flag))) {
            unset($this->cxa_on_hold_flag);
        } else {
            $this->cxa_on_hold_flag = $cxa_on_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cxa_adh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_adh_key(): ?string
    {
        return $this->cxa_adh_key ?? null;
    }
    /**
     * Set cxa_adh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_adh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_adh_key(?string $cxa_adh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_adh_key) && !is_string($cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_adh_key, true), gettype($cxa_adh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_adh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_adh_key, true)), __LINE__);
        }
        if (is_null($cxa_adh_key) || (is_array($cxa_adh_key) && empty($cxa_adh_key))) {
            unset($this->cxa_adh_key);
        } else {
            $this->cxa_adh_key = $cxa_adh_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_adt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_adt_key(): ?string
    {
        return $this->cxa_adt_key ?? null;
    }
    /**
     * Set cxa_adt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_adt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_adt_key(?string $cxa_adt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_adt_key) && !is_string($cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_adt_key, true), gettype($cxa_adt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_adt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_adt_key, true)), __LINE__);
        }
        if (is_null($cxa_adt_key) || (is_array($cxa_adt_key) && empty($cxa_adt_key))) {
            unset($this->cxa_adt_key);
        } else {
            $this->cxa_adt_key = $cxa_adt_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_seasonal_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_seasonal_from_date(): ?string
    {
        return $this->cxa_seasonal_from_date ?? null;
    }
    /**
     * Set cxa_seasonal_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_seasonal_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_seasonal_from_date(?string $cxa_seasonal_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_seasonal_from_date) && !is_string($cxa_seasonal_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_seasonal_from_date, true), gettype($cxa_seasonal_from_date)), __LINE__);
        }
        if (is_null($cxa_seasonal_from_date) || (is_array($cxa_seasonal_from_date) && empty($cxa_seasonal_from_date))) {
            unset($this->cxa_seasonal_from_date);
        } else {
            $this->cxa_seasonal_from_date = $cxa_seasonal_from_date;
        }
        
        return $this;
    }
    /**
     * Get cxa_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_mailing_label(): ?string
    {
        return $this->cxa_mailing_label ?? null;
    }
    /**
     * Set cxa_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_mailing_label(?string $cxa_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_mailing_label) && !is_string($cxa_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_mailing_label, true), gettype($cxa_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cxa_mailing_label) && mb_strlen((string) $cxa_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cxa_mailing_label)), __LINE__);
        }
        if (is_null($cxa_mailing_label) || (is_array($cxa_mailing_label) && empty($cxa_mailing_label))) {
            unset($this->cxa_mailing_label);
        } else {
            $this->cxa_mailing_label = $cxa_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get cxa_seasonal_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_seasonal_through_date(): ?string
    {
        return $this->cxa_seasonal_through_date ?? null;
    }
    /**
     * Set cxa_seasonal_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_seasonal_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_seasonal_through_date(?string $cxa_seasonal_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_seasonal_through_date) && !is_string($cxa_seasonal_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_seasonal_through_date, true), gettype($cxa_seasonal_through_date)), __LINE__);
        }
        if (is_null($cxa_seasonal_through_date) || (is_array($cxa_seasonal_through_date) && empty($cxa_seasonal_through_date))) {
            unset($this->cxa_seasonal_through_date);
        } else {
            $this->cxa_seasonal_through_date = $cxa_seasonal_through_date;
        }
        
        return $this;
    }
    /**
     * Get cxa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_entity_key(): ?string
    {
        return $this->cxa_entity_key ?? null;
    }
    /**
     * Set cxa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_entity_key(?string $cxa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_entity_key) && !is_string($cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_entity_key, true), gettype($cxa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxa_entity_key, true)), __LINE__);
        }
        if (is_null($cxa_entity_key) || (is_array($cxa_entity_key) && empty($cxa_entity_key))) {
            unset($this->cxa_entity_key);
        } else {
            $this->cxa_entity_key = $cxa_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cxa_mail_stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_mail_stop(): ?string
    {
        return $this->cxa_mail_stop ?? null;
    }
    /**
     * Set cxa_mail_stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_mail_stop
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_mail_stop(?string $cxa_mail_stop = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_mail_stop) && !is_string($cxa_mail_stop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_mail_stop, true), gettype($cxa_mail_stop)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cxa_mail_stop) && mb_strlen((string) $cxa_mail_stop) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cxa_mail_stop)), __LINE__);
        }
        if (is_null($cxa_mail_stop) || (is_array($cxa_mail_stop) && empty($cxa_mail_stop))) {
            unset($this->cxa_mail_stop);
        } else {
            $this->cxa_mail_stop = $cxa_mail_stop;
        }
        
        return $this;
    }
    /**
     * Get cxa_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_mailing_label_html(): ?string
    {
        return $this->cxa_mailing_label_html ?? null;
    }
    /**
     * Set cxa_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_mailing_label_html(?string $cxa_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_mailing_label_html) && !is_string($cxa_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_mailing_label_html, true), gettype($cxa_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cxa_mailing_label_html) && mb_strlen((string) $cxa_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cxa_mailing_label_html)), __LINE__);
        }
        if (is_null($cxa_mailing_label_html) || (is_array($cxa_mailing_label_html) && empty($cxa_mailing_label_html))) {
            unset($this->cxa_mailing_label_html);
        } else {
            $this->cxa_mailing_label_html = $cxa_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get cxa_on_hold_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_on_hold_from(): ?string
    {
        return $this->cxa_on_hold_from ?? null;
    }
    /**
     * Set cxa_on_hold_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_on_hold_from
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_on_hold_from(?string $cxa_on_hold_from = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_on_hold_from) && !is_string($cxa_on_hold_from)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_on_hold_from, true), gettype($cxa_on_hold_from)), __LINE__);
        }
        if (is_null($cxa_on_hold_from) || (is_array($cxa_on_hold_from) && empty($cxa_on_hold_from))) {
            unset($this->cxa_on_hold_from);
        } else {
            $this->cxa_on_hold_from = $cxa_on_hold_from;
        }
        
        return $this;
    }
    /**
     * Get cxa_on_hold_through value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxa_on_hold_through(): ?string
    {
        return $this->cxa_on_hold_through ?? null;
    }
    /**
     * Set cxa_on_hold_through value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxa_on_hold_through
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
     */
    public function setCxa_on_hold_through(?string $cxa_on_hold_through = null): self
    {
        // validation for constraint: string
        if (!is_null($cxa_on_hold_through) && !is_string($cxa_on_hold_through)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxa_on_hold_through, true), gettype($cxa_on_hold_through)), __LINE__);
        }
        if (is_null($cxa_on_hold_through) || (is_array($cxa_on_hold_through) && empty($cxa_on_hold_through))) {
            unset($this->cxa_on_hold_through);
        } else {
            $this->cxa_on_hold_through = $cxa_on_hold_through;
        }
        
        return $this;
    }
}
