<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Customer_Primary_Address_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Customer_Primary_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adr_key = null;
    /**
     * The adr_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Address Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adr_cst_key_owner = null;
    /**
     * The adr_line1
     * Meta information extracted from the WSDL
     * - documentation: Address Line 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_line1 = null;
    /**
     * The adr_line2
     * Meta information extracted from the WSDL
     * - documentation: Address Line 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_line2 = null;
    /**
     * The adr_line3
     * Meta information extracted from the WSDL
     * - documentation: Address Line 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_line3 = null;
    /**
     * The adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_city = null;
    /**
     * The adr_state
     * Meta information extracted from the WSDL
     * - documentation: State/Territory.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_state = null;
    /**
     * The adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: Postal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_post_code = null;
    /**
     * The adr_city_state_code
     * Meta information extracted from the WSDL
     * - documentation: City, State, Post Code. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 104
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_city_state_code = null;
    /**
     * The adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_country = null;
    /**
     * The adr_intl_province
     * Meta information extracted from the WSDL
     * - documentation: International Province. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_intl_province = null;
    /**
     * The adr_county
     * Meta information extracted from the WSDL
     * - documentation: County. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_county = null;
    /**
     * The adr_cong_dist
     * Meta information extracted from the WSDL
     * - documentation: Congressional District. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_cong_dist = null;
    /**
     * The adr_state_house
     * Meta information extracted from the WSDL
     * - documentation: State House. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_state_house = null;
    /**
     * The adr_state_senate
     * Meta information extracted from the WSDL
     * - documentation: State Senate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_state_senate = null;
    /**
     * The adr_latitude
     * Meta information extracted from the WSDL
     * - documentation: Latitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $adr_latitude = null;
    /**
     * The adr_longitude
     * Meta information extracted from the WSDL
     * - documentation: Longitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $adr_longitude = null;
    /**
     * The adr_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_mailing_label = null;
    /**
     * The adr_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_mailing_label_html = null;
    /**
     * The adr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_add_date = null;
    /**
     * The adr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_add_user = null;
    /**
     * The adr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_change_date = null;
    /**
     * The adr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_change_user = null;
    /**
     * The adr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_delete_flag = null;
    /**
     * The adr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adr_key_ext = null;
    /**
     * The adr_bad_address_flag
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_bad_address_flag = null;
    /**
     * The adr_adb_key
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adr_adb_key = null;
    /**
     * The adr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $adr_entity_key = null;
    /**
     * The adr_metro_stat_area
     * Meta information extracted from the WSDL
     * - documentation: Metropolitan Statistical Area. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_metro_stat_area = null;
    /**
     * The adr_carrier_route
     * Meta information extracted from the WSDL
     * - documentation: Carrier Route. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_carrier_route = null;
    /**
     * The adr_delivery_point_code
     * Meta information extracted from the WSDL
     * - documentation: Delivery Point Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_delivery_point_code = null;
    /**
     * The adr_lacs
     * Meta information extracted from the WSDL
     * - documentation: LACS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_lacs = null;
    /**
     * The adr_time_zone
     * Meta information extracted from the WSDL
     * - documentation: TimeZone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_time_zone = null;
    /**
     * The adr_urbanization
     * Meta information extracted from the WSDL
     * - documentation: Urbanization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_urbanization = null;
    /**
     * The adr_bar_code
     * Meta information extracted from the WSDL
     * - documentation: BarCode. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_bar_code = null;
    /**
     * The adr_fips
     * Meta information extracted from the WSDL
     * - documentation: County FIPS Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_fips = null;
    /**
     * The adr_no_validation_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Validate. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_no_validation_flag = null;
    /**
     * The adr_attn
     * Meta information extracted from the WSDL
     * - documentation: Attention. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_attn = null;
    /**
     * The adr_record_type_code
     * Meta information extracted from the WSDL
     * - documentation: Record Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_record_type_code = null;
    /**
     * The adr_geography
     * Meta information extracted from the WSDL
     * - documentation: geography datatype. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $adr_geography = null;
    /**
     * Constructor method for AccreditationArea_Customer_Primary_Address_DataObjectType
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_key()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_cst_key_owner()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_line1()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_line2()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_line3()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_city()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_state()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_post_code()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_city_state_code()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_country()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_intl_province()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_county()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_cong_dist()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_state_house()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_state_senate()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_latitude()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_longitude()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_mailing_label()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_mailing_label_html()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_add_date()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_add_user()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_change_date()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_change_user()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_delete_flag()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_key_ext()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_bad_address_flag()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_adb_key()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_entity_key()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_metro_stat_area()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_carrier_route()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_delivery_point_code()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_lacs()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_time_zone()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_urbanization()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_bar_code()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_fips()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_no_validation_flag()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_attn()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_record_type_code()
     * @uses AccreditationArea_Customer_Primary_Address_DataObjectType::setAdr_geography()
     * @param string $adr_key
     * @param string $adr_cst_key_owner
     * @param string $adr_line1
     * @param string $adr_line2
     * @param string $adr_line3
     * @param string $adr_city
     * @param string $adr_state
     * @param string $adr_post_code
     * @param string $adr_city_state_code
     * @param string $adr_country
     * @param string $adr_intl_province
     * @param string $adr_county
     * @param string $adr_cong_dist
     * @param string $adr_state_house
     * @param string $adr_state_senate
     * @param float $adr_latitude
     * @param float $adr_longitude
     * @param string $adr_mailing_label
     * @param string $adr_mailing_label_html
     * @param string $adr_add_date
     * @param string $adr_add_user
     * @param string $adr_change_date
     * @param string $adr_change_user
     * @param string $adr_delete_flag
     * @param string $adr_key_ext
     * @param string $adr_bad_address_flag
     * @param string $adr_adb_key
     * @param string $adr_entity_key
     * @param string $adr_metro_stat_area
     * @param string $adr_carrier_route
     * @param string $adr_delivery_point_code
     * @param string $adr_lacs
     * @param string $adr_time_zone
     * @param string $adr_urbanization
     * @param string $adr_bar_code
     * @param string $adr_fips
     * @param string $adr_no_validation_flag
     * @param string $adr_attn
     * @param string $adr_record_type_code
     * @param string $adr_geography
     */
    public function __construct(?string $adr_key = null, ?string $adr_cst_key_owner = null, ?string $adr_line1 = null, ?string $adr_line2 = null, ?string $adr_line3 = null, ?string $adr_city = null, ?string $adr_state = null, ?string $adr_post_code = null, ?string $adr_city_state_code = null, ?string $adr_country = null, ?string $adr_intl_province = null, ?string $adr_county = null, ?string $adr_cong_dist = null, ?string $adr_state_house = null, ?string $adr_state_senate = null, ?float $adr_latitude = null, ?float $adr_longitude = null, ?string $adr_mailing_label = null, ?string $adr_mailing_label_html = null, ?string $adr_add_date = null, ?string $adr_add_user = null, ?string $adr_change_date = null, ?string $adr_change_user = null, ?string $adr_delete_flag = null, ?string $adr_key_ext = null, ?string $adr_bad_address_flag = null, ?string $adr_adb_key = null, ?string $adr_entity_key = null, ?string $adr_metro_stat_area = null, ?string $adr_carrier_route = null, ?string $adr_delivery_point_code = null, ?string $adr_lacs = null, ?string $adr_time_zone = null, ?string $adr_urbanization = null, ?string $adr_bar_code = null, ?string $adr_fips = null, ?string $adr_no_validation_flag = null, ?string $adr_attn = null, ?string $adr_record_type_code = null, ?string $adr_geography = null)
    {
        $this
            ->setAdr_key($adr_key)
            ->setAdr_cst_key_owner($adr_cst_key_owner)
            ->setAdr_line1($adr_line1)
            ->setAdr_line2($adr_line2)
            ->setAdr_line3($adr_line3)
            ->setAdr_city($adr_city)
            ->setAdr_state($adr_state)
            ->setAdr_post_code($adr_post_code)
            ->setAdr_city_state_code($adr_city_state_code)
            ->setAdr_country($adr_country)
            ->setAdr_intl_province($adr_intl_province)
            ->setAdr_county($adr_county)
            ->setAdr_cong_dist($adr_cong_dist)
            ->setAdr_state_house($adr_state_house)
            ->setAdr_state_senate($adr_state_senate)
            ->setAdr_latitude($adr_latitude)
            ->setAdr_longitude($adr_longitude)
            ->setAdr_mailing_label($adr_mailing_label)
            ->setAdr_mailing_label_html($adr_mailing_label_html)
            ->setAdr_add_date($adr_add_date)
            ->setAdr_add_user($adr_add_user)
            ->setAdr_change_date($adr_change_date)
            ->setAdr_change_user($adr_change_user)
            ->setAdr_delete_flag($adr_delete_flag)
            ->setAdr_key_ext($adr_key_ext)
            ->setAdr_bad_address_flag($adr_bad_address_flag)
            ->setAdr_adb_key($adr_adb_key)
            ->setAdr_entity_key($adr_entity_key)
            ->setAdr_metro_stat_area($adr_metro_stat_area)
            ->setAdr_carrier_route($adr_carrier_route)
            ->setAdr_delivery_point_code($adr_delivery_point_code)
            ->setAdr_lacs($adr_lacs)
            ->setAdr_time_zone($adr_time_zone)
            ->setAdr_urbanization($adr_urbanization)
            ->setAdr_bar_code($adr_bar_code)
            ->setAdr_fips($adr_fips)
            ->setAdr_no_validation_flag($adr_no_validation_flag)
            ->setAdr_attn($adr_attn)
            ->setAdr_record_type_code($adr_record_type_code)
            ->setAdr_geography($adr_geography);
    }
    /**
     * Get adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_key(): ?string
    {
        return $this->adr_key ?? null;
    }
    /**
     * Set adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_key(?string $adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_key) && !is_string($adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_key, true), gettype($adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adr_key, true)), __LINE__);
        }
        if (is_null($adr_key) || (is_array($adr_key) && empty($adr_key))) {
            unset($this->adr_key);
        } else {
            $this->adr_key = $adr_key;
        }
        
        return $this;
    }
    /**
     * Get adr_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_cst_key_owner(): ?string
    {
        return $this->adr_cst_key_owner ?? null;
    }
    /**
     * Set adr_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_cst_key_owner(?string $adr_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_cst_key_owner) && !is_string($adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_cst_key_owner, true), gettype($adr_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adr_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adr_cst_key_owner, true)), __LINE__);
        }
        if (is_null($adr_cst_key_owner) || (is_array($adr_cst_key_owner) && empty($adr_cst_key_owner))) {
            unset($this->adr_cst_key_owner);
        } else {
            $this->adr_cst_key_owner = $adr_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_line1(): ?string
    {
        return $this->adr_line1 ?? null;
    }
    /**
     * Set adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_line1(?string $adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_line1) && !is_string($adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_line1, true), gettype($adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($adr_line1) && mb_strlen((string) $adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $adr_line1)), __LINE__);
        }
        if (is_null($adr_line1) || (is_array($adr_line1) && empty($adr_line1))) {
            unset($this->adr_line1);
        } else {
            $this->adr_line1 = $adr_line1;
        }
        
        return $this;
    }
    /**
     * Get adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_line2(): ?string
    {
        return $this->adr_line2 ?? null;
    }
    /**
     * Set adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_line2(?string $adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_line2) && !is_string($adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_line2, true), gettype($adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($adr_line2) && mb_strlen((string) $adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $adr_line2)), __LINE__);
        }
        if (is_null($adr_line2) || (is_array($adr_line2) && empty($adr_line2))) {
            unset($this->adr_line2);
        } else {
            $this->adr_line2 = $adr_line2;
        }
        
        return $this;
    }
    /**
     * Get adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_line3(): ?string
    {
        return $this->adr_line3 ?? null;
    }
    /**
     * Set adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_line3(?string $adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_line3) && !is_string($adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_line3, true), gettype($adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($adr_line3) && mb_strlen((string) $adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $adr_line3)), __LINE__);
        }
        if (is_null($adr_line3) || (is_array($adr_line3) && empty($adr_line3))) {
            unset($this->adr_line3);
        } else {
            $this->adr_line3 = $adr_line3;
        }
        
        return $this;
    }
    /**
     * Get adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_city(): ?string
    {
        return $this->adr_city ?? null;
    }
    /**
     * Set adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_city(?string $adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_city) && !is_string($adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_city, true), gettype($adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_city) && mb_strlen((string) $adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_city)), __LINE__);
        }
        if (is_null($adr_city) || (is_array($adr_city) && empty($adr_city))) {
            unset($this->adr_city);
        } else {
            $this->adr_city = $adr_city;
        }
        
        return $this;
    }
    /**
     * Get adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_state(): ?string
    {
        return $this->adr_state ?? null;
    }
    /**
     * Set adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_state(?string $adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_state) && !is_string($adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_state, true), gettype($adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_state) && mb_strlen((string) $adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_state)), __LINE__);
        }
        if (is_null($adr_state) || (is_array($adr_state) && empty($adr_state))) {
            unset($this->adr_state);
        } else {
            $this->adr_state = $adr_state;
        }
        
        return $this;
    }
    /**
     * Get adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_post_code(): ?string
    {
        return $this->adr_post_code ?? null;
    }
    /**
     * Set adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_post_code(?string $adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_post_code) && !is_string($adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_post_code, true), gettype($adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($adr_post_code) && mb_strlen((string) $adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $adr_post_code)), __LINE__);
        }
        if (is_null($adr_post_code) || (is_array($adr_post_code) && empty($adr_post_code))) {
            unset($this->adr_post_code);
        } else {
            $this->adr_post_code = $adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get adr_city_state_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_city_state_code(): ?string
    {
        return $this->adr_city_state_code ?? null;
    }
    /**
     * Set adr_city_state_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_city_state_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_city_state_code(?string $adr_city_state_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_city_state_code) && !is_string($adr_city_state_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_city_state_code, true), gettype($adr_city_state_code)), __LINE__);
        }
        // validation for constraint: maxLength(104)
        if (!is_null($adr_city_state_code) && mb_strlen((string) $adr_city_state_code) > 104) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 104', mb_strlen((string) $adr_city_state_code)), __LINE__);
        }
        if (is_null($adr_city_state_code) || (is_array($adr_city_state_code) && empty($adr_city_state_code))) {
            unset($this->adr_city_state_code);
        } else {
            $this->adr_city_state_code = $adr_city_state_code;
        }
        
        return $this;
    }
    /**
     * Get adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_country(): ?string
    {
        return $this->adr_country ?? null;
    }
    /**
     * Set adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_country(?string $adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_country) && !is_string($adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_country, true), gettype($adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($adr_country) && mb_strlen((string) $adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $adr_country)), __LINE__);
        }
        if (is_null($adr_country) || (is_array($adr_country) && empty($adr_country))) {
            unset($this->adr_country);
        } else {
            $this->adr_country = $adr_country;
        }
        
        return $this;
    }
    /**
     * Get adr_intl_province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_intl_province(): ?string
    {
        return $this->adr_intl_province ?? null;
    }
    /**
     * Set adr_intl_province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_intl_province
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_intl_province(?string $adr_intl_province = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_intl_province) && !is_string($adr_intl_province)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_intl_province, true), gettype($adr_intl_province)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_intl_province) && mb_strlen((string) $adr_intl_province) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_intl_province)), __LINE__);
        }
        if (is_null($adr_intl_province) || (is_array($adr_intl_province) && empty($adr_intl_province))) {
            unset($this->adr_intl_province);
        } else {
            $this->adr_intl_province = $adr_intl_province;
        }
        
        return $this;
    }
    /**
     * Get adr_county value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_county(): ?string
    {
        return $this->adr_county ?? null;
    }
    /**
     * Set adr_county value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_county
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_county(?string $adr_county = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_county) && !is_string($adr_county)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_county, true), gettype($adr_county)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($adr_county) && mb_strlen((string) $adr_county) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $adr_county)), __LINE__);
        }
        if (is_null($adr_county) || (is_array($adr_county) && empty($adr_county))) {
            unset($this->adr_county);
        } else {
            $this->adr_county = $adr_county;
        }
        
        return $this;
    }
    /**
     * Get adr_cong_dist value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_cong_dist(): ?string
    {
        return $this->adr_cong_dist ?? null;
    }
    /**
     * Set adr_cong_dist value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_cong_dist
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_cong_dist(?string $adr_cong_dist = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_cong_dist) && !is_string($adr_cong_dist)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_cong_dist, true), gettype($adr_cong_dist)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($adr_cong_dist) && mb_strlen((string) $adr_cong_dist) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $adr_cong_dist)), __LINE__);
        }
        if (is_null($adr_cong_dist) || (is_array($adr_cong_dist) && empty($adr_cong_dist))) {
            unset($this->adr_cong_dist);
        } else {
            $this->adr_cong_dist = $adr_cong_dist;
        }
        
        return $this;
    }
    /**
     * Get adr_state_house value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_state_house(): ?string
    {
        return $this->adr_state_house ?? null;
    }
    /**
     * Set adr_state_house value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_state_house
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_state_house(?string $adr_state_house = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_state_house) && !is_string($adr_state_house)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_state_house, true), gettype($adr_state_house)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($adr_state_house) && mb_strlen((string) $adr_state_house) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $adr_state_house)), __LINE__);
        }
        if (is_null($adr_state_house) || (is_array($adr_state_house) && empty($adr_state_house))) {
            unset($this->adr_state_house);
        } else {
            $this->adr_state_house = $adr_state_house;
        }
        
        return $this;
    }
    /**
     * Get adr_state_senate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_state_senate(): ?string
    {
        return $this->adr_state_senate ?? null;
    }
    /**
     * Set adr_state_senate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_state_senate
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_state_senate(?string $adr_state_senate = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_state_senate) && !is_string($adr_state_senate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_state_senate, true), gettype($adr_state_senate)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($adr_state_senate) && mb_strlen((string) $adr_state_senate) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $adr_state_senate)), __LINE__);
        }
        if (is_null($adr_state_senate) || (is_array($adr_state_senate) && empty($adr_state_senate))) {
            unset($this->adr_state_senate);
        } else {
            $this->adr_state_senate = $adr_state_senate;
        }
        
        return $this;
    }
    /**
     * Get adr_latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAdr_latitude(): ?float
    {
        return $this->adr_latitude ?? null;
    }
    /**
     * Set adr_latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $adr_latitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_latitude(?float $adr_latitude = null): self
    {
        // validation for constraint: float
        if (!is_null($adr_latitude) && !(is_float($adr_latitude) || is_numeric($adr_latitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adr_latitude, true), gettype($adr_latitude)), __LINE__);
        }
        if (is_null($adr_latitude) || (is_array($adr_latitude) && empty($adr_latitude))) {
            unset($this->adr_latitude);
        } else {
            $this->adr_latitude = $adr_latitude;
        }
        
        return $this;
    }
    /**
     * Get adr_longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAdr_longitude(): ?float
    {
        return $this->adr_longitude ?? null;
    }
    /**
     * Set adr_longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $adr_longitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_longitude(?float $adr_longitude = null): self
    {
        // validation for constraint: float
        if (!is_null($adr_longitude) && !(is_float($adr_longitude) || is_numeric($adr_longitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adr_longitude, true), gettype($adr_longitude)), __LINE__);
        }
        if (is_null($adr_longitude) || (is_array($adr_longitude) && empty($adr_longitude))) {
            unset($this->adr_longitude);
        } else {
            $this->adr_longitude = $adr_longitude;
        }
        
        return $this;
    }
    /**
     * Get adr_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_mailing_label(): ?string
    {
        return $this->adr_mailing_label ?? null;
    }
    /**
     * Set adr_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_mailing_label(?string $adr_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_mailing_label) && !is_string($adr_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_mailing_label, true), gettype($adr_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($adr_mailing_label) && mb_strlen((string) $adr_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $adr_mailing_label)), __LINE__);
        }
        if (is_null($adr_mailing_label) || (is_array($adr_mailing_label) && empty($adr_mailing_label))) {
            unset($this->adr_mailing_label);
        } else {
            $this->adr_mailing_label = $adr_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get adr_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_mailing_label_html(): ?string
    {
        return $this->adr_mailing_label_html ?? null;
    }
    /**
     * Set adr_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_mailing_label_html(?string $adr_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_mailing_label_html) && !is_string($adr_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_mailing_label_html, true), gettype($adr_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($adr_mailing_label_html) && mb_strlen((string) $adr_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $adr_mailing_label_html)), __LINE__);
        }
        if (is_null($adr_mailing_label_html) || (is_array($adr_mailing_label_html) && empty($adr_mailing_label_html))) {
            unset($this->adr_mailing_label_html);
        } else {
            $this->adr_mailing_label_html = $adr_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get adr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_add_date(): ?string
    {
        return $this->adr_add_date ?? null;
    }
    /**
     * Set adr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_add_date(?string $adr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_add_date) && !is_string($adr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_add_date, true), gettype($adr_add_date)), __LINE__);
        }
        if (is_null($adr_add_date) || (is_array($adr_add_date) && empty($adr_add_date))) {
            unset($this->adr_add_date);
        } else {
            $this->adr_add_date = $adr_add_date;
        }
        
        return $this;
    }
    /**
     * Get adr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_add_user(): ?string
    {
        return $this->adr_add_user ?? null;
    }
    /**
     * Set adr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_add_user(?string $adr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_add_user) && !is_string($adr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_add_user, true), gettype($adr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($adr_add_user) && mb_strlen((string) $adr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $adr_add_user)), __LINE__);
        }
        if (is_null($adr_add_user) || (is_array($adr_add_user) && empty($adr_add_user))) {
            unset($this->adr_add_user);
        } else {
            $this->adr_add_user = $adr_add_user;
        }
        
        return $this;
    }
    /**
     * Get adr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_change_date(): ?string
    {
        return $this->adr_change_date ?? null;
    }
    /**
     * Set adr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_change_date(?string $adr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_change_date) && !is_string($adr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_change_date, true), gettype($adr_change_date)), __LINE__);
        }
        if (is_null($adr_change_date) || (is_array($adr_change_date) && empty($adr_change_date))) {
            unset($this->adr_change_date);
        } else {
            $this->adr_change_date = $adr_change_date;
        }
        
        return $this;
    }
    /**
     * Get adr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_change_user(): ?string
    {
        return $this->adr_change_user ?? null;
    }
    /**
     * Set adr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_change_user(?string $adr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_change_user) && !is_string($adr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_change_user, true), gettype($adr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($adr_change_user) && mb_strlen((string) $adr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $adr_change_user)), __LINE__);
        }
        if (is_null($adr_change_user) || (is_array($adr_change_user) && empty($adr_change_user))) {
            unset($this->adr_change_user);
        } else {
            $this->adr_change_user = $adr_change_user;
        }
        
        return $this;
    }
    /**
     * Get adr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_delete_flag(): ?string
    {
        return $this->adr_delete_flag ?? null;
    }
    /**
     * Set adr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_delete_flag(?string $adr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_delete_flag) && !is_string($adr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_delete_flag, true), gettype($adr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($adr_delete_flag) && $adr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($adr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($adr_delete_flag) && $adr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($adr_delete_flag, true)), __LINE__);
        }
        if (is_null($adr_delete_flag) || (is_array($adr_delete_flag) && empty($adr_delete_flag))) {
            unset($this->adr_delete_flag);
        } else {
            $this->adr_delete_flag = $adr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get adr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_key_ext(): ?string
    {
        return $this->adr_key_ext ?? null;
    }
    /**
     * Set adr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_key_ext(?string $adr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_key_ext) && !is_string($adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_key_ext, true), gettype($adr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adr_key_ext, true)), __LINE__);
        }
        if (is_null($adr_key_ext) || (is_array($adr_key_ext) && empty($adr_key_ext))) {
            unset($this->adr_key_ext);
        } else {
            $this->adr_key_ext = $adr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get adr_bad_address_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_bad_address_flag(): ?string
    {
        return $this->adr_bad_address_flag ?? null;
    }
    /**
     * Set adr_bad_address_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_bad_address_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_bad_address_flag(?string $adr_bad_address_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_bad_address_flag) && !is_string($adr_bad_address_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_bad_address_flag, true), gettype($adr_bad_address_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($adr_bad_address_flag) && $adr_bad_address_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($adr_bad_address_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($adr_bad_address_flag) && $adr_bad_address_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($adr_bad_address_flag, true)), __LINE__);
        }
        if (is_null($adr_bad_address_flag) || (is_array($adr_bad_address_flag) && empty($adr_bad_address_flag))) {
            unset($this->adr_bad_address_flag);
        } else {
            $this->adr_bad_address_flag = $adr_bad_address_flag;
        }
        
        return $this;
    }
    /**
     * Get adr_adb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_adb_key(): ?string
    {
        return $this->adr_adb_key ?? null;
    }
    /**
     * Set adr_adb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_adb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_adb_key(?string $adr_adb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_adb_key) && !is_string($adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_adb_key, true), gettype($adr_adb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adr_adb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adr_adb_key, true)), __LINE__);
        }
        if (is_null($adr_adb_key) || (is_array($adr_adb_key) && empty($adr_adb_key))) {
            unset($this->adr_adb_key);
        } else {
            $this->adr_adb_key = $adr_adb_key;
        }
        
        return $this;
    }
    /**
     * Get adr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_entity_key(): ?string
    {
        return $this->adr_entity_key ?? null;
    }
    /**
     * Set adr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_entity_key(?string $adr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_entity_key) && !is_string($adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_entity_key, true), gettype($adr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($adr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($adr_entity_key, true)), __LINE__);
        }
        if (is_null($adr_entity_key) || (is_array($adr_entity_key) && empty($adr_entity_key))) {
            unset($this->adr_entity_key);
        } else {
            $this->adr_entity_key = $adr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get adr_metro_stat_area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_metro_stat_area(): ?string
    {
        return $this->adr_metro_stat_area ?? null;
    }
    /**
     * Set adr_metro_stat_area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_metro_stat_area
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_metro_stat_area(?string $adr_metro_stat_area = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_metro_stat_area) && !is_string($adr_metro_stat_area)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_metro_stat_area, true), gettype($adr_metro_stat_area)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($adr_metro_stat_area) && mb_strlen((string) $adr_metro_stat_area) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $adr_metro_stat_area)), __LINE__);
        }
        if (is_null($adr_metro_stat_area) || (is_array($adr_metro_stat_area) && empty($adr_metro_stat_area))) {
            unset($this->adr_metro_stat_area);
        } else {
            $this->adr_metro_stat_area = $adr_metro_stat_area;
        }
        
        return $this;
    }
    /**
     * Get adr_carrier_route value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_carrier_route(): ?string
    {
        return $this->adr_carrier_route ?? null;
    }
    /**
     * Set adr_carrier_route value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_carrier_route
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_carrier_route(?string $adr_carrier_route = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_carrier_route) && !is_string($adr_carrier_route)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_carrier_route, true), gettype($adr_carrier_route)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($adr_carrier_route) && mb_strlen((string) $adr_carrier_route) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $adr_carrier_route)), __LINE__);
        }
        if (is_null($adr_carrier_route) || (is_array($adr_carrier_route) && empty($adr_carrier_route))) {
            unset($this->adr_carrier_route);
        } else {
            $this->adr_carrier_route = $adr_carrier_route;
        }
        
        return $this;
    }
    /**
     * Get adr_delivery_point_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_delivery_point_code(): ?string
    {
        return $this->adr_delivery_point_code ?? null;
    }
    /**
     * Set adr_delivery_point_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_delivery_point_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_delivery_point_code(?string $adr_delivery_point_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_delivery_point_code) && !is_string($adr_delivery_point_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_delivery_point_code, true), gettype($adr_delivery_point_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($adr_delivery_point_code) && mb_strlen((string) $adr_delivery_point_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $adr_delivery_point_code)), __LINE__);
        }
        if (is_null($adr_delivery_point_code) || (is_array($adr_delivery_point_code) && empty($adr_delivery_point_code))) {
            unset($this->adr_delivery_point_code);
        } else {
            $this->adr_delivery_point_code = $adr_delivery_point_code;
        }
        
        return $this;
    }
    /**
     * Get adr_lacs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_lacs(): ?string
    {
        return $this->adr_lacs ?? null;
    }
    /**
     * Set adr_lacs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_lacs
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_lacs(?string $adr_lacs = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_lacs) && !is_string($adr_lacs)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_lacs, true), gettype($adr_lacs)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($adr_lacs) && mb_strlen((string) $adr_lacs) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $adr_lacs)), __LINE__);
        }
        if (is_null($adr_lacs) || (is_array($adr_lacs) && empty($adr_lacs))) {
            unset($this->adr_lacs);
        } else {
            $this->adr_lacs = $adr_lacs;
        }
        
        return $this;
    }
    /**
     * Get adr_time_zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_time_zone(): ?string
    {
        return $this->adr_time_zone ?? null;
    }
    /**
     * Set adr_time_zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_time_zone
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_time_zone(?string $adr_time_zone = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_time_zone) && !is_string($adr_time_zone)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_time_zone, true), gettype($adr_time_zone)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($adr_time_zone) && mb_strlen((string) $adr_time_zone) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $adr_time_zone)), __LINE__);
        }
        if (is_null($adr_time_zone) || (is_array($adr_time_zone) && empty($adr_time_zone))) {
            unset($this->adr_time_zone);
        } else {
            $this->adr_time_zone = $adr_time_zone;
        }
        
        return $this;
    }
    /**
     * Get adr_urbanization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_urbanization(): ?string
    {
        return $this->adr_urbanization ?? null;
    }
    /**
     * Set adr_urbanization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_urbanization
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_urbanization(?string $adr_urbanization = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_urbanization) && !is_string($adr_urbanization)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_urbanization, true), gettype($adr_urbanization)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($adr_urbanization) && mb_strlen((string) $adr_urbanization) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $adr_urbanization)), __LINE__);
        }
        if (is_null($adr_urbanization) || (is_array($adr_urbanization) && empty($adr_urbanization))) {
            unset($this->adr_urbanization);
        } else {
            $this->adr_urbanization = $adr_urbanization;
        }
        
        return $this;
    }
    /**
     * Get adr_bar_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_bar_code(): ?string
    {
        return $this->adr_bar_code ?? null;
    }
    /**
     * Set adr_bar_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_bar_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_bar_code(?string $adr_bar_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_bar_code) && !is_string($adr_bar_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_bar_code, true), gettype($adr_bar_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($adr_bar_code) && mb_strlen((string) $adr_bar_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $adr_bar_code)), __LINE__);
        }
        if (is_null($adr_bar_code) || (is_array($adr_bar_code) && empty($adr_bar_code))) {
            unset($this->adr_bar_code);
        } else {
            $this->adr_bar_code = $adr_bar_code;
        }
        
        return $this;
    }
    /**
     * Get adr_fips value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_fips(): ?string
    {
        return $this->adr_fips ?? null;
    }
    /**
     * Set adr_fips value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_fips
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_fips(?string $adr_fips = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_fips) && !is_string($adr_fips)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_fips, true), gettype($adr_fips)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($adr_fips) && mb_strlen((string) $adr_fips) > 5) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen((string) $adr_fips)), __LINE__);
        }
        if (is_null($adr_fips) || (is_array($adr_fips) && empty($adr_fips))) {
            unset($this->adr_fips);
        } else {
            $this->adr_fips = $adr_fips;
        }
        
        return $this;
    }
    /**
     * Get adr_no_validation_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_no_validation_flag(): ?string
    {
        return $this->adr_no_validation_flag ?? null;
    }
    /**
     * Set adr_no_validation_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_no_validation_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_no_validation_flag(?string $adr_no_validation_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_no_validation_flag) && !is_string($adr_no_validation_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_no_validation_flag, true), gettype($adr_no_validation_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($adr_no_validation_flag) && $adr_no_validation_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($adr_no_validation_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($adr_no_validation_flag) && $adr_no_validation_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($adr_no_validation_flag, true)), __LINE__);
        }
        if (is_null($adr_no_validation_flag) || (is_array($adr_no_validation_flag) && empty($adr_no_validation_flag))) {
            unset($this->adr_no_validation_flag);
        } else {
            $this->adr_no_validation_flag = $adr_no_validation_flag;
        }
        
        return $this;
    }
    /**
     * Get adr_attn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_attn(): ?string
    {
        return $this->adr_attn ?? null;
    }
    /**
     * Set adr_attn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_attn
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_attn(?string $adr_attn = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_attn) && !is_string($adr_attn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_attn, true), gettype($adr_attn)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($adr_attn) && mb_strlen((string) $adr_attn) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $adr_attn)), __LINE__);
        }
        if (is_null($adr_attn) || (is_array($adr_attn) && empty($adr_attn))) {
            unset($this->adr_attn);
        } else {
            $this->adr_attn = $adr_attn;
        }
        
        return $this;
    }
    /**
     * Get adr_record_type_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_record_type_code(): ?string
    {
        return $this->adr_record_type_code ?? null;
    }
    /**
     * Set adr_record_type_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_record_type_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_record_type_code(?string $adr_record_type_code = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_record_type_code) && !is_string($adr_record_type_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_record_type_code, true), gettype($adr_record_type_code)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($adr_record_type_code) && mb_strlen((string) $adr_record_type_code) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $adr_record_type_code)), __LINE__);
        }
        if (is_null($adr_record_type_code) || (is_array($adr_record_type_code) && empty($adr_record_type_code))) {
            unset($this->adr_record_type_code);
        } else {
            $this->adr_record_type_code = $adr_record_type_code;
        }
        
        return $this;
    }
    /**
     * Get adr_geography value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdr_geography(): ?string
    {
        return $this->adr_geography ?? null;
    }
    /**
     * Set adr_geography value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adr_geography
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
     */
    public function setAdr_geography(?string $adr_geography = null): self
    {
        // validation for constraint: string
        if (!is_null($adr_geography) && !is_string($adr_geography)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adr_geography, true), gettype($adr_geography)), __LINE__);
        }
        if (is_null($adr_geography) || (is_array($adr_geography) && empty($adr_geography))) {
            unset($this->adr_geography);
        } else {
            $this->adr_geography = $adr_geography;
        }
        
        return $this;
    }
}
