<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType extends AbstractStructBase
{
    /**
     * The lxo__ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_key = null;
    /**
     * The lxo__ixo_rlt_code
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_rlt_code = null;
    /**
     * The lxo__ixo_title
     * Meta information extracted from the WSDL
     * - documentation: Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_title = null;
    /**
     * The lxo__ixo_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_start_date = null;
    /**
     * The lxo__ixo_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_end_date = null;
    /**
     * The lxo__ixo_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Individual Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_ind_cst_key = null;
    /**
     * The lxo__ixo_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_org_cst_key = null;
    /**
     * The lxo__ixo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_add_date = null;
    /**
     * The lxo__ixo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_add_user = null;
    /**
     * The lxo__ixo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_change_date = null;
    /**
     * The lxo__ixo_rlt_key
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_rlt_key = null;
    /**
     * The lxo__ixo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_change_user = null;
    /**
     * The lxo__ixo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_delete_flag = null;
    /**
     * The lxo__ixo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_key_ext = null;
    /**
     * The lxo__ixo_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Owning Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_cst_key_owner = null;
    /**
     * The lxo__ixo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $lxo__ixo_entity_key = null;
    /**
     * The lxo__ixo_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $lxo__ixo_void_flag = null;
    /**
     * Constructor method for
     * AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_key()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_rlt_code()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_title()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_start_date()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_end_date()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_ind_cst_key()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_org_cst_key()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_add_date()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_add_user()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_change_date()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_rlt_key()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_change_user()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_delete_flag()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_key_ext()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_cst_key_owner()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_entity_key()
     * @uses AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType::setLxo__ixo_void_flag()
     * @param string $lxo__ixo_key
     * @param string $lxo__ixo_rlt_code
     * @param string $lxo__ixo_title
     * @param string $lxo__ixo_start_date
     * @param string $lxo__ixo_end_date
     * @param string $lxo__ixo_ind_cst_key
     * @param string $lxo__ixo_org_cst_key
     * @param string $lxo__ixo_add_date
     * @param string $lxo__ixo_add_user
     * @param string $lxo__ixo_change_date
     * @param string $lxo__ixo_rlt_key
     * @param string $lxo__ixo_change_user
     * @param string $lxo__ixo_delete_flag
     * @param string $lxo__ixo_key_ext
     * @param string $lxo__ixo_cst_key_owner
     * @param string $lxo__ixo_entity_key
     * @param string $lxo__ixo_void_flag
     */
    public function __construct(?string $lxo__ixo_key = null, ?string $lxo__ixo_rlt_code = null, ?string $lxo__ixo_title = null, ?string $lxo__ixo_start_date = null, ?string $lxo__ixo_end_date = null, ?string $lxo__ixo_ind_cst_key = null, ?string $lxo__ixo_org_cst_key = null, ?string $lxo__ixo_add_date = null, ?string $lxo__ixo_add_user = null, ?string $lxo__ixo_change_date = null, ?string $lxo__ixo_rlt_key = null, ?string $lxo__ixo_change_user = null, ?string $lxo__ixo_delete_flag = null, ?string $lxo__ixo_key_ext = null, ?string $lxo__ixo_cst_key_owner = null, ?string $lxo__ixo_entity_key = null, ?string $lxo__ixo_void_flag = null)
    {
        $this
            ->setLxo__ixo_key($lxo__ixo_key)
            ->setLxo__ixo_rlt_code($lxo__ixo_rlt_code)
            ->setLxo__ixo_title($lxo__ixo_title)
            ->setLxo__ixo_start_date($lxo__ixo_start_date)
            ->setLxo__ixo_end_date($lxo__ixo_end_date)
            ->setLxo__ixo_ind_cst_key($lxo__ixo_ind_cst_key)
            ->setLxo__ixo_org_cst_key($lxo__ixo_org_cst_key)
            ->setLxo__ixo_add_date($lxo__ixo_add_date)
            ->setLxo__ixo_add_user($lxo__ixo_add_user)
            ->setLxo__ixo_change_date($lxo__ixo_change_date)
            ->setLxo__ixo_rlt_key($lxo__ixo_rlt_key)
            ->setLxo__ixo_change_user($lxo__ixo_change_user)
            ->setLxo__ixo_delete_flag($lxo__ixo_delete_flag)
            ->setLxo__ixo_key_ext($lxo__ixo_key_ext)
            ->setLxo__ixo_cst_key_owner($lxo__ixo_cst_key_owner)
            ->setLxo__ixo_entity_key($lxo__ixo_entity_key)
            ->setLxo__ixo_void_flag($lxo__ixo_void_flag);
    }
    /**
     * Get lxo__ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_key(): ?string
    {
        return $this->lxo__ixo_key ?? null;
    }
    /**
     * Set lxo__ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_key(?string $lxo__ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_key) && !is_string($lxo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_key, true), gettype($lxo__ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_key, true)), __LINE__);
        }
        if (is_null($lxo__ixo_key) || (is_array($lxo__ixo_key) && empty($lxo__ixo_key))) {
            unset($this->lxo__ixo_key);
        } else {
            $this->lxo__ixo_key = $lxo__ixo_key;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_rlt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_rlt_code(): ?string
    {
        return $this->lxo__ixo_rlt_code ?? null;
    }
    /**
     * Set lxo__ixo_rlt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_rlt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_rlt_code(?string $lxo__ixo_rlt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_rlt_code) && !is_string($lxo__ixo_rlt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_rlt_code, true), gettype($lxo__ixo_rlt_code)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($lxo__ixo_rlt_code) && mb_strlen((string) $lxo__ixo_rlt_code) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $lxo__ixo_rlt_code)), __LINE__);
        }
        if (is_null($lxo__ixo_rlt_code) || (is_array($lxo__ixo_rlt_code) && empty($lxo__ixo_rlt_code))) {
            unset($this->lxo__ixo_rlt_code);
        } else {
            $this->lxo__ixo_rlt_code = $lxo__ixo_rlt_code;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_title(): ?string
    {
        return $this->lxo__ixo_title ?? null;
    }
    /**
     * Set lxo__ixo_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_title(?string $lxo__ixo_title = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_title) && !is_string($lxo__ixo_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_title, true), gettype($lxo__ixo_title)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($lxo__ixo_title) && mb_strlen((string) $lxo__ixo_title) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $lxo__ixo_title)), __LINE__);
        }
        if (is_null($lxo__ixo_title) || (is_array($lxo__ixo_title) && empty($lxo__ixo_title))) {
            unset($this->lxo__ixo_title);
        } else {
            $this->lxo__ixo_title = $lxo__ixo_title;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_start_date(): ?string
    {
        return $this->lxo__ixo_start_date ?? null;
    }
    /**
     * Set lxo__ixo_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_start_date(?string $lxo__ixo_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_start_date) && !is_string($lxo__ixo_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_start_date, true), gettype($lxo__ixo_start_date)), __LINE__);
        }
        if (is_null($lxo__ixo_start_date) || (is_array($lxo__ixo_start_date) && empty($lxo__ixo_start_date))) {
            unset($this->lxo__ixo_start_date);
        } else {
            $this->lxo__ixo_start_date = $lxo__ixo_start_date;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_end_date(): ?string
    {
        return $this->lxo__ixo_end_date ?? null;
    }
    /**
     * Set lxo__ixo_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_end_date(?string $lxo__ixo_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_end_date) && !is_string($lxo__ixo_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_end_date, true), gettype($lxo__ixo_end_date)), __LINE__);
        }
        if (is_null($lxo__ixo_end_date) || (is_array($lxo__ixo_end_date) && empty($lxo__ixo_end_date))) {
            unset($this->lxo__ixo_end_date);
        } else {
            $this->lxo__ixo_end_date = $lxo__ixo_end_date;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_ind_cst_key(): ?string
    {
        return $this->lxo__ixo_ind_cst_key ?? null;
    }
    /**
     * Set lxo__ixo_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_ind_cst_key(?string $lxo__ixo_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_ind_cst_key) && !is_string($lxo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_ind_cst_key, true), gettype($lxo__ixo_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_ind_cst_key, true)), __LINE__);
        }
        if (is_null($lxo__ixo_ind_cst_key) || (is_array($lxo__ixo_ind_cst_key) && empty($lxo__ixo_ind_cst_key))) {
            unset($this->lxo__ixo_ind_cst_key);
        } else {
            $this->lxo__ixo_ind_cst_key = $lxo__ixo_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_org_cst_key(): ?string
    {
        return $this->lxo__ixo_org_cst_key ?? null;
    }
    /**
     * Set lxo__ixo_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_org_cst_key(?string $lxo__ixo_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_org_cst_key) && !is_string($lxo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_org_cst_key, true), gettype($lxo__ixo_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_org_cst_key, true)), __LINE__);
        }
        if (is_null($lxo__ixo_org_cst_key) || (is_array($lxo__ixo_org_cst_key) && empty($lxo__ixo_org_cst_key))) {
            unset($this->lxo__ixo_org_cst_key);
        } else {
            $this->lxo__ixo_org_cst_key = $lxo__ixo_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_add_date(): ?string
    {
        return $this->lxo__ixo_add_date ?? null;
    }
    /**
     * Set lxo__ixo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_add_date(?string $lxo__ixo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_add_date) && !is_string($lxo__ixo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_add_date, true), gettype($lxo__ixo_add_date)), __LINE__);
        }
        if (is_null($lxo__ixo_add_date) || (is_array($lxo__ixo_add_date) && empty($lxo__ixo_add_date))) {
            unset($this->lxo__ixo_add_date);
        } else {
            $this->lxo__ixo_add_date = $lxo__ixo_add_date;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_add_user(): ?string
    {
        return $this->lxo__ixo_add_user ?? null;
    }
    /**
     * Set lxo__ixo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_add_user(?string $lxo__ixo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_add_user) && !is_string($lxo__ixo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_add_user, true), gettype($lxo__ixo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lxo__ixo_add_user) && mb_strlen((string) $lxo__ixo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $lxo__ixo_add_user)), __LINE__);
        }
        if (is_null($lxo__ixo_add_user) || (is_array($lxo__ixo_add_user) && empty($lxo__ixo_add_user))) {
            unset($this->lxo__ixo_add_user);
        } else {
            $this->lxo__ixo_add_user = $lxo__ixo_add_user;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_change_date(): ?string
    {
        return $this->lxo__ixo_change_date ?? null;
    }
    /**
     * Set lxo__ixo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_change_date(?string $lxo__ixo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_change_date) && !is_string($lxo__ixo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_change_date, true), gettype($lxo__ixo_change_date)), __LINE__);
        }
        if (is_null($lxo__ixo_change_date) || (is_array($lxo__ixo_change_date) && empty($lxo__ixo_change_date))) {
            unset($this->lxo__ixo_change_date);
        } else {
            $this->lxo__ixo_change_date = $lxo__ixo_change_date;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_rlt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_rlt_key(): ?string
    {
        return $this->lxo__ixo_rlt_key ?? null;
    }
    /**
     * Set lxo__ixo_rlt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_rlt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_rlt_key(?string $lxo__ixo_rlt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_rlt_key) && !is_string($lxo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_rlt_key, true), gettype($lxo__ixo_rlt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_rlt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_rlt_key, true)), __LINE__);
        }
        if (is_null($lxo__ixo_rlt_key) || (is_array($lxo__ixo_rlt_key) && empty($lxo__ixo_rlt_key))) {
            unset($this->lxo__ixo_rlt_key);
        } else {
            $this->lxo__ixo_rlt_key = $lxo__ixo_rlt_key;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_change_user(): ?string
    {
        return $this->lxo__ixo_change_user ?? null;
    }
    /**
     * Set lxo__ixo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_change_user(?string $lxo__ixo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_change_user) && !is_string($lxo__ixo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_change_user, true), gettype($lxo__ixo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lxo__ixo_change_user) && mb_strlen((string) $lxo__ixo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $lxo__ixo_change_user)), __LINE__);
        }
        if (is_null($lxo__ixo_change_user) || (is_array($lxo__ixo_change_user) && empty($lxo__ixo_change_user))) {
            unset($this->lxo__ixo_change_user);
        } else {
            $this->lxo__ixo_change_user = $lxo__ixo_change_user;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_delete_flag(): ?string
    {
        return $this->lxo__ixo_delete_flag ?? null;
    }
    /**
     * Set lxo__ixo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_delete_flag(?string $lxo__ixo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_delete_flag) && !is_string($lxo__ixo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_delete_flag, true), gettype($lxo__ixo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($lxo__ixo_delete_flag) && $lxo__ixo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($lxo__ixo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lxo__ixo_delete_flag) && $lxo__ixo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lxo__ixo_delete_flag, true)), __LINE__);
        }
        if (is_null($lxo__ixo_delete_flag) || (is_array($lxo__ixo_delete_flag) && empty($lxo__ixo_delete_flag))) {
            unset($this->lxo__ixo_delete_flag);
        } else {
            $this->lxo__ixo_delete_flag = $lxo__ixo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_key_ext(): ?string
    {
        return $this->lxo__ixo_key_ext ?? null;
    }
    /**
     * Set lxo__ixo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_key_ext(?string $lxo__ixo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_key_ext) && !is_string($lxo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_key_ext, true), gettype($lxo__ixo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_key_ext, true)), __LINE__);
        }
        if (is_null($lxo__ixo_key_ext) || (is_array($lxo__ixo_key_ext) && empty($lxo__ixo_key_ext))) {
            unset($this->lxo__ixo_key_ext);
        } else {
            $this->lxo__ixo_key_ext = $lxo__ixo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_cst_key_owner(): ?string
    {
        return $this->lxo__ixo_cst_key_owner ?? null;
    }
    /**
     * Set lxo__ixo_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_cst_key_owner(?string $lxo__ixo_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_cst_key_owner) && !is_string($lxo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_cst_key_owner, true), gettype($lxo__ixo_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_cst_key_owner, true)), __LINE__);
        }
        if (is_null($lxo__ixo_cst_key_owner) || (is_array($lxo__ixo_cst_key_owner) && empty($lxo__ixo_cst_key_owner))) {
            unset($this->lxo__ixo_cst_key_owner);
        } else {
            $this->lxo__ixo_cst_key_owner = $lxo__ixo_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_entity_key(): ?string
    {
        return $this->lxo__ixo_entity_key ?? null;
    }
    /**
     * Set lxo__ixo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_entity_key(?string $lxo__ixo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_entity_key) && !is_string($lxo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_entity_key, true), gettype($lxo__ixo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($lxo__ixo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $lxo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($lxo__ixo_entity_key, true)), __LINE__);
        }
        if (is_null($lxo__ixo_entity_key) || (is_array($lxo__ixo_entity_key) && empty($lxo__ixo_entity_key))) {
            unset($this->lxo__ixo_entity_key);
        } else {
            $this->lxo__ixo_entity_key = $lxo__ixo_entity_key;
        }
        
        return $this;
    }
    /**
     * Get lxo__ixo_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLxo__ixo_void_flag(): ?string
    {
        return $this->lxo__ixo_void_flag ?? null;
    }
    /**
     * Set lxo__ixo_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lxo__ixo_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
     */
    public function setLxo__ixo_void_flag(?string $lxo__ixo_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($lxo__ixo_void_flag) && !is_string($lxo__ixo_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lxo__ixo_void_flag, true), gettype($lxo__ixo_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($lxo__ixo_void_flag) && $lxo__ixo_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($lxo__ixo_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lxo__ixo_void_flag) && $lxo__ixo_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lxo__ixo_void_flag, true)), __LINE__);
        }
        if (is_null($lxo__ixo_void_flag) || (is_array($lxo__ixo_void_flag) && empty($lxo__ixo_void_flag))) {
            unset($this->lxo__ixo_void_flag);
        } else {
            $this->lxo__ixo_void_flag = $lxo__ixo_void_flag;
        }
        
        return $this;
    }
}
