<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectT
 * ype StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType extends AbstractStructBase
{
    /**
     * The sxo__ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_key = null;
    /**
     * The sxo__ixo_rlt_code
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_rlt_code = null;
    /**
     * The sxo__ixo_title
     * Meta information extracted from the WSDL
     * - documentation: Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_title = null;
    /**
     * The sxo__ixo_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_start_date = null;
    /**
     * The sxo__ixo_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_end_date = null;
    /**
     * The sxo__ixo_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Individual Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_ind_cst_key = null;
    /**
     * The sxo__ixo_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_org_cst_key = null;
    /**
     * The sxo__ixo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_add_date = null;
    /**
     * The sxo__ixo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_add_user = null;
    /**
     * The sxo__ixo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_change_date = null;
    /**
     * The sxo__ixo_rlt_key
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_rlt_key = null;
    /**
     * The sxo__ixo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_change_user = null;
    /**
     * The sxo__ixo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_delete_flag = null;
    /**
     * The sxo__ixo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_key_ext = null;
    /**
     * The sxo__ixo_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Owning Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_cst_key_owner = null;
    /**
     * The sxo__ixo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sxo__ixo_entity_key = null;
    /**
     * The sxo__ixo_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sxo__ixo_void_flag = null;
    /**
     * Constructor method for
     * AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectT
     * ype
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_key()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_rlt_code()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_title()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_start_date()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_end_date()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_ind_cst_key()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_org_cst_key()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_add_date()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_add_user()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_change_date()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_rlt_key()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_change_user()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_delete_flag()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_key_ext()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_cst_key_owner()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_entity_key()
     * @uses AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType::setSxo__ixo_void_flag()
     * @param string $sxo__ixo_key
     * @param string $sxo__ixo_rlt_code
     * @param string $sxo__ixo_title
     * @param string $sxo__ixo_start_date
     * @param string $sxo__ixo_end_date
     * @param string $sxo__ixo_ind_cst_key
     * @param string $sxo__ixo_org_cst_key
     * @param string $sxo__ixo_add_date
     * @param string $sxo__ixo_add_user
     * @param string $sxo__ixo_change_date
     * @param string $sxo__ixo_rlt_key
     * @param string $sxo__ixo_change_user
     * @param string $sxo__ixo_delete_flag
     * @param string $sxo__ixo_key_ext
     * @param string $sxo__ixo_cst_key_owner
     * @param string $sxo__ixo_entity_key
     * @param string $sxo__ixo_void_flag
     */
    public function __construct(?string $sxo__ixo_key = null, ?string $sxo__ixo_rlt_code = null, ?string $sxo__ixo_title = null, ?string $sxo__ixo_start_date = null, ?string $sxo__ixo_end_date = null, ?string $sxo__ixo_ind_cst_key = null, ?string $sxo__ixo_org_cst_key = null, ?string $sxo__ixo_add_date = null, ?string $sxo__ixo_add_user = null, ?string $sxo__ixo_change_date = null, ?string $sxo__ixo_rlt_key = null, ?string $sxo__ixo_change_user = null, ?string $sxo__ixo_delete_flag = null, ?string $sxo__ixo_key_ext = null, ?string $sxo__ixo_cst_key_owner = null, ?string $sxo__ixo_entity_key = null, ?string $sxo__ixo_void_flag = null)
    {
        $this
            ->setSxo__ixo_key($sxo__ixo_key)
            ->setSxo__ixo_rlt_code($sxo__ixo_rlt_code)
            ->setSxo__ixo_title($sxo__ixo_title)
            ->setSxo__ixo_start_date($sxo__ixo_start_date)
            ->setSxo__ixo_end_date($sxo__ixo_end_date)
            ->setSxo__ixo_ind_cst_key($sxo__ixo_ind_cst_key)
            ->setSxo__ixo_org_cst_key($sxo__ixo_org_cst_key)
            ->setSxo__ixo_add_date($sxo__ixo_add_date)
            ->setSxo__ixo_add_user($sxo__ixo_add_user)
            ->setSxo__ixo_change_date($sxo__ixo_change_date)
            ->setSxo__ixo_rlt_key($sxo__ixo_rlt_key)
            ->setSxo__ixo_change_user($sxo__ixo_change_user)
            ->setSxo__ixo_delete_flag($sxo__ixo_delete_flag)
            ->setSxo__ixo_key_ext($sxo__ixo_key_ext)
            ->setSxo__ixo_cst_key_owner($sxo__ixo_cst_key_owner)
            ->setSxo__ixo_entity_key($sxo__ixo_entity_key)
            ->setSxo__ixo_void_flag($sxo__ixo_void_flag);
    }
    /**
     * Get sxo__ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_key(): ?string
    {
        return $this->sxo__ixo_key ?? null;
    }
    /**
     * Set sxo__ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_key(?string $sxo__ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_key) && !is_string($sxo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_key, true), gettype($sxo__ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_key, true)), __LINE__);
        }
        if (is_null($sxo__ixo_key) || (is_array($sxo__ixo_key) && empty($sxo__ixo_key))) {
            unset($this->sxo__ixo_key);
        } else {
            $this->sxo__ixo_key = $sxo__ixo_key;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_rlt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_rlt_code(): ?string
    {
        return $this->sxo__ixo_rlt_code ?? null;
    }
    /**
     * Set sxo__ixo_rlt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_rlt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_rlt_code(?string $sxo__ixo_rlt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_rlt_code) && !is_string($sxo__ixo_rlt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_rlt_code, true), gettype($sxo__ixo_rlt_code)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($sxo__ixo_rlt_code) && mb_strlen((string) $sxo__ixo_rlt_code) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $sxo__ixo_rlt_code)), __LINE__);
        }
        if (is_null($sxo__ixo_rlt_code) || (is_array($sxo__ixo_rlt_code) && empty($sxo__ixo_rlt_code))) {
            unset($this->sxo__ixo_rlt_code);
        } else {
            $this->sxo__ixo_rlt_code = $sxo__ixo_rlt_code;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_title(): ?string
    {
        return $this->sxo__ixo_title ?? null;
    }
    /**
     * Set sxo__ixo_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_title(?string $sxo__ixo_title = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_title) && !is_string($sxo__ixo_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_title, true), gettype($sxo__ixo_title)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($sxo__ixo_title) && mb_strlen((string) $sxo__ixo_title) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $sxo__ixo_title)), __LINE__);
        }
        if (is_null($sxo__ixo_title) || (is_array($sxo__ixo_title) && empty($sxo__ixo_title))) {
            unset($this->sxo__ixo_title);
        } else {
            $this->sxo__ixo_title = $sxo__ixo_title;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_start_date(): ?string
    {
        return $this->sxo__ixo_start_date ?? null;
    }
    /**
     * Set sxo__ixo_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_start_date(?string $sxo__ixo_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_start_date) && !is_string($sxo__ixo_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_start_date, true), gettype($sxo__ixo_start_date)), __LINE__);
        }
        if (is_null($sxo__ixo_start_date) || (is_array($sxo__ixo_start_date) && empty($sxo__ixo_start_date))) {
            unset($this->sxo__ixo_start_date);
        } else {
            $this->sxo__ixo_start_date = $sxo__ixo_start_date;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_end_date(): ?string
    {
        return $this->sxo__ixo_end_date ?? null;
    }
    /**
     * Set sxo__ixo_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_end_date(?string $sxo__ixo_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_end_date) && !is_string($sxo__ixo_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_end_date, true), gettype($sxo__ixo_end_date)), __LINE__);
        }
        if (is_null($sxo__ixo_end_date) || (is_array($sxo__ixo_end_date) && empty($sxo__ixo_end_date))) {
            unset($this->sxo__ixo_end_date);
        } else {
            $this->sxo__ixo_end_date = $sxo__ixo_end_date;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_ind_cst_key(): ?string
    {
        return $this->sxo__ixo_ind_cst_key ?? null;
    }
    /**
     * Set sxo__ixo_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_ind_cst_key(?string $sxo__ixo_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_ind_cst_key) && !is_string($sxo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_ind_cst_key, true), gettype($sxo__ixo_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_ind_cst_key, true)), __LINE__);
        }
        if (is_null($sxo__ixo_ind_cst_key) || (is_array($sxo__ixo_ind_cst_key) && empty($sxo__ixo_ind_cst_key))) {
            unset($this->sxo__ixo_ind_cst_key);
        } else {
            $this->sxo__ixo_ind_cst_key = $sxo__ixo_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_org_cst_key(): ?string
    {
        return $this->sxo__ixo_org_cst_key ?? null;
    }
    /**
     * Set sxo__ixo_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_org_cst_key(?string $sxo__ixo_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_org_cst_key) && !is_string($sxo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_org_cst_key, true), gettype($sxo__ixo_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_org_cst_key, true)), __LINE__);
        }
        if (is_null($sxo__ixo_org_cst_key) || (is_array($sxo__ixo_org_cst_key) && empty($sxo__ixo_org_cst_key))) {
            unset($this->sxo__ixo_org_cst_key);
        } else {
            $this->sxo__ixo_org_cst_key = $sxo__ixo_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_add_date(): ?string
    {
        return $this->sxo__ixo_add_date ?? null;
    }
    /**
     * Set sxo__ixo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_add_date(?string $sxo__ixo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_add_date) && !is_string($sxo__ixo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_add_date, true), gettype($sxo__ixo_add_date)), __LINE__);
        }
        if (is_null($sxo__ixo_add_date) || (is_array($sxo__ixo_add_date) && empty($sxo__ixo_add_date))) {
            unset($this->sxo__ixo_add_date);
        } else {
            $this->sxo__ixo_add_date = $sxo__ixo_add_date;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_add_user(): ?string
    {
        return $this->sxo__ixo_add_user ?? null;
    }
    /**
     * Set sxo__ixo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_add_user(?string $sxo__ixo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_add_user) && !is_string($sxo__ixo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_add_user, true), gettype($sxo__ixo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sxo__ixo_add_user) && mb_strlen((string) $sxo__ixo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sxo__ixo_add_user)), __LINE__);
        }
        if (is_null($sxo__ixo_add_user) || (is_array($sxo__ixo_add_user) && empty($sxo__ixo_add_user))) {
            unset($this->sxo__ixo_add_user);
        } else {
            $this->sxo__ixo_add_user = $sxo__ixo_add_user;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_change_date(): ?string
    {
        return $this->sxo__ixo_change_date ?? null;
    }
    /**
     * Set sxo__ixo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_change_date(?string $sxo__ixo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_change_date) && !is_string($sxo__ixo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_change_date, true), gettype($sxo__ixo_change_date)), __LINE__);
        }
        if (is_null($sxo__ixo_change_date) || (is_array($sxo__ixo_change_date) && empty($sxo__ixo_change_date))) {
            unset($this->sxo__ixo_change_date);
        } else {
            $this->sxo__ixo_change_date = $sxo__ixo_change_date;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_rlt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_rlt_key(): ?string
    {
        return $this->sxo__ixo_rlt_key ?? null;
    }
    /**
     * Set sxo__ixo_rlt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_rlt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_rlt_key(?string $sxo__ixo_rlt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_rlt_key) && !is_string($sxo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_rlt_key, true), gettype($sxo__ixo_rlt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_rlt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_rlt_key, true)), __LINE__);
        }
        if (is_null($sxo__ixo_rlt_key) || (is_array($sxo__ixo_rlt_key) && empty($sxo__ixo_rlt_key))) {
            unset($this->sxo__ixo_rlt_key);
        } else {
            $this->sxo__ixo_rlt_key = $sxo__ixo_rlt_key;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_change_user(): ?string
    {
        return $this->sxo__ixo_change_user ?? null;
    }
    /**
     * Set sxo__ixo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_change_user(?string $sxo__ixo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_change_user) && !is_string($sxo__ixo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_change_user, true), gettype($sxo__ixo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sxo__ixo_change_user) && mb_strlen((string) $sxo__ixo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sxo__ixo_change_user)), __LINE__);
        }
        if (is_null($sxo__ixo_change_user) || (is_array($sxo__ixo_change_user) && empty($sxo__ixo_change_user))) {
            unset($this->sxo__ixo_change_user);
        } else {
            $this->sxo__ixo_change_user = $sxo__ixo_change_user;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_delete_flag(): ?string
    {
        return $this->sxo__ixo_delete_flag ?? null;
    }
    /**
     * Set sxo__ixo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_delete_flag(?string $sxo__ixo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_delete_flag) && !is_string($sxo__ixo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_delete_flag, true), gettype($sxo__ixo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($sxo__ixo_delete_flag) && $sxo__ixo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($sxo__ixo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sxo__ixo_delete_flag) && $sxo__ixo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sxo__ixo_delete_flag, true)), __LINE__);
        }
        if (is_null($sxo__ixo_delete_flag) || (is_array($sxo__ixo_delete_flag) && empty($sxo__ixo_delete_flag))) {
            unset($this->sxo__ixo_delete_flag);
        } else {
            $this->sxo__ixo_delete_flag = $sxo__ixo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_key_ext(): ?string
    {
        return $this->sxo__ixo_key_ext ?? null;
    }
    /**
     * Set sxo__ixo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_key_ext(?string $sxo__ixo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_key_ext) && !is_string($sxo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_key_ext, true), gettype($sxo__ixo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_key_ext, true)), __LINE__);
        }
        if (is_null($sxo__ixo_key_ext) || (is_array($sxo__ixo_key_ext) && empty($sxo__ixo_key_ext))) {
            unset($this->sxo__ixo_key_ext);
        } else {
            $this->sxo__ixo_key_ext = $sxo__ixo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_cst_key_owner(): ?string
    {
        return $this->sxo__ixo_cst_key_owner ?? null;
    }
    /**
     * Set sxo__ixo_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_cst_key_owner(?string $sxo__ixo_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_cst_key_owner) && !is_string($sxo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_cst_key_owner, true), gettype($sxo__ixo_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_cst_key_owner, true)), __LINE__);
        }
        if (is_null($sxo__ixo_cst_key_owner) || (is_array($sxo__ixo_cst_key_owner) && empty($sxo__ixo_cst_key_owner))) {
            unset($this->sxo__ixo_cst_key_owner);
        } else {
            $this->sxo__ixo_cst_key_owner = $sxo__ixo_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_entity_key(): ?string
    {
        return $this->sxo__ixo_entity_key ?? null;
    }
    /**
     * Set sxo__ixo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_entity_key(?string $sxo__ixo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_entity_key) && !is_string($sxo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_entity_key, true), gettype($sxo__ixo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sxo__ixo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sxo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sxo__ixo_entity_key, true)), __LINE__);
        }
        if (is_null($sxo__ixo_entity_key) || (is_array($sxo__ixo_entity_key) && empty($sxo__ixo_entity_key))) {
            unset($this->sxo__ixo_entity_key);
        } else {
            $this->sxo__ixo_entity_key = $sxo__ixo_entity_key;
        }
        
        return $this;
    }
    /**
     * Get sxo__ixo_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSxo__ixo_void_flag(): ?string
    {
        return $this->sxo__ixo_void_flag ?? null;
    }
    /**
     * Set sxo__ixo_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sxo__ixo_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
     */
    public function setSxo__ixo_void_flag(?string $sxo__ixo_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($sxo__ixo_void_flag) && !is_string($sxo__ixo_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sxo__ixo_void_flag, true), gettype($sxo__ixo_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($sxo__ixo_void_flag) && $sxo__ixo_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($sxo__ixo_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sxo__ixo_void_flag) && $sxo__ixo_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sxo__ixo_void_flag, true)), __LINE__);
        }
        if (is_null($sxo__ixo_void_flag) || (is_array($sxo__ixo_void_flag) && empty($sxo__ixo_void_flag))) {
            unset($this->sxo__ixo_void_flag);
        } else {
            $this->sxo__ixo_void_flag = $sxo__ixo_void_flag;
        }
        
        return $this;
    }
}
