<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Payment_Info_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Payment_Info_DataObjectType extends AbstractStructBase
{
    /**
     * The pin_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_key = null;
    /**
     * The pin_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_cst_key = null;
    /**
     * The pin_apm_key
     * Meta information extracted from the WSDL
     * - documentation: Payment Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_apm_key = null;
    /**
     * The pin_cc_number
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_number = null;
    /**
     * The pin_cc_number_display
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Display. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_number_display = null;
    /**
     * The pin_cc_expire
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Expiration Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_expire = null;
    /**
     * The pin_cc_cardholder_name
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Holder&apos;s Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_cardholder_name = null;
    /**
     * The pin_cc_auth
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Authorization Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_auth = null;
    /**
     * The pin_check_number
     * Meta information extracted from the WSDL
     * - documentation: Check Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_check_number = null;
    /**
     * The pin_eft_routing_number
     * Meta information extracted from the WSDL
     * - documentation: Routing Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_eft_routing_number = null;
    /**
     * The pin_eft_account_number
     * Meta information extracted from the WSDL
     * - documentation: Account Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_eft_account_number = null;
    /**
     * The pin_other_ref_number
     * Meta information extracted from the WSDL
     * - documentation: Gateway Reference Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_other_ref_number = null;
    /**
     * The pin_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_add_user = null;
    /**
     * The pin_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_add_date = null;
    /**
     * The pin_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_change_user = null;
    /**
     * The pin_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_change_date = null;
    /**
     * The pin_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_delete_flag = null;
    /**
     * The pin_check_amount
     * Meta information extracted from the WSDL
     * - documentation: Payment Amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pin_check_amount = null;
    /**
     * The pin_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_key_ext = null;
    /**
     * The pin_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_entity_key = null;
    /**
     * The pin_merchant_option
     * Meta information extracted from the WSDL
     * - documentation: Merchant Configuration Option. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_merchant_option = null;
    /**
     * The pin_enc_version
     * Meta information extracted from the WSDL
     * - documentation: Encryption Version. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pin_enc_version = null;
    /**
     * The pin_cc_preauth_flag
     * Meta information extracted from the WSDL
     * - documentation: Pre-Authorization Only?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_preauth_flag = null;
    /**
     * The pin_preauth_pin_key
     * Meta information extracted from the WSDL
     * - documentation: Pre-Authorization Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_preauth_pin_key = null;
    /**
     * The pin_street
     * Meta information extracted from the WSDL
     * - documentation: Credit Card/Check Street Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_street = null;
    /**
     * The pin_city
     * Meta information extracted from the WSDL
     * - documentation: Credit Card/Check City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_city = null;
    /**
     * The pin_state
     * Meta information extracted from the WSDL
     * - documentation: Credit Card/Check State. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_state = null;
    /**
     * The pin_zip
     * Meta information extracted from the WSDL
     * - documentation: Credit Card/Check Zip Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_zip = null;
    /**
     * The pin_email
     * Meta information extracted from the WSDL
     * - documentation: Credit Card/Check Email Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_email = null;
    /**
     * The pin_DL
     * Meta information extracted from the WSDL
     * - documentation: Check Drivers License Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_DL = null;
    /**
     * The pin_name_on_check
     * Meta information extracted from the WSDL
     * - documentation: Name on Check. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_name_on_check = null;
    /**
     * The pin_eft_account_type
     * Meta information extracted from the WSDL
     * - documentation: Bank Account Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_eft_account_type = null;
    /**
     * The pin_eft_account_number_display
     * Meta information extracted from the WSDL
     * - documentation: Account Number Display. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_eft_account_number_display = null;
    /**
     * The pin_other_preauth_ref_number
     * Meta information extracted from the WSDL
     * - documentation: Authorization Reference Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_other_preauth_ref_number = null;
    /**
     * The pin_cty_iso_number
     * Meta information extracted from the WSDL
     * - documentation: Country (ISO Number). | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cty_iso_number = null;
    /**
     * The pin_SS
     * Meta information extracted from the WSDL
     * - documentation: Check Social Security Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_SS = null;
    /**
     * The pin_vault_account
     * Meta information extracted from the WSDL
     * - documentation: Vault Payment Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_vault_account = null;
    /**
     * The pin_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_cpi_key = null;
    /**
     * The pin_description
     * Meta information extracted from the WSDL
     * - documentation: Payment Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_description = null;
    /**
     * The pin_cc_error
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Error. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_error = null;
    /**
     * The pin_hosted_page_available
     * Meta information extracted from the WSDL
     * - documentation: Hosted Page Available?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_hosted_page_available = null;
    /**
     * The pin_mobile_app_available
     * Meta information extracted from the WSDL
     * - documentation: Mobile Payment App Available?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_mobile_app_available = null;
    /**
     * The pin_ghl_key
     * Meta information extracted from the WSDL
     * - documentation: Gateway Hosted Page Log Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pin_ghl_key = null;
    /**
     * The pin_hosted_payment
     * Meta information extracted from the WSDL
     * - documentation: Payment is via Gateway Hosted/Mobile.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_hosted_payment = null;
    /**
     * The pin_mobile_payment_available
     * Meta information extracted from the WSDL
     * - documentation: Mobile Payment System Available?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_mobile_payment_available = null;
    /**
     * The pin_isvault
     * Meta information extracted from the WSDL
     * - documentation: Is Vault?.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_isvault = null;
    /**
     * The pin_record_payment_only
     * Meta information extracted from the WSDL
     * - documentation: Record Payment Only?.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_record_payment_only = null;
    /**
     * The pin_tax_amt
     * Meta information extracted from the WSDL
     * - documentation: Tax Amount.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined
     * simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pin_tax_amt = null;
    /**
     * The pin_billing_info_required_for_ach_flag
     * Meta information extracted from the WSDL
     * - documentation: Is Billing Information Required for ACH?.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. |
     * Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_billing_info_required_for_ach_flag = null;
    /**
     * The pin_cc_security_code
     * Meta information extracted from the WSDL
     * - documentation: CVV number.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_cc_security_code = null;
    /**
     * The pin_allow_online_payment_flag
     * Meta information extracted from the WSDL
     * - documentation: Save for future payments?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_allow_online_payment_flag = null;
    /**
     * The pin_preferred_flag
     * Meta information extracted from the WSDL
     * - documentation: Preferred payment?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pin_preferred_flag = null;
    /**
     * Constructor method for AccreditationArea_Payment_Info_DataObjectType
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cst_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_apm_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_number_display()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_expire()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_cardholder_name()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_auth()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_check_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_eft_routing_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_eft_account_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_other_ref_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_add_user()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_add_date()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_change_user()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_change_date()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_delete_flag()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_check_amount()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_key_ext()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_entity_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_merchant_option()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_enc_version()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_preauth_flag()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_preauth_pin_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_street()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_city()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_state()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_zip()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_email()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_DL()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_name_on_check()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_eft_account_type()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_eft_account_number_display()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_other_preauth_ref_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cty_iso_number()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_SS()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_vault_account()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cpi_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_description()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_error()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_hosted_page_available()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_mobile_app_available()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_ghl_key()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_hosted_payment()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_mobile_payment_available()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_isvault()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_record_payment_only()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_tax_amt()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_billing_info_required_for_ach_flag()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_cc_security_code()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_allow_online_payment_flag()
     * @uses AccreditationArea_Payment_Info_DataObjectType::setPin_preferred_flag()
     * @param string $pin_key
     * @param string $pin_cst_key
     * @param string $pin_apm_key
     * @param string $pin_cc_number
     * @param string $pin_cc_number_display
     * @param string $pin_cc_expire
     * @param string $pin_cc_cardholder_name
     * @param string $pin_cc_auth
     * @param string $pin_check_number
     * @param string $pin_eft_routing_number
     * @param string $pin_eft_account_number
     * @param string $pin_other_ref_number
     * @param string $pin_add_user
     * @param string $pin_add_date
     * @param string $pin_change_user
     * @param string $pin_change_date
     * @param string $pin_delete_flag
     * @param float $pin_check_amount
     * @param string $pin_key_ext
     * @param string $pin_entity_key
     * @param string $pin_merchant_option
     * @param int $pin_enc_version
     * @param string $pin_cc_preauth_flag
     * @param string $pin_preauth_pin_key
     * @param string $pin_street
     * @param string $pin_city
     * @param string $pin_state
     * @param string $pin_zip
     * @param string $pin_email
     * @param string $pin_DL
     * @param string $pin_name_on_check
     * @param string $pin_eft_account_type
     * @param string $pin_eft_account_number_display
     * @param string $pin_other_preauth_ref_number
     * @param string $pin_cty_iso_number
     * @param string $pin_SS
     * @param string $pin_vault_account
     * @param string $pin_cpi_key
     * @param string $pin_description
     * @param string $pin_cc_error
     * @param string $pin_hosted_page_available
     * @param string $pin_mobile_app_available
     * @param string $pin_ghl_key
     * @param string $pin_hosted_payment
     * @param string $pin_mobile_payment_available
     * @param string $pin_isvault
     * @param string $pin_record_payment_only
     * @param float $pin_tax_amt
     * @param string $pin_billing_info_required_for_ach_flag
     * @param string $pin_cc_security_code
     * @param string $pin_allow_online_payment_flag
     * @param string $pin_preferred_flag
     */
    public function __construct(?string $pin_key = null, ?string $pin_cst_key = null, ?string $pin_apm_key = null, ?string $pin_cc_number = null, ?string $pin_cc_number_display = null, ?string $pin_cc_expire = null, ?string $pin_cc_cardholder_name = null, ?string $pin_cc_auth = null, ?string $pin_check_number = null, ?string $pin_eft_routing_number = null, ?string $pin_eft_account_number = null, ?string $pin_other_ref_number = null, ?string $pin_add_user = null, ?string $pin_add_date = null, ?string $pin_change_user = null, ?string $pin_change_date = null, ?string $pin_delete_flag = null, ?float $pin_check_amount = null, ?string $pin_key_ext = null, ?string $pin_entity_key = null, ?string $pin_merchant_option = null, ?int $pin_enc_version = null, ?string $pin_cc_preauth_flag = null, ?string $pin_preauth_pin_key = null, ?string $pin_street = null, ?string $pin_city = null, ?string $pin_state = null, ?string $pin_zip = null, ?string $pin_email = null, ?string $pin_DL = null, ?string $pin_name_on_check = null, ?string $pin_eft_account_type = null, ?string $pin_eft_account_number_display = null, ?string $pin_other_preauth_ref_number = null, ?string $pin_cty_iso_number = null, ?string $pin_SS = null, ?string $pin_vault_account = null, ?string $pin_cpi_key = null, ?string $pin_description = null, ?string $pin_cc_error = null, ?string $pin_hosted_page_available = null, ?string $pin_mobile_app_available = null, ?string $pin_ghl_key = null, ?string $pin_hosted_payment = null, ?string $pin_mobile_payment_available = null, ?string $pin_isvault = null, ?string $pin_record_payment_only = null, ?float $pin_tax_amt = null, ?string $pin_billing_info_required_for_ach_flag = null, ?string $pin_cc_security_code = null, ?string $pin_allow_online_payment_flag = null, ?string $pin_preferred_flag = null)
    {
        $this
            ->setPin_key($pin_key)
            ->setPin_cst_key($pin_cst_key)
            ->setPin_apm_key($pin_apm_key)
            ->setPin_cc_number($pin_cc_number)
            ->setPin_cc_number_display($pin_cc_number_display)
            ->setPin_cc_expire($pin_cc_expire)
            ->setPin_cc_cardholder_name($pin_cc_cardholder_name)
            ->setPin_cc_auth($pin_cc_auth)
            ->setPin_check_number($pin_check_number)
            ->setPin_eft_routing_number($pin_eft_routing_number)
            ->setPin_eft_account_number($pin_eft_account_number)
            ->setPin_other_ref_number($pin_other_ref_number)
            ->setPin_add_user($pin_add_user)
            ->setPin_add_date($pin_add_date)
            ->setPin_change_user($pin_change_user)
            ->setPin_change_date($pin_change_date)
            ->setPin_delete_flag($pin_delete_flag)
            ->setPin_check_amount($pin_check_amount)
            ->setPin_key_ext($pin_key_ext)
            ->setPin_entity_key($pin_entity_key)
            ->setPin_merchant_option($pin_merchant_option)
            ->setPin_enc_version($pin_enc_version)
            ->setPin_cc_preauth_flag($pin_cc_preauth_flag)
            ->setPin_preauth_pin_key($pin_preauth_pin_key)
            ->setPin_street($pin_street)
            ->setPin_city($pin_city)
            ->setPin_state($pin_state)
            ->setPin_zip($pin_zip)
            ->setPin_email($pin_email)
            ->setPin_DL($pin_DL)
            ->setPin_name_on_check($pin_name_on_check)
            ->setPin_eft_account_type($pin_eft_account_type)
            ->setPin_eft_account_number_display($pin_eft_account_number_display)
            ->setPin_other_preauth_ref_number($pin_other_preauth_ref_number)
            ->setPin_cty_iso_number($pin_cty_iso_number)
            ->setPin_SS($pin_SS)
            ->setPin_vault_account($pin_vault_account)
            ->setPin_cpi_key($pin_cpi_key)
            ->setPin_description($pin_description)
            ->setPin_cc_error($pin_cc_error)
            ->setPin_hosted_page_available($pin_hosted_page_available)
            ->setPin_mobile_app_available($pin_mobile_app_available)
            ->setPin_ghl_key($pin_ghl_key)
            ->setPin_hosted_payment($pin_hosted_payment)
            ->setPin_mobile_payment_available($pin_mobile_payment_available)
            ->setPin_isvault($pin_isvault)
            ->setPin_record_payment_only($pin_record_payment_only)
            ->setPin_tax_amt($pin_tax_amt)
            ->setPin_billing_info_required_for_ach_flag($pin_billing_info_required_for_ach_flag)
            ->setPin_cc_security_code($pin_cc_security_code)
            ->setPin_allow_online_payment_flag($pin_allow_online_payment_flag)
            ->setPin_preferred_flag($pin_preferred_flag);
    }
    /**
     * Get pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_key(): ?string
    {
        return $this->pin_key ?? null;
    }
    /**
     * Set pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_key(?string $pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_key) && !is_string($pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_key, true), gettype($pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_key, true)), __LINE__);
        }
        if (is_null($pin_key) || (is_array($pin_key) && empty($pin_key))) {
            unset($this->pin_key);
        } else {
            $this->pin_key = $pin_key;
        }
        
        return $this;
    }
    /**
     * Get pin_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cst_key(): ?string
    {
        return $this->pin_cst_key ?? null;
    }
    /**
     * Set pin_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cst_key(?string $pin_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cst_key) && !is_string($pin_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cst_key, true), gettype($pin_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_cst_key, true)), __LINE__);
        }
        if (is_null($pin_cst_key) || (is_array($pin_cst_key) && empty($pin_cst_key))) {
            unset($this->pin_cst_key);
        } else {
            $this->pin_cst_key = $pin_cst_key;
        }
        
        return $this;
    }
    /**
     * Get pin_apm_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_apm_key(): ?string
    {
        return $this->pin_apm_key ?? null;
    }
    /**
     * Set pin_apm_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_apm_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_apm_key(?string $pin_apm_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_apm_key) && !is_string($pin_apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_apm_key, true), gettype($pin_apm_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_apm_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_apm_key, true)), __LINE__);
        }
        if (is_null($pin_apm_key) || (is_array($pin_apm_key) && empty($pin_apm_key))) {
            unset($this->pin_apm_key);
        } else {
            $this->pin_apm_key = $pin_apm_key;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_number(): ?string
    {
        return $this->pin_cc_number ?? null;
    }
    /**
     * Set pin_cc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_number(?string $pin_cc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_number) && !is_string($pin_cc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_number, true), gettype($pin_cc_number)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($pin_cc_number) && mb_strlen((string) $pin_cc_number) > 2048) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen((string) $pin_cc_number)), __LINE__);
        }
        if (is_null($pin_cc_number) || (is_array($pin_cc_number) && empty($pin_cc_number))) {
            unset($this->pin_cc_number);
        } else {
            $this->pin_cc_number = $pin_cc_number;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_number_display(): ?string
    {
        return $this->pin_cc_number_display ?? null;
    }
    /**
     * Set pin_cc_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_number_display(?string $pin_cc_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_number_display) && !is_string($pin_cc_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_number_display, true), gettype($pin_cc_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pin_cc_number_display) && mb_strlen((string) $pin_cc_number_display) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pin_cc_number_display)), __LINE__);
        }
        if (is_null($pin_cc_number_display) || (is_array($pin_cc_number_display) && empty($pin_cc_number_display))) {
            unset($this->pin_cc_number_display);
        } else {
            $this->pin_cc_number_display = $pin_cc_number_display;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_expire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_expire(): ?string
    {
        return $this->pin_cc_expire ?? null;
    }
    /**
     * Set pin_cc_expire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_expire
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_expire(?string $pin_cc_expire = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_expire) && !is_string($pin_cc_expire)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_expire, true), gettype($pin_cc_expire)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($pin_cc_expire) && mb_strlen((string) $pin_cc_expire) > 7) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen((string) $pin_cc_expire)), __LINE__);
        }
        if (is_null($pin_cc_expire) || (is_array($pin_cc_expire) && empty($pin_cc_expire))) {
            unset($this->pin_cc_expire);
        } else {
            $this->pin_cc_expire = $pin_cc_expire;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_cardholder_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_cardholder_name(): ?string
    {
        return $this->pin_cc_cardholder_name ?? null;
    }
    /**
     * Set pin_cc_cardholder_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_cardholder_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_cardholder_name(?string $pin_cc_cardholder_name = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_cardholder_name) && !is_string($pin_cc_cardholder_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_cardholder_name, true), gettype($pin_cc_cardholder_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($pin_cc_cardholder_name) && mb_strlen((string) $pin_cc_cardholder_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $pin_cc_cardholder_name)), __LINE__);
        }
        if (is_null($pin_cc_cardholder_name) || (is_array($pin_cc_cardholder_name) && empty($pin_cc_cardholder_name))) {
            unset($this->pin_cc_cardholder_name);
        } else {
            $this->pin_cc_cardholder_name = $pin_cc_cardholder_name;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_auth(): ?string
    {
        return $this->pin_cc_auth ?? null;
    }
    /**
     * Set pin_cc_auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_auth
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_auth(?string $pin_cc_auth = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_auth) && !is_string($pin_cc_auth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_auth, true), gettype($pin_cc_auth)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_cc_auth) && mb_strlen((string) $pin_cc_auth) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_cc_auth)), __LINE__);
        }
        if (is_null($pin_cc_auth) || (is_array($pin_cc_auth) && empty($pin_cc_auth))) {
            unset($this->pin_cc_auth);
        } else {
            $this->pin_cc_auth = $pin_cc_auth;
        }
        
        return $this;
    }
    /**
     * Get pin_check_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_check_number(): ?string
    {
        return $this->pin_check_number ?? null;
    }
    /**
     * Set pin_check_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_check_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_check_number(?string $pin_check_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_check_number) && !is_string($pin_check_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_check_number, true), gettype($pin_check_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pin_check_number) && mb_strlen((string) $pin_check_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pin_check_number)), __LINE__);
        }
        if (is_null($pin_check_number) || (is_array($pin_check_number) && empty($pin_check_number))) {
            unset($this->pin_check_number);
        } else {
            $this->pin_check_number = $pin_check_number;
        }
        
        return $this;
    }
    /**
     * Get pin_eft_routing_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_eft_routing_number(): ?string
    {
        return $this->pin_eft_routing_number ?? null;
    }
    /**
     * Set pin_eft_routing_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_eft_routing_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_eft_routing_number(?string $pin_eft_routing_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_eft_routing_number) && !is_string($pin_eft_routing_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_eft_routing_number, true), gettype($pin_eft_routing_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pin_eft_routing_number) && mb_strlen((string) $pin_eft_routing_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pin_eft_routing_number)), __LINE__);
        }
        if (is_null($pin_eft_routing_number) || (is_array($pin_eft_routing_number) && empty($pin_eft_routing_number))) {
            unset($this->pin_eft_routing_number);
        } else {
            $this->pin_eft_routing_number = $pin_eft_routing_number;
        }
        
        return $this;
    }
    /**
     * Get pin_eft_account_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_eft_account_number(): ?string
    {
        return $this->pin_eft_account_number ?? null;
    }
    /**
     * Set pin_eft_account_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_eft_account_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_eft_account_number(?string $pin_eft_account_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_eft_account_number) && !is_string($pin_eft_account_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_eft_account_number, true), gettype($pin_eft_account_number)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($pin_eft_account_number) && mb_strlen((string) $pin_eft_account_number) > 2048) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen((string) $pin_eft_account_number)), __LINE__);
        }
        if (is_null($pin_eft_account_number) || (is_array($pin_eft_account_number) && empty($pin_eft_account_number))) {
            unset($this->pin_eft_account_number);
        } else {
            $this->pin_eft_account_number = $pin_eft_account_number;
        }
        
        return $this;
    }
    /**
     * Get pin_other_ref_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_other_ref_number(): ?string
    {
        return $this->pin_other_ref_number ?? null;
    }
    /**
     * Set pin_other_ref_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_other_ref_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_other_ref_number(?string $pin_other_ref_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_other_ref_number) && !is_string($pin_other_ref_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_other_ref_number, true), gettype($pin_other_ref_number)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_other_ref_number) && mb_strlen((string) $pin_other_ref_number) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_other_ref_number)), __LINE__);
        }
        if (is_null($pin_other_ref_number) || (is_array($pin_other_ref_number) && empty($pin_other_ref_number))) {
            unset($this->pin_other_ref_number);
        } else {
            $this->pin_other_ref_number = $pin_other_ref_number;
        }
        
        return $this;
    }
    /**
     * Get pin_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_add_user(): ?string
    {
        return $this->pin_add_user ?? null;
    }
    /**
     * Set pin_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_add_user(?string $pin_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_add_user) && !is_string($pin_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_add_user, true), gettype($pin_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pin_add_user) && mb_strlen((string) $pin_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pin_add_user)), __LINE__);
        }
        if (is_null($pin_add_user) || (is_array($pin_add_user) && empty($pin_add_user))) {
            unset($this->pin_add_user);
        } else {
            $this->pin_add_user = $pin_add_user;
        }
        
        return $this;
    }
    /**
     * Get pin_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_add_date(): ?string
    {
        return $this->pin_add_date ?? null;
    }
    /**
     * Set pin_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_add_date(?string $pin_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_add_date) && !is_string($pin_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_add_date, true), gettype($pin_add_date)), __LINE__);
        }
        if (is_null($pin_add_date) || (is_array($pin_add_date) && empty($pin_add_date))) {
            unset($this->pin_add_date);
        } else {
            $this->pin_add_date = $pin_add_date;
        }
        
        return $this;
    }
    /**
     * Get pin_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_change_user(): ?string
    {
        return $this->pin_change_user ?? null;
    }
    /**
     * Set pin_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_change_user(?string $pin_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_change_user) && !is_string($pin_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_change_user, true), gettype($pin_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pin_change_user) && mb_strlen((string) $pin_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pin_change_user)), __LINE__);
        }
        if (is_null($pin_change_user) || (is_array($pin_change_user) && empty($pin_change_user))) {
            unset($this->pin_change_user);
        } else {
            $this->pin_change_user = $pin_change_user;
        }
        
        return $this;
    }
    /**
     * Get pin_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_change_date(): ?string
    {
        return $this->pin_change_date ?? null;
    }
    /**
     * Set pin_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_change_date(?string $pin_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_change_date) && !is_string($pin_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_change_date, true), gettype($pin_change_date)), __LINE__);
        }
        if (is_null($pin_change_date) || (is_array($pin_change_date) && empty($pin_change_date))) {
            unset($this->pin_change_date);
        } else {
            $this->pin_change_date = $pin_change_date;
        }
        
        return $this;
    }
    /**
     * Get pin_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_delete_flag(): ?string
    {
        return $this->pin_delete_flag ?? null;
    }
    /**
     * Set pin_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_delete_flag(?string $pin_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_delete_flag) && !is_string($pin_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_delete_flag, true), gettype($pin_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_delete_flag) && $pin_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_delete_flag) && $pin_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_delete_flag, true)), __LINE__);
        }
        if (is_null($pin_delete_flag) || (is_array($pin_delete_flag) && empty($pin_delete_flag))) {
            unset($this->pin_delete_flag);
        } else {
            $this->pin_delete_flag = $pin_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pin_check_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPin_check_amount(): ?float
    {
        return $this->pin_check_amount ?? null;
    }
    /**
     * Set pin_check_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pin_check_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_check_amount(?float $pin_check_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($pin_check_amount) && !(is_float($pin_check_amount) || is_numeric($pin_check_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pin_check_amount, true), gettype($pin_check_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pin_check_amount) && mb_strlen(mb_substr((string) $pin_check_amount, false !== mb_strpos((string) $pin_check_amount, '.') ? mb_strpos((string) $pin_check_amount, '.') + 1 : mb_strlen((string) $pin_check_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pin_check_amount, true), mb_strlen(mb_substr((string) $pin_check_amount, mb_strpos((string) $pin_check_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pin_check_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $pin_check_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pin_check_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pin_check_amount))), __LINE__);
        }
        if (is_null($pin_check_amount) || (is_array($pin_check_amount) && empty($pin_check_amount))) {
            unset($this->pin_check_amount);
        } else {
            $this->pin_check_amount = $pin_check_amount;
        }
        
        return $this;
    }
    /**
     * Get pin_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_key_ext(): ?string
    {
        return $this->pin_key_ext ?? null;
    }
    /**
     * Set pin_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_key_ext(?string $pin_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_key_ext) && !is_string($pin_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_key_ext, true), gettype($pin_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_key_ext, true)), __LINE__);
        }
        if (is_null($pin_key_ext) || (is_array($pin_key_ext) && empty($pin_key_ext))) {
            unset($this->pin_key_ext);
        } else {
            $this->pin_key_ext = $pin_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pin_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_entity_key(): ?string
    {
        return $this->pin_entity_key ?? null;
    }
    /**
     * Set pin_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_entity_key(?string $pin_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_entity_key) && !is_string($pin_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_entity_key, true), gettype($pin_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_entity_key, true)), __LINE__);
        }
        if (is_null($pin_entity_key) || (is_array($pin_entity_key) && empty($pin_entity_key))) {
            unset($this->pin_entity_key);
        } else {
            $this->pin_entity_key = $pin_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pin_merchant_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_merchant_option(): ?string
    {
        return $this->pin_merchant_option ?? null;
    }
    /**
     * Set pin_merchant_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_merchant_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_merchant_option(?string $pin_merchant_option = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_merchant_option) && !is_string($pin_merchant_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_merchant_option, true), gettype($pin_merchant_option)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($pin_merchant_option) && mb_strlen((string) $pin_merchant_option) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $pin_merchant_option)), __LINE__);
        }
        if (is_null($pin_merchant_option) || (is_array($pin_merchant_option) && empty($pin_merchant_option))) {
            unset($this->pin_merchant_option);
        } else {
            $this->pin_merchant_option = $pin_merchant_option;
        }
        
        return $this;
    }
    /**
     * Get pin_enc_version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPin_enc_version(): ?int
    {
        return $this->pin_enc_version ?? null;
    }
    /**
     * Set pin_enc_version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pin_enc_version
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_enc_version(?int $pin_enc_version = null): self
    {
        // validation for constraint: int
        if (!is_null($pin_enc_version) && !(is_int($pin_enc_version) || ctype_digit($pin_enc_version))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pin_enc_version, true), gettype($pin_enc_version)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pin_enc_version) && $pin_enc_version > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pin_enc_version, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pin_enc_version) && $pin_enc_version < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pin_enc_version, true)), __LINE__);
        }
        if (is_null($pin_enc_version) || (is_array($pin_enc_version) && empty($pin_enc_version))) {
            unset($this->pin_enc_version);
        } else {
            $this->pin_enc_version = $pin_enc_version;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_preauth_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_preauth_flag(): ?string
    {
        return $this->pin_cc_preauth_flag ?? null;
    }
    /**
     * Set pin_cc_preauth_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_preauth_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_preauth_flag(?string $pin_cc_preauth_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_preauth_flag) && !is_string($pin_cc_preauth_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_preauth_flag, true), gettype($pin_cc_preauth_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_cc_preauth_flag) && $pin_cc_preauth_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_cc_preauth_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_cc_preauth_flag) && $pin_cc_preauth_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_cc_preauth_flag, true)), __LINE__);
        }
        if (is_null($pin_cc_preauth_flag) || (is_array($pin_cc_preauth_flag) && empty($pin_cc_preauth_flag))) {
            unset($this->pin_cc_preauth_flag);
        } else {
            $this->pin_cc_preauth_flag = $pin_cc_preauth_flag;
        }
        
        return $this;
    }
    /**
     * Get pin_preauth_pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_preauth_pin_key(): ?string
    {
        return $this->pin_preauth_pin_key ?? null;
    }
    /**
     * Set pin_preauth_pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_preauth_pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_preauth_pin_key(?string $pin_preauth_pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_preauth_pin_key) && !is_string($pin_preauth_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_preauth_pin_key, true), gettype($pin_preauth_pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_preauth_pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_preauth_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_preauth_pin_key, true)), __LINE__);
        }
        if (is_null($pin_preauth_pin_key) || (is_array($pin_preauth_pin_key) && empty($pin_preauth_pin_key))) {
            unset($this->pin_preauth_pin_key);
        } else {
            $this->pin_preauth_pin_key = $pin_preauth_pin_key;
        }
        
        return $this;
    }
    /**
     * Get pin_street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_street(): ?string
    {
        return $this->pin_street ?? null;
    }
    /**
     * Set pin_street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_street
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_street(?string $pin_street = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_street) && !is_string($pin_street)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_street, true), gettype($pin_street)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pin_street) && mb_strlen((string) $pin_street) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pin_street)), __LINE__);
        }
        if (is_null($pin_street) || (is_array($pin_street) && empty($pin_street))) {
            unset($this->pin_street);
        } else {
            $this->pin_street = $pin_street;
        }
        
        return $this;
    }
    /**
     * Get pin_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_city(): ?string
    {
        return $this->pin_city ?? null;
    }
    /**
     * Set pin_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_city(?string $pin_city = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_city) && !is_string($pin_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_city, true), gettype($pin_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_city) && mb_strlen((string) $pin_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_city)), __LINE__);
        }
        if (is_null($pin_city) || (is_array($pin_city) && empty($pin_city))) {
            unset($this->pin_city);
        } else {
            $this->pin_city = $pin_city;
        }
        
        return $this;
    }
    /**
     * Get pin_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_state(): ?string
    {
        return $this->pin_state ?? null;
    }
    /**
     * Set pin_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_state(?string $pin_state = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_state) && !is_string($pin_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_state, true), gettype($pin_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_state) && mb_strlen((string) $pin_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_state)), __LINE__);
        }
        if (is_null($pin_state) || (is_array($pin_state) && empty($pin_state))) {
            unset($this->pin_state);
        } else {
            $this->pin_state = $pin_state;
        }
        
        return $this;
    }
    /**
     * Get pin_zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_zip(): ?string
    {
        return $this->pin_zip ?? null;
    }
    /**
     * Set pin_zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_zip
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_zip(?string $pin_zip = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_zip) && !is_string($pin_zip)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_zip, true), gettype($pin_zip)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pin_zip) && mb_strlen((string) $pin_zip) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pin_zip)), __LINE__);
        }
        if (is_null($pin_zip) || (is_array($pin_zip) && empty($pin_zip))) {
            unset($this->pin_zip);
        } else {
            $this->pin_zip = $pin_zip;
        }
        
        return $this;
    }
    /**
     * Get pin_email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_email(): ?string
    {
        return $this->pin_email ?? null;
    }
    /**
     * Set pin_email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_email
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_email(?string $pin_email = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_email) && !is_string($pin_email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_email, true), gettype($pin_email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($pin_email) && mb_strlen((string) $pin_email) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $pin_email)), __LINE__);
        }
        if (is_null($pin_email) || (is_array($pin_email) && empty($pin_email))) {
            unset($this->pin_email);
        } else {
            $this->pin_email = $pin_email;
        }
        
        return $this;
    }
    /**
     * Get pin_DL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_DL(): ?string
    {
        return $this->pin_DL ?? null;
    }
    /**
     * Set pin_DL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_DL
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_DL(?string $pin_DL = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_DL) && !is_string($pin_DL)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_DL, true), gettype($pin_DL)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($pin_DL) && mb_strlen((string) $pin_DL) > 33) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen((string) $pin_DL)), __LINE__);
        }
        if (is_null($pin_DL) || (is_array($pin_DL) && empty($pin_DL))) {
            unset($this->pin_DL);
        } else {
            $this->pin_DL = $pin_DL;
        }
        
        return $this;
    }
    /**
     * Get pin_name_on_check value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_name_on_check(): ?string
    {
        return $this->pin_name_on_check ?? null;
    }
    /**
     * Set pin_name_on_check value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_name_on_check
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_name_on_check(?string $pin_name_on_check = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_name_on_check) && !is_string($pin_name_on_check)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_name_on_check, true), gettype($pin_name_on_check)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($pin_name_on_check) && mb_strlen((string) $pin_name_on_check) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $pin_name_on_check)), __LINE__);
        }
        if (is_null($pin_name_on_check) || (is_array($pin_name_on_check) && empty($pin_name_on_check))) {
            unset($this->pin_name_on_check);
        } else {
            $this->pin_name_on_check = $pin_name_on_check;
        }
        
        return $this;
    }
    /**
     * Get pin_eft_account_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_eft_account_type(): ?string
    {
        return $this->pin_eft_account_type ?? null;
    }
    /**
     * Set pin_eft_account_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_eft_account_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_eft_account_type(?string $pin_eft_account_type = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_eft_account_type) && !is_string($pin_eft_account_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_eft_account_type, true), gettype($pin_eft_account_type)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($pin_eft_account_type) && mb_strlen((string) $pin_eft_account_type) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $pin_eft_account_type)), __LINE__);
        }
        if (is_null($pin_eft_account_type) || (is_array($pin_eft_account_type) && empty($pin_eft_account_type))) {
            unset($this->pin_eft_account_type);
        } else {
            $this->pin_eft_account_type = $pin_eft_account_type;
        }
        
        return $this;
    }
    /**
     * Get pin_eft_account_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_eft_account_number_display(): ?string
    {
        return $this->pin_eft_account_number_display ?? null;
    }
    /**
     * Set pin_eft_account_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_eft_account_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_eft_account_number_display(?string $pin_eft_account_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_eft_account_number_display) && !is_string($pin_eft_account_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_eft_account_number_display, true), gettype($pin_eft_account_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pin_eft_account_number_display) && mb_strlen((string) $pin_eft_account_number_display) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pin_eft_account_number_display)), __LINE__);
        }
        if (is_null($pin_eft_account_number_display) || (is_array($pin_eft_account_number_display) && empty($pin_eft_account_number_display))) {
            unset($this->pin_eft_account_number_display);
        } else {
            $this->pin_eft_account_number_display = $pin_eft_account_number_display;
        }
        
        return $this;
    }
    /**
     * Get pin_other_preauth_ref_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_other_preauth_ref_number(): ?string
    {
        return $this->pin_other_preauth_ref_number ?? null;
    }
    /**
     * Set pin_other_preauth_ref_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_other_preauth_ref_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_other_preauth_ref_number(?string $pin_other_preauth_ref_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_other_preauth_ref_number) && !is_string($pin_other_preauth_ref_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_other_preauth_ref_number, true), gettype($pin_other_preauth_ref_number)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_other_preauth_ref_number) && mb_strlen((string) $pin_other_preauth_ref_number) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_other_preauth_ref_number)), __LINE__);
        }
        if (is_null($pin_other_preauth_ref_number) || (is_array($pin_other_preauth_ref_number) && empty($pin_other_preauth_ref_number))) {
            unset($this->pin_other_preauth_ref_number);
        } else {
            $this->pin_other_preauth_ref_number = $pin_other_preauth_ref_number;
        }
        
        return $this;
    }
    /**
     * Get pin_cty_iso_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cty_iso_number(): ?string
    {
        return $this->pin_cty_iso_number ?? null;
    }
    /**
     * Set pin_cty_iso_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cty_iso_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cty_iso_number(?string $pin_cty_iso_number = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cty_iso_number) && !is_string($pin_cty_iso_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cty_iso_number, true), gettype($pin_cty_iso_number)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($pin_cty_iso_number) && mb_strlen((string) $pin_cty_iso_number) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $pin_cty_iso_number)), __LINE__);
        }
        if (is_null($pin_cty_iso_number) || (is_array($pin_cty_iso_number) && empty($pin_cty_iso_number))) {
            unset($this->pin_cty_iso_number);
        } else {
            $this->pin_cty_iso_number = $pin_cty_iso_number;
        }
        
        return $this;
    }
    /**
     * Get pin_SS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_SS(): ?string
    {
        return $this->pin_SS ?? null;
    }
    /**
     * Set pin_SS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_SS
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_SS(?string $pin_SS = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_SS) && !is_string($pin_SS)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_SS, true), gettype($pin_SS)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($pin_SS) && mb_strlen((string) $pin_SS) > 35) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen((string) $pin_SS)), __LINE__);
        }
        if (is_null($pin_SS) || (is_array($pin_SS) && empty($pin_SS))) {
            unset($this->pin_SS);
        } else {
            $this->pin_SS = $pin_SS;
        }
        
        return $this;
    }
    /**
     * Get pin_vault_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_vault_account(): ?string
    {
        return $this->pin_vault_account ?? null;
    }
    /**
     * Set pin_vault_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_vault_account
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_vault_account(?string $pin_vault_account = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_vault_account) && !is_string($pin_vault_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_vault_account, true), gettype($pin_vault_account)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pin_vault_account) && mb_strlen((string) $pin_vault_account) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pin_vault_account)), __LINE__);
        }
        if (is_null($pin_vault_account) || (is_array($pin_vault_account) && empty($pin_vault_account))) {
            unset($this->pin_vault_account);
        } else {
            $this->pin_vault_account = $pin_vault_account;
        }
        
        return $this;
    }
    /**
     * Get pin_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cpi_key(): ?string
    {
        return $this->pin_cpi_key ?? null;
    }
    /**
     * Set pin_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cpi_key(?string $pin_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cpi_key) && !is_string($pin_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cpi_key, true), gettype($pin_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_cpi_key, true)), __LINE__);
        }
        if (is_null($pin_cpi_key) || (is_array($pin_cpi_key) && empty($pin_cpi_key))) {
            unset($this->pin_cpi_key);
        } else {
            $this->pin_cpi_key = $pin_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get pin_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_description(): ?string
    {
        return $this->pin_description ?? null;
    }
    /**
     * Set pin_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_description(?string $pin_description = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_description) && !is_string($pin_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_description, true), gettype($pin_description)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($pin_description) && mb_strlen((string) $pin_description) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $pin_description)), __LINE__);
        }
        if (is_null($pin_description) || (is_array($pin_description) && empty($pin_description))) {
            unset($this->pin_description);
        } else {
            $this->pin_description = $pin_description;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_error(): ?string
    {
        return $this->pin_cc_error ?? null;
    }
    /**
     * Set pin_cc_error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_error
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_error(?string $pin_cc_error = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_error) && !is_string($pin_cc_error)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_error, true), gettype($pin_cc_error)), __LINE__);
        }
        if (is_null($pin_cc_error) || (is_array($pin_cc_error) && empty($pin_cc_error))) {
            unset($this->pin_cc_error);
        } else {
            $this->pin_cc_error = $pin_cc_error;
        }
        
        return $this;
    }
    /**
     * Get pin_hosted_page_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_hosted_page_available(): ?string
    {
        return $this->pin_hosted_page_available ?? null;
    }
    /**
     * Set pin_hosted_page_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_hosted_page_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_hosted_page_available(?string $pin_hosted_page_available = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_hosted_page_available) && !is_string($pin_hosted_page_available)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_hosted_page_available, true), gettype($pin_hosted_page_available)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_hosted_page_available) && $pin_hosted_page_available > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_hosted_page_available, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_hosted_page_available) && $pin_hosted_page_available < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_hosted_page_available, true)), __LINE__);
        }
        if (is_null($pin_hosted_page_available) || (is_array($pin_hosted_page_available) && empty($pin_hosted_page_available))) {
            unset($this->pin_hosted_page_available);
        } else {
            $this->pin_hosted_page_available = $pin_hosted_page_available;
        }
        
        return $this;
    }
    /**
     * Get pin_mobile_app_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_mobile_app_available(): ?string
    {
        return $this->pin_mobile_app_available ?? null;
    }
    /**
     * Set pin_mobile_app_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_mobile_app_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_mobile_app_available(?string $pin_mobile_app_available = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_mobile_app_available) && !is_string($pin_mobile_app_available)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_mobile_app_available, true), gettype($pin_mobile_app_available)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_mobile_app_available) && $pin_mobile_app_available > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_mobile_app_available, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_mobile_app_available) && $pin_mobile_app_available < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_mobile_app_available, true)), __LINE__);
        }
        if (is_null($pin_mobile_app_available) || (is_array($pin_mobile_app_available) && empty($pin_mobile_app_available))) {
            unset($this->pin_mobile_app_available);
        } else {
            $this->pin_mobile_app_available = $pin_mobile_app_available;
        }
        
        return $this;
    }
    /**
     * Get pin_ghl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_ghl_key(): ?string
    {
        return $this->pin_ghl_key ?? null;
    }
    /**
     * Set pin_ghl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_ghl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_ghl_key(?string $pin_ghl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_ghl_key) && !is_string($pin_ghl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_ghl_key, true), gettype($pin_ghl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pin_ghl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pin_ghl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pin_ghl_key, true)), __LINE__);
        }
        if (is_null($pin_ghl_key) || (is_array($pin_ghl_key) && empty($pin_ghl_key))) {
            unset($this->pin_ghl_key);
        } else {
            $this->pin_ghl_key = $pin_ghl_key;
        }
        
        return $this;
    }
    /**
     * Get pin_hosted_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_hosted_payment(): ?string
    {
        return $this->pin_hosted_payment ?? null;
    }
    /**
     * Set pin_hosted_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_hosted_payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_hosted_payment(?string $pin_hosted_payment = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_hosted_payment) && !is_string($pin_hosted_payment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_hosted_payment, true), gettype($pin_hosted_payment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_hosted_payment) && $pin_hosted_payment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_hosted_payment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_hosted_payment) && $pin_hosted_payment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_hosted_payment, true)), __LINE__);
        }
        if (is_null($pin_hosted_payment) || (is_array($pin_hosted_payment) && empty($pin_hosted_payment))) {
            unset($this->pin_hosted_payment);
        } else {
            $this->pin_hosted_payment = $pin_hosted_payment;
        }
        
        return $this;
    }
    /**
     * Get pin_mobile_payment_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_mobile_payment_available(): ?string
    {
        return $this->pin_mobile_payment_available ?? null;
    }
    /**
     * Set pin_mobile_payment_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_mobile_payment_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_mobile_payment_available(?string $pin_mobile_payment_available = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_mobile_payment_available) && !is_string($pin_mobile_payment_available)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_mobile_payment_available, true), gettype($pin_mobile_payment_available)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_mobile_payment_available) && $pin_mobile_payment_available > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_mobile_payment_available, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_mobile_payment_available) && $pin_mobile_payment_available < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_mobile_payment_available, true)), __LINE__);
        }
        if (is_null($pin_mobile_payment_available) || (is_array($pin_mobile_payment_available) && empty($pin_mobile_payment_available))) {
            unset($this->pin_mobile_payment_available);
        } else {
            $this->pin_mobile_payment_available = $pin_mobile_payment_available;
        }
        
        return $this;
    }
    /**
     * Get pin_isvault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_isvault(): ?string
    {
        return $this->pin_isvault ?? null;
    }
    /**
     * Set pin_isvault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_isvault
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_isvault(?string $pin_isvault = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_isvault) && !is_string($pin_isvault)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_isvault, true), gettype($pin_isvault)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_isvault) && $pin_isvault > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_isvault, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_isvault) && $pin_isvault < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_isvault, true)), __LINE__);
        }
        if (is_null($pin_isvault) || (is_array($pin_isvault) && empty($pin_isvault))) {
            unset($this->pin_isvault);
        } else {
            $this->pin_isvault = $pin_isvault;
        }
        
        return $this;
    }
    /**
     * Get pin_record_payment_only value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_record_payment_only(): ?string
    {
        return $this->pin_record_payment_only ?? null;
    }
    /**
     * Set pin_record_payment_only value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_record_payment_only
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_record_payment_only(?string $pin_record_payment_only = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_record_payment_only) && !is_string($pin_record_payment_only)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_record_payment_only, true), gettype($pin_record_payment_only)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_record_payment_only) && $pin_record_payment_only > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_record_payment_only, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_record_payment_only) && $pin_record_payment_only < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_record_payment_only, true)), __LINE__);
        }
        if (is_null($pin_record_payment_only) || (is_array($pin_record_payment_only) && empty($pin_record_payment_only))) {
            unset($this->pin_record_payment_only);
        } else {
            $this->pin_record_payment_only = $pin_record_payment_only;
        }
        
        return $this;
    }
    /**
     * Get pin_tax_amt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPin_tax_amt(): ?float
    {
        return $this->pin_tax_amt ?? null;
    }
    /**
     * Set pin_tax_amt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pin_tax_amt
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_tax_amt(?float $pin_tax_amt = null): self
    {
        // validation for constraint: float
        if (!is_null($pin_tax_amt) && !(is_float($pin_tax_amt) || is_numeric($pin_tax_amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pin_tax_amt, true), gettype($pin_tax_amt)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pin_tax_amt) && mb_strlen(mb_substr((string) $pin_tax_amt, false !== mb_strpos((string) $pin_tax_amt, '.') ? mb_strpos((string) $pin_tax_amt, '.') + 1 : mb_strlen((string) $pin_tax_amt))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pin_tax_amt, true), mb_strlen(mb_substr((string) $pin_tax_amt, mb_strpos((string) $pin_tax_amt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pin_tax_amt) && mb_strlen(preg_replace('/(\D)/', '', (string) $pin_tax_amt)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pin_tax_amt, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pin_tax_amt))), __LINE__);
        }
        if (is_null($pin_tax_amt) || (is_array($pin_tax_amt) && empty($pin_tax_amt))) {
            unset($this->pin_tax_amt);
        } else {
            $this->pin_tax_amt = $pin_tax_amt;
        }
        
        return $this;
    }
    /**
     * Get pin_billing_info_required_for_ach_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_billing_info_required_for_ach_flag(): ?string
    {
        return $this->pin_billing_info_required_for_ach_flag ?? null;
    }
    /**
     * Set pin_billing_info_required_for_ach_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_billing_info_required_for_ach_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_billing_info_required_for_ach_flag(?string $pin_billing_info_required_for_ach_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_billing_info_required_for_ach_flag) && !is_string($pin_billing_info_required_for_ach_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_billing_info_required_for_ach_flag, true), gettype($pin_billing_info_required_for_ach_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_billing_info_required_for_ach_flag) && $pin_billing_info_required_for_ach_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_billing_info_required_for_ach_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_billing_info_required_for_ach_flag) && $pin_billing_info_required_for_ach_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_billing_info_required_for_ach_flag, true)), __LINE__);
        }
        if (is_null($pin_billing_info_required_for_ach_flag) || (is_array($pin_billing_info_required_for_ach_flag) && empty($pin_billing_info_required_for_ach_flag))) {
            unset($this->pin_billing_info_required_for_ach_flag);
        } else {
            $this->pin_billing_info_required_for_ach_flag = $pin_billing_info_required_for_ach_flag;
        }
        
        return $this;
    }
    /**
     * Get pin_cc_security_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_cc_security_code(): ?string
    {
        return $this->pin_cc_security_code ?? null;
    }
    /**
     * Set pin_cc_security_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_cc_security_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_cc_security_code(?string $pin_cc_security_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_cc_security_code) && !is_string($pin_cc_security_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_cc_security_code, true), gettype($pin_cc_security_code)), __LINE__);
        }
        if (is_null($pin_cc_security_code) || (is_array($pin_cc_security_code) && empty($pin_cc_security_code))) {
            unset($this->pin_cc_security_code);
        } else {
            $this->pin_cc_security_code = $pin_cc_security_code;
        }
        
        return $this;
    }
    /**
     * Get pin_allow_online_payment_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_allow_online_payment_flag(): ?string
    {
        return $this->pin_allow_online_payment_flag ?? null;
    }
    /**
     * Set pin_allow_online_payment_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_allow_online_payment_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_allow_online_payment_flag(?string $pin_allow_online_payment_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_allow_online_payment_flag) && !is_string($pin_allow_online_payment_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_allow_online_payment_flag, true), gettype($pin_allow_online_payment_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_allow_online_payment_flag) && $pin_allow_online_payment_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_allow_online_payment_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_allow_online_payment_flag) && $pin_allow_online_payment_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_allow_online_payment_flag, true)), __LINE__);
        }
        if (is_null($pin_allow_online_payment_flag) || (is_array($pin_allow_online_payment_flag) && empty($pin_allow_online_payment_flag))) {
            unset($this->pin_allow_online_payment_flag);
        } else {
            $this->pin_allow_online_payment_flag = $pin_allow_online_payment_flag;
        }
        
        return $this;
    }
    /**
     * Get pin_preferred_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin_preferred_flag(): ?string
    {
        return $this->pin_preferred_flag ?? null;
    }
    /**
     * Set pin_preferred_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin_preferred_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
     */
    public function setPin_preferred_flag(?string $pin_preferred_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pin_preferred_flag) && !is_string($pin_preferred_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin_preferred_flag, true), gettype($pin_preferred_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pin_preferred_flag) && $pin_preferred_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pin_preferred_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pin_preferred_flag) && $pin_preferred_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pin_preferred_flag, true)), __LINE__);
        }
        if (is_null($pin_preferred_flag) || (is_array($pin_preferred_flag) && empty($pin_preferred_flag))) {
            unset($this->pin_preferred_flag);
        } else {
            $this->pin_preferred_flag = $pin_preferred_flag;
        }
        
        return $this;
    }
}
