<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Payment_Method_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Payment_Method_DataObjectType extends AbstractStructBase
{
    /**
     * The apm_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_key = null;
    /**
     * The apm_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Business Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_atc_key = null;
    /**
     * The apm_type
     * Meta information extracted from the WSDL
     * - documentation: Payment Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_type = null;
    /**
     * The apm_method
     * Meta information extracted from the WSDL
     * - documentation: Payment Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_method = null;
    /**
     * The apm_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_add_user = null;
    /**
     * The apm_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_add_date = null;
    /**
     * The apm_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_change_date = null;
    /**
     * The apm_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_change_user = null;
    /**
     * The apm_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_delete_flag = null;
    /**
     * The apm_gla_key
     * Meta information extracted from the WSDL
     * - documentation: Cash Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_gla_key = null;
    /**
     * The apm_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_entity_key = null;
    /**
     * The apm_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_key_ext = null;
    /**
     * The apm_iweb_flag
     * Meta information extracted from the WSDL
     * - documentation: Available Internally. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_iweb_flag = null;
    /**
     * The apm_eweb_flag
     * Meta information extracted from the WSDL
     * - documentation: Available Externally. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_eweb_flag = null;
    /**
     * The apm_merchant_option
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Gateway. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_merchant_option = null;
    /**
     * The apm_batch_suffix
     * Meta information extracted from the WSDL
     * - documentation: Batch Suffix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_batch_suffix = null;
    /**
     * The apm_currency_code
     * Meta information extracted from the WSDL
     * - documentation: Currency Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_currency_code = null;
    /**
     * The apm_csc_flag
     * Meta information extracted from the WSDL
     * - documentation: Centralized Shopping Cart?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_csc_flag = null;
    /**
     * The apm_cc_format
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Format Regex. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_cc_format = null;
    /**
     * The apm_pma_key
     * Meta information extracted from the WSDL
     * - documentation: Merchant Account Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apm_pma_key = null;
    /**
     * The apm_gateway_is_frozen_flag
     * Meta information extracted from the WSDL
     * - documentation: Payment Method Is Frozen?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apm_gateway_is_frozen_flag = null;
    /**
     * Constructor method for AccreditationArea_Payment_Method_DataObjectType
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_key()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_atc_key()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_type()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_method()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_add_user()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_add_date()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_change_date()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_change_user()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_delete_flag()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_gla_key()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_entity_key()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_key_ext()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_iweb_flag()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_eweb_flag()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_merchant_option()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_batch_suffix()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_currency_code()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_csc_flag()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_cc_format()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_pma_key()
     * @uses AccreditationArea_Payment_Method_DataObjectType::setApm_gateway_is_frozen_flag()
     * @param string $apm_key
     * @param string $apm_atc_key
     * @param string $apm_type
     * @param string $apm_method
     * @param string $apm_add_user
     * @param string $apm_add_date
     * @param string $apm_change_date
     * @param string $apm_change_user
     * @param string $apm_delete_flag
     * @param string $apm_gla_key
     * @param string $apm_entity_key
     * @param string $apm_key_ext
     * @param string $apm_iweb_flag
     * @param string $apm_eweb_flag
     * @param string $apm_merchant_option
     * @param string $apm_batch_suffix
     * @param string $apm_currency_code
     * @param string $apm_csc_flag
     * @param string $apm_cc_format
     * @param string $apm_pma_key
     * @param string $apm_gateway_is_frozen_flag
     */
    public function __construct(?string $apm_key = null, ?string $apm_atc_key = null, ?string $apm_type = null, ?string $apm_method = null, ?string $apm_add_user = null, ?string $apm_add_date = null, ?string $apm_change_date = null, ?string $apm_change_user = null, ?string $apm_delete_flag = null, ?string $apm_gla_key = null, ?string $apm_entity_key = null, ?string $apm_key_ext = null, ?string $apm_iweb_flag = null, ?string $apm_eweb_flag = null, ?string $apm_merchant_option = null, ?string $apm_batch_suffix = null, ?string $apm_currency_code = null, ?string $apm_csc_flag = null, ?string $apm_cc_format = null, ?string $apm_pma_key = null, ?string $apm_gateway_is_frozen_flag = null)
    {
        $this
            ->setApm_key($apm_key)
            ->setApm_atc_key($apm_atc_key)
            ->setApm_type($apm_type)
            ->setApm_method($apm_method)
            ->setApm_add_user($apm_add_user)
            ->setApm_add_date($apm_add_date)
            ->setApm_change_date($apm_change_date)
            ->setApm_change_user($apm_change_user)
            ->setApm_delete_flag($apm_delete_flag)
            ->setApm_gla_key($apm_gla_key)
            ->setApm_entity_key($apm_entity_key)
            ->setApm_key_ext($apm_key_ext)
            ->setApm_iweb_flag($apm_iweb_flag)
            ->setApm_eweb_flag($apm_eweb_flag)
            ->setApm_merchant_option($apm_merchant_option)
            ->setApm_batch_suffix($apm_batch_suffix)
            ->setApm_currency_code($apm_currency_code)
            ->setApm_csc_flag($apm_csc_flag)
            ->setApm_cc_format($apm_cc_format)
            ->setApm_pma_key($apm_pma_key)
            ->setApm_gateway_is_frozen_flag($apm_gateway_is_frozen_flag);
    }
    /**
     * Get apm_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_key(): ?string
    {
        return $this->apm_key ?? null;
    }
    /**
     * Set apm_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_key(?string $apm_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_key) && !is_string($apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_key, true), gettype($apm_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_key, true)), __LINE__);
        }
        if (is_null($apm_key) || (is_array($apm_key) && empty($apm_key))) {
            unset($this->apm_key);
        } else {
            $this->apm_key = $apm_key;
        }
        
        return $this;
    }
    /**
     * Get apm_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_atc_key(): ?string
    {
        return $this->apm_atc_key ?? null;
    }
    /**
     * Set apm_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_atc_key(?string $apm_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_atc_key) && !is_string($apm_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_atc_key, true), gettype($apm_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_atc_key, true)), __LINE__);
        }
        if (is_null($apm_atc_key) || (is_array($apm_atc_key) && empty($apm_atc_key))) {
            unset($this->apm_atc_key);
        } else {
            $this->apm_atc_key = $apm_atc_key;
        }
        
        return $this;
    }
    /**
     * Get apm_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_type(): ?string
    {
        return $this->apm_type ?? null;
    }
    /**
     * Set apm_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_type(?string $apm_type = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_type) && !is_string($apm_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_type, true), gettype($apm_type)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($apm_type) && mb_strlen((string) $apm_type) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $apm_type)), __LINE__);
        }
        if (is_null($apm_type) || (is_array($apm_type) && empty($apm_type))) {
            unset($this->apm_type);
        } else {
            $this->apm_type = $apm_type;
        }
        
        return $this;
    }
    /**
     * Get apm_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_method(): ?string
    {
        return $this->apm_method ?? null;
    }
    /**
     * Set apm_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_method(?string $apm_method = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_method) && !is_string($apm_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_method, true), gettype($apm_method)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($apm_method) && mb_strlen((string) $apm_method) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $apm_method)), __LINE__);
        }
        if (is_null($apm_method) || (is_array($apm_method) && empty($apm_method))) {
            unset($this->apm_method);
        } else {
            $this->apm_method = $apm_method;
        }
        
        return $this;
    }
    /**
     * Get apm_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_add_user(): ?string
    {
        return $this->apm_add_user ?? null;
    }
    /**
     * Set apm_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_add_user(?string $apm_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_add_user) && !is_string($apm_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_add_user, true), gettype($apm_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($apm_add_user) && mb_strlen((string) $apm_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $apm_add_user)), __LINE__);
        }
        if (is_null($apm_add_user) || (is_array($apm_add_user) && empty($apm_add_user))) {
            unset($this->apm_add_user);
        } else {
            $this->apm_add_user = $apm_add_user;
        }
        
        return $this;
    }
    /**
     * Get apm_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_add_date(): ?string
    {
        return $this->apm_add_date ?? null;
    }
    /**
     * Set apm_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_add_date(?string $apm_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_add_date) && !is_string($apm_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_add_date, true), gettype($apm_add_date)), __LINE__);
        }
        if (is_null($apm_add_date) || (is_array($apm_add_date) && empty($apm_add_date))) {
            unset($this->apm_add_date);
        } else {
            $this->apm_add_date = $apm_add_date;
        }
        
        return $this;
    }
    /**
     * Get apm_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_change_date(): ?string
    {
        return $this->apm_change_date ?? null;
    }
    /**
     * Set apm_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_change_date(?string $apm_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_change_date) && !is_string($apm_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_change_date, true), gettype($apm_change_date)), __LINE__);
        }
        if (is_null($apm_change_date) || (is_array($apm_change_date) && empty($apm_change_date))) {
            unset($this->apm_change_date);
        } else {
            $this->apm_change_date = $apm_change_date;
        }
        
        return $this;
    }
    /**
     * Get apm_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_change_user(): ?string
    {
        return $this->apm_change_user ?? null;
    }
    /**
     * Set apm_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_change_user(?string $apm_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_change_user) && !is_string($apm_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_change_user, true), gettype($apm_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($apm_change_user) && mb_strlen((string) $apm_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $apm_change_user)), __LINE__);
        }
        if (is_null($apm_change_user) || (is_array($apm_change_user) && empty($apm_change_user))) {
            unset($this->apm_change_user);
        } else {
            $this->apm_change_user = $apm_change_user;
        }
        
        return $this;
    }
    /**
     * Get apm_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_delete_flag(): ?string
    {
        return $this->apm_delete_flag ?? null;
    }
    /**
     * Set apm_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_delete_flag(?string $apm_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_delete_flag) && !is_string($apm_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_delete_flag, true), gettype($apm_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apm_delete_flag) && $apm_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apm_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apm_delete_flag) && $apm_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apm_delete_flag, true)), __LINE__);
        }
        if (is_null($apm_delete_flag) || (is_array($apm_delete_flag) && empty($apm_delete_flag))) {
            unset($this->apm_delete_flag);
        } else {
            $this->apm_delete_flag = $apm_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get apm_gla_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_gla_key(): ?string
    {
        return $this->apm_gla_key ?? null;
    }
    /**
     * Set apm_gla_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_gla_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_gla_key(?string $apm_gla_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_gla_key) && !is_string($apm_gla_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_gla_key, true), gettype($apm_gla_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_gla_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_gla_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_gla_key, true)), __LINE__);
        }
        if (is_null($apm_gla_key) || (is_array($apm_gla_key) && empty($apm_gla_key))) {
            unset($this->apm_gla_key);
        } else {
            $this->apm_gla_key = $apm_gla_key;
        }
        
        return $this;
    }
    /**
     * Get apm_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_entity_key(): ?string
    {
        return $this->apm_entity_key ?? null;
    }
    /**
     * Set apm_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_entity_key(?string $apm_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_entity_key) && !is_string($apm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_entity_key, true), gettype($apm_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_entity_key, true)), __LINE__);
        }
        if (is_null($apm_entity_key) || (is_array($apm_entity_key) && empty($apm_entity_key))) {
            unset($this->apm_entity_key);
        } else {
            $this->apm_entity_key = $apm_entity_key;
        }
        
        return $this;
    }
    /**
     * Get apm_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_key_ext(): ?string
    {
        return $this->apm_key_ext ?? null;
    }
    /**
     * Set apm_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_key_ext(?string $apm_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_key_ext) && !is_string($apm_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_key_ext, true), gettype($apm_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_key_ext, true)), __LINE__);
        }
        if (is_null($apm_key_ext) || (is_array($apm_key_ext) && empty($apm_key_ext))) {
            unset($this->apm_key_ext);
        } else {
            $this->apm_key_ext = $apm_key_ext;
        }
        
        return $this;
    }
    /**
     * Get apm_iweb_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_iweb_flag(): ?string
    {
        return $this->apm_iweb_flag ?? null;
    }
    /**
     * Set apm_iweb_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_iweb_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_iweb_flag(?string $apm_iweb_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_iweb_flag) && !is_string($apm_iweb_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_iweb_flag, true), gettype($apm_iweb_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apm_iweb_flag) && $apm_iweb_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apm_iweb_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apm_iweb_flag) && $apm_iweb_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apm_iweb_flag, true)), __LINE__);
        }
        if (is_null($apm_iweb_flag) || (is_array($apm_iweb_flag) && empty($apm_iweb_flag))) {
            unset($this->apm_iweb_flag);
        } else {
            $this->apm_iweb_flag = $apm_iweb_flag;
        }
        
        return $this;
    }
    /**
     * Get apm_eweb_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_eweb_flag(): ?string
    {
        return $this->apm_eweb_flag ?? null;
    }
    /**
     * Set apm_eweb_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_eweb_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_eweb_flag(?string $apm_eweb_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_eweb_flag) && !is_string($apm_eweb_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_eweb_flag, true), gettype($apm_eweb_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apm_eweb_flag) && $apm_eweb_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apm_eweb_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apm_eweb_flag) && $apm_eweb_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apm_eweb_flag, true)), __LINE__);
        }
        if (is_null($apm_eweb_flag) || (is_array($apm_eweb_flag) && empty($apm_eweb_flag))) {
            unset($this->apm_eweb_flag);
        } else {
            $this->apm_eweb_flag = $apm_eweb_flag;
        }
        
        return $this;
    }
    /**
     * Get apm_merchant_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_merchant_option(): ?string
    {
        return $this->apm_merchant_option ?? null;
    }
    /**
     * Set apm_merchant_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_merchant_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_merchant_option(?string $apm_merchant_option = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_merchant_option) && !is_string($apm_merchant_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_merchant_option, true), gettype($apm_merchant_option)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($apm_merchant_option) && mb_strlen((string) $apm_merchant_option) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $apm_merchant_option)), __LINE__);
        }
        if (is_null($apm_merchant_option) || (is_array($apm_merchant_option) && empty($apm_merchant_option))) {
            unset($this->apm_merchant_option);
        } else {
            $this->apm_merchant_option = $apm_merchant_option;
        }
        
        return $this;
    }
    /**
     * Get apm_batch_suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_batch_suffix(): ?string
    {
        return $this->apm_batch_suffix ?? null;
    }
    /**
     * Set apm_batch_suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_batch_suffix
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_batch_suffix(?string $apm_batch_suffix = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_batch_suffix) && !is_string($apm_batch_suffix)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_batch_suffix, true), gettype($apm_batch_suffix)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($apm_batch_suffix) && mb_strlen((string) $apm_batch_suffix) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $apm_batch_suffix)), __LINE__);
        }
        if (is_null($apm_batch_suffix) || (is_array($apm_batch_suffix) && empty($apm_batch_suffix))) {
            unset($this->apm_batch_suffix);
        } else {
            $this->apm_batch_suffix = $apm_batch_suffix;
        }
        
        return $this;
    }
    /**
     * Get apm_currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_currency_code(): ?string
    {
        return $this->apm_currency_code ?? null;
    }
    /**
     * Set apm_currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_currency_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_currency_code(?string $apm_currency_code = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_currency_code) && !is_string($apm_currency_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_currency_code, true), gettype($apm_currency_code)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($apm_currency_code) && mb_strlen((string) $apm_currency_code) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $apm_currency_code)), __LINE__);
        }
        if (is_null($apm_currency_code) || (is_array($apm_currency_code) && empty($apm_currency_code))) {
            unset($this->apm_currency_code);
        } else {
            $this->apm_currency_code = $apm_currency_code;
        }
        
        return $this;
    }
    /**
     * Get apm_csc_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_csc_flag(): ?string
    {
        return $this->apm_csc_flag ?? null;
    }
    /**
     * Set apm_csc_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_csc_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_csc_flag(?string $apm_csc_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_csc_flag) && !is_string($apm_csc_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_csc_flag, true), gettype($apm_csc_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apm_csc_flag) && $apm_csc_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apm_csc_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apm_csc_flag) && $apm_csc_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apm_csc_flag, true)), __LINE__);
        }
        if (is_null($apm_csc_flag) || (is_array($apm_csc_flag) && empty($apm_csc_flag))) {
            unset($this->apm_csc_flag);
        } else {
            $this->apm_csc_flag = $apm_csc_flag;
        }
        
        return $this;
    }
    /**
     * Get apm_cc_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_cc_format(): ?string
    {
        return $this->apm_cc_format ?? null;
    }
    /**
     * Set apm_cc_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_cc_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_cc_format(?string $apm_cc_format = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_cc_format) && !is_string($apm_cc_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_cc_format, true), gettype($apm_cc_format)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($apm_cc_format) && mb_strlen((string) $apm_cc_format) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $apm_cc_format)), __LINE__);
        }
        if (is_null($apm_cc_format) || (is_array($apm_cc_format) && empty($apm_cc_format))) {
            unset($this->apm_cc_format);
        } else {
            $this->apm_cc_format = $apm_cc_format;
        }
        
        return $this;
    }
    /**
     * Get apm_pma_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_pma_key(): ?string
    {
        return $this->apm_pma_key ?? null;
    }
    /**
     * Set apm_pma_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_pma_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_pma_key(?string $apm_pma_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_pma_key) && !is_string($apm_pma_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_pma_key, true), gettype($apm_pma_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apm_pma_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apm_pma_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apm_pma_key, true)), __LINE__);
        }
        if (is_null($apm_pma_key) || (is_array($apm_pma_key) && empty($apm_pma_key))) {
            unset($this->apm_pma_key);
        } else {
            $this->apm_pma_key = $apm_pma_key;
        }
        
        return $this;
    }
    /**
     * Get apm_gateway_is_frozen_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApm_gateway_is_frozen_flag(): ?string
    {
        return $this->apm_gateway_is_frozen_flag ?? null;
    }
    /**
     * Set apm_gateway_is_frozen_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apm_gateway_is_frozen_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
     */
    public function setApm_gateway_is_frozen_flag(?string $apm_gateway_is_frozen_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apm_gateway_is_frozen_flag) && !is_string($apm_gateway_is_frozen_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apm_gateway_is_frozen_flag, true), gettype($apm_gateway_is_frozen_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apm_gateway_is_frozen_flag) && $apm_gateway_is_frozen_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apm_gateway_is_frozen_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apm_gateway_is_frozen_flag) && $apm_gateway_is_frozen_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apm_gateway_is_frozen_flag, true)), __LINE__);
        }
        if (is_null($apm_gateway_is_frozen_flag) || (is_array($apm_gateway_is_frozen_flag) && empty($apm_gateway_is_frozen_flag))) {
            unset($this->apm_gateway_is_frozen_flag);
        } else {
            $this->apm_gateway_is_frozen_flag = $apm_gateway_is_frozen_flag;
        }
        
        return $this;
    }
}
