<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AudienceDefinition StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AudienceDefinition
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AudienceDefinition extends AbstractStructBase
{
    /**
     * The qrh_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $qrh_key = null;
    /**
     * The qrh_description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $qrh_description = null;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter $Parameters = null;
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn $Columns = null;
    /**
     * Constructor method for AudienceDefinition
     * @uses AudienceDefinition::setQrh_key()
     * @uses AudienceDefinition::setQrh_description()
     * @uses AudienceDefinition::setParameters()
     * @uses AudienceDefinition::setColumns()
     * @param string $qrh_key
     * @param string $qrh_description
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter $parameters
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn $columns
     */
    public function __construct(?string $qrh_key = null, ?string $qrh_description = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter $parameters = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn $columns = null)
    {
        $this
            ->setQrh_key($qrh_key)
            ->setQrh_description($qrh_description)
            ->setParameters($parameters)
            ->setColumns($columns);
    }
    /**
     * Get qrh_key value
     * @return string|null
     */
    public function getQrh_key(): ?string
    {
        return $this->qrh_key;
    }
    /**
     * Set qrh_key value
     * @param string $qrh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AudienceDefinition
     */
    public function setQrh_key(?string $qrh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($qrh_key) && !is_string($qrh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrh_key, true), gettype($qrh_key)), __LINE__);
        }
        $this->qrh_key = $qrh_key;
        
        return $this;
    }
    /**
     * Get qrh_description value
     * @return string|null
     */
    public function getQrh_description(): ?string
    {
        return $this->qrh_description;
    }
    /**
     * Set qrh_description value
     * @param string $qrh_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\AudienceDefinition
     */
    public function setQrh_description(?string $qrh_description = null): self
    {
        // validation for constraint: string
        if (!is_null($qrh_description) && !is_string($qrh_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrh_description, true), gettype($qrh_description)), __LINE__);
        }
        $this->qrh_description = $qrh_description;
        
        return $this;
    }
    /**
     * Get Parameters value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter|null
     */
    public function getParameters(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\AudienceDefinition
     */
    public function setParameters(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter $parameters = null): self
    {
        $this->Parameters = $parameters;
        
        return $this;
    }
    /**
     * Get Columns value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn|null
     */
    public function getColumns(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn
    {
        return $this->Columns;
    }
    /**
     * Set Columns value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn $columns
     * @return \Drupal\netforum\xWeb\Generated\StructType\AudienceDefinition
     */
    public function setColumns(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryColumn $columns = null): self
    {
        $this->Columns = $columns;
        
        return $this;
    }
}
