<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType extends AbstractStructBase
{
    /**
     * The bin__ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bin__ind_cst_key = null;
    /**
     * The bin__ind_prf_code
     * Meta information extracted from the WSDL
     * - documentation: Prefix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_prf_code = null;
    /**
     * The bin__ind_first_name
     * Meta information extracted from the WSDL
     * - documentation: First Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_first_name = null;
    /**
     * The bin__ind_mid_name
     * Meta information extracted from the WSDL
     * - documentation: Middle Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_mid_name = null;
    /**
     * The bin__ind_last_name
     * Meta information extracted from the WSDL
     * - documentation: Last Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_last_name = null;
    /**
     * The bin__ind_sfx_code
     * Meta information extracted from the WSDL
     * - documentation: Suffix. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_sfx_code = null;
    /**
     * The bin__ind_designation
     * Meta information extracted from the WSDL
     * - documentation: Designation. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_designation = null;
    /**
     * The bin__ind_dob
     * Meta information extracted from the WSDL
     * - documentation: Date of Birth. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_dob = null;
    /**
     * The bin__ind_gender
     * Meta information extracted from the WSDL
     * - documentation: Gender. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_gender = null;
    /**
     * The bin__ind_full_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 187
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_full_name_cp = null;
    /**
     * The bin__ind_salutation_cp
     * Meta information extracted from the WSDL
     * - documentation: Salutation. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 51
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_salutation_cp = null;
    /**
     * The bin__ind_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bin__ind_cst_key_ext = null;
    /**
     * The bin__ind_ssn
     * Meta information extracted from the WSDL
     * - documentation: social security number. This field has this Input Mask: ^[0-9]{3}-?[0-9]{2}-?[0-9]{4}. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_ssn = null;
    /**
     * The bin__ind_spouse_name
     * Meta information extracted from the WSDL
     * - documentation: Spouse&apos;s Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_spouse_name = null;
    /**
     * The bin__ind_age_cp
     * Meta information extracted from the WSDL
     * - documentation: age. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bin__ind_age_cp = null;
    /**
     * The bin__ind_salary
     * Meta information extracted from the WSDL
     * - documentation: annual salary. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bin__ind_salary = null;
    /**
     * The bin__ind_ethnicity
     * Meta information extracted from the WSDL
     * - documentation: ethnicity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_ethnicity = null;
    /**
     * The bin__ind_badge_name
     * Meta information extracted from the WSDL
     * - documentation: badge name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_badge_name = null;
    /**
     * The bin__ind_license_number
     * Meta information extracted from the WSDL
     * - documentation: license number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_license_number = null;
    /**
     * The bin__ind_entered_field_date
     * Meta information extracted from the WSDL
     * - documentation: date first entered field. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_entered_field_date = null;
    /**
     * The bin__ind_num_years_in_field_cp
     * Meta information extracted from the WSDL
     * - documentation: number of years in field. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $bin__ind_num_years_in_field_cp = null;
    /**
     * The bin__ind_grad_date
     * Meta information extracted from the WSDL
     * - documentation: Graduation Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_grad_date = null;
    /**
     * The bin__ind_political_party
     * Meta information extracted from the WSDL
     * - documentation: political party. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_political_party = null;
    /**
     * The bin__ind_deceased_flag
     * Meta information extracted from the WSDL
     * - documentation: deceased. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_deceased_flag = null;
    /**
     * The bin__ind_int_code
     * Meta information extracted from the WSDL
     * - documentation: Individual Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_int_code = null;
    /**
     * The bin__ind_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Relationship. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bin__ind_ixo_key = null;
    /**
     * The bin__ind_marital_status
     * Meta information extracted from the WSDL
     * - documentation: Marital Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_marital_status = null;
    /**
     * The bin__ind_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_add_date = null;
    /**
     * The bin__ind_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_add_user = null;
    /**
     * The bin__ind_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bin__ind_entity_key = null;
    /**
     * The bin__ind_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_change_date = null;
    /**
     * The bin__ind_cst_passcode_ext
     * Meta information extracted from the WSDL
     * - documentation: cst passcode ext. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_cst_passcode_ext = null;
    /**
     * The bin__ind_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_change_user = null;
    /**
     * The bin__ind_sample_multi
     * Meta information extracted from the WSDL
     * - documentation: sample multi. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_sample_multi = null;
    /**
     * The bin__ind_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_delete_flag = null;
    /**
     * The bin__ind_maiden_name
     * Meta information extracted from the WSDL
     * - documentation: Former Last Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_maiden_name = null;
    /**
     * The bin__ind_progress_ext
     * Meta information extracted from the WSDL
     * - documentation: Progress Ext. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_progress_ext = null;
    /**
     * The bin__ind_ssn_display
     * Meta information extracted from the WSDL
     * - documentation: SSN (Last Four digit). | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_ssn_display = null;
    /**
     * The bin__ind_aicpa_id
     * Meta information extracted from the WSDL
     * - documentation: AICPA ID. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_aicpa_id = null;
    /**
     * The bin__ind_deceased_date
     * Meta information extracted from the WSDL
     * - documentation: Deceased Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_deceased_date = null;
    /**
     * The bin__ind_prn_code
     * Meta information extracted from the WSDL
     * - documentation: Preferred Pronouns. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_prn_code = null;
    /**
     * The bin__ind_popup
     * Meta information extracted from the WSDL
     * - documentation: Popup. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_popup = null;
    /**
     * The bin__ind_anonymization_status
     * Meta information extracted from the WSDL
     * - documentation: Anonymization Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bin__ind_anonymization_status = null;
    /**
     * Constructor method for
     * CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_cst_key()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_prf_code()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_first_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_mid_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_last_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_sfx_code()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_designation()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_dob()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_gender()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_full_name_cp()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_salutation_cp()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_cst_key_ext()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_ssn()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_spouse_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_age_cp()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_salary()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_ethnicity()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_badge_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_license_number()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_entered_field_date()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_num_years_in_field_cp()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_grad_date()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_political_party()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_deceased_flag()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_int_code()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_ixo_key()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_marital_status()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_add_date()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_add_user()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_entity_key()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_change_date()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_cst_passcode_ext()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_change_user()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_sample_multi()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_delete_flag()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_maiden_name()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_progress_ext()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_ssn_display()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_aicpa_id()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_deceased_date()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_prn_code()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_popup()
     * @uses CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType::setBin__ind_anonymization_status()
     * @param string $bin__ind_cst_key
     * @param string $bin__ind_prf_code
     * @param string $bin__ind_first_name
     * @param string $bin__ind_mid_name
     * @param string $bin__ind_last_name
     * @param string $bin__ind_sfx_code
     * @param string $bin__ind_designation
     * @param string $bin__ind_dob
     * @param string $bin__ind_gender
     * @param string $bin__ind_full_name_cp
     * @param string $bin__ind_salutation_cp
     * @param string $bin__ind_cst_key_ext
     * @param string $bin__ind_ssn
     * @param string $bin__ind_spouse_name
     * @param int $bin__ind_age_cp
     * @param float $bin__ind_salary
     * @param string $bin__ind_ethnicity
     * @param string $bin__ind_badge_name
     * @param string $bin__ind_license_number
     * @param string $bin__ind_entered_field_date
     * @param int $bin__ind_num_years_in_field_cp
     * @param string $bin__ind_grad_date
     * @param string $bin__ind_political_party
     * @param string $bin__ind_deceased_flag
     * @param string $bin__ind_int_code
     * @param string $bin__ind_ixo_key
     * @param string $bin__ind_marital_status
     * @param string $bin__ind_add_date
     * @param string $bin__ind_add_user
     * @param string $bin__ind_entity_key
     * @param string $bin__ind_change_date
     * @param string $bin__ind_cst_passcode_ext
     * @param string $bin__ind_change_user
     * @param string $bin__ind_sample_multi
     * @param string $bin__ind_delete_flag
     * @param string $bin__ind_maiden_name
     * @param string $bin__ind_progress_ext
     * @param string $bin__ind_ssn_display
     * @param string $bin__ind_aicpa_id
     * @param string $bin__ind_deceased_date
     * @param string $bin__ind_prn_code
     * @param string $bin__ind_popup
     * @param string $bin__ind_anonymization_status
     */
    public function __construct(?string $bin__ind_cst_key = null, ?string $bin__ind_prf_code = null, ?string $bin__ind_first_name = null, ?string $bin__ind_mid_name = null, ?string $bin__ind_last_name = null, ?string $bin__ind_sfx_code = null, ?string $bin__ind_designation = null, ?string $bin__ind_dob = null, ?string $bin__ind_gender = null, ?string $bin__ind_full_name_cp = null, ?string $bin__ind_salutation_cp = null, ?string $bin__ind_cst_key_ext = null, ?string $bin__ind_ssn = null, ?string $bin__ind_spouse_name = null, ?int $bin__ind_age_cp = null, ?float $bin__ind_salary = null, ?string $bin__ind_ethnicity = null, ?string $bin__ind_badge_name = null, ?string $bin__ind_license_number = null, ?string $bin__ind_entered_field_date = null, ?int $bin__ind_num_years_in_field_cp = null, ?string $bin__ind_grad_date = null, ?string $bin__ind_political_party = null, ?string $bin__ind_deceased_flag = null, ?string $bin__ind_int_code = null, ?string $bin__ind_ixo_key = null, ?string $bin__ind_marital_status = null, ?string $bin__ind_add_date = null, ?string $bin__ind_add_user = null, ?string $bin__ind_entity_key = null, ?string $bin__ind_change_date = null, ?string $bin__ind_cst_passcode_ext = null, ?string $bin__ind_change_user = null, ?string $bin__ind_sample_multi = null, ?string $bin__ind_delete_flag = null, ?string $bin__ind_maiden_name = null, ?string $bin__ind_progress_ext = null, ?string $bin__ind_ssn_display = null, ?string $bin__ind_aicpa_id = null, ?string $bin__ind_deceased_date = null, ?string $bin__ind_prn_code = null, ?string $bin__ind_popup = null, ?string $bin__ind_anonymization_status = null)
    {
        $this
            ->setBin__ind_cst_key($bin__ind_cst_key)
            ->setBin__ind_prf_code($bin__ind_prf_code)
            ->setBin__ind_first_name($bin__ind_first_name)
            ->setBin__ind_mid_name($bin__ind_mid_name)
            ->setBin__ind_last_name($bin__ind_last_name)
            ->setBin__ind_sfx_code($bin__ind_sfx_code)
            ->setBin__ind_designation($bin__ind_designation)
            ->setBin__ind_dob($bin__ind_dob)
            ->setBin__ind_gender($bin__ind_gender)
            ->setBin__ind_full_name_cp($bin__ind_full_name_cp)
            ->setBin__ind_salutation_cp($bin__ind_salutation_cp)
            ->setBin__ind_cst_key_ext($bin__ind_cst_key_ext)
            ->setBin__ind_ssn($bin__ind_ssn)
            ->setBin__ind_spouse_name($bin__ind_spouse_name)
            ->setBin__ind_age_cp($bin__ind_age_cp)
            ->setBin__ind_salary($bin__ind_salary)
            ->setBin__ind_ethnicity($bin__ind_ethnicity)
            ->setBin__ind_badge_name($bin__ind_badge_name)
            ->setBin__ind_license_number($bin__ind_license_number)
            ->setBin__ind_entered_field_date($bin__ind_entered_field_date)
            ->setBin__ind_num_years_in_field_cp($bin__ind_num_years_in_field_cp)
            ->setBin__ind_grad_date($bin__ind_grad_date)
            ->setBin__ind_political_party($bin__ind_political_party)
            ->setBin__ind_deceased_flag($bin__ind_deceased_flag)
            ->setBin__ind_int_code($bin__ind_int_code)
            ->setBin__ind_ixo_key($bin__ind_ixo_key)
            ->setBin__ind_marital_status($bin__ind_marital_status)
            ->setBin__ind_add_date($bin__ind_add_date)
            ->setBin__ind_add_user($bin__ind_add_user)
            ->setBin__ind_entity_key($bin__ind_entity_key)
            ->setBin__ind_change_date($bin__ind_change_date)
            ->setBin__ind_cst_passcode_ext($bin__ind_cst_passcode_ext)
            ->setBin__ind_change_user($bin__ind_change_user)
            ->setBin__ind_sample_multi($bin__ind_sample_multi)
            ->setBin__ind_delete_flag($bin__ind_delete_flag)
            ->setBin__ind_maiden_name($bin__ind_maiden_name)
            ->setBin__ind_progress_ext($bin__ind_progress_ext)
            ->setBin__ind_ssn_display($bin__ind_ssn_display)
            ->setBin__ind_aicpa_id($bin__ind_aicpa_id)
            ->setBin__ind_deceased_date($bin__ind_deceased_date)
            ->setBin__ind_prn_code($bin__ind_prn_code)
            ->setBin__ind_popup($bin__ind_popup)
            ->setBin__ind_anonymization_status($bin__ind_anonymization_status);
    }
    /**
     * Get bin__ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_cst_key(): ?string
    {
        return $this->bin__ind_cst_key ?? null;
    }
    /**
     * Set bin__ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_cst_key(?string $bin__ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_cst_key) && !is_string($bin__ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_cst_key, true), gettype($bin__ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bin__ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bin__ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bin__ind_cst_key, true)), __LINE__);
        }
        if (is_null($bin__ind_cst_key) || (is_array($bin__ind_cst_key) && empty($bin__ind_cst_key))) {
            unset($this->bin__ind_cst_key);
        } else {
            $this->bin__ind_cst_key = $bin__ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_prf_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_prf_code(): ?string
    {
        return $this->bin__ind_prf_code ?? null;
    }
    /**
     * Set bin__ind_prf_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_prf_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_prf_code(?string $bin__ind_prf_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_prf_code) && !is_string($bin__ind_prf_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_prf_code, true), gettype($bin__ind_prf_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_prf_code) && mb_strlen((string) $bin__ind_prf_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_prf_code)), __LINE__);
        }
        if (is_null($bin__ind_prf_code) || (is_array($bin__ind_prf_code) && empty($bin__ind_prf_code))) {
            unset($this->bin__ind_prf_code);
        } else {
            $this->bin__ind_prf_code = $bin__ind_prf_code;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_first_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_first_name(): ?string
    {
        return $this->bin__ind_first_name ?? null;
    }
    /**
     * Set bin__ind_first_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_first_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_first_name(?string $bin__ind_first_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_first_name) && !is_string($bin__ind_first_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_first_name, true), gettype($bin__ind_first_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_first_name) && mb_strlen((string) $bin__ind_first_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_first_name)), __LINE__);
        }
        if (is_null($bin__ind_first_name) || (is_array($bin__ind_first_name) && empty($bin__ind_first_name))) {
            unset($this->bin__ind_first_name);
        } else {
            $this->bin__ind_first_name = $bin__ind_first_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_mid_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_mid_name(): ?string
    {
        return $this->bin__ind_mid_name ?? null;
    }
    /**
     * Set bin__ind_mid_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_mid_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_mid_name(?string $bin__ind_mid_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_mid_name) && !is_string($bin__ind_mid_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_mid_name, true), gettype($bin__ind_mid_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_mid_name) && mb_strlen((string) $bin__ind_mid_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_mid_name)), __LINE__);
        }
        if (is_null($bin__ind_mid_name) || (is_array($bin__ind_mid_name) && empty($bin__ind_mid_name))) {
            unset($this->bin__ind_mid_name);
        } else {
            $this->bin__ind_mid_name = $bin__ind_mid_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_last_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_last_name(): ?string
    {
        return $this->bin__ind_last_name ?? null;
    }
    /**
     * Set bin__ind_last_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_last_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_last_name(?string $bin__ind_last_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_last_name) && !is_string($bin__ind_last_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_last_name, true), gettype($bin__ind_last_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_last_name) && mb_strlen((string) $bin__ind_last_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_last_name)), __LINE__);
        }
        if (is_null($bin__ind_last_name) || (is_array($bin__ind_last_name) && empty($bin__ind_last_name))) {
            unset($this->bin__ind_last_name);
        } else {
            $this->bin__ind_last_name = $bin__ind_last_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_sfx_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_sfx_code(): ?string
    {
        return $this->bin__ind_sfx_code ?? null;
    }
    /**
     * Set bin__ind_sfx_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_sfx_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_sfx_code(?string $bin__ind_sfx_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_sfx_code) && !is_string($bin__ind_sfx_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_sfx_code, true), gettype($bin__ind_sfx_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_sfx_code) && mb_strlen((string) $bin__ind_sfx_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_sfx_code)), __LINE__);
        }
        if (is_null($bin__ind_sfx_code) || (is_array($bin__ind_sfx_code) && empty($bin__ind_sfx_code))) {
            unset($this->bin__ind_sfx_code);
        } else {
            $this->bin__ind_sfx_code = $bin__ind_sfx_code;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_designation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_designation(): ?string
    {
        return $this->bin__ind_designation ?? null;
    }
    /**
     * Set bin__ind_designation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_designation
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_designation(?string $bin__ind_designation = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_designation) && !is_string($bin__ind_designation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_designation, true), gettype($bin__ind_designation)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bin__ind_designation) && mb_strlen((string) $bin__ind_designation) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bin__ind_designation)), __LINE__);
        }
        if (is_null($bin__ind_designation) || (is_array($bin__ind_designation) && empty($bin__ind_designation))) {
            unset($this->bin__ind_designation);
        } else {
            $this->bin__ind_designation = $bin__ind_designation;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_dob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_dob(): ?string
    {
        return $this->bin__ind_dob ?? null;
    }
    /**
     * Set bin__ind_dob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_dob
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_dob(?string $bin__ind_dob = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_dob) && !is_string($bin__ind_dob)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_dob, true), gettype($bin__ind_dob)), __LINE__);
        }
        if (is_null($bin__ind_dob) || (is_array($bin__ind_dob) && empty($bin__ind_dob))) {
            unset($this->bin__ind_dob);
        } else {
            $this->bin__ind_dob = $bin__ind_dob;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_gender(): ?string
    {
        return $this->bin__ind_gender ?? null;
    }
    /**
     * Set bin__ind_gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_gender
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_gender(?string $bin__ind_gender = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_gender) && !is_string($bin__ind_gender)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_gender, true), gettype($bin__ind_gender)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_gender) && mb_strlen((string) $bin__ind_gender) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_gender)), __LINE__);
        }
        if (is_null($bin__ind_gender) || (is_array($bin__ind_gender) && empty($bin__ind_gender))) {
            unset($this->bin__ind_gender);
        } else {
            $this->bin__ind_gender = $bin__ind_gender;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_full_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_full_name_cp(): ?string
    {
        return $this->bin__ind_full_name_cp ?? null;
    }
    /**
     * Set bin__ind_full_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_full_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_full_name_cp(?string $bin__ind_full_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_full_name_cp) && !is_string($bin__ind_full_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_full_name_cp, true), gettype($bin__ind_full_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(187)
        if (!is_null($bin__ind_full_name_cp) && mb_strlen((string) $bin__ind_full_name_cp) > 187) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 187', mb_strlen((string) $bin__ind_full_name_cp)), __LINE__);
        }
        if (is_null($bin__ind_full_name_cp) || (is_array($bin__ind_full_name_cp) && empty($bin__ind_full_name_cp))) {
            unset($this->bin__ind_full_name_cp);
        } else {
            $this->bin__ind_full_name_cp = $bin__ind_full_name_cp;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_salutation_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_salutation_cp(): ?string
    {
        return $this->bin__ind_salutation_cp ?? null;
    }
    /**
     * Set bin__ind_salutation_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_salutation_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_salutation_cp(?string $bin__ind_salutation_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_salutation_cp) && !is_string($bin__ind_salutation_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_salutation_cp, true), gettype($bin__ind_salutation_cp)), __LINE__);
        }
        // validation for constraint: maxLength(51)
        if (!is_null($bin__ind_salutation_cp) && mb_strlen((string) $bin__ind_salutation_cp) > 51) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 51', mb_strlen((string) $bin__ind_salutation_cp)), __LINE__);
        }
        if (is_null($bin__ind_salutation_cp) || (is_array($bin__ind_salutation_cp) && empty($bin__ind_salutation_cp))) {
            unset($this->bin__ind_salutation_cp);
        } else {
            $this->bin__ind_salutation_cp = $bin__ind_salutation_cp;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_cst_key_ext(): ?string
    {
        return $this->bin__ind_cst_key_ext ?? null;
    }
    /**
     * Set bin__ind_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_cst_key_ext(?string $bin__ind_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_cst_key_ext) && !is_string($bin__ind_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_cst_key_ext, true), gettype($bin__ind_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bin__ind_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bin__ind_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bin__ind_cst_key_ext, true)), __LINE__);
        }
        if (is_null($bin__ind_cst_key_ext) || (is_array($bin__ind_cst_key_ext) && empty($bin__ind_cst_key_ext))) {
            unset($this->bin__ind_cst_key_ext);
        } else {
            $this->bin__ind_cst_key_ext = $bin__ind_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_ssn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_ssn(): ?string
    {
        return $this->bin__ind_ssn ?? null;
    }
    /**
     * Set bin__ind_ssn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_ssn
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_ssn(?string $bin__ind_ssn = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_ssn) && !is_string($bin__ind_ssn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_ssn, true), gettype($bin__ind_ssn)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($bin__ind_ssn) && mb_strlen((string) $bin__ind_ssn) > 2048) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen((string) $bin__ind_ssn)), __LINE__);
        }
        if (is_null($bin__ind_ssn) || (is_array($bin__ind_ssn) && empty($bin__ind_ssn))) {
            unset($this->bin__ind_ssn);
        } else {
            $this->bin__ind_ssn = $bin__ind_ssn;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_spouse_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_spouse_name(): ?string
    {
        return $this->bin__ind_spouse_name ?? null;
    }
    /**
     * Set bin__ind_spouse_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_spouse_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_spouse_name(?string $bin__ind_spouse_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_spouse_name) && !is_string($bin__ind_spouse_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_spouse_name, true), gettype($bin__ind_spouse_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($bin__ind_spouse_name) && mb_strlen((string) $bin__ind_spouse_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $bin__ind_spouse_name)), __LINE__);
        }
        if (is_null($bin__ind_spouse_name) || (is_array($bin__ind_spouse_name) && empty($bin__ind_spouse_name))) {
            unset($this->bin__ind_spouse_name);
        } else {
            $this->bin__ind_spouse_name = $bin__ind_spouse_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_age_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBin__ind_age_cp(): ?int
    {
        return $this->bin__ind_age_cp ?? null;
    }
    /**
     * Set bin__ind_age_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bin__ind_age_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_age_cp(?int $bin__ind_age_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($bin__ind_age_cp) && !(is_int($bin__ind_age_cp) || ctype_digit($bin__ind_age_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bin__ind_age_cp, true), gettype($bin__ind_age_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bin__ind_age_cp) && $bin__ind_age_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bin__ind_age_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bin__ind_age_cp) && $bin__ind_age_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bin__ind_age_cp, true)), __LINE__);
        }
        if (is_null($bin__ind_age_cp) || (is_array($bin__ind_age_cp) && empty($bin__ind_age_cp))) {
            unset($this->bin__ind_age_cp);
        } else {
            $this->bin__ind_age_cp = $bin__ind_age_cp;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_salary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBin__ind_salary(): ?float
    {
        return $this->bin__ind_salary ?? null;
    }
    /**
     * Set bin__ind_salary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bin__ind_salary
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_salary(?float $bin__ind_salary = null): self
    {
        // validation for constraint: float
        if (!is_null($bin__ind_salary) && !(is_float($bin__ind_salary) || is_numeric($bin__ind_salary))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bin__ind_salary, true), gettype($bin__ind_salary)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($bin__ind_salary) && mb_strlen(mb_substr((string) $bin__ind_salary, false !== mb_strpos((string) $bin__ind_salary, '.') ? mb_strpos((string) $bin__ind_salary, '.') + 1 : mb_strlen((string) $bin__ind_salary))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($bin__ind_salary, true), mb_strlen(mb_substr((string) $bin__ind_salary, mb_strpos((string) $bin__ind_salary, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bin__ind_salary) && mb_strlen(preg_replace('/(\D)/', '', (string) $bin__ind_salary)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bin__ind_salary, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bin__ind_salary))), __LINE__);
        }
        if (is_null($bin__ind_salary) || (is_array($bin__ind_salary) && empty($bin__ind_salary))) {
            unset($this->bin__ind_salary);
        } else {
            $this->bin__ind_salary = $bin__ind_salary;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_ethnicity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_ethnicity(): ?string
    {
        return $this->bin__ind_ethnicity ?? null;
    }
    /**
     * Set bin__ind_ethnicity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_ethnicity
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_ethnicity(?string $bin__ind_ethnicity = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_ethnicity) && !is_string($bin__ind_ethnicity)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_ethnicity, true), gettype($bin__ind_ethnicity)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bin__ind_ethnicity) && mb_strlen((string) $bin__ind_ethnicity) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bin__ind_ethnicity)), __LINE__);
        }
        if (is_null($bin__ind_ethnicity) || (is_array($bin__ind_ethnicity) && empty($bin__ind_ethnicity))) {
            unset($this->bin__ind_ethnicity);
        } else {
            $this->bin__ind_ethnicity = $bin__ind_ethnicity;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_badge_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_badge_name(): ?string
    {
        return $this->bin__ind_badge_name ?? null;
    }
    /**
     * Set bin__ind_badge_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_badge_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_badge_name(?string $bin__ind_badge_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_badge_name) && !is_string($bin__ind_badge_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_badge_name, true), gettype($bin__ind_badge_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_badge_name) && mb_strlen((string) $bin__ind_badge_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_badge_name)), __LINE__);
        }
        if (is_null($bin__ind_badge_name) || (is_array($bin__ind_badge_name) && empty($bin__ind_badge_name))) {
            unset($this->bin__ind_badge_name);
        } else {
            $this->bin__ind_badge_name = $bin__ind_badge_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_license_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_license_number(): ?string
    {
        return $this->bin__ind_license_number ?? null;
    }
    /**
     * Set bin__ind_license_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_license_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_license_number(?string $bin__ind_license_number = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_license_number) && !is_string($bin__ind_license_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_license_number, true), gettype($bin__ind_license_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_license_number) && mb_strlen((string) $bin__ind_license_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_license_number)), __LINE__);
        }
        if (is_null($bin__ind_license_number) || (is_array($bin__ind_license_number) && empty($bin__ind_license_number))) {
            unset($this->bin__ind_license_number);
        } else {
            $this->bin__ind_license_number = $bin__ind_license_number;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_entered_field_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_entered_field_date(): ?string
    {
        return $this->bin__ind_entered_field_date ?? null;
    }
    /**
     * Set bin__ind_entered_field_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_entered_field_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_entered_field_date(?string $bin__ind_entered_field_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_entered_field_date) && !is_string($bin__ind_entered_field_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_entered_field_date, true), gettype($bin__ind_entered_field_date)), __LINE__);
        }
        if (is_null($bin__ind_entered_field_date) || (is_array($bin__ind_entered_field_date) && empty($bin__ind_entered_field_date))) {
            unset($this->bin__ind_entered_field_date);
        } else {
            $this->bin__ind_entered_field_date = $bin__ind_entered_field_date;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_num_years_in_field_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBin__ind_num_years_in_field_cp(): ?int
    {
        return $this->bin__ind_num_years_in_field_cp ?? null;
    }
    /**
     * Set bin__ind_num_years_in_field_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bin__ind_num_years_in_field_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_num_years_in_field_cp(?int $bin__ind_num_years_in_field_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($bin__ind_num_years_in_field_cp) && !(is_int($bin__ind_num_years_in_field_cp) || ctype_digit($bin__ind_num_years_in_field_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bin__ind_num_years_in_field_cp, true), gettype($bin__ind_num_years_in_field_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($bin__ind_num_years_in_field_cp) && $bin__ind_num_years_in_field_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($bin__ind_num_years_in_field_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($bin__ind_num_years_in_field_cp) && $bin__ind_num_years_in_field_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($bin__ind_num_years_in_field_cp, true)), __LINE__);
        }
        if (is_null($bin__ind_num_years_in_field_cp) || (is_array($bin__ind_num_years_in_field_cp) && empty($bin__ind_num_years_in_field_cp))) {
            unset($this->bin__ind_num_years_in_field_cp);
        } else {
            $this->bin__ind_num_years_in_field_cp = $bin__ind_num_years_in_field_cp;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_grad_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_grad_date(): ?string
    {
        return $this->bin__ind_grad_date ?? null;
    }
    /**
     * Set bin__ind_grad_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_grad_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_grad_date(?string $bin__ind_grad_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_grad_date) && !is_string($bin__ind_grad_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_grad_date, true), gettype($bin__ind_grad_date)), __LINE__);
        }
        if (is_null($bin__ind_grad_date) || (is_array($bin__ind_grad_date) && empty($bin__ind_grad_date))) {
            unset($this->bin__ind_grad_date);
        } else {
            $this->bin__ind_grad_date = $bin__ind_grad_date;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_political_party value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_political_party(): ?string
    {
        return $this->bin__ind_political_party ?? null;
    }
    /**
     * Set bin__ind_political_party value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_political_party
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_political_party(?string $bin__ind_political_party = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_political_party) && !is_string($bin__ind_political_party)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_political_party, true), gettype($bin__ind_political_party)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_political_party) && mb_strlen((string) $bin__ind_political_party) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_political_party)), __LINE__);
        }
        if (is_null($bin__ind_political_party) || (is_array($bin__ind_political_party) && empty($bin__ind_political_party))) {
            unset($this->bin__ind_political_party);
        } else {
            $this->bin__ind_political_party = $bin__ind_political_party;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_deceased_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_deceased_flag(): ?string
    {
        return $this->bin__ind_deceased_flag ?? null;
    }
    /**
     * Set bin__ind_deceased_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_deceased_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_deceased_flag(?string $bin__ind_deceased_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_deceased_flag) && !is_string($bin__ind_deceased_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_deceased_flag, true), gettype($bin__ind_deceased_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bin__ind_deceased_flag) && $bin__ind_deceased_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bin__ind_deceased_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bin__ind_deceased_flag) && $bin__ind_deceased_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bin__ind_deceased_flag, true)), __LINE__);
        }
        if (is_null($bin__ind_deceased_flag) || (is_array($bin__ind_deceased_flag) && empty($bin__ind_deceased_flag))) {
            unset($this->bin__ind_deceased_flag);
        } else {
            $this->bin__ind_deceased_flag = $bin__ind_deceased_flag;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_int_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_int_code(): ?string
    {
        return $this->bin__ind_int_code ?? null;
    }
    /**
     * Set bin__ind_int_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_int_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_int_code(?string $bin__ind_int_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_int_code) && !is_string($bin__ind_int_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_int_code, true), gettype($bin__ind_int_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bin__ind_int_code) && mb_strlen((string) $bin__ind_int_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bin__ind_int_code)), __LINE__);
        }
        if (is_null($bin__ind_int_code) || (is_array($bin__ind_int_code) && empty($bin__ind_int_code))) {
            unset($this->bin__ind_int_code);
        } else {
            $this->bin__ind_int_code = $bin__ind_int_code;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_ixo_key(): ?string
    {
        return $this->bin__ind_ixo_key ?? null;
    }
    /**
     * Set bin__ind_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_ixo_key(?string $bin__ind_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_ixo_key) && !is_string($bin__ind_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_ixo_key, true), gettype($bin__ind_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bin__ind_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bin__ind_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bin__ind_ixo_key, true)), __LINE__);
        }
        if (is_null($bin__ind_ixo_key) || (is_array($bin__ind_ixo_key) && empty($bin__ind_ixo_key))) {
            unset($this->bin__ind_ixo_key);
        } else {
            $this->bin__ind_ixo_key = $bin__ind_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_marital_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_marital_status(): ?string
    {
        return $this->bin__ind_marital_status ?? null;
    }
    /**
     * Set bin__ind_marital_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_marital_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_marital_status(?string $bin__ind_marital_status = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_marital_status) && !is_string($bin__ind_marital_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_marital_status, true), gettype($bin__ind_marital_status)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($bin__ind_marital_status) && mb_strlen((string) $bin__ind_marital_status) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $bin__ind_marital_status)), __LINE__);
        }
        if (is_null($bin__ind_marital_status) || (is_array($bin__ind_marital_status) && empty($bin__ind_marital_status))) {
            unset($this->bin__ind_marital_status);
        } else {
            $this->bin__ind_marital_status = $bin__ind_marital_status;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_add_date(): ?string
    {
        return $this->bin__ind_add_date ?? null;
    }
    /**
     * Set bin__ind_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_add_date(?string $bin__ind_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_add_date) && !is_string($bin__ind_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_add_date, true), gettype($bin__ind_add_date)), __LINE__);
        }
        if (is_null($bin__ind_add_date) || (is_array($bin__ind_add_date) && empty($bin__ind_add_date))) {
            unset($this->bin__ind_add_date);
        } else {
            $this->bin__ind_add_date = $bin__ind_add_date;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_add_user(): ?string
    {
        return $this->bin__ind_add_user ?? null;
    }
    /**
     * Set bin__ind_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_add_user(?string $bin__ind_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_add_user) && !is_string($bin__ind_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_add_user, true), gettype($bin__ind_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bin__ind_add_user) && mb_strlen((string) $bin__ind_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bin__ind_add_user)), __LINE__);
        }
        if (is_null($bin__ind_add_user) || (is_array($bin__ind_add_user) && empty($bin__ind_add_user))) {
            unset($this->bin__ind_add_user);
        } else {
            $this->bin__ind_add_user = $bin__ind_add_user;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_entity_key(): ?string
    {
        return $this->bin__ind_entity_key ?? null;
    }
    /**
     * Set bin__ind_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_entity_key(?string $bin__ind_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_entity_key) && !is_string($bin__ind_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_entity_key, true), gettype($bin__ind_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bin__ind_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bin__ind_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bin__ind_entity_key, true)), __LINE__);
        }
        if (is_null($bin__ind_entity_key) || (is_array($bin__ind_entity_key) && empty($bin__ind_entity_key))) {
            unset($this->bin__ind_entity_key);
        } else {
            $this->bin__ind_entity_key = $bin__ind_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_change_date(): ?string
    {
        return $this->bin__ind_change_date ?? null;
    }
    /**
     * Set bin__ind_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_change_date(?string $bin__ind_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_change_date) && !is_string($bin__ind_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_change_date, true), gettype($bin__ind_change_date)), __LINE__);
        }
        if (is_null($bin__ind_change_date) || (is_array($bin__ind_change_date) && empty($bin__ind_change_date))) {
            unset($this->bin__ind_change_date);
        } else {
            $this->bin__ind_change_date = $bin__ind_change_date;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_cst_passcode_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_cst_passcode_ext(): ?string
    {
        return $this->bin__ind_cst_passcode_ext ?? null;
    }
    /**
     * Set bin__ind_cst_passcode_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_cst_passcode_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_cst_passcode_ext(?string $bin__ind_cst_passcode_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_cst_passcode_ext) && !is_string($bin__ind_cst_passcode_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_cst_passcode_ext, true), gettype($bin__ind_cst_passcode_ext)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_cst_passcode_ext) && mb_strlen((string) $bin__ind_cst_passcode_ext) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_cst_passcode_ext)), __LINE__);
        }
        if (is_null($bin__ind_cst_passcode_ext) || (is_array($bin__ind_cst_passcode_ext) && empty($bin__ind_cst_passcode_ext))) {
            unset($this->bin__ind_cst_passcode_ext);
        } else {
            $this->bin__ind_cst_passcode_ext = $bin__ind_cst_passcode_ext;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_change_user(): ?string
    {
        return $this->bin__ind_change_user ?? null;
    }
    /**
     * Set bin__ind_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_change_user(?string $bin__ind_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_change_user) && !is_string($bin__ind_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_change_user, true), gettype($bin__ind_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bin__ind_change_user) && mb_strlen((string) $bin__ind_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bin__ind_change_user)), __LINE__);
        }
        if (is_null($bin__ind_change_user) || (is_array($bin__ind_change_user) && empty($bin__ind_change_user))) {
            unset($this->bin__ind_change_user);
        } else {
            $this->bin__ind_change_user = $bin__ind_change_user;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_sample_multi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_sample_multi(): ?string
    {
        return $this->bin__ind_sample_multi ?? null;
    }
    /**
     * Set bin__ind_sample_multi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_sample_multi
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_sample_multi(?string $bin__ind_sample_multi = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_sample_multi) && !is_string($bin__ind_sample_multi)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_sample_multi, true), gettype($bin__ind_sample_multi)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bin__ind_sample_multi) && mb_strlen((string) $bin__ind_sample_multi) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $bin__ind_sample_multi)), __LINE__);
        }
        if (is_null($bin__ind_sample_multi) || (is_array($bin__ind_sample_multi) && empty($bin__ind_sample_multi))) {
            unset($this->bin__ind_sample_multi);
        } else {
            $this->bin__ind_sample_multi = $bin__ind_sample_multi;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_delete_flag(): ?string
    {
        return $this->bin__ind_delete_flag ?? null;
    }
    /**
     * Set bin__ind_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_delete_flag(?string $bin__ind_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_delete_flag) && !is_string($bin__ind_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_delete_flag, true), gettype($bin__ind_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bin__ind_delete_flag) && $bin__ind_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bin__ind_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bin__ind_delete_flag) && $bin__ind_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bin__ind_delete_flag, true)), __LINE__);
        }
        if (is_null($bin__ind_delete_flag) || (is_array($bin__ind_delete_flag) && empty($bin__ind_delete_flag))) {
            unset($this->bin__ind_delete_flag);
        } else {
            $this->bin__ind_delete_flag = $bin__ind_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_maiden_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_maiden_name(): ?string
    {
        return $this->bin__ind_maiden_name ?? null;
    }
    /**
     * Set bin__ind_maiden_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_maiden_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_maiden_name(?string $bin__ind_maiden_name = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_maiden_name) && !is_string($bin__ind_maiden_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_maiden_name, true), gettype($bin__ind_maiden_name)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_maiden_name) && mb_strlen((string) $bin__ind_maiden_name) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_maiden_name)), __LINE__);
        }
        if (is_null($bin__ind_maiden_name) || (is_array($bin__ind_maiden_name) && empty($bin__ind_maiden_name))) {
            unset($this->bin__ind_maiden_name);
        } else {
            $this->bin__ind_maiden_name = $bin__ind_maiden_name;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_progress_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_progress_ext(): ?string
    {
        return $this->bin__ind_progress_ext ?? null;
    }
    /**
     * Set bin__ind_progress_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_progress_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_progress_ext(?string $bin__ind_progress_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_progress_ext) && !is_string($bin__ind_progress_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_progress_ext, true), gettype($bin__ind_progress_ext)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bin__ind_progress_ext) && mb_strlen((string) $bin__ind_progress_ext) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $bin__ind_progress_ext)), __LINE__);
        }
        if (is_null($bin__ind_progress_ext) || (is_array($bin__ind_progress_ext) && empty($bin__ind_progress_ext))) {
            unset($this->bin__ind_progress_ext);
        } else {
            $this->bin__ind_progress_ext = $bin__ind_progress_ext;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_ssn_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_ssn_display(): ?string
    {
        return $this->bin__ind_ssn_display ?? null;
    }
    /**
     * Set bin__ind_ssn_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_ssn_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_ssn_display(?string $bin__ind_ssn_display = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_ssn_display) && !is_string($bin__ind_ssn_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_ssn_display, true), gettype($bin__ind_ssn_display)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bin__ind_ssn_display) && mb_strlen((string) $bin__ind_ssn_display) > 11) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen((string) $bin__ind_ssn_display)), __LINE__);
        }
        if (is_null($bin__ind_ssn_display) || (is_array($bin__ind_ssn_display) && empty($bin__ind_ssn_display))) {
            unset($this->bin__ind_ssn_display);
        } else {
            $this->bin__ind_ssn_display = $bin__ind_ssn_display;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_aicpa_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_aicpa_id(): ?string
    {
        return $this->bin__ind_aicpa_id ?? null;
    }
    /**
     * Set bin__ind_aicpa_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_aicpa_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_aicpa_id(?string $bin__ind_aicpa_id = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_aicpa_id) && !is_string($bin__ind_aicpa_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_aicpa_id, true), gettype($bin__ind_aicpa_id)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bin__ind_aicpa_id) && mb_strlen((string) $bin__ind_aicpa_id) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $bin__ind_aicpa_id)), __LINE__);
        }
        if (is_null($bin__ind_aicpa_id) || (is_array($bin__ind_aicpa_id) && empty($bin__ind_aicpa_id))) {
            unset($this->bin__ind_aicpa_id);
        } else {
            $this->bin__ind_aicpa_id = $bin__ind_aicpa_id;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_deceased_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_deceased_date(): ?string
    {
        return $this->bin__ind_deceased_date ?? null;
    }
    /**
     * Set bin__ind_deceased_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_deceased_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_deceased_date(?string $bin__ind_deceased_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_deceased_date) && !is_string($bin__ind_deceased_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_deceased_date, true), gettype($bin__ind_deceased_date)), __LINE__);
        }
        if (is_null($bin__ind_deceased_date) || (is_array($bin__ind_deceased_date) && empty($bin__ind_deceased_date))) {
            unset($this->bin__ind_deceased_date);
        } else {
            $this->bin__ind_deceased_date = $bin__ind_deceased_date;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_prn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_prn_code(): ?string
    {
        return $this->bin__ind_prn_code ?? null;
    }
    /**
     * Set bin__ind_prn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_prn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_prn_code(?string $bin__ind_prn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_prn_code) && !is_string($bin__ind_prn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_prn_code, true), gettype($bin__ind_prn_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bin__ind_prn_code) && mb_strlen((string) $bin__ind_prn_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bin__ind_prn_code)), __LINE__);
        }
        if (is_null($bin__ind_prn_code) || (is_array($bin__ind_prn_code) && empty($bin__ind_prn_code))) {
            unset($this->bin__ind_prn_code);
        } else {
            $this->bin__ind_prn_code = $bin__ind_prn_code;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_popup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_popup(): ?string
    {
        return $this->bin__ind_popup ?? null;
    }
    /**
     * Set bin__ind_popup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_popup
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_popup(?string $bin__ind_popup = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_popup) && !is_string($bin__ind_popup)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_popup, true), gettype($bin__ind_popup)), __LINE__);
        }
        if (is_null($bin__ind_popup) || (is_array($bin__ind_popup) && empty($bin__ind_popup))) {
            unset($this->bin__ind_popup);
        } else {
            $this->bin__ind_popup = $bin__ind_popup;
        }
        
        return $this;
    }
    /**
     * Get bin__ind_anonymization_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin__ind_anonymization_status(): ?string
    {
        return $this->bin__ind_anonymization_status ?? null;
    }
    /**
     * Set bin__ind_anonymization_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin__ind_anonymization_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_BillToCustomerIndividual_DataObjectType
     */
    public function setBin__ind_anonymization_status(?string $bin__ind_anonymization_status = null): self
    {
        // validation for constraint: string
        if (!is_null($bin__ind_anonymization_status) && !is_string($bin__ind_anonymization_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin__ind_anonymization_status, true), gettype($bin__ind_anonymization_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bin__ind_anonymization_status) && mb_strlen((string) $bin__ind_anonymization_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $bin__ind_anonymization_status)), __LINE__);
        }
        if (is_null($bin__ind_anonymization_status) || (is_array($bin__ind_anonymization_status) && empty($bin__ind_anonymization_status))) {
            unset($this->bin__ind_anonymization_status);
        } else {
            $this->bin__ind_anonymization_status = $bin__ind_anonymization_status;
        }
        
        return $this;
    }
}
