<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType extends AbstractStructBase
{
    /**
     * The trm_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_ivd_key = null;
    /**
     * The trm_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_start_date = null;
    /**
     * The trm_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_end_date = null;
    /**
     * The trm_original_end_date
     * Meta information extracted from the WSDL
     * - documentation: Original End Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_original_end_date = null;
    /**
     * The trm_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_add_user = null;
    /**
     * The trm_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_add_date = null;
    /**
     * The trm_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_change_user = null;
    /**
     * The trm_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_entity_key = null;
    /**
     * The trm_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_change_date = null;
    /**
     * The trm_ivd_key_previous
     * Meta information extracted from the WSDL
     * - documentation: Previous Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_ivd_key_previous = null;
    /**
     * The trm_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_delete_flag = null;
    /**
     * The trm_do_not_renew_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Renew. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_do_not_renew_flag = null;
    /**
     * The trm_ivd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_ivd_key_ext = null;
    /**
     * The trm_sui_prd_key_start
     * Meta information extracted from the WSDL
     * - documentation: Start Issue. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_sui_prd_key_start = null;
    /**
     * The trm_sui_prd_key_hold_start
     * Meta information extracted from the WSDL
     * - documentation: On Hold Start Issue. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_sui_prd_key_hold_start = null;
    /**
     * The trm_number_fulfilled
     * Meta information extracted from the WSDL
     * - documentation: Number Fulfilled. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $trm_number_fulfilled = null;
    /**
     * The trm_sui_prd_key_hold_end
     * Meta information extracted from the WSDL
     * - documentation: On Hold End Issue. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_sui_prd_key_hold_end = null;
    /**
     * The trm_num_issues
     * Meta information extracted from the WSDL
     * - documentation: Number of Issues. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $trm_num_issues = null;
    /**
     * The trm_num_issues_remain_cp
     * Meta information extracted from the WSDL
     * - documentation: Issues Remaining. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $trm_num_issues_remain_cp = null;
    /**
     * The trm_cla_key
     * Meta information extracted from the WSDL
     * - documentation: Classification. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_cla_key = null;
    /**
     * The trm_qualified_flag
     * Meta information extracted from the WSDL
     * - documentation: Qualified Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_qualified_flag = null;
    /**
     * The trm_qualified_date
     * Meta information extracted from the WSDL
     * - documentation: Qualified Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_qualified_date = null;
    /**
     * The trm_rqt_key
     * Meta information extracted from the WSDL
     * - documentation: Request Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_rqt_key = null;
    /**
     * The trm_controlled_flag
     * Meta information extracted from the WSDL
     * - documentation: Controlled?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_controlled_flag = null;
    /**
     * The trm_requested_flag
     * Meta information extracted from the WSDL
     * - documentation: Requested?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_requested_flag = null;
    /**
     * The trm_sin_key
     * Meta information extracted from the WSDL
     * - documentation: Industry. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_sin_key = null;
    /**
     * The trm_ttl_key
     * Meta information extracted from the WSDL
     * - documentation: Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_ttl_key = null;
    /**
     * The trm_jfn_key
     * Meta information extracted from the WSDL
     * - documentation: Job Function. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_jfn_key = null;
    /**
     * The trm_demog1
     * Meta information extracted from the WSDL
     * - documentation: Demographics 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_demog1 = null;
    /**
     * The trm_demog2
     * Meta information extracted from the WSDL
     * - documentation: Demographics 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_demog2 = null;
    /**
     * The trm_demog3
     * Meta information extracted from the WSDL
     * - documentation: Demographics 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_demog3 = null;
    /**
     * The trm_demog4
     * Meta information extracted from the WSDL
     * - documentation: Demographics 4. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_demog4 = null;
    /**
     * The trm_demog5
     * Meta information extracted from the WSDL
     * - documentation: Demographics 5. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_demog5 = null;
    /**
     * The trm_cancel_flag
     * Meta information extracted from the WSDL
     * - documentation: Cancel Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_cancel_flag = null;
    /**
     * The trm_ivd_prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_ivd_prc_prd_key = null;
    /**
     * The trm_lifetime_flag
     * Meta information extracted from the WSDL
     * - documentation: Lifetime?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_lifetime_flag = null;
    /**
     * The trm_grace_issues_cp
     * Meta information extracted from the WSDL
     * - documentation: Grace Issues Fulfilled. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $trm_grace_issues_cp = null;
    /**
     * The trm_sui_prd_key_drop
     * Meta information extracted from the WSDL
     * - documentation: Drop Issue. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_sui_prd_key_drop = null;
    /**
     * The trm_add_drop_flag
     * Meta information extracted from the WSDL
     * - documentation: Subscriber Add/Drop. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_add_drop_flag = null;
    /**
     * The trm_mbr_key
     * Meta information extracted from the WSDL
     * - documentation: National Membership to Sync Dates. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_mbr_key = null;
    /**
     * The trm_mxi_key
     * Meta information extracted from the WSDL
     * - documentation: National Membership to Sync Dates MXI. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_mxi_key = null;
    /**
     * The trm_reference_num
     * Meta information extracted from the WSDL
     * - documentation: Reference Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_reference_num = null;
    /**
     * The trm_auto_pay_flag
     * Meta information extracted from the WSDL
     * - documentation: Auto Pay Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_auto_pay_flag = null;
    /**
     * The trm_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Auto Pay CPI Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $trm_cpi_key = null;
    /**
     * The trm_issues_fulfilled
     * Meta information extracted from the WSDL
     * - documentation: Issues Fulfilled. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $trm_issues_fulfilled = null;
    /**
     * The trm_cpi_consent_date
     * Meta information extracted from the WSDL
     * - documentation: Date cardholder consented to store their payment info for installment/recurring/renewal payments.. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $trm_cpi_consent_date = null;
    /**
     * Constructor method for CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_ivd_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_start_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_end_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_original_end_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_add_user()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_add_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_change_user()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_entity_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_change_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_ivd_key_previous()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_delete_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_do_not_renew_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_ivd_key_ext()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_sui_prd_key_start()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_sui_prd_key_hold_start()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_number_fulfilled()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_sui_prd_key_hold_end()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_num_issues()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_num_issues_remain_cp()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_cla_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_qualified_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_qualified_date()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_rqt_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_controlled_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_requested_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_sin_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_ttl_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_jfn_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_demog1()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_demog2()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_demog3()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_demog4()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_demog5()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_cancel_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_ivd_prc_prd_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_lifetime_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_grace_issues_cp()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_sui_prd_key_drop()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_add_drop_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_mbr_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_mxi_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_reference_num()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_auto_pay_flag()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_cpi_key()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_issues_fulfilled()
     * @uses CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType::setTrm_cpi_consent_date()
     * @param string $trm_ivd_key
     * @param string $trm_start_date
     * @param string $trm_end_date
     * @param string $trm_original_end_date
     * @param string $trm_add_user
     * @param string $trm_add_date
     * @param string $trm_change_user
     * @param string $trm_entity_key
     * @param string $trm_change_date
     * @param string $trm_ivd_key_previous
     * @param string $trm_delete_flag
     * @param string $trm_do_not_renew_flag
     * @param string $trm_ivd_key_ext
     * @param string $trm_sui_prd_key_start
     * @param string $trm_sui_prd_key_hold_start
     * @param int $trm_number_fulfilled
     * @param string $trm_sui_prd_key_hold_end
     * @param int $trm_num_issues
     * @param int $trm_num_issues_remain_cp
     * @param string $trm_cla_key
     * @param string $trm_qualified_flag
     * @param string $trm_qualified_date
     * @param string $trm_rqt_key
     * @param string $trm_controlled_flag
     * @param string $trm_requested_flag
     * @param string $trm_sin_key
     * @param string $trm_ttl_key
     * @param string $trm_jfn_key
     * @param string $trm_demog1
     * @param string $trm_demog2
     * @param string $trm_demog3
     * @param string $trm_demog4
     * @param string $trm_demog5
     * @param string $trm_cancel_flag
     * @param string $trm_ivd_prc_prd_key
     * @param string $trm_lifetime_flag
     * @param int $trm_grace_issues_cp
     * @param string $trm_sui_prd_key_drop
     * @param string $trm_add_drop_flag
     * @param string $trm_mbr_key
     * @param string $trm_mxi_key
     * @param string $trm_reference_num
     * @param string $trm_auto_pay_flag
     * @param string $trm_cpi_key
     * @param int $trm_issues_fulfilled
     * @param string $trm_cpi_consent_date
     */
    public function __construct(?string $trm_ivd_key = null, ?string $trm_start_date = null, ?string $trm_end_date = null, ?string $trm_original_end_date = null, ?string $trm_add_user = null, ?string $trm_add_date = null, ?string $trm_change_user = null, ?string $trm_entity_key = null, ?string $trm_change_date = null, ?string $trm_ivd_key_previous = null, ?string $trm_delete_flag = null, ?string $trm_do_not_renew_flag = null, ?string $trm_ivd_key_ext = null, ?string $trm_sui_prd_key_start = null, ?string $trm_sui_prd_key_hold_start = null, ?int $trm_number_fulfilled = null, ?string $trm_sui_prd_key_hold_end = null, ?int $trm_num_issues = null, ?int $trm_num_issues_remain_cp = null, ?string $trm_cla_key = null, ?string $trm_qualified_flag = null, ?string $trm_qualified_date = null, ?string $trm_rqt_key = null, ?string $trm_controlled_flag = null, ?string $trm_requested_flag = null, ?string $trm_sin_key = null, ?string $trm_ttl_key = null, ?string $trm_jfn_key = null, ?string $trm_demog1 = null, ?string $trm_demog2 = null, ?string $trm_demog3 = null, ?string $trm_demog4 = null, ?string $trm_demog5 = null, ?string $trm_cancel_flag = null, ?string $trm_ivd_prc_prd_key = null, ?string $trm_lifetime_flag = null, ?int $trm_grace_issues_cp = null, ?string $trm_sui_prd_key_drop = null, ?string $trm_add_drop_flag = null, ?string $trm_mbr_key = null, ?string $trm_mxi_key = null, ?string $trm_reference_num = null, ?string $trm_auto_pay_flag = null, ?string $trm_cpi_key = null, ?int $trm_issues_fulfilled = null, ?string $trm_cpi_consent_date = null)
    {
        $this
            ->setTrm_ivd_key($trm_ivd_key)
            ->setTrm_start_date($trm_start_date)
            ->setTrm_end_date($trm_end_date)
            ->setTrm_original_end_date($trm_original_end_date)
            ->setTrm_add_user($trm_add_user)
            ->setTrm_add_date($trm_add_date)
            ->setTrm_change_user($trm_change_user)
            ->setTrm_entity_key($trm_entity_key)
            ->setTrm_change_date($trm_change_date)
            ->setTrm_ivd_key_previous($trm_ivd_key_previous)
            ->setTrm_delete_flag($trm_delete_flag)
            ->setTrm_do_not_renew_flag($trm_do_not_renew_flag)
            ->setTrm_ivd_key_ext($trm_ivd_key_ext)
            ->setTrm_sui_prd_key_start($trm_sui_prd_key_start)
            ->setTrm_sui_prd_key_hold_start($trm_sui_prd_key_hold_start)
            ->setTrm_number_fulfilled($trm_number_fulfilled)
            ->setTrm_sui_prd_key_hold_end($trm_sui_prd_key_hold_end)
            ->setTrm_num_issues($trm_num_issues)
            ->setTrm_num_issues_remain_cp($trm_num_issues_remain_cp)
            ->setTrm_cla_key($trm_cla_key)
            ->setTrm_qualified_flag($trm_qualified_flag)
            ->setTrm_qualified_date($trm_qualified_date)
            ->setTrm_rqt_key($trm_rqt_key)
            ->setTrm_controlled_flag($trm_controlled_flag)
            ->setTrm_requested_flag($trm_requested_flag)
            ->setTrm_sin_key($trm_sin_key)
            ->setTrm_ttl_key($trm_ttl_key)
            ->setTrm_jfn_key($trm_jfn_key)
            ->setTrm_demog1($trm_demog1)
            ->setTrm_demog2($trm_demog2)
            ->setTrm_demog3($trm_demog3)
            ->setTrm_demog4($trm_demog4)
            ->setTrm_demog5($trm_demog5)
            ->setTrm_cancel_flag($trm_cancel_flag)
            ->setTrm_ivd_prc_prd_key($trm_ivd_prc_prd_key)
            ->setTrm_lifetime_flag($trm_lifetime_flag)
            ->setTrm_grace_issues_cp($trm_grace_issues_cp)
            ->setTrm_sui_prd_key_drop($trm_sui_prd_key_drop)
            ->setTrm_add_drop_flag($trm_add_drop_flag)
            ->setTrm_mbr_key($trm_mbr_key)
            ->setTrm_mxi_key($trm_mxi_key)
            ->setTrm_reference_num($trm_reference_num)
            ->setTrm_auto_pay_flag($trm_auto_pay_flag)
            ->setTrm_cpi_key($trm_cpi_key)
            ->setTrm_issues_fulfilled($trm_issues_fulfilled)
            ->setTrm_cpi_consent_date($trm_cpi_consent_date);
    }
    /**
     * Get trm_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_ivd_key(): ?string
    {
        return $this->trm_ivd_key ?? null;
    }
    /**
     * Set trm_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_ivd_key(?string $trm_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_ivd_key) && !is_string($trm_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_ivd_key, true), gettype($trm_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_ivd_key, true)), __LINE__);
        }
        if (is_null($trm_ivd_key) || (is_array($trm_ivd_key) && empty($trm_ivd_key))) {
            unset($this->trm_ivd_key);
        } else {
            $this->trm_ivd_key = $trm_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get trm_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_start_date(): ?string
    {
        return $this->trm_start_date ?? null;
    }
    /**
     * Set trm_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_start_date(?string $trm_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_start_date) && !is_string($trm_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_start_date, true), gettype($trm_start_date)), __LINE__);
        }
        if (is_null($trm_start_date) || (is_array($trm_start_date) && empty($trm_start_date))) {
            unset($this->trm_start_date);
        } else {
            $this->trm_start_date = $trm_start_date;
        }
        
        return $this;
    }
    /**
     * Get trm_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_end_date(): ?string
    {
        return $this->trm_end_date ?? null;
    }
    /**
     * Set trm_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_end_date(?string $trm_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_end_date) && !is_string($trm_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_end_date, true), gettype($trm_end_date)), __LINE__);
        }
        if (is_null($trm_end_date) || (is_array($trm_end_date) && empty($trm_end_date))) {
            unset($this->trm_end_date);
        } else {
            $this->trm_end_date = $trm_end_date;
        }
        
        return $this;
    }
    /**
     * Get trm_original_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_original_end_date(): ?string
    {
        return $this->trm_original_end_date ?? null;
    }
    /**
     * Set trm_original_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_original_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_original_end_date(?string $trm_original_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_original_end_date) && !is_string($trm_original_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_original_end_date, true), gettype($trm_original_end_date)), __LINE__);
        }
        if (is_null($trm_original_end_date) || (is_array($trm_original_end_date) && empty($trm_original_end_date))) {
            unset($this->trm_original_end_date);
        } else {
            $this->trm_original_end_date = $trm_original_end_date;
        }
        
        return $this;
    }
    /**
     * Get trm_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_add_user(): ?string
    {
        return $this->trm_add_user ?? null;
    }
    /**
     * Set trm_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_add_user(?string $trm_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_add_user) && !is_string($trm_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_add_user, true), gettype($trm_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($trm_add_user) && mb_strlen((string) $trm_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $trm_add_user)), __LINE__);
        }
        if (is_null($trm_add_user) || (is_array($trm_add_user) && empty($trm_add_user))) {
            unset($this->trm_add_user);
        } else {
            $this->trm_add_user = $trm_add_user;
        }
        
        return $this;
    }
    /**
     * Get trm_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_add_date(): ?string
    {
        return $this->trm_add_date ?? null;
    }
    /**
     * Set trm_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_add_date(?string $trm_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_add_date) && !is_string($trm_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_add_date, true), gettype($trm_add_date)), __LINE__);
        }
        if (is_null($trm_add_date) || (is_array($trm_add_date) && empty($trm_add_date))) {
            unset($this->trm_add_date);
        } else {
            $this->trm_add_date = $trm_add_date;
        }
        
        return $this;
    }
    /**
     * Get trm_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_change_user(): ?string
    {
        return $this->trm_change_user ?? null;
    }
    /**
     * Set trm_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_change_user(?string $trm_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_change_user) && !is_string($trm_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_change_user, true), gettype($trm_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($trm_change_user) && mb_strlen((string) $trm_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $trm_change_user)), __LINE__);
        }
        if (is_null($trm_change_user) || (is_array($trm_change_user) && empty($trm_change_user))) {
            unset($this->trm_change_user);
        } else {
            $this->trm_change_user = $trm_change_user;
        }
        
        return $this;
    }
    /**
     * Get trm_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_entity_key(): ?string
    {
        return $this->trm_entity_key ?? null;
    }
    /**
     * Set trm_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_entity_key(?string $trm_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_entity_key) && !is_string($trm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_entity_key, true), gettype($trm_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_entity_key, true)), __LINE__);
        }
        if (is_null($trm_entity_key) || (is_array($trm_entity_key) && empty($trm_entity_key))) {
            unset($this->trm_entity_key);
        } else {
            $this->trm_entity_key = $trm_entity_key;
        }
        
        return $this;
    }
    /**
     * Get trm_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_change_date(): ?string
    {
        return $this->trm_change_date ?? null;
    }
    /**
     * Set trm_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_change_date(?string $trm_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_change_date) && !is_string($trm_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_change_date, true), gettype($trm_change_date)), __LINE__);
        }
        if (is_null($trm_change_date) || (is_array($trm_change_date) && empty($trm_change_date))) {
            unset($this->trm_change_date);
        } else {
            $this->trm_change_date = $trm_change_date;
        }
        
        return $this;
    }
    /**
     * Get trm_ivd_key_previous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_ivd_key_previous(): ?string
    {
        return $this->trm_ivd_key_previous ?? null;
    }
    /**
     * Set trm_ivd_key_previous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_ivd_key_previous
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_ivd_key_previous(?string $trm_ivd_key_previous = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_ivd_key_previous) && !is_string($trm_ivd_key_previous)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_ivd_key_previous, true), gettype($trm_ivd_key_previous)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_ivd_key_previous) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_ivd_key_previous)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_ivd_key_previous, true)), __LINE__);
        }
        if (is_null($trm_ivd_key_previous) || (is_array($trm_ivd_key_previous) && empty($trm_ivd_key_previous))) {
            unset($this->trm_ivd_key_previous);
        } else {
            $this->trm_ivd_key_previous = $trm_ivd_key_previous;
        }
        
        return $this;
    }
    /**
     * Get trm_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_delete_flag(): ?string
    {
        return $this->trm_delete_flag ?? null;
    }
    /**
     * Set trm_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_delete_flag(?string $trm_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_delete_flag) && !is_string($trm_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_delete_flag, true), gettype($trm_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_delete_flag) && $trm_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_delete_flag) && $trm_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_delete_flag, true)), __LINE__);
        }
        if (is_null($trm_delete_flag) || (is_array($trm_delete_flag) && empty($trm_delete_flag))) {
            unset($this->trm_delete_flag);
        } else {
            $this->trm_delete_flag = $trm_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_do_not_renew_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_do_not_renew_flag(): ?string
    {
        return $this->trm_do_not_renew_flag ?? null;
    }
    /**
     * Set trm_do_not_renew_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_do_not_renew_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_do_not_renew_flag(?string $trm_do_not_renew_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_do_not_renew_flag) && !is_string($trm_do_not_renew_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_do_not_renew_flag, true), gettype($trm_do_not_renew_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_do_not_renew_flag) && $trm_do_not_renew_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_do_not_renew_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_do_not_renew_flag) && $trm_do_not_renew_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_do_not_renew_flag, true)), __LINE__);
        }
        if (is_null($trm_do_not_renew_flag) || (is_array($trm_do_not_renew_flag) && empty($trm_do_not_renew_flag))) {
            unset($this->trm_do_not_renew_flag);
        } else {
            $this->trm_do_not_renew_flag = $trm_do_not_renew_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_ivd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_ivd_key_ext(): ?string
    {
        return $this->trm_ivd_key_ext ?? null;
    }
    /**
     * Set trm_ivd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_ivd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_ivd_key_ext(?string $trm_ivd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_ivd_key_ext) && !is_string($trm_ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_ivd_key_ext, true), gettype($trm_ivd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_ivd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_ivd_key_ext, true)), __LINE__);
        }
        if (is_null($trm_ivd_key_ext) || (is_array($trm_ivd_key_ext) && empty($trm_ivd_key_ext))) {
            unset($this->trm_ivd_key_ext);
        } else {
            $this->trm_ivd_key_ext = $trm_ivd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get trm_sui_prd_key_start value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_sui_prd_key_start(): ?string
    {
        return $this->trm_sui_prd_key_start ?? null;
    }
    /**
     * Set trm_sui_prd_key_start value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_sui_prd_key_start
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_sui_prd_key_start(?string $trm_sui_prd_key_start = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_sui_prd_key_start) && !is_string($trm_sui_prd_key_start)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_sui_prd_key_start, true), gettype($trm_sui_prd_key_start)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_sui_prd_key_start) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_sui_prd_key_start)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_sui_prd_key_start, true)), __LINE__);
        }
        if (is_null($trm_sui_prd_key_start) || (is_array($trm_sui_prd_key_start) && empty($trm_sui_prd_key_start))) {
            unset($this->trm_sui_prd_key_start);
        } else {
            $this->trm_sui_prd_key_start = $trm_sui_prd_key_start;
        }
        
        return $this;
    }
    /**
     * Get trm_sui_prd_key_hold_start value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_sui_prd_key_hold_start(): ?string
    {
        return $this->trm_sui_prd_key_hold_start ?? null;
    }
    /**
     * Set trm_sui_prd_key_hold_start value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_sui_prd_key_hold_start
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_sui_prd_key_hold_start(?string $trm_sui_prd_key_hold_start = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_sui_prd_key_hold_start) && !is_string($trm_sui_prd_key_hold_start)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_sui_prd_key_hold_start, true), gettype($trm_sui_prd_key_hold_start)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_sui_prd_key_hold_start) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_sui_prd_key_hold_start)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_sui_prd_key_hold_start, true)), __LINE__);
        }
        if (is_null($trm_sui_prd_key_hold_start) || (is_array($trm_sui_prd_key_hold_start) && empty($trm_sui_prd_key_hold_start))) {
            unset($this->trm_sui_prd_key_hold_start);
        } else {
            $this->trm_sui_prd_key_hold_start = $trm_sui_prd_key_hold_start;
        }
        
        return $this;
    }
    /**
     * Get trm_number_fulfilled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrm_number_fulfilled(): ?int
    {
        return $this->trm_number_fulfilled ?? null;
    }
    /**
     * Set trm_number_fulfilled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trm_number_fulfilled
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_number_fulfilled(?int $trm_number_fulfilled = null): self
    {
        // validation for constraint: int
        if (!is_null($trm_number_fulfilled) && !(is_int($trm_number_fulfilled) || ctype_digit($trm_number_fulfilled))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trm_number_fulfilled, true), gettype($trm_number_fulfilled)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($trm_number_fulfilled) && $trm_number_fulfilled > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($trm_number_fulfilled, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($trm_number_fulfilled) && $trm_number_fulfilled < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($trm_number_fulfilled, true)), __LINE__);
        }
        if (is_null($trm_number_fulfilled) || (is_array($trm_number_fulfilled) && empty($trm_number_fulfilled))) {
            unset($this->trm_number_fulfilled);
        } else {
            $this->trm_number_fulfilled = $trm_number_fulfilled;
        }
        
        return $this;
    }
    /**
     * Get trm_sui_prd_key_hold_end value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_sui_prd_key_hold_end(): ?string
    {
        return $this->trm_sui_prd_key_hold_end ?? null;
    }
    /**
     * Set trm_sui_prd_key_hold_end value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_sui_prd_key_hold_end
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_sui_prd_key_hold_end(?string $trm_sui_prd_key_hold_end = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_sui_prd_key_hold_end) && !is_string($trm_sui_prd_key_hold_end)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_sui_prd_key_hold_end, true), gettype($trm_sui_prd_key_hold_end)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_sui_prd_key_hold_end) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_sui_prd_key_hold_end)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_sui_prd_key_hold_end, true)), __LINE__);
        }
        if (is_null($trm_sui_prd_key_hold_end) || (is_array($trm_sui_prd_key_hold_end) && empty($trm_sui_prd_key_hold_end))) {
            unset($this->trm_sui_prd_key_hold_end);
        } else {
            $this->trm_sui_prd_key_hold_end = $trm_sui_prd_key_hold_end;
        }
        
        return $this;
    }
    /**
     * Get trm_num_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrm_num_issues(): ?int
    {
        return $this->trm_num_issues ?? null;
    }
    /**
     * Set trm_num_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trm_num_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_num_issues(?int $trm_num_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($trm_num_issues) && !(is_int($trm_num_issues) || ctype_digit($trm_num_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trm_num_issues, true), gettype($trm_num_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($trm_num_issues) && $trm_num_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($trm_num_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($trm_num_issues) && $trm_num_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($trm_num_issues, true)), __LINE__);
        }
        if (is_null($trm_num_issues) || (is_array($trm_num_issues) && empty($trm_num_issues))) {
            unset($this->trm_num_issues);
        } else {
            $this->trm_num_issues = $trm_num_issues;
        }
        
        return $this;
    }
    /**
     * Get trm_num_issues_remain_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrm_num_issues_remain_cp(): ?int
    {
        return $this->trm_num_issues_remain_cp ?? null;
    }
    /**
     * Set trm_num_issues_remain_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trm_num_issues_remain_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_num_issues_remain_cp(?int $trm_num_issues_remain_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($trm_num_issues_remain_cp) && !(is_int($trm_num_issues_remain_cp) || ctype_digit($trm_num_issues_remain_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trm_num_issues_remain_cp, true), gettype($trm_num_issues_remain_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($trm_num_issues_remain_cp) && $trm_num_issues_remain_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($trm_num_issues_remain_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($trm_num_issues_remain_cp) && $trm_num_issues_remain_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($trm_num_issues_remain_cp, true)), __LINE__);
        }
        if (is_null($trm_num_issues_remain_cp) || (is_array($trm_num_issues_remain_cp) && empty($trm_num_issues_remain_cp))) {
            unset($this->trm_num_issues_remain_cp);
        } else {
            $this->trm_num_issues_remain_cp = $trm_num_issues_remain_cp;
        }
        
        return $this;
    }
    /**
     * Get trm_cla_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_cla_key(): ?string
    {
        return $this->trm_cla_key ?? null;
    }
    /**
     * Set trm_cla_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_cla_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_cla_key(?string $trm_cla_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_cla_key) && !is_string($trm_cla_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_cla_key, true), gettype($trm_cla_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_cla_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_cla_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_cla_key, true)), __LINE__);
        }
        if (is_null($trm_cla_key) || (is_array($trm_cla_key) && empty($trm_cla_key))) {
            unset($this->trm_cla_key);
        } else {
            $this->trm_cla_key = $trm_cla_key;
        }
        
        return $this;
    }
    /**
     * Get trm_qualified_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_qualified_flag(): ?string
    {
        return $this->trm_qualified_flag ?? null;
    }
    /**
     * Set trm_qualified_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_qualified_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_qualified_flag(?string $trm_qualified_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_qualified_flag) && !is_string($trm_qualified_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_qualified_flag, true), gettype($trm_qualified_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_qualified_flag) && $trm_qualified_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_qualified_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_qualified_flag) && $trm_qualified_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_qualified_flag, true)), __LINE__);
        }
        if (is_null($trm_qualified_flag) || (is_array($trm_qualified_flag) && empty($trm_qualified_flag))) {
            unset($this->trm_qualified_flag);
        } else {
            $this->trm_qualified_flag = $trm_qualified_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_qualified_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_qualified_date(): ?string
    {
        return $this->trm_qualified_date ?? null;
    }
    /**
     * Set trm_qualified_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_qualified_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_qualified_date(?string $trm_qualified_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_qualified_date) && !is_string($trm_qualified_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_qualified_date, true), gettype($trm_qualified_date)), __LINE__);
        }
        if (is_null($trm_qualified_date) || (is_array($trm_qualified_date) && empty($trm_qualified_date))) {
            unset($this->trm_qualified_date);
        } else {
            $this->trm_qualified_date = $trm_qualified_date;
        }
        
        return $this;
    }
    /**
     * Get trm_rqt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_rqt_key(): ?string
    {
        return $this->trm_rqt_key ?? null;
    }
    /**
     * Set trm_rqt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_rqt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_rqt_key(?string $trm_rqt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_rqt_key) && !is_string($trm_rqt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_rqt_key, true), gettype($trm_rqt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_rqt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_rqt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_rqt_key, true)), __LINE__);
        }
        if (is_null($trm_rqt_key) || (is_array($trm_rqt_key) && empty($trm_rqt_key))) {
            unset($this->trm_rqt_key);
        } else {
            $this->trm_rqt_key = $trm_rqt_key;
        }
        
        return $this;
    }
    /**
     * Get trm_controlled_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_controlled_flag(): ?string
    {
        return $this->trm_controlled_flag ?? null;
    }
    /**
     * Set trm_controlled_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_controlled_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_controlled_flag(?string $trm_controlled_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_controlled_flag) && !is_string($trm_controlled_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_controlled_flag, true), gettype($trm_controlled_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_controlled_flag) && $trm_controlled_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_controlled_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_controlled_flag) && $trm_controlled_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_controlled_flag, true)), __LINE__);
        }
        if (is_null($trm_controlled_flag) || (is_array($trm_controlled_flag) && empty($trm_controlled_flag))) {
            unset($this->trm_controlled_flag);
        } else {
            $this->trm_controlled_flag = $trm_controlled_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_requested_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_requested_flag(): ?string
    {
        return $this->trm_requested_flag ?? null;
    }
    /**
     * Set trm_requested_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_requested_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_requested_flag(?string $trm_requested_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_requested_flag) && !is_string($trm_requested_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_requested_flag, true), gettype($trm_requested_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_requested_flag) && $trm_requested_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_requested_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_requested_flag) && $trm_requested_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_requested_flag, true)), __LINE__);
        }
        if (is_null($trm_requested_flag) || (is_array($trm_requested_flag) && empty($trm_requested_flag))) {
            unset($this->trm_requested_flag);
        } else {
            $this->trm_requested_flag = $trm_requested_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_sin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_sin_key(): ?string
    {
        return $this->trm_sin_key ?? null;
    }
    /**
     * Set trm_sin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_sin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_sin_key(?string $trm_sin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_sin_key) && !is_string($trm_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_sin_key, true), gettype($trm_sin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_sin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_sin_key, true)), __LINE__);
        }
        if (is_null($trm_sin_key) || (is_array($trm_sin_key) && empty($trm_sin_key))) {
            unset($this->trm_sin_key);
        } else {
            $this->trm_sin_key = $trm_sin_key;
        }
        
        return $this;
    }
    /**
     * Get trm_ttl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_ttl_key(): ?string
    {
        return $this->trm_ttl_key ?? null;
    }
    /**
     * Set trm_ttl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_ttl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_ttl_key(?string $trm_ttl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_ttl_key) && !is_string($trm_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_ttl_key, true), gettype($trm_ttl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_ttl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_ttl_key, true)), __LINE__);
        }
        if (is_null($trm_ttl_key) || (is_array($trm_ttl_key) && empty($trm_ttl_key))) {
            unset($this->trm_ttl_key);
        } else {
            $this->trm_ttl_key = $trm_ttl_key;
        }
        
        return $this;
    }
    /**
     * Get trm_jfn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_jfn_key(): ?string
    {
        return $this->trm_jfn_key ?? null;
    }
    /**
     * Set trm_jfn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_jfn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_jfn_key(?string $trm_jfn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_jfn_key) && !is_string($trm_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_jfn_key, true), gettype($trm_jfn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_jfn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_jfn_key, true)), __LINE__);
        }
        if (is_null($trm_jfn_key) || (is_array($trm_jfn_key) && empty($trm_jfn_key))) {
            unset($this->trm_jfn_key);
        } else {
            $this->trm_jfn_key = $trm_jfn_key;
        }
        
        return $this;
    }
    /**
     * Get trm_demog1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_demog1(): ?string
    {
        return $this->trm_demog1 ?? null;
    }
    /**
     * Set trm_demog1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_demog1
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_demog1(?string $trm_demog1 = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_demog1) && !is_string($trm_demog1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_demog1, true), gettype($trm_demog1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($trm_demog1) && mb_strlen((string) $trm_demog1) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $trm_demog1)), __LINE__);
        }
        if (is_null($trm_demog1) || (is_array($trm_demog1) && empty($trm_demog1))) {
            unset($this->trm_demog1);
        } else {
            $this->trm_demog1 = $trm_demog1;
        }
        
        return $this;
    }
    /**
     * Get trm_demog2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_demog2(): ?string
    {
        return $this->trm_demog2 ?? null;
    }
    /**
     * Set trm_demog2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_demog2
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_demog2(?string $trm_demog2 = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_demog2) && !is_string($trm_demog2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_demog2, true), gettype($trm_demog2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($trm_demog2) && mb_strlen((string) $trm_demog2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $trm_demog2)), __LINE__);
        }
        if (is_null($trm_demog2) || (is_array($trm_demog2) && empty($trm_demog2))) {
            unset($this->trm_demog2);
        } else {
            $this->trm_demog2 = $trm_demog2;
        }
        
        return $this;
    }
    /**
     * Get trm_demog3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_demog3(): ?string
    {
        return $this->trm_demog3 ?? null;
    }
    /**
     * Set trm_demog3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_demog3
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_demog3(?string $trm_demog3 = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_demog3) && !is_string($trm_demog3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_demog3, true), gettype($trm_demog3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($trm_demog3) && mb_strlen((string) $trm_demog3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $trm_demog3)), __LINE__);
        }
        if (is_null($trm_demog3) || (is_array($trm_demog3) && empty($trm_demog3))) {
            unset($this->trm_demog3);
        } else {
            $this->trm_demog3 = $trm_demog3;
        }
        
        return $this;
    }
    /**
     * Get trm_demog4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_demog4(): ?string
    {
        return $this->trm_demog4 ?? null;
    }
    /**
     * Set trm_demog4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_demog4
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_demog4(?string $trm_demog4 = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_demog4) && !is_string($trm_demog4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_demog4, true), gettype($trm_demog4)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($trm_demog4) && mb_strlen((string) $trm_demog4) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $trm_demog4)), __LINE__);
        }
        if (is_null($trm_demog4) || (is_array($trm_demog4) && empty($trm_demog4))) {
            unset($this->trm_demog4);
        } else {
            $this->trm_demog4 = $trm_demog4;
        }
        
        return $this;
    }
    /**
     * Get trm_demog5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_demog5(): ?string
    {
        return $this->trm_demog5 ?? null;
    }
    /**
     * Set trm_demog5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_demog5
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_demog5(?string $trm_demog5 = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_demog5) && !is_string($trm_demog5)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_demog5, true), gettype($trm_demog5)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($trm_demog5) && mb_strlen((string) $trm_demog5) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $trm_demog5)), __LINE__);
        }
        if (is_null($trm_demog5) || (is_array($trm_demog5) && empty($trm_demog5))) {
            unset($this->trm_demog5);
        } else {
            $this->trm_demog5 = $trm_demog5;
        }
        
        return $this;
    }
    /**
     * Get trm_cancel_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_cancel_flag(): ?string
    {
        return $this->trm_cancel_flag ?? null;
    }
    /**
     * Set trm_cancel_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_cancel_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_cancel_flag(?string $trm_cancel_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_cancel_flag) && !is_string($trm_cancel_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_cancel_flag, true), gettype($trm_cancel_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_cancel_flag) && $trm_cancel_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_cancel_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_cancel_flag) && $trm_cancel_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_cancel_flag, true)), __LINE__);
        }
        if (is_null($trm_cancel_flag) || (is_array($trm_cancel_flag) && empty($trm_cancel_flag))) {
            unset($this->trm_cancel_flag);
        } else {
            $this->trm_cancel_flag = $trm_cancel_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_ivd_prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_ivd_prc_prd_key(): ?string
    {
        return $this->trm_ivd_prc_prd_key ?? null;
    }
    /**
     * Set trm_ivd_prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_ivd_prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_ivd_prc_prd_key(?string $trm_ivd_prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_ivd_prc_prd_key) && !is_string($trm_ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_ivd_prc_prd_key, true), gettype($trm_ivd_prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_ivd_prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_ivd_prc_prd_key, true)), __LINE__);
        }
        if (is_null($trm_ivd_prc_prd_key) || (is_array($trm_ivd_prc_prd_key) && empty($trm_ivd_prc_prd_key))) {
            unset($this->trm_ivd_prc_prd_key);
        } else {
            $this->trm_ivd_prc_prd_key = $trm_ivd_prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get trm_lifetime_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_lifetime_flag(): ?string
    {
        return $this->trm_lifetime_flag ?? null;
    }
    /**
     * Set trm_lifetime_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_lifetime_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_lifetime_flag(?string $trm_lifetime_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_lifetime_flag) && !is_string($trm_lifetime_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_lifetime_flag, true), gettype($trm_lifetime_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_lifetime_flag) && $trm_lifetime_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_lifetime_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_lifetime_flag) && $trm_lifetime_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_lifetime_flag, true)), __LINE__);
        }
        if (is_null($trm_lifetime_flag) || (is_array($trm_lifetime_flag) && empty($trm_lifetime_flag))) {
            unset($this->trm_lifetime_flag);
        } else {
            $this->trm_lifetime_flag = $trm_lifetime_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_grace_issues_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrm_grace_issues_cp(): ?int
    {
        return $this->trm_grace_issues_cp ?? null;
    }
    /**
     * Set trm_grace_issues_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trm_grace_issues_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_grace_issues_cp(?int $trm_grace_issues_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($trm_grace_issues_cp) && !(is_int($trm_grace_issues_cp) || ctype_digit($trm_grace_issues_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trm_grace_issues_cp, true), gettype($trm_grace_issues_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($trm_grace_issues_cp) && $trm_grace_issues_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($trm_grace_issues_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($trm_grace_issues_cp) && $trm_grace_issues_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($trm_grace_issues_cp, true)), __LINE__);
        }
        if (is_null($trm_grace_issues_cp) || (is_array($trm_grace_issues_cp) && empty($trm_grace_issues_cp))) {
            unset($this->trm_grace_issues_cp);
        } else {
            $this->trm_grace_issues_cp = $trm_grace_issues_cp;
        }
        
        return $this;
    }
    /**
     * Get trm_sui_prd_key_drop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_sui_prd_key_drop(): ?string
    {
        return $this->trm_sui_prd_key_drop ?? null;
    }
    /**
     * Set trm_sui_prd_key_drop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_sui_prd_key_drop
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_sui_prd_key_drop(?string $trm_sui_prd_key_drop = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_sui_prd_key_drop) && !is_string($trm_sui_prd_key_drop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_sui_prd_key_drop, true), gettype($trm_sui_prd_key_drop)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_sui_prd_key_drop) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_sui_prd_key_drop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_sui_prd_key_drop, true)), __LINE__);
        }
        if (is_null($trm_sui_prd_key_drop) || (is_array($trm_sui_prd_key_drop) && empty($trm_sui_prd_key_drop))) {
            unset($this->trm_sui_prd_key_drop);
        } else {
            $this->trm_sui_prd_key_drop = $trm_sui_prd_key_drop;
        }
        
        return $this;
    }
    /**
     * Get trm_add_drop_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_add_drop_flag(): ?string
    {
        return $this->trm_add_drop_flag ?? null;
    }
    /**
     * Set trm_add_drop_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_add_drop_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_add_drop_flag(?string $trm_add_drop_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_add_drop_flag) && !is_string($trm_add_drop_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_add_drop_flag, true), gettype($trm_add_drop_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_add_drop_flag) && $trm_add_drop_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_add_drop_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_add_drop_flag) && $trm_add_drop_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_add_drop_flag, true)), __LINE__);
        }
        if (is_null($trm_add_drop_flag) || (is_array($trm_add_drop_flag) && empty($trm_add_drop_flag))) {
            unset($this->trm_add_drop_flag);
        } else {
            $this->trm_add_drop_flag = $trm_add_drop_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_mbr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_mbr_key(): ?string
    {
        return $this->trm_mbr_key ?? null;
    }
    /**
     * Set trm_mbr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_mbr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_mbr_key(?string $trm_mbr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_mbr_key) && !is_string($trm_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_mbr_key, true), gettype($trm_mbr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_mbr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_mbr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_mbr_key, true)), __LINE__);
        }
        if (is_null($trm_mbr_key) || (is_array($trm_mbr_key) && empty($trm_mbr_key))) {
            unset($this->trm_mbr_key);
        } else {
            $this->trm_mbr_key = $trm_mbr_key;
        }
        
        return $this;
    }
    /**
     * Get trm_mxi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_mxi_key(): ?string
    {
        return $this->trm_mxi_key ?? null;
    }
    /**
     * Set trm_mxi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_mxi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_mxi_key(?string $trm_mxi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_mxi_key) && !is_string($trm_mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_mxi_key, true), gettype($trm_mxi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_mxi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_mxi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_mxi_key, true)), __LINE__);
        }
        if (is_null($trm_mxi_key) || (is_array($trm_mxi_key) && empty($trm_mxi_key))) {
            unset($this->trm_mxi_key);
        } else {
            $this->trm_mxi_key = $trm_mxi_key;
        }
        
        return $this;
    }
    /**
     * Get trm_reference_num value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_reference_num(): ?string
    {
        return $this->trm_reference_num ?? null;
    }
    /**
     * Set trm_reference_num value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_reference_num
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_reference_num(?string $trm_reference_num = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_reference_num) && !is_string($trm_reference_num)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_reference_num, true), gettype($trm_reference_num)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($trm_reference_num) && mb_strlen((string) $trm_reference_num) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $trm_reference_num)), __LINE__);
        }
        if (is_null($trm_reference_num) || (is_array($trm_reference_num) && empty($trm_reference_num))) {
            unset($this->trm_reference_num);
        } else {
            $this->trm_reference_num = $trm_reference_num;
        }
        
        return $this;
    }
    /**
     * Get trm_auto_pay_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_auto_pay_flag(): ?string
    {
        return $this->trm_auto_pay_flag ?? null;
    }
    /**
     * Set trm_auto_pay_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_auto_pay_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_auto_pay_flag(?string $trm_auto_pay_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_auto_pay_flag) && !is_string($trm_auto_pay_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_auto_pay_flag, true), gettype($trm_auto_pay_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($trm_auto_pay_flag) && $trm_auto_pay_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($trm_auto_pay_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trm_auto_pay_flag) && $trm_auto_pay_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trm_auto_pay_flag, true)), __LINE__);
        }
        if (is_null($trm_auto_pay_flag) || (is_array($trm_auto_pay_flag) && empty($trm_auto_pay_flag))) {
            unset($this->trm_auto_pay_flag);
        } else {
            $this->trm_auto_pay_flag = $trm_auto_pay_flag;
        }
        
        return $this;
    }
    /**
     * Get trm_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_cpi_key(): ?string
    {
        return $this->trm_cpi_key ?? null;
    }
    /**
     * Set trm_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_cpi_key(?string $trm_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_cpi_key) && !is_string($trm_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_cpi_key, true), gettype($trm_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($trm_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $trm_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($trm_cpi_key, true)), __LINE__);
        }
        if (is_null($trm_cpi_key) || (is_array($trm_cpi_key) && empty($trm_cpi_key))) {
            unset($this->trm_cpi_key);
        } else {
            $this->trm_cpi_key = $trm_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get trm_issues_fulfilled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTrm_issues_fulfilled(): ?int
    {
        return $this->trm_issues_fulfilled ?? null;
    }
    /**
     * Set trm_issues_fulfilled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $trm_issues_fulfilled
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_issues_fulfilled(?int $trm_issues_fulfilled = null): self
    {
        // validation for constraint: int
        if (!is_null($trm_issues_fulfilled) && !(is_int($trm_issues_fulfilled) || ctype_digit($trm_issues_fulfilled))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trm_issues_fulfilled, true), gettype($trm_issues_fulfilled)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($trm_issues_fulfilled) && $trm_issues_fulfilled > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($trm_issues_fulfilled, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($trm_issues_fulfilled) && $trm_issues_fulfilled < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($trm_issues_fulfilled, true)), __LINE__);
        }
        if (is_null($trm_issues_fulfilled) || (is_array($trm_issues_fulfilled) && empty($trm_issues_fulfilled))) {
            unset($this->trm_issues_fulfilled);
        } else {
            $this->trm_issues_fulfilled = $trm_issues_fulfilled;
        }
        
        return $this;
    }
    /**
     * Get trm_cpi_consent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrm_cpi_consent_date(): ?string
    {
        return $this->trm_cpi_consent_date ?? null;
    }
    /**
     * Set trm_cpi_consent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trm_cpi_consent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Invoice_Detail_Term_DataObjectType
     */
    public function setTrm_cpi_consent_date(?string $trm_cpi_consent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($trm_cpi_consent_date) && !is_string($trm_cpi_consent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trm_cpi_consent_date, true), gettype($trm_cpi_consent_date)), __LINE__);
        }
        if (is_null($trm_cpi_consent_date) || (is_array($trm_cpi_consent_date) && empty($trm_cpi_consent_date))) {
            unset($this->trm_cpi_consent_date);
        } else {
            $this->trm_cpi_consent_date = $trm_cpi_consent_date;
        }
        
        return $this;
    }
}
