<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_Price_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_Price_DataObjectType extends AbstractStructBase
{
    /**
     * The prc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_key = null;
    /**
     * The prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_prd_key = null;
    /**
     * The prc_price
     * Meta information extracted from the WSDL
     * - documentation: Price/Rate.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $prc_price = null;
    /**
     * The prc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_add_user = null;
    /**
     * The prc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_add_date = null;
    /**
     * The prc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_change_user = null;
    /**
     * The prc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_change_date = null;
    /**
     * The prc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_delete_flag = null;
    /**
     * The prc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_key_ext = null;
    /**
     * The prc_gla_ar_key
     * Meta information extracted from the WSDL
     * - documentation: A/R Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_ar_key = null;
    /**
     * The prc_gla_revenue_key
     * Meta information extracted from the WSDL
     * - documentation: Revenue Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_revenue_key = null;
    /**
     * The prc_gla_liability_key
     * Meta information extracted from the WSDL
     * - documentation: Liability Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_liability_key = null;
    /**
     * The prc_gla_return_key
     * Meta information extracted from the WSDL
     * - documentation: Return Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_return_key = null;
    /**
     * The prc_gla_writeoff_key
     * Meta information extracted from the WSDL
     * - documentation: Write Off Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_writeoff_key = null;
    /**
     * The prc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_start_date = null;
    /**
     * The prc_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_end_date = null;
    /**
     * The prc_ptr_key
     * Meta information extracted from the WSDL
     * - documentation: Term Length. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_ptr_key = null;
    /**
     * The prc_num_issues
     * Meta information extracted from the WSDL
     * - documentation: Number of Issues. This field has this Input Mask: 9,999,999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prc_num_issues = null;
    /**
     * The prc_prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_prd_ptp_key = null;
    /**
     * The prc_percent
     * Meta information extracted from the WSDL
     * - documentation: Percentage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_percent = null;
    /**
     * The prc_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: percent. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_percent_cp = null;
    /**
     * The prc_prd_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Business Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_prd_atc_key = null;
    /**
     * The prc_code
     * Meta information extracted from the WSDL
     * - documentation: Price Lookup Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_code = null;
    /**
     * The prc_display_name
     * Meta information extracted from the WSDL
     * - documentation: Display Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_display_name = null;
    /**
     * The prc_sell_online
     * Meta information extracted from the WSDL
     * - documentation: Sell Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_sell_online = null;
    /**
     * The prc_gla_deferred_key
     * Meta information extracted from the WSDL
     * - documentation: Deferred Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_gla_deferred_key = null;
    /**
     * The prc_deferred_flag
     * Meta information extracted from the WSDL
     * - documentation: Deferred?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_deferred_flag = null;
    /**
     * The prc_mail
     * Meta information extracted from the WSDL
     * - documentation: send via mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_mail = null;
    /**
     * The prc_email
     * Meta information extracted from the WSDL
     * - documentation: send via email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_email = null;
    /**
     * The prc_fax
     * Meta information extracted from the WSDL
     * - documentation: send via fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_fax = null;
    /**
     * The prc_thumbnail
     * Meta information extracted from the WSDL
     * - documentation: Thumbnail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_thumbnail = null;
    /**
     * The prc_online_abstract
     * Meta information extracted from the WSDL
     * - documentation: Online Abstract. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_online_abstract = null;
    /**
     * The prc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_entity_key = null;
    /**
     * The prc_qty_min
     * Meta information extracted from the WSDL
     * - documentation: Minimum Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_qty_min = null;
    /**
     * The prc_qty_max
     * Meta information extracted from the WSDL
     * - documentation: Maximum Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_qty_max = null;
    /**
     * The prc_recognize_after_date
     * Meta information extracted from the WSDL
     * - documentation: Recognize Revenue After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_recognize_after_date = null;
    /**
     * The prc_account_split_flag
     * Meta information extracted from the WSDL
     * - documentation: Split Revenue. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_account_split_flag = null;
    /**
     * The prc_prorate_flag
     * Meta information extracted from the WSDL
     * - documentation: Proration Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_prorate_flag = null;
    /**
     * The prc_prorate_first_year_flag
     * Meta information extracted from the WSDL
     * - documentation: Prorate in First Year. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_prorate_first_year_flag = null;
    /**
     * The prc_web
     * Meta information extracted from the WSDL
     * - documentation: send via web. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_web = null;
    /**
     * The prc_microfiche
     * Meta information extracted from the WSDL
     * - documentation: send via microfiche. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_microfiche = null;
    /**
     * The prc_revenue_recog_frequency
     * Meta information extracted from the WSDL
     * - documentation: revenue recog frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prc_revenue_recog_frequency = null;
    /**
     * The prc_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allow installment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_allow_installment = null;
    /**
     * The prc_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_pjt_key = null;
    /**
     * The prc_shippable_flag
     * Meta information extracted from the WSDL
     * - documentation: shippable. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_shippable_flag = null;
    /**
     * The prc_eweb_code
     * Meta information extracted from the WSDL
     * - documentation: eweb code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_eweb_code = null;
    /**
     * The prc_weight_min
     * Meta information extracted from the WSDL
     * - documentation: Minimum Weight. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_weight_min = null;
    /**
     * The prc_weight_max
     * Meta information extracted from the WSDL
     * - documentation: Maximum Weight. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $prc_weight_max = null;
    /**
     * The prc_recognize_by_issue_flag
     * Meta information extracted from the WSDL
     * - documentation: Recognize Revenue by Issue. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_recognize_by_issue_flag = null;
    /**
     * The prc_num_grace_issues
     * Meta information extracted from the WSDL
     * - documentation: Number of Grace Issues. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prc_num_grace_issues = null;
    /**
     * The prc_back_issue_flag
     * Meta information extracted from the WSDL
     * - documentation: Back Issue Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_back_issue_flag = null;
    /**
     * The prc_renew_unpaid_orders_flag
     * Meta information extracted from the WSDL
     * - documentation: Renew Unpaid Orders.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_renew_unpaid_orders_flag = null;
    /**
     * The prc_allow_unpaid_orders_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Unpaid Orders.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_allow_unpaid_orders_flag = null;
    /**
     * The prc_deferral_num_years
     * Meta information extracted from the WSDL
     * - documentation: years for deferral. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prc_deferral_num_years = null;
    /**
     * The prc_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_cur_key = null;
    /**
     * The prc_award_credit_flag
     * Meta information extracted from the WSDL
     * - documentation: Award Credit Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_award_credit_flag = null;
    /**
     * The prc_deferral_num_issues
     * Meta information extracted from the WSDL
     * - documentation: issues for deferral. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $prc_deferral_num_issues = null;
    /**
     * The prc_allow_sync_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow sync with National Membe. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_allow_sync_flag = null;
    /**
     * The prc_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_cct_key = null;
    /**
     * The prc_no_discount_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Discount. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $prc_no_discount_flag = null;
    /**
     * The prc_pcl_key
     * Meta information extracted from the WSDL
     * - documentation: Class. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_pcl_key = null;
    /**
     * The prc_pde_key
     * Meta information extracted from the WSDL
     * - documentation: Department. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_pde_key = null;
    /**
     * The prc_plo_key
     * Meta information extracted from the WSDL
     * - documentation: Location. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $prc_plo_key = null;
    /**
     * Constructor method for CentralizedOrderEntry_Price_DataObjectType
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_prd_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_price()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_add_user()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_add_date()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_change_user()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_change_date()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_delete_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_key_ext()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_ar_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_revenue_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_liability_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_return_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_writeoff_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_start_date()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_end_date()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_ptr_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_num_issues()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_prd_ptp_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_percent()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_percent_cp()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_prd_atc_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_code()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_display_name()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_sell_online()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_gla_deferred_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_deferred_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_mail()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_email()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_fax()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_thumbnail()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_online_abstract()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_entity_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_qty_min()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_qty_max()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_recognize_after_date()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_account_split_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_prorate_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_prorate_first_year_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_web()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_microfiche()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_revenue_recog_frequency()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_allow_installment()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_pjt_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_shippable_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_eweb_code()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_weight_min()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_weight_max()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_recognize_by_issue_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_num_grace_issues()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_back_issue_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_renew_unpaid_orders_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_allow_unpaid_orders_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_deferral_num_years()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_cur_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_award_credit_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_deferral_num_issues()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_allow_sync_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_cct_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_no_discount_flag()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_pcl_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_pde_key()
     * @uses CentralizedOrderEntry_Price_DataObjectType::setPrc_plo_key()
     * @param string $prc_key
     * @param string $prc_prd_key
     * @param float $prc_price
     * @param string $prc_add_user
     * @param string $prc_add_date
     * @param string $prc_change_user
     * @param string $prc_change_date
     * @param string $prc_delete_flag
     * @param string $prc_key_ext
     * @param string $prc_gla_ar_key
     * @param string $prc_gla_revenue_key
     * @param string $prc_gla_liability_key
     * @param string $prc_gla_return_key
     * @param string $prc_gla_writeoff_key
     * @param string $prc_start_date
     * @param string $prc_end_date
     * @param string $prc_ptr_key
     * @param int $prc_num_issues
     * @param string $prc_prd_ptp_key
     * @param float $prc_percent
     * @param float $prc_percent_cp
     * @param string $prc_prd_atc_key
     * @param string $prc_code
     * @param string $prc_display_name
     * @param string $prc_sell_online
     * @param string $prc_gla_deferred_key
     * @param string $prc_deferred_flag
     * @param string $prc_mail
     * @param string $prc_email
     * @param string $prc_fax
     * @param string $prc_thumbnail
     * @param string $prc_online_abstract
     * @param string $prc_entity_key
     * @param float $prc_qty_min
     * @param float $prc_qty_max
     * @param string $prc_recognize_after_date
     * @param string $prc_account_split_flag
     * @param string $prc_prorate_flag
     * @param string $prc_prorate_first_year_flag
     * @param string $prc_web
     * @param string $prc_microfiche
     * @param int $prc_revenue_recog_frequency
     * @param string $prc_allow_installment
     * @param string $prc_pjt_key
     * @param string $prc_shippable_flag
     * @param string $prc_eweb_code
     * @param float $prc_weight_min
     * @param float $prc_weight_max
     * @param string $prc_recognize_by_issue_flag
     * @param int $prc_num_grace_issues
     * @param string $prc_back_issue_flag
     * @param string $prc_renew_unpaid_orders_flag
     * @param string $prc_allow_unpaid_orders_flag
     * @param int $prc_deferral_num_years
     * @param string $prc_cur_key
     * @param string $prc_award_credit_flag
     * @param int $prc_deferral_num_issues
     * @param string $prc_allow_sync_flag
     * @param string $prc_cct_key
     * @param string $prc_no_discount_flag
     * @param string $prc_pcl_key
     * @param string $prc_pde_key
     * @param string $prc_plo_key
     */
    public function __construct(?string $prc_key = null, ?string $prc_prd_key = null, ?float $prc_price = null, ?string $prc_add_user = null, ?string $prc_add_date = null, ?string $prc_change_user = null, ?string $prc_change_date = null, ?string $prc_delete_flag = null, ?string $prc_key_ext = null, ?string $prc_gla_ar_key = null, ?string $prc_gla_revenue_key = null, ?string $prc_gla_liability_key = null, ?string $prc_gla_return_key = null, ?string $prc_gla_writeoff_key = null, ?string $prc_start_date = null, ?string $prc_end_date = null, ?string $prc_ptr_key = null, ?int $prc_num_issues = null, ?string $prc_prd_ptp_key = null, ?float $prc_percent = null, ?float $prc_percent_cp = null, ?string $prc_prd_atc_key = null, ?string $prc_code = null, ?string $prc_display_name = null, ?string $prc_sell_online = null, ?string $prc_gla_deferred_key = null, ?string $prc_deferred_flag = null, ?string $prc_mail = null, ?string $prc_email = null, ?string $prc_fax = null, ?string $prc_thumbnail = null, ?string $prc_online_abstract = null, ?string $prc_entity_key = null, ?float $prc_qty_min = null, ?float $prc_qty_max = null, ?string $prc_recognize_after_date = null, ?string $prc_account_split_flag = null, ?string $prc_prorate_flag = null, ?string $prc_prorate_first_year_flag = null, ?string $prc_web = null, ?string $prc_microfiche = null, ?int $prc_revenue_recog_frequency = null, ?string $prc_allow_installment = null, ?string $prc_pjt_key = null, ?string $prc_shippable_flag = null, ?string $prc_eweb_code = null, ?float $prc_weight_min = null, ?float $prc_weight_max = null, ?string $prc_recognize_by_issue_flag = null, ?int $prc_num_grace_issues = null, ?string $prc_back_issue_flag = null, ?string $prc_renew_unpaid_orders_flag = null, ?string $prc_allow_unpaid_orders_flag = null, ?int $prc_deferral_num_years = null, ?string $prc_cur_key = null, ?string $prc_award_credit_flag = null, ?int $prc_deferral_num_issues = null, ?string $prc_allow_sync_flag = null, ?string $prc_cct_key = null, ?string $prc_no_discount_flag = null, ?string $prc_pcl_key = null, ?string $prc_pde_key = null, ?string $prc_plo_key = null)
    {
        $this
            ->setPrc_key($prc_key)
            ->setPrc_prd_key($prc_prd_key)
            ->setPrc_price($prc_price)
            ->setPrc_add_user($prc_add_user)
            ->setPrc_add_date($prc_add_date)
            ->setPrc_change_user($prc_change_user)
            ->setPrc_change_date($prc_change_date)
            ->setPrc_delete_flag($prc_delete_flag)
            ->setPrc_key_ext($prc_key_ext)
            ->setPrc_gla_ar_key($prc_gla_ar_key)
            ->setPrc_gla_revenue_key($prc_gla_revenue_key)
            ->setPrc_gla_liability_key($prc_gla_liability_key)
            ->setPrc_gla_return_key($prc_gla_return_key)
            ->setPrc_gla_writeoff_key($prc_gla_writeoff_key)
            ->setPrc_start_date($prc_start_date)
            ->setPrc_end_date($prc_end_date)
            ->setPrc_ptr_key($prc_ptr_key)
            ->setPrc_num_issues($prc_num_issues)
            ->setPrc_prd_ptp_key($prc_prd_ptp_key)
            ->setPrc_percent($prc_percent)
            ->setPrc_percent_cp($prc_percent_cp)
            ->setPrc_prd_atc_key($prc_prd_atc_key)
            ->setPrc_code($prc_code)
            ->setPrc_display_name($prc_display_name)
            ->setPrc_sell_online($prc_sell_online)
            ->setPrc_gla_deferred_key($prc_gla_deferred_key)
            ->setPrc_deferred_flag($prc_deferred_flag)
            ->setPrc_mail($prc_mail)
            ->setPrc_email($prc_email)
            ->setPrc_fax($prc_fax)
            ->setPrc_thumbnail($prc_thumbnail)
            ->setPrc_online_abstract($prc_online_abstract)
            ->setPrc_entity_key($prc_entity_key)
            ->setPrc_qty_min($prc_qty_min)
            ->setPrc_qty_max($prc_qty_max)
            ->setPrc_recognize_after_date($prc_recognize_after_date)
            ->setPrc_account_split_flag($prc_account_split_flag)
            ->setPrc_prorate_flag($prc_prorate_flag)
            ->setPrc_prorate_first_year_flag($prc_prorate_first_year_flag)
            ->setPrc_web($prc_web)
            ->setPrc_microfiche($prc_microfiche)
            ->setPrc_revenue_recog_frequency($prc_revenue_recog_frequency)
            ->setPrc_allow_installment($prc_allow_installment)
            ->setPrc_pjt_key($prc_pjt_key)
            ->setPrc_shippable_flag($prc_shippable_flag)
            ->setPrc_eweb_code($prc_eweb_code)
            ->setPrc_weight_min($prc_weight_min)
            ->setPrc_weight_max($prc_weight_max)
            ->setPrc_recognize_by_issue_flag($prc_recognize_by_issue_flag)
            ->setPrc_num_grace_issues($prc_num_grace_issues)
            ->setPrc_back_issue_flag($prc_back_issue_flag)
            ->setPrc_renew_unpaid_orders_flag($prc_renew_unpaid_orders_flag)
            ->setPrc_allow_unpaid_orders_flag($prc_allow_unpaid_orders_flag)
            ->setPrc_deferral_num_years($prc_deferral_num_years)
            ->setPrc_cur_key($prc_cur_key)
            ->setPrc_award_credit_flag($prc_award_credit_flag)
            ->setPrc_deferral_num_issues($prc_deferral_num_issues)
            ->setPrc_allow_sync_flag($prc_allow_sync_flag)
            ->setPrc_cct_key($prc_cct_key)
            ->setPrc_no_discount_flag($prc_no_discount_flag)
            ->setPrc_pcl_key($prc_pcl_key)
            ->setPrc_pde_key($prc_pde_key)
            ->setPrc_plo_key($prc_plo_key);
    }
    /**
     * Get prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_key(): ?string
    {
        return $this->prc_key ?? null;
    }
    /**
     * Set prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_key(?string $prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_key) && !is_string($prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_key, true), gettype($prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_key, true)), __LINE__);
        }
        if (is_null($prc_key) || (is_array($prc_key) && empty($prc_key))) {
            unset($this->prc_key);
        } else {
            $this->prc_key = $prc_key;
        }
        
        return $this;
    }
    /**
     * Get prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_prd_key(): ?string
    {
        return $this->prc_prd_key ?? null;
    }
    /**
     * Set prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_prd_key(?string $prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_prd_key) && !is_string($prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_prd_key, true), gettype($prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_prd_key, true)), __LINE__);
        }
        if (is_null($prc_prd_key) || (is_array($prc_prd_key) && empty($prc_prd_key))) {
            unset($this->prc_prd_key);
        } else {
            $this->prc_prd_key = $prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get prc_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_price(): ?float
    {
        return $this->prc_price ?? null;
    }
    /**
     * Set prc_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_price(?float $prc_price = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_price) && !(is_float($prc_price) || is_numeric($prc_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_price, true), gettype($prc_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_price) && mb_strlen(mb_substr((string) $prc_price, false !== mb_strpos((string) $prc_price, '.') ? mb_strpos((string) $prc_price, '.') + 1 : mb_strlen((string) $prc_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_price, true), mb_strlen(mb_substr((string) $prc_price, mb_strpos((string) $prc_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($prc_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($prc_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_price))), __LINE__);
        }
        if (is_null($prc_price) || (is_array($prc_price) && empty($prc_price))) {
            unset($this->prc_price);
        } else {
            $this->prc_price = $prc_price;
        }
        
        return $this;
    }
    /**
     * Get prc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_add_user(): ?string
    {
        return $this->prc_add_user ?? null;
    }
    /**
     * Set prc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_add_user(?string $prc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_add_user) && !is_string($prc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_add_user, true), gettype($prc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prc_add_user) && mb_strlen((string) $prc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prc_add_user)), __LINE__);
        }
        if (is_null($prc_add_user) || (is_array($prc_add_user) && empty($prc_add_user))) {
            unset($this->prc_add_user);
        } else {
            $this->prc_add_user = $prc_add_user;
        }
        
        return $this;
    }
    /**
     * Get prc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_add_date(): ?string
    {
        return $this->prc_add_date ?? null;
    }
    /**
     * Set prc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_add_date(?string $prc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_add_date) && !is_string($prc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_add_date, true), gettype($prc_add_date)), __LINE__);
        }
        if (is_null($prc_add_date) || (is_array($prc_add_date) && empty($prc_add_date))) {
            unset($this->prc_add_date);
        } else {
            $this->prc_add_date = $prc_add_date;
        }
        
        return $this;
    }
    /**
     * Get prc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_change_user(): ?string
    {
        return $this->prc_change_user ?? null;
    }
    /**
     * Set prc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_change_user(?string $prc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_change_user) && !is_string($prc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_change_user, true), gettype($prc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($prc_change_user) && mb_strlen((string) $prc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $prc_change_user)), __LINE__);
        }
        if (is_null($prc_change_user) || (is_array($prc_change_user) && empty($prc_change_user))) {
            unset($this->prc_change_user);
        } else {
            $this->prc_change_user = $prc_change_user;
        }
        
        return $this;
    }
    /**
     * Get prc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_change_date(): ?string
    {
        return $this->prc_change_date ?? null;
    }
    /**
     * Set prc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_change_date(?string $prc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_change_date) && !is_string($prc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_change_date, true), gettype($prc_change_date)), __LINE__);
        }
        if (is_null($prc_change_date) || (is_array($prc_change_date) && empty($prc_change_date))) {
            unset($this->prc_change_date);
        } else {
            $this->prc_change_date = $prc_change_date;
        }
        
        return $this;
    }
    /**
     * Get prc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_delete_flag(): ?string
    {
        return $this->prc_delete_flag ?? null;
    }
    /**
     * Set prc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_delete_flag(?string $prc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_delete_flag) && !is_string($prc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_delete_flag, true), gettype($prc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_delete_flag) && $prc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_delete_flag) && $prc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_delete_flag, true)), __LINE__);
        }
        if (is_null($prc_delete_flag) || (is_array($prc_delete_flag) && empty($prc_delete_flag))) {
            unset($this->prc_delete_flag);
        } else {
            $this->prc_delete_flag = $prc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_key_ext(): ?string
    {
        return $this->prc_key_ext ?? null;
    }
    /**
     * Set prc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_key_ext(?string $prc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_key_ext) && !is_string($prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_key_ext, true), gettype($prc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_key_ext, true)), __LINE__);
        }
        if (is_null($prc_key_ext) || (is_array($prc_key_ext) && empty($prc_key_ext))) {
            unset($this->prc_key_ext);
        } else {
            $this->prc_key_ext = $prc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_ar_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_ar_key(): ?string
    {
        return $this->prc_gla_ar_key ?? null;
    }
    /**
     * Set prc_gla_ar_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_ar_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_ar_key(?string $prc_gla_ar_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_ar_key) && !is_string($prc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_ar_key, true), gettype($prc_gla_ar_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_ar_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_ar_key, true)), __LINE__);
        }
        if (is_null($prc_gla_ar_key) || (is_array($prc_gla_ar_key) && empty($prc_gla_ar_key))) {
            unset($this->prc_gla_ar_key);
        } else {
            $this->prc_gla_ar_key = $prc_gla_ar_key;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_revenue_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_revenue_key(): ?string
    {
        return $this->prc_gla_revenue_key ?? null;
    }
    /**
     * Set prc_gla_revenue_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_revenue_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_revenue_key(?string $prc_gla_revenue_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_revenue_key) && !is_string($prc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_revenue_key, true), gettype($prc_gla_revenue_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_revenue_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_revenue_key, true)), __LINE__);
        }
        if (is_null($prc_gla_revenue_key) || (is_array($prc_gla_revenue_key) && empty($prc_gla_revenue_key))) {
            unset($this->prc_gla_revenue_key);
        } else {
            $this->prc_gla_revenue_key = $prc_gla_revenue_key;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_liability_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_liability_key(): ?string
    {
        return $this->prc_gla_liability_key ?? null;
    }
    /**
     * Set prc_gla_liability_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_liability_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_liability_key(?string $prc_gla_liability_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_liability_key) && !is_string($prc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_liability_key, true), gettype($prc_gla_liability_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_liability_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_liability_key, true)), __LINE__);
        }
        if (is_null($prc_gla_liability_key) || (is_array($prc_gla_liability_key) && empty($prc_gla_liability_key))) {
            unset($this->prc_gla_liability_key);
        } else {
            $this->prc_gla_liability_key = $prc_gla_liability_key;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_return_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_return_key(): ?string
    {
        return $this->prc_gla_return_key ?? null;
    }
    /**
     * Set prc_gla_return_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_return_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_return_key(?string $prc_gla_return_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_return_key) && !is_string($prc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_return_key, true), gettype($prc_gla_return_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_return_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_return_key, true)), __LINE__);
        }
        if (is_null($prc_gla_return_key) || (is_array($prc_gla_return_key) && empty($prc_gla_return_key))) {
            unset($this->prc_gla_return_key);
        } else {
            $this->prc_gla_return_key = $prc_gla_return_key;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_writeoff_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_writeoff_key(): ?string
    {
        return $this->prc_gla_writeoff_key ?? null;
    }
    /**
     * Set prc_gla_writeoff_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_writeoff_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_writeoff_key(?string $prc_gla_writeoff_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_writeoff_key) && !is_string($prc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_writeoff_key, true), gettype($prc_gla_writeoff_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_writeoff_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_writeoff_key, true)), __LINE__);
        }
        if (is_null($prc_gla_writeoff_key) || (is_array($prc_gla_writeoff_key) && empty($prc_gla_writeoff_key))) {
            unset($this->prc_gla_writeoff_key);
        } else {
            $this->prc_gla_writeoff_key = $prc_gla_writeoff_key;
        }
        
        return $this;
    }
    /**
     * Get prc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_start_date(): ?string
    {
        return $this->prc_start_date ?? null;
    }
    /**
     * Set prc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_start_date(?string $prc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_start_date) && !is_string($prc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_start_date, true), gettype($prc_start_date)), __LINE__);
        }
        if (is_null($prc_start_date) || (is_array($prc_start_date) && empty($prc_start_date))) {
            unset($this->prc_start_date);
        } else {
            $this->prc_start_date = $prc_start_date;
        }
        
        return $this;
    }
    /**
     * Get prc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_end_date(): ?string
    {
        return $this->prc_end_date ?? null;
    }
    /**
     * Set prc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_end_date(?string $prc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_end_date) && !is_string($prc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_end_date, true), gettype($prc_end_date)), __LINE__);
        }
        if (is_null($prc_end_date) || (is_array($prc_end_date) && empty($prc_end_date))) {
            unset($this->prc_end_date);
        } else {
            $this->prc_end_date = $prc_end_date;
        }
        
        return $this;
    }
    /**
     * Get prc_ptr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_ptr_key(): ?string
    {
        return $this->prc_ptr_key ?? null;
    }
    /**
     * Set prc_ptr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_ptr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_ptr_key(?string $prc_ptr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_ptr_key) && !is_string($prc_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_ptr_key, true), gettype($prc_ptr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_ptr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_ptr_key, true)), __LINE__);
        }
        if (is_null($prc_ptr_key) || (is_array($prc_ptr_key) && empty($prc_ptr_key))) {
            unset($this->prc_ptr_key);
        } else {
            $this->prc_ptr_key = $prc_ptr_key;
        }
        
        return $this;
    }
    /**
     * Get prc_num_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrc_num_issues(): ?int
    {
        return $this->prc_num_issues ?? null;
    }
    /**
     * Set prc_num_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prc_num_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_num_issues(?int $prc_num_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($prc_num_issues) && !(is_int($prc_num_issues) || ctype_digit($prc_num_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prc_num_issues, true), gettype($prc_num_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prc_num_issues) && $prc_num_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prc_num_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prc_num_issues) && $prc_num_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prc_num_issues, true)), __LINE__);
        }
        if (is_null($prc_num_issues) || (is_array($prc_num_issues) && empty($prc_num_issues))) {
            unset($this->prc_num_issues);
        } else {
            $this->prc_num_issues = $prc_num_issues;
        }
        
        return $this;
    }
    /**
     * Get prc_prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_prd_ptp_key(): ?string
    {
        return $this->prc_prd_ptp_key ?? null;
    }
    /**
     * Set prc_prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_prd_ptp_key(?string $prc_prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_prd_ptp_key) && !is_string($prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_prd_ptp_key, true), gettype($prc_prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_prd_ptp_key, true)), __LINE__);
        }
        if (is_null($prc_prd_ptp_key) || (is_array($prc_prd_ptp_key) && empty($prc_prd_ptp_key))) {
            unset($this->prc_prd_ptp_key);
        } else {
            $this->prc_prd_ptp_key = $prc_prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get prc_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_percent(): ?float
    {
        return $this->prc_percent ?? null;
    }
    /**
     * Set prc_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_percent(?float $prc_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_percent) && !(is_float($prc_percent) || is_numeric($prc_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_percent, true), gettype($prc_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_percent) && mb_strlen(mb_substr((string) $prc_percent, false !== mb_strpos((string) $prc_percent, '.') ? mb_strpos((string) $prc_percent, '.') + 1 : mb_strlen((string) $prc_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_percent, true), mb_strlen(mb_substr((string) $prc_percent, mb_strpos((string) $prc_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_percent))), __LINE__);
        }
        if (is_null($prc_percent) || (is_array($prc_percent) && empty($prc_percent))) {
            unset($this->prc_percent);
        } else {
            $this->prc_percent = $prc_percent;
        }
        
        return $this;
    }
    /**
     * Get prc_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_percent_cp(): ?float
    {
        return $this->prc_percent_cp ?? null;
    }
    /**
     * Set prc_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_percent_cp(?float $prc_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_percent_cp) && !(is_float($prc_percent_cp) || is_numeric($prc_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_percent_cp, true), gettype($prc_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_percent_cp) && mb_strlen(mb_substr((string) $prc_percent_cp, false !== mb_strpos((string) $prc_percent_cp, '.') ? mb_strpos((string) $prc_percent_cp, '.') + 1 : mb_strlen((string) $prc_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_percent_cp, true), mb_strlen(mb_substr((string) $prc_percent_cp, mb_strpos((string) $prc_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_percent_cp))), __LINE__);
        }
        if (is_null($prc_percent_cp) || (is_array($prc_percent_cp) && empty($prc_percent_cp))) {
            unset($this->prc_percent_cp);
        } else {
            $this->prc_percent_cp = $prc_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get prc_prd_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_prd_atc_key(): ?string
    {
        return $this->prc_prd_atc_key ?? null;
    }
    /**
     * Set prc_prd_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_prd_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_prd_atc_key(?string $prc_prd_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_prd_atc_key) && !is_string($prc_prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_prd_atc_key, true), gettype($prc_prd_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_prd_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_prd_atc_key, true)), __LINE__);
        }
        if (is_null($prc_prd_atc_key) || (is_array($prc_prd_atc_key) && empty($prc_prd_atc_key))) {
            unset($this->prc_prd_atc_key);
        } else {
            $this->prc_prd_atc_key = $prc_prd_atc_key;
        }
        
        return $this;
    }
    /**
     * Get prc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_code(): ?string
    {
        return $this->prc_code ?? null;
    }
    /**
     * Set prc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_code(?string $prc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_code) && !is_string($prc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_code, true), gettype($prc_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($prc_code) && mb_strlen((string) $prc_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $prc_code)), __LINE__);
        }
        if (is_null($prc_code) || (is_array($prc_code) && empty($prc_code))) {
            unset($this->prc_code);
        } else {
            $this->prc_code = $prc_code;
        }
        
        return $this;
    }
    /**
     * Get prc_display_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_display_name(): ?string
    {
        return $this->prc_display_name ?? null;
    }
    /**
     * Set prc_display_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_display_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_display_name(?string $prc_display_name = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_display_name) && !is_string($prc_display_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_display_name, true), gettype($prc_display_name)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($prc_display_name) && mb_strlen((string) $prc_display_name) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $prc_display_name)), __LINE__);
        }
        if (is_null($prc_display_name) || (is_array($prc_display_name) && empty($prc_display_name))) {
            unset($this->prc_display_name);
        } else {
            $this->prc_display_name = $prc_display_name;
        }
        
        return $this;
    }
    /**
     * Get prc_sell_online value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_sell_online(): ?string
    {
        return $this->prc_sell_online ?? null;
    }
    /**
     * Set prc_sell_online value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_sell_online
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_sell_online(?string $prc_sell_online = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_sell_online) && !is_string($prc_sell_online)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_sell_online, true), gettype($prc_sell_online)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_sell_online) && $prc_sell_online > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_sell_online, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_sell_online) && $prc_sell_online < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_sell_online, true)), __LINE__);
        }
        if (is_null($prc_sell_online) || (is_array($prc_sell_online) && empty($prc_sell_online))) {
            unset($this->prc_sell_online);
        } else {
            $this->prc_sell_online = $prc_sell_online;
        }
        
        return $this;
    }
    /**
     * Get prc_gla_deferred_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_gla_deferred_key(): ?string
    {
        return $this->prc_gla_deferred_key ?? null;
    }
    /**
     * Set prc_gla_deferred_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_gla_deferred_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_gla_deferred_key(?string $prc_gla_deferred_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_gla_deferred_key) && !is_string($prc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_gla_deferred_key, true), gettype($prc_gla_deferred_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_gla_deferred_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_gla_deferred_key, true)), __LINE__);
        }
        if (is_null($prc_gla_deferred_key) || (is_array($prc_gla_deferred_key) && empty($prc_gla_deferred_key))) {
            unset($this->prc_gla_deferred_key);
        } else {
            $this->prc_gla_deferred_key = $prc_gla_deferred_key;
        }
        
        return $this;
    }
    /**
     * Get prc_deferred_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_deferred_flag(): ?string
    {
        return $this->prc_deferred_flag ?? null;
    }
    /**
     * Set prc_deferred_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_deferred_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_deferred_flag(?string $prc_deferred_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_deferred_flag) && !is_string($prc_deferred_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_deferred_flag, true), gettype($prc_deferred_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_deferred_flag) && $prc_deferred_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_deferred_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_deferred_flag) && $prc_deferred_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_deferred_flag, true)), __LINE__);
        }
        if (is_null($prc_deferred_flag) || (is_array($prc_deferred_flag) && empty($prc_deferred_flag))) {
            unset($this->prc_deferred_flag);
        } else {
            $this->prc_deferred_flag = $prc_deferred_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_mail(): ?string
    {
        return $this->prc_mail ?? null;
    }
    /**
     * Set prc_mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_mail
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_mail(?string $prc_mail = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_mail) && !is_string($prc_mail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_mail, true), gettype($prc_mail)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_mail) && $prc_mail > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_mail, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_mail) && $prc_mail < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_mail, true)), __LINE__);
        }
        if (is_null($prc_mail) || (is_array($prc_mail) && empty($prc_mail))) {
            unset($this->prc_mail);
        } else {
            $this->prc_mail = $prc_mail;
        }
        
        return $this;
    }
    /**
     * Get prc_email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_email(): ?string
    {
        return $this->prc_email ?? null;
    }
    /**
     * Set prc_email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_email
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_email(?string $prc_email = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_email) && !is_string($prc_email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_email, true), gettype($prc_email)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_email) && $prc_email > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_email, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_email) && $prc_email < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_email, true)), __LINE__);
        }
        if (is_null($prc_email) || (is_array($prc_email) && empty($prc_email))) {
            unset($this->prc_email);
        } else {
            $this->prc_email = $prc_email;
        }
        
        return $this;
    }
    /**
     * Get prc_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_fax(): ?string
    {
        return $this->prc_fax ?? null;
    }
    /**
     * Set prc_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_fax(?string $prc_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_fax) && !is_string($prc_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_fax, true), gettype($prc_fax)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_fax) && $prc_fax > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_fax, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_fax) && $prc_fax < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_fax, true)), __LINE__);
        }
        if (is_null($prc_fax) || (is_array($prc_fax) && empty($prc_fax))) {
            unset($this->prc_fax);
        } else {
            $this->prc_fax = $prc_fax;
        }
        
        return $this;
    }
    /**
     * Get prc_thumbnail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_thumbnail(): ?string
    {
        return $this->prc_thumbnail ?? null;
    }
    /**
     * Set prc_thumbnail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_thumbnail
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_thumbnail(?string $prc_thumbnail = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_thumbnail) && !is_string($prc_thumbnail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_thumbnail, true), gettype($prc_thumbnail)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prc_thumbnail) && mb_strlen((string) $prc_thumbnail) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $prc_thumbnail)), __LINE__);
        }
        if (is_null($prc_thumbnail) || (is_array($prc_thumbnail) && empty($prc_thumbnail))) {
            unset($this->prc_thumbnail);
        } else {
            $this->prc_thumbnail = $prc_thumbnail;
        }
        
        return $this;
    }
    /**
     * Get prc_online_abstract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_online_abstract(): ?string
    {
        return $this->prc_online_abstract ?? null;
    }
    /**
     * Set prc_online_abstract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_online_abstract
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_online_abstract(?string $prc_online_abstract = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_online_abstract) && !is_string($prc_online_abstract)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_online_abstract, true), gettype($prc_online_abstract)), __LINE__);
        }
        if (is_null($prc_online_abstract) || (is_array($prc_online_abstract) && empty($prc_online_abstract))) {
            unset($this->prc_online_abstract);
        } else {
            $this->prc_online_abstract = $prc_online_abstract;
        }
        
        return $this;
    }
    /**
     * Get prc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_entity_key(): ?string
    {
        return $this->prc_entity_key ?? null;
    }
    /**
     * Set prc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_entity_key(?string $prc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_entity_key) && !is_string($prc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_entity_key, true), gettype($prc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_entity_key, true)), __LINE__);
        }
        if (is_null($prc_entity_key) || (is_array($prc_entity_key) && empty($prc_entity_key))) {
            unset($this->prc_entity_key);
        } else {
            $this->prc_entity_key = $prc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get prc_qty_min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_qty_min(): ?float
    {
        return $this->prc_qty_min ?? null;
    }
    /**
     * Set prc_qty_min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_qty_min
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_qty_min(?float $prc_qty_min = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_qty_min) && !(is_float($prc_qty_min) || is_numeric($prc_qty_min))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_qty_min, true), gettype($prc_qty_min)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_qty_min) && mb_strlen(mb_substr((string) $prc_qty_min, false !== mb_strpos((string) $prc_qty_min, '.') ? mb_strpos((string) $prc_qty_min, '.') + 1 : mb_strlen((string) $prc_qty_min))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_qty_min, true), mb_strlen(mb_substr((string) $prc_qty_min, mb_strpos((string) $prc_qty_min, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_qty_min) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_qty_min)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_qty_min, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_qty_min))), __LINE__);
        }
        if (is_null($prc_qty_min) || (is_array($prc_qty_min) && empty($prc_qty_min))) {
            unset($this->prc_qty_min);
        } else {
            $this->prc_qty_min = $prc_qty_min;
        }
        
        return $this;
    }
    /**
     * Get prc_qty_max value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_qty_max(): ?float
    {
        return $this->prc_qty_max ?? null;
    }
    /**
     * Set prc_qty_max value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_qty_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_qty_max(?float $prc_qty_max = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_qty_max) && !(is_float($prc_qty_max) || is_numeric($prc_qty_max))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_qty_max, true), gettype($prc_qty_max)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_qty_max) && mb_strlen(mb_substr((string) $prc_qty_max, false !== mb_strpos((string) $prc_qty_max, '.') ? mb_strpos((string) $prc_qty_max, '.') + 1 : mb_strlen((string) $prc_qty_max))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_qty_max, true), mb_strlen(mb_substr((string) $prc_qty_max, mb_strpos((string) $prc_qty_max, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_qty_max) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_qty_max)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_qty_max, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_qty_max))), __LINE__);
        }
        if (is_null($prc_qty_max) || (is_array($prc_qty_max) && empty($prc_qty_max))) {
            unset($this->prc_qty_max);
        } else {
            $this->prc_qty_max = $prc_qty_max;
        }
        
        return $this;
    }
    /**
     * Get prc_recognize_after_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_recognize_after_date(): ?string
    {
        return $this->prc_recognize_after_date ?? null;
    }
    /**
     * Set prc_recognize_after_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_recognize_after_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_recognize_after_date(?string $prc_recognize_after_date = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_recognize_after_date) && !is_string($prc_recognize_after_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_recognize_after_date, true), gettype($prc_recognize_after_date)), __LINE__);
        }
        if (is_null($prc_recognize_after_date) || (is_array($prc_recognize_after_date) && empty($prc_recognize_after_date))) {
            unset($this->prc_recognize_after_date);
        } else {
            $this->prc_recognize_after_date = $prc_recognize_after_date;
        }
        
        return $this;
    }
    /**
     * Get prc_account_split_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_account_split_flag(): ?string
    {
        return $this->prc_account_split_flag ?? null;
    }
    /**
     * Set prc_account_split_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_account_split_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_account_split_flag(?string $prc_account_split_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_account_split_flag) && !is_string($prc_account_split_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_account_split_flag, true), gettype($prc_account_split_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_account_split_flag) && $prc_account_split_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_account_split_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_account_split_flag) && $prc_account_split_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_account_split_flag, true)), __LINE__);
        }
        if (is_null($prc_account_split_flag) || (is_array($prc_account_split_flag) && empty($prc_account_split_flag))) {
            unset($this->prc_account_split_flag);
        } else {
            $this->prc_account_split_flag = $prc_account_split_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_prorate_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_prorate_flag(): ?string
    {
        return $this->prc_prorate_flag ?? null;
    }
    /**
     * Set prc_prorate_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_prorate_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_prorate_flag(?string $prc_prorate_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_prorate_flag) && !is_string($prc_prorate_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_prorate_flag, true), gettype($prc_prorate_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_prorate_flag) && $prc_prorate_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_prorate_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_prorate_flag) && $prc_prorate_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_prorate_flag, true)), __LINE__);
        }
        if (is_null($prc_prorate_flag) || (is_array($prc_prorate_flag) && empty($prc_prorate_flag))) {
            unset($this->prc_prorate_flag);
        } else {
            $this->prc_prorate_flag = $prc_prorate_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_prorate_first_year_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_prorate_first_year_flag(): ?string
    {
        return $this->prc_prorate_first_year_flag ?? null;
    }
    /**
     * Set prc_prorate_first_year_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_prorate_first_year_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_prorate_first_year_flag(?string $prc_prorate_first_year_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_prorate_first_year_flag) && !is_string($prc_prorate_first_year_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_prorate_first_year_flag, true), gettype($prc_prorate_first_year_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_prorate_first_year_flag) && $prc_prorate_first_year_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_prorate_first_year_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_prorate_first_year_flag) && $prc_prorate_first_year_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_prorate_first_year_flag, true)), __LINE__);
        }
        if (is_null($prc_prorate_first_year_flag) || (is_array($prc_prorate_first_year_flag) && empty($prc_prorate_first_year_flag))) {
            unset($this->prc_prorate_first_year_flag);
        } else {
            $this->prc_prorate_first_year_flag = $prc_prorate_first_year_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_web value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_web(): ?string
    {
        return $this->prc_web ?? null;
    }
    /**
     * Set prc_web value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_web
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_web(?string $prc_web = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_web) && !is_string($prc_web)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_web, true), gettype($prc_web)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_web) && $prc_web > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_web, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_web) && $prc_web < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_web, true)), __LINE__);
        }
        if (is_null($prc_web) || (is_array($prc_web) && empty($prc_web))) {
            unset($this->prc_web);
        } else {
            $this->prc_web = $prc_web;
        }
        
        return $this;
    }
    /**
     * Get prc_microfiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_microfiche(): ?string
    {
        return $this->prc_microfiche ?? null;
    }
    /**
     * Set prc_microfiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_microfiche
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_microfiche(?string $prc_microfiche = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_microfiche) && !is_string($prc_microfiche)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_microfiche, true), gettype($prc_microfiche)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_microfiche) && $prc_microfiche > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_microfiche, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_microfiche) && $prc_microfiche < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_microfiche, true)), __LINE__);
        }
        if (is_null($prc_microfiche) || (is_array($prc_microfiche) && empty($prc_microfiche))) {
            unset($this->prc_microfiche);
        } else {
            $this->prc_microfiche = $prc_microfiche;
        }
        
        return $this;
    }
    /**
     * Get prc_revenue_recog_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrc_revenue_recog_frequency(): ?int
    {
        return $this->prc_revenue_recog_frequency ?? null;
    }
    /**
     * Set prc_revenue_recog_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prc_revenue_recog_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_revenue_recog_frequency(?int $prc_revenue_recog_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($prc_revenue_recog_frequency) && !(is_int($prc_revenue_recog_frequency) || ctype_digit($prc_revenue_recog_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prc_revenue_recog_frequency, true), gettype($prc_revenue_recog_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prc_revenue_recog_frequency) && $prc_revenue_recog_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prc_revenue_recog_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prc_revenue_recog_frequency) && $prc_revenue_recog_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prc_revenue_recog_frequency, true)), __LINE__);
        }
        if (is_null($prc_revenue_recog_frequency) || (is_array($prc_revenue_recog_frequency) && empty($prc_revenue_recog_frequency))) {
            unset($this->prc_revenue_recog_frequency);
        } else {
            $this->prc_revenue_recog_frequency = $prc_revenue_recog_frequency;
        }
        
        return $this;
    }
    /**
     * Get prc_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_allow_installment(): ?string
    {
        return $this->prc_allow_installment ?? null;
    }
    /**
     * Set prc_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_allow_installment(?string $prc_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_allow_installment) && !is_string($prc_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_allow_installment, true), gettype($prc_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_allow_installment) && $prc_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_allow_installment) && $prc_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_allow_installment, true)), __LINE__);
        }
        if (is_null($prc_allow_installment) || (is_array($prc_allow_installment) && empty($prc_allow_installment))) {
            unset($this->prc_allow_installment);
        } else {
            $this->prc_allow_installment = $prc_allow_installment;
        }
        
        return $this;
    }
    /**
     * Get prc_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_pjt_key(): ?string
    {
        return $this->prc_pjt_key ?? null;
    }
    /**
     * Set prc_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_pjt_key(?string $prc_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_pjt_key) && !is_string($prc_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_pjt_key, true), gettype($prc_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_pjt_key, true)), __LINE__);
        }
        if (is_null($prc_pjt_key) || (is_array($prc_pjt_key) && empty($prc_pjt_key))) {
            unset($this->prc_pjt_key);
        } else {
            $this->prc_pjt_key = $prc_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get prc_shippable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_shippable_flag(): ?string
    {
        return $this->prc_shippable_flag ?? null;
    }
    /**
     * Set prc_shippable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_shippable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_shippable_flag(?string $prc_shippable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_shippable_flag) && !is_string($prc_shippable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_shippable_flag, true), gettype($prc_shippable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_shippable_flag) && $prc_shippable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_shippable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_shippable_flag) && $prc_shippable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_shippable_flag, true)), __LINE__);
        }
        if (is_null($prc_shippable_flag) || (is_array($prc_shippable_flag) && empty($prc_shippable_flag))) {
            unset($this->prc_shippable_flag);
        } else {
            $this->prc_shippable_flag = $prc_shippable_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_eweb_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_eweb_code(): ?string
    {
        return $this->prc_eweb_code ?? null;
    }
    /**
     * Set prc_eweb_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_eweb_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_eweb_code(?string $prc_eweb_code = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_eweb_code) && !is_string($prc_eweb_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_eweb_code, true), gettype($prc_eweb_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prc_eweb_code) && mb_strlen((string) $prc_eweb_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $prc_eweb_code)), __LINE__);
        }
        if (is_null($prc_eweb_code) || (is_array($prc_eweb_code) && empty($prc_eweb_code))) {
            unset($this->prc_eweb_code);
        } else {
            $this->prc_eweb_code = $prc_eweb_code;
        }
        
        return $this;
    }
    /**
     * Get prc_weight_min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_weight_min(): ?float
    {
        return $this->prc_weight_min ?? null;
    }
    /**
     * Set prc_weight_min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_weight_min
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_weight_min(?float $prc_weight_min = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_weight_min) && !(is_float($prc_weight_min) || is_numeric($prc_weight_min))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_weight_min, true), gettype($prc_weight_min)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_weight_min) && mb_strlen(mb_substr((string) $prc_weight_min, false !== mb_strpos((string) $prc_weight_min, '.') ? mb_strpos((string) $prc_weight_min, '.') + 1 : mb_strlen((string) $prc_weight_min))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_weight_min, true), mb_strlen(mb_substr((string) $prc_weight_min, mb_strpos((string) $prc_weight_min, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_weight_min) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_weight_min)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_weight_min, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_weight_min))), __LINE__);
        }
        if (is_null($prc_weight_min) || (is_array($prc_weight_min) && empty($prc_weight_min))) {
            unset($this->prc_weight_min);
        } else {
            $this->prc_weight_min = $prc_weight_min;
        }
        
        return $this;
    }
    /**
     * Get prc_weight_max value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrc_weight_max(): ?float
    {
        return $this->prc_weight_max ?? null;
    }
    /**
     * Set prc_weight_max value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prc_weight_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_weight_max(?float $prc_weight_max = null): self
    {
        // validation for constraint: float
        if (!is_null($prc_weight_max) && !(is_float($prc_weight_max) || is_numeric($prc_weight_max))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prc_weight_max, true), gettype($prc_weight_max)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($prc_weight_max) && mb_strlen(mb_substr((string) $prc_weight_max, false !== mb_strpos((string) $prc_weight_max, '.') ? mb_strpos((string) $prc_weight_max, '.') + 1 : mb_strlen((string) $prc_weight_max))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($prc_weight_max, true), mb_strlen(mb_substr((string) $prc_weight_max, mb_strpos((string) $prc_weight_max, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($prc_weight_max) && mb_strlen(preg_replace('/(\D)/', '', (string) $prc_weight_max)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($prc_weight_max, true), mb_strlen(preg_replace('/(\D)/', '', (string) $prc_weight_max))), __LINE__);
        }
        if (is_null($prc_weight_max) || (is_array($prc_weight_max) && empty($prc_weight_max))) {
            unset($this->prc_weight_max);
        } else {
            $this->prc_weight_max = $prc_weight_max;
        }
        
        return $this;
    }
    /**
     * Get prc_recognize_by_issue_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_recognize_by_issue_flag(): ?string
    {
        return $this->prc_recognize_by_issue_flag ?? null;
    }
    /**
     * Set prc_recognize_by_issue_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_recognize_by_issue_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_recognize_by_issue_flag(?string $prc_recognize_by_issue_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_recognize_by_issue_flag) && !is_string($prc_recognize_by_issue_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_recognize_by_issue_flag, true), gettype($prc_recognize_by_issue_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_recognize_by_issue_flag) && $prc_recognize_by_issue_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_recognize_by_issue_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_recognize_by_issue_flag) && $prc_recognize_by_issue_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_recognize_by_issue_flag, true)), __LINE__);
        }
        if (is_null($prc_recognize_by_issue_flag) || (is_array($prc_recognize_by_issue_flag) && empty($prc_recognize_by_issue_flag))) {
            unset($this->prc_recognize_by_issue_flag);
        } else {
            $this->prc_recognize_by_issue_flag = $prc_recognize_by_issue_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_num_grace_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrc_num_grace_issues(): ?int
    {
        return $this->prc_num_grace_issues ?? null;
    }
    /**
     * Set prc_num_grace_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prc_num_grace_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_num_grace_issues(?int $prc_num_grace_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($prc_num_grace_issues) && !(is_int($prc_num_grace_issues) || ctype_digit($prc_num_grace_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prc_num_grace_issues, true), gettype($prc_num_grace_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prc_num_grace_issues) && $prc_num_grace_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prc_num_grace_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prc_num_grace_issues) && $prc_num_grace_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prc_num_grace_issues, true)), __LINE__);
        }
        if (is_null($prc_num_grace_issues) || (is_array($prc_num_grace_issues) && empty($prc_num_grace_issues))) {
            unset($this->prc_num_grace_issues);
        } else {
            $this->prc_num_grace_issues = $prc_num_grace_issues;
        }
        
        return $this;
    }
    /**
     * Get prc_back_issue_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_back_issue_flag(): ?string
    {
        return $this->prc_back_issue_flag ?? null;
    }
    /**
     * Set prc_back_issue_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_back_issue_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_back_issue_flag(?string $prc_back_issue_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_back_issue_flag) && !is_string($prc_back_issue_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_back_issue_flag, true), gettype($prc_back_issue_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_back_issue_flag) && $prc_back_issue_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_back_issue_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_back_issue_flag) && $prc_back_issue_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_back_issue_flag, true)), __LINE__);
        }
        if (is_null($prc_back_issue_flag) || (is_array($prc_back_issue_flag) && empty($prc_back_issue_flag))) {
            unset($this->prc_back_issue_flag);
        } else {
            $this->prc_back_issue_flag = $prc_back_issue_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_renew_unpaid_orders_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_renew_unpaid_orders_flag(): ?string
    {
        return $this->prc_renew_unpaid_orders_flag ?? null;
    }
    /**
     * Set prc_renew_unpaid_orders_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_renew_unpaid_orders_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_renew_unpaid_orders_flag(?string $prc_renew_unpaid_orders_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_renew_unpaid_orders_flag) && !is_string($prc_renew_unpaid_orders_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_renew_unpaid_orders_flag, true), gettype($prc_renew_unpaid_orders_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_renew_unpaid_orders_flag) && $prc_renew_unpaid_orders_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_renew_unpaid_orders_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_renew_unpaid_orders_flag) && $prc_renew_unpaid_orders_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_renew_unpaid_orders_flag, true)), __LINE__);
        }
        if (is_null($prc_renew_unpaid_orders_flag) || (is_array($prc_renew_unpaid_orders_flag) && empty($prc_renew_unpaid_orders_flag))) {
            unset($this->prc_renew_unpaid_orders_flag);
        } else {
            $this->prc_renew_unpaid_orders_flag = $prc_renew_unpaid_orders_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_allow_unpaid_orders_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_allow_unpaid_orders_flag(): ?string
    {
        return $this->prc_allow_unpaid_orders_flag ?? null;
    }
    /**
     * Set prc_allow_unpaid_orders_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_allow_unpaid_orders_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_allow_unpaid_orders_flag(?string $prc_allow_unpaid_orders_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_allow_unpaid_orders_flag) && !is_string($prc_allow_unpaid_orders_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_allow_unpaid_orders_flag, true), gettype($prc_allow_unpaid_orders_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_allow_unpaid_orders_flag) && $prc_allow_unpaid_orders_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_allow_unpaid_orders_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_allow_unpaid_orders_flag) && $prc_allow_unpaid_orders_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_allow_unpaid_orders_flag, true)), __LINE__);
        }
        if (is_null($prc_allow_unpaid_orders_flag) || (is_array($prc_allow_unpaid_orders_flag) && empty($prc_allow_unpaid_orders_flag))) {
            unset($this->prc_allow_unpaid_orders_flag);
        } else {
            $this->prc_allow_unpaid_orders_flag = $prc_allow_unpaid_orders_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_deferral_num_years value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrc_deferral_num_years(): ?int
    {
        return $this->prc_deferral_num_years ?? null;
    }
    /**
     * Set prc_deferral_num_years value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prc_deferral_num_years
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_deferral_num_years(?int $prc_deferral_num_years = null): self
    {
        // validation for constraint: int
        if (!is_null($prc_deferral_num_years) && !(is_int($prc_deferral_num_years) || ctype_digit($prc_deferral_num_years))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prc_deferral_num_years, true), gettype($prc_deferral_num_years)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prc_deferral_num_years) && $prc_deferral_num_years > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prc_deferral_num_years, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prc_deferral_num_years) && $prc_deferral_num_years < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prc_deferral_num_years, true)), __LINE__);
        }
        if (is_null($prc_deferral_num_years) || (is_array($prc_deferral_num_years) && empty($prc_deferral_num_years))) {
            unset($this->prc_deferral_num_years);
        } else {
            $this->prc_deferral_num_years = $prc_deferral_num_years;
        }
        
        return $this;
    }
    /**
     * Get prc_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_cur_key(): ?string
    {
        return $this->prc_cur_key ?? null;
    }
    /**
     * Set prc_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_cur_key(?string $prc_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_cur_key) && !is_string($prc_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_cur_key, true), gettype($prc_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_cur_key, true)), __LINE__);
        }
        if (is_null($prc_cur_key) || (is_array($prc_cur_key) && empty($prc_cur_key))) {
            unset($this->prc_cur_key);
        } else {
            $this->prc_cur_key = $prc_cur_key;
        }
        
        return $this;
    }
    /**
     * Get prc_award_credit_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_award_credit_flag(): ?string
    {
        return $this->prc_award_credit_flag ?? null;
    }
    /**
     * Set prc_award_credit_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_award_credit_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_award_credit_flag(?string $prc_award_credit_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_award_credit_flag) && !is_string($prc_award_credit_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_award_credit_flag, true), gettype($prc_award_credit_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_award_credit_flag) && $prc_award_credit_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_award_credit_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_award_credit_flag) && $prc_award_credit_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_award_credit_flag, true)), __LINE__);
        }
        if (is_null($prc_award_credit_flag) || (is_array($prc_award_credit_flag) && empty($prc_award_credit_flag))) {
            unset($this->prc_award_credit_flag);
        } else {
            $this->prc_award_credit_flag = $prc_award_credit_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_deferral_num_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrc_deferral_num_issues(): ?int
    {
        return $this->prc_deferral_num_issues ?? null;
    }
    /**
     * Set prc_deferral_num_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prc_deferral_num_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_deferral_num_issues(?int $prc_deferral_num_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($prc_deferral_num_issues) && !(is_int($prc_deferral_num_issues) || ctype_digit($prc_deferral_num_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prc_deferral_num_issues, true), gettype($prc_deferral_num_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($prc_deferral_num_issues) && $prc_deferral_num_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($prc_deferral_num_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($prc_deferral_num_issues) && $prc_deferral_num_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($prc_deferral_num_issues, true)), __LINE__);
        }
        if (is_null($prc_deferral_num_issues) || (is_array($prc_deferral_num_issues) && empty($prc_deferral_num_issues))) {
            unset($this->prc_deferral_num_issues);
        } else {
            $this->prc_deferral_num_issues = $prc_deferral_num_issues;
        }
        
        return $this;
    }
    /**
     * Get prc_allow_sync_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_allow_sync_flag(): ?string
    {
        return $this->prc_allow_sync_flag ?? null;
    }
    /**
     * Set prc_allow_sync_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_allow_sync_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_allow_sync_flag(?string $prc_allow_sync_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_allow_sync_flag) && !is_string($prc_allow_sync_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_allow_sync_flag, true), gettype($prc_allow_sync_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_allow_sync_flag) && $prc_allow_sync_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_allow_sync_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_allow_sync_flag) && $prc_allow_sync_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_allow_sync_flag, true)), __LINE__);
        }
        if (is_null($prc_allow_sync_flag) || (is_array($prc_allow_sync_flag) && empty($prc_allow_sync_flag))) {
            unset($this->prc_allow_sync_flag);
        } else {
            $this->prc_allow_sync_flag = $prc_allow_sync_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_cct_key(): ?string
    {
        return $this->prc_cct_key ?? null;
    }
    /**
     * Set prc_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_cct_key(?string $prc_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_cct_key) && !is_string($prc_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_cct_key, true), gettype($prc_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_cct_key, true)), __LINE__);
        }
        if (is_null($prc_cct_key) || (is_array($prc_cct_key) && empty($prc_cct_key))) {
            unset($this->prc_cct_key);
        } else {
            $this->prc_cct_key = $prc_cct_key;
        }
        
        return $this;
    }
    /**
     * Get prc_no_discount_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_no_discount_flag(): ?string
    {
        return $this->prc_no_discount_flag ?? null;
    }
    /**
     * Set prc_no_discount_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_no_discount_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_no_discount_flag(?string $prc_no_discount_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_no_discount_flag) && !is_string($prc_no_discount_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_no_discount_flag, true), gettype($prc_no_discount_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($prc_no_discount_flag) && $prc_no_discount_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($prc_no_discount_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prc_no_discount_flag) && $prc_no_discount_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prc_no_discount_flag, true)), __LINE__);
        }
        if (is_null($prc_no_discount_flag) || (is_array($prc_no_discount_flag) && empty($prc_no_discount_flag))) {
            unset($this->prc_no_discount_flag);
        } else {
            $this->prc_no_discount_flag = $prc_no_discount_flag;
        }
        
        return $this;
    }
    /**
     * Get prc_pcl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_pcl_key(): ?string
    {
        return $this->prc_pcl_key ?? null;
    }
    /**
     * Set prc_pcl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_pcl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_pcl_key(?string $prc_pcl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_pcl_key) && !is_string($prc_pcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_pcl_key, true), gettype($prc_pcl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_pcl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_pcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_pcl_key, true)), __LINE__);
        }
        if (is_null($prc_pcl_key) || (is_array($prc_pcl_key) && empty($prc_pcl_key))) {
            unset($this->prc_pcl_key);
        } else {
            $this->prc_pcl_key = $prc_pcl_key;
        }
        
        return $this;
    }
    /**
     * Get prc_pde_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_pde_key(): ?string
    {
        return $this->prc_pde_key ?? null;
    }
    /**
     * Set prc_pde_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_pde_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_pde_key(?string $prc_pde_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_pde_key) && !is_string($prc_pde_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_pde_key, true), gettype($prc_pde_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_pde_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_pde_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_pde_key, true)), __LINE__);
        }
        if (is_null($prc_pde_key) || (is_array($prc_pde_key) && empty($prc_pde_key))) {
            unset($this->prc_pde_key);
        } else {
            $this->prc_pde_key = $prc_pde_key;
        }
        
        return $this;
    }
    /**
     * Get prc_plo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrc_plo_key(): ?string
    {
        return $this->prc_plo_key ?? null;
    }
    /**
     * Set prc_plo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prc_plo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Price_DataObjectType
     */
    public function setPrc_plo_key(?string $prc_plo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($prc_plo_key) && !is_string($prc_plo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prc_plo_key, true), gettype($prc_plo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($prc_plo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $prc_plo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($prc_plo_key, true)), __LINE__);
        }
        if (is_null($prc_plo_key) || (is_array($prc_plo_key) && empty($prc_plo_key))) {
            unset($this->prc_plo_key);
        } else {
            $this->prc_plo_key = $prc_plo_key;
        }
        
        return $this;
    }
}
