<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_Sales_Opportunity_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_Sales_Opportunity_DataObjectType extends AbstractStructBase
{
    /**
     * The sfo_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_key = null;
    /**
     * The sfo_type
     * Meta information extracted from the WSDL
     * - documentation: Record Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_type = null;
    /**
     * The sfo_usr_key
     * Meta information extracted from the WSDL
     * - documentation: Staff Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_usr_key = null;
    /**
     * The sfo_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_cst_key = null;
    /**
     * The sfo_opportunity_name
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_opportunity_name = null;
    /**
     * The sfo_sot_code
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_sot_code = null;
    /**
     * The sfo_sor_code
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_sor_code = null;
    /**
     * The sfo_quantity
     * Meta information extracted from the WSDL
     * - documentation: Sales Quantity.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $sfo_quantity = null;
    /**
     * The sfo_description
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_description = null;
    /**
     * The sfo_amount
     * Meta information extracted from the WSDL
     * - documentation: Opportunity Amount.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $sfo_amount = null;
    /**
     * The sfo_close_date
     * Meta information extracted from the WSDL
     * - documentation: Close Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_close_date = null;
    /**
     * The sfo_sos_code
     * Meta information extracted from the WSDL
     * - documentation: Current Stage. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_sos_code = null;
    /**
     * The sfo_close_probability
     * Meta information extracted from the WSDL
     * - documentation: Close Probability. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $sfo_close_probability = null;
    /**
     * The sfo_expected_revenue
     * Meta information extracted from the WSDL
     * - documentation: Expected Revenue. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $sfo_expected_revenue = null;
    /**
     * The sfo_sos_code_next
     * Meta information extracted from the WSDL
     * - documentation: Next Step. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_sos_code_next = null;
    /**
     * The sfo_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_ptp_key = null;
    /**
     * The sfo_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_prd_key = null;
    /**
     * The sfo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_add_user = null;
    /**
     * The sfo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_add_date = null;
    /**
     * The sfo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_change_user = null;
    /**
     * The sfo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_change_date = null;
    /**
     * The sfo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $sfo_delete_flag = null;
    /**
     * The sfo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_key_ext = null;
    /**
     * The sfo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $sfo_entity_key = null;
    /**
     * Constructor method for CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_key()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_type()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_usr_key()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_cst_key()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_opportunity_name()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_sot_code()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_sor_code()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_quantity()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_description()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_amount()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_close_date()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_sos_code()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_close_probability()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_expected_revenue()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_sos_code_next()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_ptp_key()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_prd_key()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_add_user()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_add_date()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_change_user()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_change_date()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_delete_flag()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_key_ext()
     * @uses CentralizedOrderEntry_Sales_Opportunity_DataObjectType::setSfo_entity_key()
     * @param string $sfo_key
     * @param string $sfo_type
     * @param string $sfo_usr_key
     * @param string $sfo_cst_key
     * @param string $sfo_opportunity_name
     * @param string $sfo_sot_code
     * @param string $sfo_sor_code
     * @param float $sfo_quantity
     * @param string $sfo_description
     * @param float $sfo_amount
     * @param string $sfo_close_date
     * @param string $sfo_sos_code
     * @param float $sfo_close_probability
     * @param float $sfo_expected_revenue
     * @param string $sfo_sos_code_next
     * @param string $sfo_ptp_key
     * @param string $sfo_prd_key
     * @param string $sfo_add_user
     * @param string $sfo_add_date
     * @param string $sfo_change_user
     * @param string $sfo_change_date
     * @param string $sfo_delete_flag
     * @param string $sfo_key_ext
     * @param string $sfo_entity_key
     */
    public function __construct(?string $sfo_key = null, ?string $sfo_type = null, ?string $sfo_usr_key = null, ?string $sfo_cst_key = null, ?string $sfo_opportunity_name = null, ?string $sfo_sot_code = null, ?string $sfo_sor_code = null, ?float $sfo_quantity = null, ?string $sfo_description = null, ?float $sfo_amount = null, ?string $sfo_close_date = null, ?string $sfo_sos_code = null, ?float $sfo_close_probability = null, ?float $sfo_expected_revenue = null, ?string $sfo_sos_code_next = null, ?string $sfo_ptp_key = null, ?string $sfo_prd_key = null, ?string $sfo_add_user = null, ?string $sfo_add_date = null, ?string $sfo_change_user = null, ?string $sfo_change_date = null, ?string $sfo_delete_flag = null, ?string $sfo_key_ext = null, ?string $sfo_entity_key = null)
    {
        $this
            ->setSfo_key($sfo_key)
            ->setSfo_type($sfo_type)
            ->setSfo_usr_key($sfo_usr_key)
            ->setSfo_cst_key($sfo_cst_key)
            ->setSfo_opportunity_name($sfo_opportunity_name)
            ->setSfo_sot_code($sfo_sot_code)
            ->setSfo_sor_code($sfo_sor_code)
            ->setSfo_quantity($sfo_quantity)
            ->setSfo_description($sfo_description)
            ->setSfo_amount($sfo_amount)
            ->setSfo_close_date($sfo_close_date)
            ->setSfo_sos_code($sfo_sos_code)
            ->setSfo_close_probability($sfo_close_probability)
            ->setSfo_expected_revenue($sfo_expected_revenue)
            ->setSfo_sos_code_next($sfo_sos_code_next)
            ->setSfo_ptp_key($sfo_ptp_key)
            ->setSfo_prd_key($sfo_prd_key)
            ->setSfo_add_user($sfo_add_user)
            ->setSfo_add_date($sfo_add_date)
            ->setSfo_change_user($sfo_change_user)
            ->setSfo_change_date($sfo_change_date)
            ->setSfo_delete_flag($sfo_delete_flag)
            ->setSfo_key_ext($sfo_key_ext)
            ->setSfo_entity_key($sfo_entity_key);
    }
    /**
     * Get sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_key(): ?string
    {
        return $this->sfo_key ?? null;
    }
    /**
     * Set sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_key(?string $sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_key) && !is_string($sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_key, true), gettype($sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_key, true)), __LINE__);
        }
        if (is_null($sfo_key) || (is_array($sfo_key) && empty($sfo_key))) {
            unset($this->sfo_key);
        } else {
            $this->sfo_key = $sfo_key;
        }
        
        return $this;
    }
    /**
     * Get sfo_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_type(): ?string
    {
        return $this->sfo_type ?? null;
    }
    /**
     * Set sfo_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_type(?string $sfo_type = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_type) && !is_string($sfo_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_type, true), gettype($sfo_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sfo_type) && mb_strlen((string) $sfo_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sfo_type)), __LINE__);
        }
        if (is_null($sfo_type) || (is_array($sfo_type) && empty($sfo_type))) {
            unset($this->sfo_type);
        } else {
            $this->sfo_type = $sfo_type;
        }
        
        return $this;
    }
    /**
     * Get sfo_usr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_usr_key(): ?string
    {
        return $this->sfo_usr_key ?? null;
    }
    /**
     * Set sfo_usr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_usr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_usr_key(?string $sfo_usr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_usr_key) && !is_string($sfo_usr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_usr_key, true), gettype($sfo_usr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_usr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_usr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_usr_key, true)), __LINE__);
        }
        if (is_null($sfo_usr_key) || (is_array($sfo_usr_key) && empty($sfo_usr_key))) {
            unset($this->sfo_usr_key);
        } else {
            $this->sfo_usr_key = $sfo_usr_key;
        }
        
        return $this;
    }
    /**
     * Get sfo_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_cst_key(): ?string
    {
        return $this->sfo_cst_key ?? null;
    }
    /**
     * Set sfo_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_cst_key(?string $sfo_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_cst_key) && !is_string($sfo_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_cst_key, true), gettype($sfo_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_cst_key, true)), __LINE__);
        }
        if (is_null($sfo_cst_key) || (is_array($sfo_cst_key) && empty($sfo_cst_key))) {
            unset($this->sfo_cst_key);
        } else {
            $this->sfo_cst_key = $sfo_cst_key;
        }
        
        return $this;
    }
    /**
     * Get sfo_opportunity_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_opportunity_name(): ?string
    {
        return $this->sfo_opportunity_name ?? null;
    }
    /**
     * Set sfo_opportunity_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_opportunity_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_opportunity_name(?string $sfo_opportunity_name = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_opportunity_name) && !is_string($sfo_opportunity_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_opportunity_name, true), gettype($sfo_opportunity_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($sfo_opportunity_name) && mb_strlen((string) $sfo_opportunity_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $sfo_opportunity_name)), __LINE__);
        }
        if (is_null($sfo_opportunity_name) || (is_array($sfo_opportunity_name) && empty($sfo_opportunity_name))) {
            unset($this->sfo_opportunity_name);
        } else {
            $this->sfo_opportunity_name = $sfo_opportunity_name;
        }
        
        return $this;
    }
    /**
     * Get sfo_sot_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_sot_code(): ?string
    {
        return $this->sfo_sot_code ?? null;
    }
    /**
     * Set sfo_sot_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_sot_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_sot_code(?string $sfo_sot_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_sot_code) && !is_string($sfo_sot_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_sot_code, true), gettype($sfo_sot_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sfo_sot_code) && mb_strlen((string) $sfo_sot_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sfo_sot_code)), __LINE__);
        }
        if (is_null($sfo_sot_code) || (is_array($sfo_sot_code) && empty($sfo_sot_code))) {
            unset($this->sfo_sot_code);
        } else {
            $this->sfo_sot_code = $sfo_sot_code;
        }
        
        return $this;
    }
    /**
     * Get sfo_sor_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_sor_code(): ?string
    {
        return $this->sfo_sor_code ?? null;
    }
    /**
     * Set sfo_sor_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_sor_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_sor_code(?string $sfo_sor_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_sor_code) && !is_string($sfo_sor_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_sor_code, true), gettype($sfo_sor_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sfo_sor_code) && mb_strlen((string) $sfo_sor_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sfo_sor_code)), __LINE__);
        }
        if (is_null($sfo_sor_code) || (is_array($sfo_sor_code) && empty($sfo_sor_code))) {
            unset($this->sfo_sor_code);
        } else {
            $this->sfo_sor_code = $sfo_sor_code;
        }
        
        return $this;
    }
    /**
     * Get sfo_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSfo_quantity(): ?float
    {
        return $this->sfo_quantity ?? null;
    }
    /**
     * Set sfo_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sfo_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_quantity(?float $sfo_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($sfo_quantity) && !(is_float($sfo_quantity) || is_numeric($sfo_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sfo_quantity, true), gettype($sfo_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($sfo_quantity) && mb_strlen(mb_substr((string) $sfo_quantity, false !== mb_strpos((string) $sfo_quantity, '.') ? mb_strpos((string) $sfo_quantity, '.') + 1 : mb_strlen((string) $sfo_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($sfo_quantity, true), mb_strlen(mb_substr((string) $sfo_quantity, mb_strpos((string) $sfo_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($sfo_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($sfo_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_quantity))), __LINE__);
        }
        if (is_null($sfo_quantity) || (is_array($sfo_quantity) && empty($sfo_quantity))) {
            unset($this->sfo_quantity);
        } else {
            $this->sfo_quantity = $sfo_quantity;
        }
        
        return $this;
    }
    /**
     * Get sfo_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_description(): ?string
    {
        return $this->sfo_description ?? null;
    }
    /**
     * Set sfo_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_description(?string $sfo_description = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_description) && !is_string($sfo_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_description, true), gettype($sfo_description)), __LINE__);
        }
        if (is_null($sfo_description) || (is_array($sfo_description) && empty($sfo_description))) {
            unset($this->sfo_description);
        } else {
            $this->sfo_description = $sfo_description;
        }
        
        return $this;
    }
    /**
     * Get sfo_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSfo_amount(): ?float
    {
        return $this->sfo_amount ?? null;
    }
    /**
     * Set sfo_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sfo_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_amount(?float $sfo_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($sfo_amount) && !(is_float($sfo_amount) || is_numeric($sfo_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sfo_amount, true), gettype($sfo_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($sfo_amount) && mb_strlen(mb_substr((string) $sfo_amount, false !== mb_strpos((string) $sfo_amount, '.') ? mb_strpos((string) $sfo_amount, '.') + 1 : mb_strlen((string) $sfo_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($sfo_amount, true), mb_strlen(mb_substr((string) $sfo_amount, mb_strpos((string) $sfo_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($sfo_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($sfo_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_amount))), __LINE__);
        }
        if (is_null($sfo_amount) || (is_array($sfo_amount) && empty($sfo_amount))) {
            unset($this->sfo_amount);
        } else {
            $this->sfo_amount = $sfo_amount;
        }
        
        return $this;
    }
    /**
     * Get sfo_close_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_close_date(): ?string
    {
        return $this->sfo_close_date ?? null;
    }
    /**
     * Set sfo_close_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_close_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_close_date(?string $sfo_close_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_close_date) && !is_string($sfo_close_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_close_date, true), gettype($sfo_close_date)), __LINE__);
        }
        if (is_null($sfo_close_date) || (is_array($sfo_close_date) && empty($sfo_close_date))) {
            unset($this->sfo_close_date);
        } else {
            $this->sfo_close_date = $sfo_close_date;
        }
        
        return $this;
    }
    /**
     * Get sfo_sos_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_sos_code(): ?string
    {
        return $this->sfo_sos_code ?? null;
    }
    /**
     * Set sfo_sos_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_sos_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_sos_code(?string $sfo_sos_code = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_sos_code) && !is_string($sfo_sos_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_sos_code, true), gettype($sfo_sos_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sfo_sos_code) && mb_strlen((string) $sfo_sos_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sfo_sos_code)), __LINE__);
        }
        if (is_null($sfo_sos_code) || (is_array($sfo_sos_code) && empty($sfo_sos_code))) {
            unset($this->sfo_sos_code);
        } else {
            $this->sfo_sos_code = $sfo_sos_code;
        }
        
        return $this;
    }
    /**
     * Get sfo_close_probability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSfo_close_probability(): ?float
    {
        return $this->sfo_close_probability ?? null;
    }
    /**
     * Set sfo_close_probability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sfo_close_probability
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_close_probability(?float $sfo_close_probability = null): self
    {
        // validation for constraint: float
        if (!is_null($sfo_close_probability) && !(is_float($sfo_close_probability) || is_numeric($sfo_close_probability))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sfo_close_probability, true), gettype($sfo_close_probability)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($sfo_close_probability) && mb_strlen(mb_substr((string) $sfo_close_probability, false !== mb_strpos((string) $sfo_close_probability, '.') ? mb_strpos((string) $sfo_close_probability, '.') + 1 : mb_strlen((string) $sfo_close_probability))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($sfo_close_probability, true), mb_strlen(mb_substr((string) $sfo_close_probability, mb_strpos((string) $sfo_close_probability, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($sfo_close_probability) && mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_close_probability)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($sfo_close_probability, true), mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_close_probability))), __LINE__);
        }
        if (is_null($sfo_close_probability) || (is_array($sfo_close_probability) && empty($sfo_close_probability))) {
            unset($this->sfo_close_probability);
        } else {
            $this->sfo_close_probability = $sfo_close_probability;
        }
        
        return $this;
    }
    /**
     * Get sfo_expected_revenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSfo_expected_revenue(): ?float
    {
        return $this->sfo_expected_revenue ?? null;
    }
    /**
     * Set sfo_expected_revenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sfo_expected_revenue
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_expected_revenue(?float $sfo_expected_revenue = null): self
    {
        // validation for constraint: float
        if (!is_null($sfo_expected_revenue) && !(is_float($sfo_expected_revenue) || is_numeric($sfo_expected_revenue))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sfo_expected_revenue, true), gettype($sfo_expected_revenue)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($sfo_expected_revenue) && mb_strlen(mb_substr((string) $sfo_expected_revenue, false !== mb_strpos((string) $sfo_expected_revenue, '.') ? mb_strpos((string) $sfo_expected_revenue, '.') + 1 : mb_strlen((string) $sfo_expected_revenue))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($sfo_expected_revenue, true), mb_strlen(mb_substr((string) $sfo_expected_revenue, mb_strpos((string) $sfo_expected_revenue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($sfo_expected_revenue) && mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_expected_revenue)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($sfo_expected_revenue, true), mb_strlen(preg_replace('/(\D)/', '', (string) $sfo_expected_revenue))), __LINE__);
        }
        if (is_null($sfo_expected_revenue) || (is_array($sfo_expected_revenue) && empty($sfo_expected_revenue))) {
            unset($this->sfo_expected_revenue);
        } else {
            $this->sfo_expected_revenue = $sfo_expected_revenue;
        }
        
        return $this;
    }
    /**
     * Get sfo_sos_code_next value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_sos_code_next(): ?string
    {
        return $this->sfo_sos_code_next ?? null;
    }
    /**
     * Set sfo_sos_code_next value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_sos_code_next
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_sos_code_next(?string $sfo_sos_code_next = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_sos_code_next) && !is_string($sfo_sos_code_next)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_sos_code_next, true), gettype($sfo_sos_code_next)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sfo_sos_code_next) && mb_strlen((string) $sfo_sos_code_next) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $sfo_sos_code_next)), __LINE__);
        }
        if (is_null($sfo_sos_code_next) || (is_array($sfo_sos_code_next) && empty($sfo_sos_code_next))) {
            unset($this->sfo_sos_code_next);
        } else {
            $this->sfo_sos_code_next = $sfo_sos_code_next;
        }
        
        return $this;
    }
    /**
     * Get sfo_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_ptp_key(): ?string
    {
        return $this->sfo_ptp_key ?? null;
    }
    /**
     * Set sfo_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_ptp_key(?string $sfo_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_ptp_key) && !is_string($sfo_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_ptp_key, true), gettype($sfo_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_ptp_key, true)), __LINE__);
        }
        if (is_null($sfo_ptp_key) || (is_array($sfo_ptp_key) && empty($sfo_ptp_key))) {
            unset($this->sfo_ptp_key);
        } else {
            $this->sfo_ptp_key = $sfo_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get sfo_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_prd_key(): ?string
    {
        return $this->sfo_prd_key ?? null;
    }
    /**
     * Set sfo_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_prd_key(?string $sfo_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_prd_key) && !is_string($sfo_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_prd_key, true), gettype($sfo_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_prd_key, true)), __LINE__);
        }
        if (is_null($sfo_prd_key) || (is_array($sfo_prd_key) && empty($sfo_prd_key))) {
            unset($this->sfo_prd_key);
        } else {
            $this->sfo_prd_key = $sfo_prd_key;
        }
        
        return $this;
    }
    /**
     * Get sfo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_add_user(): ?string
    {
        return $this->sfo_add_user ?? null;
    }
    /**
     * Set sfo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_add_user(?string $sfo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_add_user) && !is_string($sfo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_add_user, true), gettype($sfo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sfo_add_user) && mb_strlen((string) $sfo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sfo_add_user)), __LINE__);
        }
        if (is_null($sfo_add_user) || (is_array($sfo_add_user) && empty($sfo_add_user))) {
            unset($this->sfo_add_user);
        } else {
            $this->sfo_add_user = $sfo_add_user;
        }
        
        return $this;
    }
    /**
     * Get sfo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_add_date(): ?string
    {
        return $this->sfo_add_date ?? null;
    }
    /**
     * Set sfo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_add_date(?string $sfo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_add_date) && !is_string($sfo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_add_date, true), gettype($sfo_add_date)), __LINE__);
        }
        if (is_null($sfo_add_date) || (is_array($sfo_add_date) && empty($sfo_add_date))) {
            unset($this->sfo_add_date);
        } else {
            $this->sfo_add_date = $sfo_add_date;
        }
        
        return $this;
    }
    /**
     * Get sfo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_change_user(): ?string
    {
        return $this->sfo_change_user ?? null;
    }
    /**
     * Set sfo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_change_user(?string $sfo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_change_user) && !is_string($sfo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_change_user, true), gettype($sfo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sfo_change_user) && mb_strlen((string) $sfo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $sfo_change_user)), __LINE__);
        }
        if (is_null($sfo_change_user) || (is_array($sfo_change_user) && empty($sfo_change_user))) {
            unset($this->sfo_change_user);
        } else {
            $this->sfo_change_user = $sfo_change_user;
        }
        
        return $this;
    }
    /**
     * Get sfo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_change_date(): ?string
    {
        return $this->sfo_change_date ?? null;
    }
    /**
     * Set sfo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_change_date(?string $sfo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_change_date) && !is_string($sfo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_change_date, true), gettype($sfo_change_date)), __LINE__);
        }
        if (is_null($sfo_change_date) || (is_array($sfo_change_date) && empty($sfo_change_date))) {
            unset($this->sfo_change_date);
        } else {
            $this->sfo_change_date = $sfo_change_date;
        }
        
        return $this;
    }
    /**
     * Get sfo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_delete_flag(): ?string
    {
        return $this->sfo_delete_flag ?? null;
    }
    /**
     * Set sfo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_delete_flag(?string $sfo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_delete_flag) && !is_string($sfo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_delete_flag, true), gettype($sfo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($sfo_delete_flag) && $sfo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($sfo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sfo_delete_flag) && $sfo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sfo_delete_flag, true)), __LINE__);
        }
        if (is_null($sfo_delete_flag) || (is_array($sfo_delete_flag) && empty($sfo_delete_flag))) {
            unset($this->sfo_delete_flag);
        } else {
            $this->sfo_delete_flag = $sfo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get sfo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_key_ext(): ?string
    {
        return $this->sfo_key_ext ?? null;
    }
    /**
     * Set sfo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_key_ext(?string $sfo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_key_ext) && !is_string($sfo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_key_ext, true), gettype($sfo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_key_ext, true)), __LINE__);
        }
        if (is_null($sfo_key_ext) || (is_array($sfo_key_ext) && empty($sfo_key_ext))) {
            unset($this->sfo_key_ext);
        } else {
            $this->sfo_key_ext = $sfo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get sfo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSfo_entity_key(): ?string
    {
        return $this->sfo_entity_key ?? null;
    }
    /**
     * Set sfo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sfo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Sales_Opportunity_DataObjectType
     */
    public function setSfo_entity_key(?string $sfo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($sfo_entity_key) && !is_string($sfo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sfo_entity_key, true), gettype($sfo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($sfo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $sfo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($sfo_entity_key, true)), __LINE__);
        }
        if (is_null($sfo_entity_key) || (is_array($sfo_entity_key) && empty($sfo_entity_key))) {
            unset($this->sfo_entity_key);
        } else {
            $this->sfo_entity_key = $sfo_entity_key;
        }
        
        return $this;
    }
}
